export default "@export ecgl.realistic.vertex\r\n\r\n@import ecgl.common.transformUniforms\r\n\r\n@import ecgl.common.uv.header\r\n\r\n@import ecgl.common.attributes\r\n\r\n\r\n@import ecgl.common.wireframe.vertexHeader\r\n\r\n#ifdef VERTEX_COLOR\r\nattribute vec4 a_Color : COLOR;\r\nvarying vec4 v_Color;\r\n#endif\r\n\r\n#ifdef NORMALMAP_ENABLED\r\nattribute vec4 tangent : TANGENT;\r\nvarying vec3 v_Tangent;\r\nvarying vec3 v_Bitangent;\r\n#endif\r\n\r\n@import ecgl.common.vertexAnimation.header\r\n\r\nvarying vec3 v_Normal;\r\nvarying vec3 v_WorldPosition;\r\n\r\nvoid main()\r\n{\r\n\r\n @import ecgl.common.uv.main\r\n\r\n @import ecgl.common.vertexAnimation.main\r\n\r\n gl_Position = worldViewProjection * vec4(pos, 1.0);\r\n\r\n v_Normal = normalize((worldInverseTranspose * vec4(norm, 0.0)).xyz);\r\n v_WorldPosition = (world * vec4(pos, 1.0)).xyz;\r\n\r\n#ifdef VERTEX_COLOR\r\n v_Color = a_Color;\r\n#endif\r\n\r\n#ifdef NORMALMAP_ENABLED\r\n v_Tangent = normalize((worldInverseTranspose * vec4(tangent.xyz, 0.0)).xyz);\r\n v_Bitangent = normalize(cross(v_Normal, v_Tangent) * tangent.w);\r\n#endif\r\n\r\n @import ecgl.common.wireframe.vertexMain\r\n\r\n}\r\n\r\n@end\r\n\r\n\r\n\r\n@export ecgl.realistic.fragment\r\n\r\n#define LAYER_DIFFUSEMAP_COUNT 0\r\n#define LAYER_EMISSIVEMAP_COUNT 0\r\n#define PI 3.14159265358979\r\n#define ROUGHNESS_CHANEL 0\r\n#define METALNESS_CHANEL 1\r\n\r\n#define NORMAL_UP_AXIS 1\r\n#define NORMAL_FRONT_AXIS 2\r\n\r\n#ifdef VERTEX_COLOR\r\nvarying vec4 v_Color;\r\n#endif\r\n\r\n@import ecgl.common.uv.fragmentHeader\r\n\r\nvarying vec3 v_Normal;\r\nvarying vec3 v_WorldPosition;\r\n\r\n// diffuseMap, bumpMap use v_Texcoord\r\nuniform sampler2D diffuseMap;\r\n\r\n// detailMap, metalnessMap, roughnessMap, normalMap use v_DetailTexcoord.\r\nuniform sampler2D detailMap;\r\nuniform sampler2D metalnessMap;\r\nuniform sampler2D roughnessMap;\r\n\r\n@import ecgl.common.layers.header\r\n\r\nuniform float emissionIntensity: 1.0;\r\n\r\nuniform vec4 color : [1.0, 1.0, 1.0, 1.0];\r\n\r\nuniform float metalness : 0.0;\r\nuniform float roughness : 0.5;\r\n\r\nuniform mat4 viewInverse : VIEWINVERSE;\r\n\r\n#ifdef ATMOSPHERE_ENABLED\r\nuniform mat4 viewTranspose: VIEWTRANSPOSE;\r\nuniform vec3 glowColor;\r\nuniform float glowPower;\r\n#endif\r\n\r\n#ifdef AMBIENT_LIGHT_COUNT\r\n@import clay.header.ambient_light\r\n#endif\r\n\r\n#ifdef AMBIENT_SH_LIGHT_COUNT\r\n@import clay.header.ambient_sh_light\r\n#endif\r\n\r\n#ifdef AMBIENT_CUBEMAP_LIGHT_COUNT\r\n@import clay.header.ambient_cubemap_light\r\n#endif\r\n\r\n#ifdef DIRECTIONAL_LIGHT_COUNT\r\n@import clay.header.directional_light\r\n#endif\r\n\r\n@import ecgl.common.normalMap.fragmentHeader\r\n\r\n@import ecgl.common.ssaoMap.header\r\n\r\n@import ecgl.common.bumpMap.header\r\n\r\n@import clay.util.srgb\r\n\r\n@import clay.util.rgbm\r\n\r\n@import ecgl.common.wireframe.fragmentHeader\r\n\r\n@import clay.plugin.compute_shadow_map\r\n\r\n// Fresnel\r\nvec3 F_Schlick(float ndv, vec3 spec) {\r\n return spec + (1.0 - spec) * pow(1.0 - ndv, 5.0);\r\n}\r\n\r\nfloat D_Phong(float g, float ndh) {\r\n // from black ops 2\r\n float a = pow(8192.0, g);\r\n return (a + 2.0) / 8.0 * pow(ndh, a);\r\n}\r\n\r\nvoid main()\r\n{\r\n vec4 albedoColor = color;\r\n\r\n vec3 eyePos = viewInverse[3].xyz;\r\n vec3 V = normalize(eyePos - v_WorldPosition);\r\n#ifdef VERTEX_COLOR\r\n // PENDING\r\n #ifdef SRGB_DECODE\r\n albedoColor *= sRGBToLinear(v_Color);\r\n #else\r\n albedoColor *= v_Color;\r\n #endif\r\n#endif\r\n\r\n @import ecgl.common.albedo.main\r\n\r\n @import ecgl.common.diffuseLayer.main\r\n\r\n albedoColor *= albedoTexel;\r\n\r\n float m = metalness;\r\n\r\n#ifdef METALNESSMAP_ENABLED\r\n float m2 = texture2D(metalnessMap, v_DetailTexcoord)[METALNESS_CHANEL];\r\n // Adjust the brightness\r\n m = clamp(m2 + (m - 0.5) * 2.0, 0.0, 1.0);\r\n#endif\r\n\r\n vec3 baseColor = albedoColor.rgb;\r\n albedoColor.rgb = baseColor * (1.0 - m);\r\n vec3 specFactor = mix(vec3(0.04), baseColor, m);\r\n\r\n float g = 1.0 - roughness;\r\n\r\n#ifdef ROUGHNESSMAP_ENABLED\r\n float g2 = 1.0 - texture2D(roughnessMap, v_DetailTexcoord)[ROUGHNESS_CHANEL];\r\n // Adjust the brightness\r\n g = clamp(g2 + (g - 0.5) * 2.0, 0.0, 1.0);\r\n#endif\r\n\r\n vec3 N = v_Normal;\r\n\r\n#ifdef DOUBLE_SIDED\r\n if (dot(N, V) < 0.0) {\r\n N = -N;\r\n }\r\n#endif\r\n\r\n float ambientFactor = 1.0;\r\n\r\n#ifdef BUMPMAP_ENABLED\r\n N = bumpNormal(v_WorldPosition, v_Normal, N);\r\n // PENDING\r\n ambientFactor = dot(v_Normal, N);\r\n#endif\r\n\r\n@import ecgl.common.normalMap.fragmentMain\r\n\r\n vec3 N2 = vec3(N.x, N[NORMAL_UP_AXIS], N[NORMAL_FRONT_AXIS]);\r\n\r\n vec3 diffuseTerm = vec3(0.0);\r\n vec3 specularTerm = vec3(0.0);\r\n\r\n float ndv = clamp(dot(N, V), 0.0, 1.0);\r\n vec3 fresnelTerm = F_Schlick(ndv, specFactor);\r\n\r\n @import ecgl.common.ssaoMap.main\r\n\r\n#ifdef AMBIENT_LIGHT_COUNT\r\n for(int _idx_ = 0; _idx_ < AMBIENT_LIGHT_COUNT; _idx_++)\r\n {{\r\n // Multiply a dot factor to make sure the bump detail can be seen\r\n // in the dark side\r\n diffuseTerm += ambientLightColor[_idx_] * ambientFactor * ao;\r\n }}\r\n#endif\r\n\r\n#ifdef AMBIENT_SH_LIGHT_COUNT\r\n for(int _idx_ = 0; _idx_ < AMBIENT_SH_LIGHT_COUNT; _idx_++)\r\n {{\r\n diffuseTerm += calcAmbientSHLight(_idx_, N2) * ambientSHLightColor[_idx_] * ao;\r\n }}\r\n#endif\r\n\r\n#ifdef DIRECTIONAL_LIGHT_COUNT\r\n#if defined(DIRECTIONAL_LIGHT_SHADOWMAP_COUNT)\r\n float shadowContribsDir[DIRECTIONAL_LIGHT_COUNT];\r\n if(shadowEnabled)\r\n {\r\n computeShadowOfDirectionalLights(v_WorldPosition, shadowContribsDir);\r\n }\r\n#endif\r\n for(int _idx_ = 0; _idx_ < DIRECTIONAL_LIGHT_COUNT; _idx_++)\r\n {{\r\n vec3 L = -directionalLightDirection[_idx_];\r\n vec3 lc = directionalLightColor[_idx_];\r\n\r\n vec3 H = normalize(L + V);\r\n float ndl = clamp(dot(N, normalize(L)), 0.0, 1.0);\r\n float ndh = clamp(dot(N, H), 0.0, 1.0);\r\n\r\n float shadowContrib = 1.0;\r\n#if defined(DIRECTIONAL_LIGHT_SHADOWMAP_COUNT)\r\n if (shadowEnabled)\r\n {\r\n shadowContrib = shadowContribsDir[_idx_];\r\n }\r\n#endif\r\n\r\n vec3 li = lc * ndl * shadowContrib;\r\n\r\n diffuseTerm += li;\r\n specularTerm += li * fresnelTerm * D_Phong(g, ndh);\r\n }}\r\n#endif\r\n\r\n\r\n#ifdef AMBIENT_CUBEMAP_LIGHT_COUNT\r\n vec3 L = reflect(-V, N);\r\n L = vec3(L.x, L[NORMAL_UP_AXIS], L[NORMAL_FRONT_AXIS]);\r\n float rough2 = clamp(1.0 - g, 0.0, 1.0);\r\n // FIXME fixed maxMipmapLevel ?\r\n float bias2 = rough2 * 5.0;\r\n // One brdf lookup is enough\r\n vec2 brdfParam2 = texture2D(ambientCubemapLightBRDFLookup[0], vec2(rough2, ndv)).xy;\r\n vec3 envWeight2 = specFactor * brdfParam2.x + brdfParam2.y;\r\n vec3 envTexel2;\r\n for(int _idx_ = 0; _idx_ < AMBIENT_CUBEMAP_LIGHT_COUNT; _idx_++)\r\n {{\r\n envTexel2 = RGBMDecode(textureCubeLodEXT(ambientCubemapLightCubemap[_idx_], L, bias2), 8.12);\r\n // TODO mix ?\r\n specularTerm += ambientCubemapLightColor[_idx_] * envTexel2 * envWeight2 * ao;\r\n }}\r\n#endif\r\n\r\n gl_FragColor.rgb = albedoColor.rgb * diffuseTerm + specularTerm;\r\n gl_FragColor.a = albedoColor.a;\r\n\r\n#ifdef ATMOSPHERE_ENABLED\r\n float atmoIntensity = pow(1.0 - dot(v_Normal, (viewTranspose * vec4(0.0, 0.0, 1.0, 0.0)).xyz), glowPower);\r\n gl_FragColor.rgb += glowColor * atmoIntensity;\r\n#endif\r\n\r\n#ifdef SRGB_ENCODE\r\n gl_FragColor = linearTosRGB(gl_FragColor);\r\n#endif\r\n\r\n @import ecgl.common.emissiveLayer.main\r\n\r\n @import ecgl.common.wireframe.fragmentMain\r\n}\r\n\r\n@end";