export default "@export ecgl.sm.depth.vertex\r\n\r\nuniform mat4 worldViewProjection : WORLDVIEWPROJECTION;\r\n\r\nattribute vec3 position : POSITION;\r\nattribute vec2 texcoord : TEXCOORD_0;\r\n\r\n#ifdef VERTEX_ANIMATION\r\nattribute vec3 prevPosition;\r\nuniform float percent : 1.0;\r\n#endif\r\n\r\nvarying vec4 v_ViewPosition;\r\nvarying vec2 v_Texcoord;\r\n\r\nvoid main(){\r\n\r\n#ifdef VERTEX_ANIMATION\r\n vec3 pos = mix(prevPosition, position, percent);\r\n#else\r\n vec3 pos = position;\r\n#endif\r\n\r\n v_ViewPosition = worldViewProjection * vec4(pos, 1.0);\r\n gl_Position = v_ViewPosition;\r\n\r\n v_Texcoord = texcoord;\r\n\r\n}\r\n@end\r\n\r\n\r\n\r\n@export ecgl.sm.depth.fragment\r\n\r\n@import clay.sm.depth.fragment\r\n\r\n@end";