export default "@export ecgl.trail.vertex\r\n\r\nuniform mat4 worldViewProjection : WORLDVIEWPROJECTION;\r\nuniform float percent : 0.0;\r\nuniform float trailLength: 0.3;\r\n\r\nuniform sampler2D pointsTexture;\r\nuniform float textureWidth : 1024;\r\n\r\nuniform vec4 viewport : VIEWPORT;\r\nuniform float near : NEAR;\r\n\r\nattribute vec2 uv;\r\nattribute vec4 color : COLOR;\r\n\r\nattribute float start;\r\nattribute float prevT;\r\nattribute float currT;\r\nattribute float nextT;\r\nattribute float offset;\r\n\r\nvarying vec4 v_Color;\r\n\r\n@import ecgl.lines3D.clipNear\r\n\r\nvec3 getPointAt(in float off, in vec3 p0, in vec3 p1, in vec3 p2, in vec3 p3) {\r\n float t = max(min(mod(start + percent, (1.0 + trailLength)) + off, 1.0), 0.0);\r\n float onet = 1.0 - t;\r\n return onet * onet * (onet * p0 + 3.0 * t * p1)\r\n + t * t * (t * p3 + 3.0 * onet * p2);\r\n}\r\n\r\nvoid main()\r\n{\r\n vec2 unit = vec2(1.0 / textureWidth, 0.0);\r\n vec3 p0 = texture2D(pointsTexture, uv).rgb;\r\n vec3 p1 = texture2D(pointsTexture, uv + unit).rgb;\r\n vec3 p2 = texture2D(pointsTexture, uv + unit * 2.0).rgb;\r\n vec3 p3 = texture2D(pointsTexture, uv + unit * 3.0).rgb;\r\n\r\n vec3 positionPrev = getPointAt(prevT, p0, p1, p2, p3);\r\n vec3 position = getPointAt(currT, p0, p1, p2, p3);\r\n vec3 positionNext = getPointAt(nextT, p0, p1, p2, p3);\r\n\r\n @import ecgl.lines3D.expandLine\r\n\r\n gl_Position = currProj;\r\n\r\n v_Color = color;\r\n}\r\n\r\n@end\r\n\r\n@export ecgl.trail.fragment\r\n\r\nvarying vec4 v_Color;\r\n\r\nuniform sampler2D sprite;\r\n\r\nvoid main()\r\n{\r\n gl_FragColor = v_Color;\r\n\r\n#ifdef SPRITE_ENABLED\r\n gl_FragColor *= texture2D(sprite, gl_PointCoord);\r\n#endif\r\n\r\n}\r\n@end";
