export default "@export ecgl.atmosphere.vertex\r\nattribute vec3 position: POSITION;\r\nattribute vec3 normal : NORMAL;\r\nuniform mat4 worldViewProjection : WORLDVIEWPROJECTION;\r\nuniform mat4 normalMatrix : WORLDINVERSETRANSPOSE;\r\n\r\nvarying vec3 v_Normal;\r\n\r\nvoid main() {\r\n v_Normal = normalize((normalMatrix * vec4(normal, 0.0)).xyz);\r\n gl_Position = worldViewProjection * vec4(position, 1.0);\r\n}\r\n@end\r\n\r\n\r\n@export ecgl.atmosphere.fragment\r\nuniform mat4 viewTranspose: VIEWTRANSPOSE;\r\nuniform float glowPower;\r\nuniform vec3 glowColor;\r\n\r\nvarying vec3 v_Normal;\r\n\r\nvoid main() {\r\n float intensity = pow(1.0 - dot(v_Normal, (viewTranspose * vec4(0.0, 0.0, 1.0, 0.0)).xyz), glowPower);\r\n gl_FragColor = vec4(glowColor, intensity * intensity);\r\n}\r\n@end";
