export default "@export ecgl.dof.coc\r\n\r\nuniform sampler2D depth;\r\n\r\nuniform float zNear: 0.1;\r\nuniform float zFar: 2000;\r\n\r\nuniform float focalDistance: 3;\r\n// Object in range are perfectly in focus\r\nuniform float focalRange: 1;\r\n// 30mm\r\nuniform float focalLength: 30;\r\n// f/2.8\r\nuniform float fstop: 2.8;\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\n@import clay.util.encode_float\r\n\r\nvoid main()\r\n{\r\n float z = texture2D(depth, v_Texcoord).r * 2.0 - 1.0;\r\n\r\n float dist = 2.0 * zNear * zFar / (zFar + zNear - z * (zFar - zNear));\r\n\r\n float aperture = focalLength / fstop;\r\n\r\n float coc;\r\n\r\n float uppper = focalDistance + focalRange;\r\n float lower = focalDistance - focalRange;\r\n if (dist <= uppper && dist >= lower) {\r\n // Object in range are perfectly in focus\r\n coc = 0.5;\r\n }\r\n else {\r\n // Adjust focalDistance\r\n float focalAdjusted = dist > uppper ? uppper : lower;\r\n\r\n // GPU Gems Depth of Field: A Survey of Techniques\r\n coc = abs(aperture * (focalLength * (dist - focalAdjusted)) / (dist * (focalAdjusted - focalLength)));\r\n // Clamp on the near focus plane and far focus plane\r\n // PENDING\r\n // Float value can only be [0.0 - 1.0)\r\n coc = clamp(coc, 0.0, 2.0) / 2.00001;\r\n\r\n // Near field\r\n if (dist < lower) {\r\n coc = -coc;\r\n }\r\n coc = coc * 0.5 + 0.5;\r\n }\r\n\r\n // R: coc, < 0.5 is near field, > 0.5 is far field\r\n gl_FragColor = encodeFloat(coc);\r\n}\r\n@end\r\n\r\n\r\n@export ecgl.dof.composite\r\n\r\n#define DEBUG 0\r\n\r\nuniform sampler2D original;\r\nuniform sampler2D blurred;\r\nuniform sampler2D nearfield;\r\nuniform sampler2D coc;\r\nuniform sampler2D nearcoc;\r\nvarying vec2 v_Texcoord;\r\n\r\n@import clay.util.rgbm\r\n@import clay.util.float\r\n\r\nvoid main()\r\n{\r\n vec4 blurredColor = texture2D(blurred, v_Texcoord);\r\n vec4 originalColor = texture2D(original, v_Texcoord);\r\n\r\n float fCoc = decodeFloat(texture2D(coc, v_Texcoord));\r\n\r\n // FIXME blur after premultiply will have white edge\r\n // blurredColor.rgb /= max(fCoc, 0.1);\r\n fCoc = abs(fCoc * 2.0 - 1.0);\r\n\r\n float weight = smoothstep(0.0, 1.0, fCoc);\r\n // float weight = fCoc;\r\n\r\n#ifdef NEARFIELD_ENABLED\r\n vec4 nearfieldColor = texture2D(nearfield, v_Texcoord);\r\n float fNearCoc = decodeFloat(texture2D(nearcoc, v_Texcoord));\r\n fNearCoc = abs(fNearCoc * 2.0 - 1.0);\r\n\r\n // FIXME\r\n gl_FragColor = encodeHDR(\r\n mix(\r\n nearfieldColor, mix(originalColor, blurredColor, weight),\r\n // near field blur is too unobvious if use linear blending\r\n pow(1.0 - fNearCoc, 4.0)\r\n )\r\n );\r\n#else\r\n gl_FragColor = encodeHDR(mix(originalColor, blurredColor, weight));\r\n#endif\r\n\r\n// #if DEBUG == 1\r\n// // Show coc\r\n// gl_FragColor = vec4(vec3(fCoc), 1.0);\r\n// #elif DEBUG == 2\r\n// // Show near coc\r\n// gl_FragColor = vec4(vec3(fNearCoc), 1.0);\r\n// #elif DEBUG == 3\r\n// gl_FragColor = encodeHDR(blurredColor);\r\n// #elif DEBUG == 4\r\n// // gl_FragColor = vec4(vec3(nearfieldTexel.a), 1.0);\r\n// gl_FragColor = encodeHDR(nearfieldColor);\r\n// #endif\r\n}\r\n\r\n@end\r\n\r\n\r\n\r\n@export ecgl.dof.diskBlur\r\n\r\n#define POISSON_KERNEL_SIZE 16;\r\n\r\nuniform sampler2D texture;\r\nuniform sampler2D coc;\r\nvarying vec2 v_Texcoord;\r\n\r\nuniform float blurRadius : 10.0;\r\nuniform vec2 textureSize : [512.0, 512.0];\r\n\r\nuniform vec2 poissonKernel[POISSON_KERNEL_SIZE];\r\n\r\nuniform float percent;\r\n\r\nfloat nrand(const in vec2 n) {\r\n return fract(sin(dot(n.xy ,vec2(12.9898,78.233))) * 43758.5453);\r\n}\r\n\r\n@import clay.util.rgbm\r\n@import clay.util.float\r\n\r\n\r\nvoid main()\r\n{\r\n vec2 offset = blurRadius / textureSize;\r\n\r\n float rnd = 6.28318 * nrand(v_Texcoord + 0.07 * percent );\r\n float cosa = cos(rnd);\r\n float sina = sin(rnd);\r\n vec4 basis = vec4(cosa, -sina, sina, cosa);\r\n\r\n#if !defined(BLUR_NEARFIELD) && !defined(BLUR_COC)\r\n offset *= abs(decodeFloat(texture2D(coc, v_Texcoord)) * 2.0 - 1.0);\r\n#endif\r\n\r\n#ifdef BLUR_COC\r\n float cocSum = 0.0;\r\n#else\r\n vec4 color = vec4(0.0);\r\n#endif\r\n\r\n\r\n float weightSum = 0.0;\r\n\r\n for (int i = 0; i < POISSON_KERNEL_SIZE; i++) {\r\n vec2 ofs = poissonKernel[i];\r\n\r\n ofs = vec2(dot(ofs, basis.xy), dot(ofs, basis.zw));\r\n\r\n vec2 uv = v_Texcoord + ofs * offset;\r\n vec4 texel = texture2D(texture, uv);\r\n\r\n float w = 1.0;\r\n#ifdef BLUR_COC\r\n float fCoc = decodeFloat(texel) * 2.0 - 1.0;\r\n // Blur coc in nearfield\r\n cocSum += clamp(fCoc, -1.0, 0.0) * w;\r\n#else\r\n texel = texel;\r\n #if !defined(BLUR_NEARFIELD)\r\n float fCoc = decodeFloat(texture2D(coc, uv)) * 2.0 - 1.0;\r\n // TODO DOF premult to avoid bleeding, can be tweaked (currently x^3)\r\n // tradeoff between bleeding dof and out of focus object that shrinks too much\r\n w *= abs(fCoc);\r\n #endif\r\n texel.rgb *= texel.a;\r\n color += texel * w;\r\n#endif\r\n\r\n weightSum += w;\r\n }\r\n\r\n#ifdef BLUR_COC\r\n gl_FragColor = encodeFloat(clamp(cocSum / weightSum, -1.0, 0.0) * 0.5 + 0.5);\r\n#else\r\n color /= weightSum;\r\n color.rgb /= (color.a + 0.0001);\r\n // TODO Windows will not be totally transparent if color.rgb is not 0 and color.a is 0.\r\n gl_FragColor = color;\r\n#endif\r\n}\r\n\r\n@end";
