export default "@export ecgl.ssao.estimate\r\n\r\nuniform sampler2D depthTex;\r\n\r\nuniform sampler2D normalTex;\r\n\r\nuniform sampler2D noiseTex;\r\n\r\nuniform vec2 depthTexSize;\r\n\r\nuniform vec2 noiseTexSize;\r\n\r\nuniform mat4 projection;\r\n\r\nuniform mat4 projectionInv;\r\n\r\nuniform mat4 viewInverseTranspose;\r\n\r\nuniform vec3 kernel[KERNEL_SIZE];\r\n\r\nuniform float radius : 1;\r\n\r\n// PENDING\r\nuniform float power : 1;\r\n\r\nuniform float bias: 1e-2;\r\n\r\nuniform float intensity: 1.0;\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\nfloat ssaoEstimator(in vec3 originPos, in mat3 kernelBasis) {\r\n float occlusion = 0.0;\r\n\r\n for (int i = 0; i < KERNEL_SIZE; i++) {\r\n vec3 samplePos = kernel[i];\r\n#ifdef NORMALTEX_ENABLED\r\n samplePos = kernelBasis * samplePos;\r\n#endif\r\n samplePos = samplePos * radius + originPos;\r\n\r\n vec4 texCoord = projection * vec4(samplePos, 1.0);\r\n texCoord.xy /= texCoord.w;\r\n\r\n vec4 depthTexel = texture2D(depthTex, texCoord.xy * 0.5 + 0.5);\r\n\r\n float sampleDepth = depthTexel.r * 2.0 - 1.0;\r\n if (projection[3][3] == 0.0) {\r\n // Perspective\r\n sampleDepth = projection[3][2] / (sampleDepth * projection[2][3] - projection[2][2]);\r\n }\r\n else {\r\n // Symmetrical orthographic\r\n // PENDING\r\n sampleDepth = (sampleDepth - projection[3][2]) / projection[2][2];\r\n }\r\n // Consider orthographic projection\r\n // vec4 projectedPos = vec4(texCoord.xy, sampleDepth, 1.0);\r\n // vec4 p4 = projectionInv * projectedPos;\r\n // sampleDepth = p4.z / p4.w;\r\n\r\n float rangeCheck = smoothstep(0.0, 1.0, radius / abs(originPos.z - sampleDepth));\r\n occlusion += rangeCheck * step(samplePos.z, sampleDepth - bias);\r\n }\r\n#ifdef NORMALTEX_ENABLED\r\n occlusion = 1.0 - occlusion / float(KERNEL_SIZE);\r\n#else\r\n occlusion = 1.0 - clamp((occlusion / float(KERNEL_SIZE) - 0.6) * 2.5, 0.0, 1.0);\r\n#endif\r\n return pow(occlusion, power);\r\n}\r\n\r\nvoid main()\r\n{\r\n\r\n vec4 depthTexel = texture2D(depthTex, v_Texcoord);\r\n\r\n#ifdef NORMALTEX_ENABLED\r\n vec4 tex = texture2D(normalTex, v_Texcoord);\r\n // Is empty\r\n if (dot(tex.rgb, tex.rgb) == 0.0) {\r\n gl_FragColor = vec4(1.0);\r\n return;\r\n }\r\n vec3 N = tex.rgb * 2.0 - 1.0;\r\n N = (viewInverseTranspose * vec4(N, 0.0)).xyz;\r\n\r\n vec2 noiseTexCoord = depthTexSize / vec2(noiseTexSize) * v_Texcoord;\r\n vec3 rvec = texture2D(noiseTex, noiseTexCoord).rgb * 2.0 - 1.0;\r\n // Tangent\r\n vec3 T = normalize(rvec - N * dot(rvec, N));\r\n // Bitangent\r\n vec3 BT = normalize(cross(N, T));\r\n mat3 kernelBasis = mat3(T, BT, N);\r\n#else\r\n if (depthTexel.r > 0.99999) {\r\n gl_FragColor = vec4(1.0);\r\n return;\r\n }\r\n mat3 kernelBasis;\r\n#endif\r\n\r\n float z = depthTexel.r * 2.0 - 1.0;\r\n\r\n vec4 projectedPos = vec4(v_Texcoord * 2.0 - 1.0, z, 1.0);\r\n vec4 p4 = projectionInv * projectedPos;\r\n\r\n vec3 position = p4.xyz / p4.w;\r\n\r\n float ao = ssaoEstimator(position, kernelBasis);\r\n ao = clamp(1.0 - (1.0 - ao) * intensity, 0.0, 1.0);\r\n gl_FragColor = vec4(vec3(ao), 1.0);\r\n}\r\n\r\n@end\r\n\r\n\r\n@export ecgl.ssao.blur\r\n#define SHADER_NAME SSAO_BLUR\r\n\r\nuniform sampler2D ssaoTexture;\r\n\r\n#ifdef NORMALTEX_ENABLED\r\nuniform sampler2D normalTex;\r\n#endif\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\nuniform vec2 textureSize;\r\nuniform float blurSize : 1.0;\r\n\r\n// 0 horizontal, 1 vertical\r\nuniform int direction: 0.0;\r\n\r\n#ifdef DEPTHTEX_ENABLED\r\nuniform sampler2D depthTex;\r\nuniform mat4 projection;\r\nuniform float depthRange : 0.5;\r\n\r\nfloat getLinearDepth(vec2 coord)\r\n{\r\n float depth = texture2D(depthTex, coord).r * 2.0 - 1.0;\r\n return projection[3][2] / (depth * projection[2][3] - projection[2][2]);\r\n}\r\n#endif\r\n\r\nvoid main()\r\n{\r\n float kernel[5];\r\n kernel[0] = 0.122581;\r\n kernel[1] = 0.233062;\r\n kernel[2] = 0.288713;\r\n kernel[3] = 0.233062;\r\n kernel[4] = 0.122581;\r\n\r\n vec2 off = vec2(0.0);\r\n if (direction == 0) {\r\n off[0] = blurSize / textureSize.x;\r\n }\r\n else {\r\n off[1] = blurSize / textureSize.y;\r\n }\r\n\r\n vec2 coord = v_Texcoord;\r\n\r\n float sum = 0.0;\r\n float weightAll = 0.0;\r\n\r\n#ifdef NORMALTEX_ENABLED\r\n vec3 centerNormal = texture2D(normalTex, v_Texcoord).rgb * 2.0 - 1.0;\r\n#endif\r\n#if defined(DEPTHTEX_ENABLED)\r\n float centerDepth = getLinearDepth(v_Texcoord);\r\n#endif\r\n\r\n for (int i = 0; i < 5; i++) {\r\n vec2 coord = clamp(v_Texcoord + vec2(float(i) - 2.0) * off, vec2(0.0), vec2(1.0));\r\n\r\n float w = kernel[i];\r\n#ifdef NORMALTEX_ENABLED\r\n vec3 normal = texture2D(normalTex, coord).rgb * 2.0 - 1.0;\r\n w *= clamp(dot(normal, centerNormal), 0.0, 1.0);\r\n#endif\r\n#ifdef DEPTHTEX_ENABLED\r\n float d = getLinearDepth(coord);\r\n // PENDING Better equation?\r\n w *= (1.0 - smoothstep(abs(centerDepth - d) / depthRange, 0.0, 1.0));\r\n#endif\r\n\r\n weightAll += w;\r\n sum += texture2D(ssaoTexture, coord).r * w;\r\n }\r\n\r\n gl_FragColor = vec4(vec3(sum / weightAll), 1.0);\r\n// gl_FragColor = texture2D(ssaoTexture, v_Texcoord);\r\n}\r\n\r\n@end\r\n";
