export default "// http://www.kode80.com/blog/2015/03/11/screen-space-reflections-in-unity-5/\r\n// http://casual-effects.blogspot.jp/2014/08/screen-space-ray-tracing.html\r\n@export ecgl.ssr.main\r\n\r\n#define SHADER_NAME SSR\r\n#define MAX_ITERATION 20;\r\n#define SAMPLE_PER_FRAME 5;\r\n#define TOTAL_SAMPLES 128;\r\n\r\nuniform sampler2D sourceTexture;\r\nuniform sampler2D gBufferTexture1;\r\nuniform sampler2D gBufferTexture2;\r\nuniform sampler2D gBufferTexture3;\r\nuniform samplerCube specularCubemap;\r\nuniform float specularIntensity: 1;\r\n\r\nuniform mat4 projection;\r\nuniform mat4 projectionInv;\r\nuniform mat4 toViewSpace;\r\nuniform mat4 toWorldSpace;\r\n\r\nuniform float maxRayDistance: 200;\r\n\r\nuniform float pixelStride: 16;\r\nuniform float pixelStrideZCutoff: 50; // ray origin Z at this distance will have a pixel stride of 1.0\r\n\r\nuniform float screenEdgeFadeStart: 0.9; // distance to screen edge that ray hits will start to fade (0.0 -> 1.0)\r\n\r\nuniform float eyeFadeStart : 0.2; // ray direction's Z that ray hits will start to fade (0.0 -> 1.0)\r\nuniform float eyeFadeEnd: 0.8; // ray direction's Z that ray hits will be cut (0.0 -> 1.0)\r\n\r\nuniform float minGlossiness: 0.2; // Object larger than minGlossiness will have ssr effect\r\nuniform float zThicknessThreshold: 1;\r\n\r\nuniform float nearZ;\r\nuniform vec2 viewportSize : VIEWPORT_SIZE;\r\n\r\nuniform float jitterOffset: 0;\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\n#ifdef DEPTH_DECODE\r\n@import clay.util.decode_float\r\n#endif\r\n\r\n#ifdef PHYSICALLY_CORRECT\r\n// uniform vec3 lambertNormals[SAMPLE_PER_FRAME];\r\nuniform sampler2D normalDistribution;\r\nuniform float sampleOffset: 0;\r\nuniform vec2 normalDistributionSize;\r\n\r\nvec3 transformNormal(vec3 H, vec3 N) {\r\n vec3 upVector = N.y > 0.999 ? vec3(1.0, 0.0, 0.0) : vec3(0.0, 1.0, 0.0);\r\n vec3 tangentX = normalize(cross(N, upVector));\r\n vec3 tangentZ = cross(N, tangentX);\r\n // Tangent to world space\r\n return normalize(tangentX * H.x + N * H.y + tangentZ * H.z);\r\n}\r\nvec3 importanceSampleNormalGGX(float i, float roughness, vec3 N) {\r\n float p = fract((i + sampleOffset) / float(TOTAL_SAMPLES));\r\n vec3 H = texture2D(normalDistribution,vec2(roughness, p)).rgb;\r\n return transformNormal(H, N);\r\n}\r\nfloat G_Smith(float g, float ndv, float ndl) {\r\n float roughness = 1.0 - g;\r\n float k = roughness * roughness / 2.0;\r\n float G1V = ndv / (ndv * (1.0 - k) + k);\r\n float G1L = ndl / (ndl * (1.0 - k) + k);\r\n return G1L * G1V;\r\n}\r\nvec3 F_Schlick(float ndv, vec3 spec) {\r\n return spec + (1.0 - spec) * pow(1.0 - ndv, 5.0);\r\n}\r\n#endif\r\n\r\nfloat fetchDepth(sampler2D depthTexture, vec2 uv)\r\n{\r\n vec4 depthTexel = texture2D(depthTexture, uv);\r\n return depthTexel.r * 2.0 - 1.0;\r\n}\r\n\r\nfloat linearDepth(float depth)\r\n{\r\n if (projection[3][3] == 0.0) {\r\n // Perspective\r\n return projection[3][2] / (depth * projection[2][3] - projection[2][2]);\r\n }\r\n else {\r\n // Symmetrical orthographic\r\n // PENDING\r\n return (depth - projection[3][2]) / projection[2][2];\r\n }\r\n}\r\n\r\nbool rayIntersectDepth(float rayZNear, float rayZFar, vec2 hitPixel)\r\n{\r\n // Swap if bigger\r\n if (rayZFar > rayZNear)\r\n {\r\n float t = rayZFar; rayZFar = rayZNear; rayZNear = t;\r\n }\r\n float cameraZ = linearDepth(fetchDepth(gBufferTexture2, hitPixel));\r\n // Cross z\r\n return rayZFar <= cameraZ && rayZNear >= cameraZ - zThicknessThreshold;\r\n}\r\n\r\n// Trace a ray in screenspace from rayOrigin (in camera space) pointing in rayDir (in camera space)\r\n//\r\n// With perspective correct interpolation\r\n//\r\n// Returns true if the ray hits a pixel in the depth buffer\r\n// and outputs the hitPixel (in UV space), the hitPoint (in camera space) and the number\r\n// of iterations it took to get there.\r\n//\r\n// Based on Morgan McGuire & Mike Mara's GLSL implementation:\r\n// http://casual-effects.blogspot.com/2014/08/screen-space-ray-tracing.html\r\n\r\nbool traceScreenSpaceRay(\r\n vec3 rayOrigin, vec3 rayDir, float jitter,\r\n out vec2 hitPixel, out vec3 hitPoint, out float iterationCount\r\n)\r\n{\r\n // Clip to the near plane\r\n float rayLength = ((rayOrigin.z + rayDir.z * maxRayDistance) > -nearZ)\r\n ? (-nearZ - rayOrigin.z) / rayDir.z : maxRayDistance;\r\n\r\n vec3 rayEnd = rayOrigin + rayDir * rayLength;\r\n\r\n // Project into homogeneous clip space\r\n vec4 H0 = projection * vec4(rayOrigin, 1.0);\r\n vec4 H1 = projection * vec4(rayEnd, 1.0);\r\n\r\n float k0 = 1.0 / H0.w, k1 = 1.0 / H1.w;\r\n\r\n // The interpolated homogeneous version of the camera space points\r\n vec3 Q0 = rayOrigin * k0, Q1 = rayEnd * k1;\r\n\r\n // Screen space endpoints\r\n // PENDING viewportSize ?\r\n vec2 P0 = (H0.xy * k0 * 0.5 + 0.5) * viewportSize;\r\n vec2 P1 = (H1.xy * k1 * 0.5 + 0.5) * viewportSize;\r\n\r\n // If the line is degenerate, make it cover at least one pixel to avoid handling\r\n // zero-pixel extent as a special case later\r\n P1 += dot(P1 - P0, P1 - P0) < 0.0001 ? 0.01 : 0.0;\r\n vec2 delta = P1 - P0;\r\n\r\n // Permute so that the primary iteration is in x to collapse\r\n // all quadrant-specific DDA case later\r\n bool permute = false;\r\n if (abs(delta.x) < abs(delta.y)) {\r\n // More vertical line\r\n permute = true;\r\n delta = delta.yx;\r\n P0 = P0.yx;\r\n P1 = P1.yx;\r\n }\r\n float stepDir = sign(delta.x);\r\n float invdx = stepDir / delta.x;\r\n\r\n // Track the derivatives of Q and K\r\n vec3 dQ = (Q1 - Q0) * invdx;\r\n float dk = (k1 - k0) * invdx;\r\n\r\n vec2 dP = vec2(stepDir, delta.y * invdx);\r\n\r\n // Calculate pixel stride based on distance of ray origin from camera.\r\n // Since perspective means distant objects will be smaller in screen space\r\n // we can use this to have higher quality reflections for far away objects\r\n // while still using a large pixel stride for near objects (and increase performance)\r\n // this also helps mitigate artifacts on distant reflections when we use a large\r\n // pixel stride.\r\n float strideScaler = 1.0 - min(1.0, -rayOrigin.z / pixelStrideZCutoff);\r\n float pixStride = 1.0 + strideScaler * pixelStride;\r\n\r\n // Scale derivatives by the desired pixel stride and the offset the starting values by the jitter fraction\r\n dP *= pixStride; dQ *= pixStride; dk *= pixStride;\r\n\r\n // Track ray step and derivatives in a vec4 to parallelize\r\n vec4 pqk = vec4(P0, Q0.z, k0);\r\n vec4 dPQK = vec4(dP, dQ.z, dk);\r\n\r\n pqk += dPQK * jitter;\r\n float rayZFar = (dPQK.z * 0.5 + pqk.z) / (dPQK.w * 0.5 + pqk.w);\r\n float rayZNear;\r\n\r\n bool intersect = false;\r\n\r\n vec2 texelSize = 1.0 / viewportSize;\r\n\r\n iterationCount = 0.0;\r\n\r\n for (int i = 0; i < MAX_ITERATION; i++)\r\n {\r\n pqk += dPQK;\r\n\r\n rayZNear = rayZFar;\r\n rayZFar = (dPQK.z * 0.5 + pqk.z) / (dPQK.w * 0.5 + pqk.w);\r\n\r\n hitPixel = permute ? pqk.yx : pqk.xy;\r\n hitPixel *= texelSize;\r\n\r\n intersect = rayIntersectDepth(rayZNear, rayZFar, hitPixel);\r\n\r\n iterationCount += 1.0;\r\n\r\n dPQK *= 1.2;\r\n\r\n // PENDING Right on all platforms?\r\n if (intersect) {\r\n break;\r\n }\r\n }\r\n\r\n Q0.xy += dQ.xy * iterationCount;\r\n Q0.z = pqk.z;\r\n hitPoint = Q0 / pqk.w;\r\n\r\n return intersect;\r\n}\r\n\r\nfloat calculateAlpha(\r\n float iterationCount, float reflectivity,\r\n vec2 hitPixel, vec3 hitPoint, float dist, vec3 rayDir\r\n)\r\n{\r\n float alpha = clamp(reflectivity, 0.0, 1.0);\r\n // Fade ray hits that approach the maximum iterations\r\n alpha *= 1.0 - (iterationCount / float(MAX_ITERATION));\r\n // Fade ray hits that approach the screen edge\r\n vec2 hitPixelNDC = hitPixel * 2.0 - 1.0;\r\n float maxDimension = min(1.0, max(abs(hitPixelNDC.x), abs(hitPixelNDC.y)));\r\n alpha *= 1.0 - max(0.0, maxDimension - screenEdgeFadeStart) / (1.0 - screenEdgeFadeStart);\r\n\r\n // Fade ray hits base on how much they face the camera\r\n float _eyeFadeStart = eyeFadeStart;\r\n float _eyeFadeEnd = eyeFadeEnd;\r\n if (_eyeFadeStart > _eyeFadeEnd) {\r\n float tmp = _eyeFadeEnd;\r\n _eyeFadeEnd = _eyeFadeStart;\r\n _eyeFadeStart = tmp;\r\n }\r\n\r\n float eyeDir = clamp(rayDir.z, _eyeFadeStart, _eyeFadeEnd);\r\n alpha *= 1.0 - (eyeDir - _eyeFadeStart) / (_eyeFadeEnd - _eyeFadeStart);\r\n\r\n // Fade ray hits based on distance from ray origin\r\n alpha *= 1.0 - clamp(dist / maxRayDistance, 0.0, 1.0);\r\n\r\n return alpha;\r\n}\r\n\r\n@import clay.util.rand\r\n\r\n@import clay.util.rgbm\r\n\r\nvoid main()\r\n{\r\n vec4 normalAndGloss = texture2D(gBufferTexture1, v_Texcoord);\r\n\r\n // Is empty\r\n if (dot(normalAndGloss.rgb, vec3(1.0)) == 0.0) {\r\n discard;\r\n }\r\n\r\n float g = normalAndGloss.a;\r\n#if !defined(PHYSICALLY_CORRECT)\r\n if (g <= minGlossiness) {\r\n discard;\r\n }\r\n#endif\r\n\r\n float reflectivity = (g - minGlossiness) / (1.0 - minGlossiness);\r\n\r\n vec3 N = normalize(normalAndGloss.rgb * 2.0 - 1.0);\r\n N = normalize((toViewSpace * vec4(N, 0.0)).xyz);\r\n\r\n // Position in view\r\n vec4 projectedPos = vec4(v_Texcoord * 2.0 - 1.0, fetchDepth(gBufferTexture2, v_Texcoord), 1.0);\r\n vec4 pos = projectionInv * projectedPos;\r\n vec3 rayOrigin = pos.xyz / pos.w;\r\n vec3 V = -normalize(rayOrigin);\r\n\r\n float ndv = clamp(dot(N, V), 0.0, 1.0);\r\n float iterationCount;\r\n float jitter = rand(fract(v_Texcoord + jitterOffset));\r\n\r\n#ifdef PHYSICALLY_CORRECT\r\n vec4 color = vec4(vec3(0.0), 1.0);\r\n vec4 albedoMetalness = texture2D(gBufferTexture3, v_Texcoord);\r\n vec3 albedo = albedoMetalness.rgb;\r\n float m = albedoMetalness.a;\r\n vec3 diffuseColor = albedo * (1.0 - m);\r\n vec3 spec = mix(vec3(0.04), albedo, m);\r\n\r\n // PENDING Add noise?\r\n float jitter2 = rand(fract(v_Texcoord)) * float(TOTAL_SAMPLES);\r\n\r\n for (int i = 0; i < SAMPLE_PER_FRAME; i++) {\r\n vec3 H = importanceSampleNormalGGX(float(i) + jitter2, 1.0 - g, N);\r\n // TODO Normal\r\n // vec3 H = transformNormal(lambertNormals[i], N);\r\n // vec3 rayDir = H;\r\n vec3 rayDir = normalize(reflect(-V, H));\r\n#else\r\n vec3 rayDir = normalize(reflect(-V, N));\r\n#endif\r\n vec2 hitPixel;\r\n vec3 hitPoint;\r\n\r\n bool intersect = traceScreenSpaceRay(rayOrigin, rayDir, jitter, hitPixel, hitPoint, iterationCount);\r\n\r\n float dist = distance(rayOrigin, hitPoint);\r\n\r\n vec3 hitNormal = texture2D(gBufferTexture1, hitPixel).rgb * 2.0 - 1.0;\r\n hitNormal = normalize((toViewSpace * vec4(hitNormal, 0.0)).xyz);\r\n#ifdef PHYSICALLY_CORRECT\r\n float ndl = clamp(dot(N, rayDir), 0.0, 1.0);\r\n float vdh = clamp(dot(V, H), 0.0, 1.0);\r\n float ndh = clamp(dot(N, H), 0.0, 1.0);\r\n vec3 litTexel = vec3(0.0);\r\n if (dot(hitNormal, rayDir) < 0.0 && intersect) {\r\n litTexel = texture2D(sourceTexture, hitPixel).rgb;\r\n // PENDING\r\n litTexel *= pow(clamp(1.0 - dist / 200.0, 0.0, 1.0), 3.0);\r\n\r\n // color.rgb += ndl * litTexel * fade * diffuseColor;\r\n }\r\n else {\r\n // Fetch from environment\r\n#ifdef SPECULARCUBEMAP_ENABLED\r\n vec3 rayDirW = normalize(toWorldSpace * vec4(rayDir, 0.0)).rgb;\r\n litTexel = RGBMDecode(textureCubeLodEXT(specularCubemap, rayDirW, 0.0), 8.12).rgb * specularIntensity;\r\n#endif\r\n }\r\n color.rgb += ndl * litTexel * (\r\n F_Schlick(ndl, spec) * G_Smith(g, ndv, ndl) * vdh / (ndh * ndv + 0.001)\r\n );\r\n }\r\n color.rgb /= float(SAMPLE_PER_FRAME);\r\n#else\r\n // Ignore the pixel not face the ray\r\n // TODO fadeout ?\r\n // PENDING Can be configured?\r\n#if !defined(SPECULARCUBEMAP_ENABLED)\r\n if (dot(hitNormal, rayDir) >= 0.0) {\r\n discard;\r\n }\r\n if (!intersect) {\r\n discard;\r\n }\r\n#endif\r\n float alpha = clamp(calculateAlpha(iterationCount, reflectivity, hitPixel, hitPoint, dist, rayDir), 0.0, 1.0);\r\n vec4 color = texture2D(sourceTexture, hitPixel);\r\n color.rgb *= alpha;\r\n\r\n#ifdef SPECULARCUBEMAP_ENABLED\r\n vec3 rayDirW = normalize(toWorldSpace * vec4(rayDir, 0.0)).rgb;\r\n alpha = alpha * (intersect ? 1.0 : 0.0);\r\n float bias = (1.0 -g) * 5.0;\r\n color.rgb += (1.0 - alpha)\r\n * RGBMDecode(textureCubeLodEXT(specularCubemap, rayDirW, bias), 8.12).rgb\r\n * specularIntensity;\r\n#endif\r\n\r\n#endif\r\n\r\n gl_FragColor = encodeHDR(color);\r\n}\r\n@end\r\n\r\n// https://bartwronski.com/2014/03/23/gdc-follow-up-screenspace-reflections-filtering-and-up-sampling/\r\n@export ecgl.ssr.blur\r\n\r\nuniform sampler2D texture;\r\nuniform sampler2D gBufferTexture1;\r\nuniform sampler2D gBufferTexture2;\r\nuniform mat4 projection;\r\nuniform float depthRange : 0.05;\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\nuniform vec2 textureSize;\r\nuniform float blurSize : 1.0;\r\n\r\n#ifdef BLEND\r\n #ifdef SSAOTEX_ENABLED\r\nuniform sampler2D ssaoTex;\r\n #endif\r\nuniform sampler2D sourceTexture;\r\n#endif\r\n\r\nfloat getLinearDepth(vec2 coord)\r\n{\r\n float depth = texture2D(gBufferTexture2, coord).r * 2.0 - 1.0;\r\n return projection[3][2] / (depth * projection[2][3] - projection[2][2]);\r\n}\r\n\r\n@import clay.util.rgbm\r\n\r\n\r\nvoid main()\r\n{\r\n @import clay.compositor.kernel.gaussian_9\r\n\r\n vec4 centerNTexel = texture2D(gBufferTexture1, v_Texcoord);\r\n float g = centerNTexel.a;\r\n float maxBlurSize = clamp(1.0 - g, 0.0, 1.0) * blurSize;\r\n#ifdef VERTICAL\r\n vec2 off = vec2(0.0, maxBlurSize / textureSize.y);\r\n#else\r\n vec2 off = vec2(maxBlurSize / textureSize.x, 0.0);\r\n#endif\r\n\r\n vec2 coord = v_Texcoord;\r\n\r\n vec4 sum = vec4(0.0);\r\n float weightAll = 0.0;\r\n\r\n vec3 cN = centerNTexel.rgb * 2.0 - 1.0;\r\n float cD = getLinearDepth(v_Texcoord);\r\n for (int i = 0; i < 9; i++) {\r\n vec2 coord = clamp((float(i) - 4.0) * off + v_Texcoord, vec2(0.0), vec2(1.0));\r\n float w = gaussianKernel[i]\r\n * clamp(dot(cN, texture2D(gBufferTexture1, coord).rgb * 2.0 - 1.0), 0.0, 1.0);\r\n float d = getLinearDepth(coord);\r\n w *= (1.0 - smoothstep(abs(cD - d) / depthRange, 0.0, 1.0));\r\n\r\n weightAll += w;\r\n sum += decodeHDR(texture2D(texture, coord)) * w;\r\n }\r\n\r\n#ifdef BLEND\r\n float aoFactor = 1.0;\r\n #ifdef SSAOTEX_ENABLED\r\n aoFactor = texture2D(ssaoTex, v_Texcoord).r;\r\n #endif\r\n gl_FragColor = encodeHDR(\r\n sum / weightAll * aoFactor + decodeHDR(texture2D(sourceTexture, v_Texcoord))\r\n );\r\n#else\r\n gl_FragColor = encodeHDR(sum / weightAll);\r\n#endif\r\n}\r\n\r\n@end";
