export default "// COMMON SHADERS\r\n\r\n// ----------------- UNIFORM AND ATTRIBUTES -----------\r\n@export ecgl.common.transformUniforms\r\nuniform mat4 worldViewProjection : WORLDVIEWPROJECTION;\r\nuniform mat4 worldInverseTranspose : WORLDINVERSETRANSPOSE;\r\nuniform mat4 world : WORLD;\r\n@end\r\n\r\n@export ecgl.common.attributes\r\nattribute vec3 position : POSITION;\r\nattribute vec2 texcoord : TEXCOORD_0;\r\nattribute vec3 normal : NORMAL;\r\n@end\r\n\r\n@export ecgl.common.uv.header\r\nuniform vec2 uvRepeat : [1.0, 1.0];\r\nuniform vec2 uvOffset : [0.0, 0.0];\r\nuniform vec2 detailUvRepeat : [1.0, 1.0];\r\nuniform vec2 detailUvOffset : [0.0, 0.0];\r\n\r\nvarying vec2 v_Texcoord;\r\nvarying vec2 v_DetailTexcoord;\r\n@end\r\n\r\n@export ecgl.common.uv.main\r\nv_Texcoord = texcoord * uvRepeat + uvOffset;\r\nv_DetailTexcoord = texcoord * detailUvRepeat + detailUvOffset;\r\n@end\r\n\r\n@export ecgl.common.uv.fragmentHeader\r\nvarying vec2 v_Texcoord;\r\nvarying vec2 v_DetailTexcoord;\r\n@end\r\n\r\n// ----------------- albedo -----------\r\n\r\n@export ecgl.common.albedo.main\r\n\r\n vec4 albedoTexel = vec4(1.0);\r\n#ifdef DIFFUSEMAP_ENABLED\r\n albedoTexel = texture2D(diffuseMap, v_Texcoord);\r\n #ifdef SRGB_DECODE\r\n albedoTexel = sRGBToLinear(albedoTexel);\r\n #endif\r\n#endif\r\n\r\n#ifdef DETAILMAP_ENABLED\r\n vec4 detailTexel = texture2D(detailMap, v_DetailTexcoord);\r\n #ifdef SRGB_DECODE\r\n detailTexel = sRGBToLinear(detailTexel);\r\n #endif\r\n albedoTexel.rgb = mix(albedoTexel.rgb, detailTexel.rgb, detailTexel.a);\r\n albedoTexel.a = detailTexel.a + (1.0 - detailTexel.a) * albedoTexel.a;\r\n#endif\r\n\r\n@end\r\n\r\n// -----------------WIREFRAME -----------\r\n@export ecgl.common.wireframe.vertexHeader\r\n\r\n#ifdef WIREFRAME_QUAD\r\nattribute vec4 barycentric;\r\nvarying vec4 v_Barycentric;\r\n#elif defined(WIREFRAME_TRIANGLE)\r\nattribute vec3 barycentric;\r\nvarying vec3 v_Barycentric;\r\n#endif\r\n\r\n@end\r\n\r\n@export ecgl.common.wireframe.vertexMain\r\n\r\n#if defined(WIREFRAME_QUAD) || defined(WIREFRAME_TRIANGLE)\r\n v_Barycentric = barycentric;\r\n#endif\r\n\r\n@end\r\n\r\n\r\n@export ecgl.common.wireframe.fragmentHeader\r\n\r\nuniform float wireframeLineWidth : 1;\r\nuniform vec4 wireframeLineColor: [0, 0, 0, 0.5];\r\n\r\n#ifdef WIREFRAME_QUAD\r\nvarying vec4 v_Barycentric;\r\nfloat edgeFactor () {\r\n vec4 d = fwidth(v_Barycentric);\r\n vec4 a4 = smoothstep(vec4(0.0), d * wireframeLineWidth, v_Barycentric);\r\n return min(min(min(a4.x, a4.y), a4.z), a4.w);\r\n}\r\n#elif defined(WIREFRAME_TRIANGLE)\r\nvarying vec3 v_Barycentric;\r\nfloat edgeFactor () {\r\n vec3 d = fwidth(v_Barycentric);\r\n vec3 a3 = smoothstep(vec3(0.0), d * wireframeLineWidth, v_Barycentric);\r\n return min(min(a3.x, a3.y), a3.z);\r\n}\r\n#endif\r\n\r\n@end\r\n\r\n\r\n@export ecgl.common.wireframe.fragmentMain\r\n\r\n#if defined(WIREFRAME_QUAD) || defined(WIREFRAME_TRIANGLE)\r\n if (wireframeLineWidth > 0.) {\r\n vec4 lineColor = wireframeLineColor;\r\n#ifdef SRGB_DECODE\r\n lineColor = sRGBToLinear(lineColor);\r\n#endif\r\n\r\n gl_FragColor.rgb = mix(gl_FragColor.rgb, lineColor.rgb, (1.0 - edgeFactor()) * lineColor.a);\r\n }\r\n#endif\r\n@end\r\n\r\n\r\n\r\n// ----------------- Bumpmap and normal map -----------\r\n\r\n@export ecgl.common.bumpMap.header\r\n\r\n#ifdef BUMPMAP_ENABLED\r\nuniform sampler2D bumpMap;\r\nuniform float bumpScale : 1.0;\r\n// Derivative maps - bump mapping unparametrized surfaces by Morten Mikkelsen\r\n// http://mmikkelsen3d.blogspot.sk/2011/07/derivative-maps.html\r\n\r\n// Evaluate the derivative of the height w.r.t. screen-space using forward differencing (listing 2)\r\n\r\nvec3 bumpNormal(vec3 surfPos, vec3 surfNormal, vec3 baseNormal)\r\n{\r\n vec2 dSTdx = dFdx(v_Texcoord);\r\n vec2 dSTdy = dFdy(v_Texcoord);\r\n\r\n float Hll = bumpScale * texture2D(bumpMap, v_Texcoord).x;\r\n float dHx = bumpScale * texture2D(bumpMap, v_Texcoord + dSTdx).x - Hll;\r\n float dHy = bumpScale * texture2D(bumpMap, v_Texcoord + dSTdy).x - Hll;\r\n\r\n vec3 vSigmaX = dFdx(surfPos);\r\n vec3 vSigmaY = dFdy(surfPos);\r\n vec3 vN = surfNormal;\r\n\r\n vec3 R1 = cross(vSigmaY, vN);\r\n vec3 R2 = cross(vN, vSigmaX);\r\n\r\n float fDet = dot(vSigmaX, R1);\r\n\r\n vec3 vGrad = sign(fDet) * (dHx * R1 + dHy * R2);\r\n return normalize(abs(fDet) * baseNormal - vGrad);\r\n\r\n}\r\n#endif\r\n\r\n@end\r\n\r\n@export ecgl.common.normalMap.vertexHeader\r\n\r\n#ifdef NORMALMAP_ENABLED\r\nattribute vec4 tangent : TANGENT;\r\nvarying vec3 v_Tangent;\r\nvarying vec3 v_Bitangent;\r\n#endif\r\n\r\n@end\r\n\r\n@export ecgl.common.normalMap.vertexMain\r\n\r\n#ifdef NORMALMAP_ENABLED\r\n if (dot(tangent, tangent) > 0.0) {\r\n v_Tangent = normalize((worldInverseTranspose * vec4(tangent.xyz, 0.0)).xyz);\r\n v_Bitangent = normalize(cross(v_Normal, v_Tangent) * tangent.w);\r\n }\r\n#endif\r\n\r\n@end\r\n\r\n\r\n@export ecgl.common.normalMap.fragmentHeader\r\n\r\n#ifdef NORMALMAP_ENABLED\r\nuniform sampler2D normalMap;\r\nvarying vec3 v_Tangent;\r\nvarying vec3 v_Bitangent;\r\n#endif\r\n\r\n@end\r\n\r\n@export ecgl.common.normalMap.fragmentMain\r\n#ifdef NORMALMAP_ENABLED\r\n if (dot(v_Tangent, v_Tangent) > 0.0) {\r\n vec3 normalTexel = texture2D(normalMap, v_DetailTexcoord).xyz;\r\n if (dot(normalTexel, normalTexel) > 0.0) { // Valid normal map\r\n N = normalTexel * 2.0 - 1.0;\r\n mat3 tbn = mat3(v_Tangent, v_Bitangent, v_Normal);\r\n N = normalize(tbn * N);\r\n }\r\n }\r\n#endif\r\n@end\r\n\r\n\r\n//----------- Vertex animation ---------\r\n\r\n@export ecgl.common.vertexAnimation.header\r\n\r\n#ifdef VERTEX_ANIMATION\r\nattribute vec3 prevPosition;\r\nattribute vec3 prevNormal;\r\nuniform float percent;\r\n#endif\r\n\r\n@end\r\n\r\n@export ecgl.common.vertexAnimation.main\r\n\r\n#ifdef VERTEX_ANIMATION\r\n vec3 pos = mix(prevPosition, position, percent);\r\n vec3 norm = mix(prevNormal, normal, percent);\r\n#else\r\n vec3 pos = position;\r\n vec3 norm = normal;\r\n#endif\r\n\r\n@end\r\n\r\n//---------- SSAO MAP -------\r\n\r\n@export ecgl.common.ssaoMap.header\r\n#ifdef SSAOMAP_ENABLED\r\nuniform sampler2D ssaoMap;\r\nuniform vec4 viewport : VIEWPORT;\r\n#endif\r\n@end\r\n\r\n@export ecgl.common.ssaoMap.main\r\n float ao = 1.0;\r\n#ifdef SSAOMAP_ENABLED\r\n ao = texture2D(ssaoMap, (gl_FragCoord.xy - viewport.xy) / viewport.zw).r;\r\n#endif\r\n@end\r\n\r\n\r\n//----------- Layers ---------\r\n\r\n\r\n@export ecgl.common.diffuseLayer.header\r\n\r\n#if (LAYER_DIFFUSEMAP_COUNT > 0)\r\nuniform float layerDiffuseIntensity[LAYER_DIFFUSEMAP_COUNT];\r\nuniform sampler2D layerDiffuseMap[LAYER_DIFFUSEMAP_COUNT];\r\n#endif\r\n\r\n@end\r\n\r\n@export ecgl.common.emissiveLayer.header\r\n\r\n#if (LAYER_EMISSIVEMAP_COUNT > 0)\r\nuniform float layerEmissionIntensity[LAYER_EMISSIVEMAP_COUNT];\r\nuniform sampler2D layerEmissiveMap[LAYER_EMISSIVEMAP_COUNT];\r\n#endif\r\n\r\n@end\r\n\r\n@export ecgl.common.layers.header\r\n@import ecgl.common.diffuseLayer.header\r\n@import ecgl.common.emissiveLayer.header\r\n@end\r\n\r\n@export ecgl.common.diffuseLayer.main\r\n\r\n#if (LAYER_DIFFUSEMAP_COUNT > 0)\r\n for (int _idx_ = 0; _idx_ < LAYER_DIFFUSEMAP_COUNT; _idx_++) {{\r\n float intensity = layerDiffuseIntensity[_idx_];\r\n vec4 texel2 = texture2D(layerDiffuseMap[_idx_], v_Texcoord);\r\n #ifdef SRGB_DECODE\r\n texel2 = sRGBToLinear(texel2);\r\n #endif\r\n // source-over blend\r\n albedoTexel.rgb = mix(albedoTexel.rgb, texel2.rgb * intensity, texel2.a);\r\n albedoTexel.a = texel2.a + (1.0 - texel2.a) * albedoTexel.a;\r\n }}\r\n#endif\r\n\r\n@end\r\n\r\n@export ecgl.common.emissiveLayer.main\r\n\r\n#if (LAYER_EMISSIVEMAP_COUNT > 0)\r\n for (int _idx_ = 0; _idx_ < LAYER_EMISSIVEMAP_COUNT; _idx_++)\r\n {{\r\n vec4 texel2 = texture2D(layerEmissiveMap[_idx_], v_Texcoord) * layerEmissionIntensity[_idx_];\r\n #ifdef SRGB_DECODE\r\n texel2 = sRGBToLinear(texel2);\r\n #endif\r\n float intensity = layerEmissionIntensity[_idx_];\r\n gl_FragColor.rgb += texel2.rgb * texel2.a * intensity;\r\n }}\r\n#endif\r\n\r\n@end\r\n";
