export default "@export ecgl.labels.vertex\r\n\r\n// https://mattdesl.svbtle.com/drawing-lines-is-hard\r\nattribute vec3 position: POSITION;\r\nattribute vec2 texcoord: TEXCOORD_0;\r\nattribute vec2 offset;\r\n#ifdef VERTEX_COLOR\r\nattribute vec4 a_Color : COLOR;\r\nvarying vec4 v_Color;\r\n#endif\r\n\r\nuniform mat4 worldViewProjection : WORLDVIEWPROJECTION;\r\nuniform vec4 viewport : VIEWPORT;\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\nvoid main()\r\n{\r\n vec4 proj = worldViewProjection * vec4(position, 1.0);\r\n\r\n vec2 screen = (proj.xy / abs(proj.w) + 1.0) * 0.5 * viewport.zw;\r\n\r\n screen += offset;\r\n\r\n proj.xy = (screen / viewport.zw - 0.5) * 2.0 * abs(proj.w);\r\n gl_Position = proj;\r\n#ifdef VERTEX_COLOR\r\n v_Color = a_Color;\r\n#endif\r\n v_Texcoord = texcoord;\r\n}\r\n@end\r\n\r\n\r\n@export ecgl.labels.fragment\r\n\r\nuniform vec3 color : [1.0, 1.0, 1.0];\r\nuniform float alpha : 1.0;\r\nuniform sampler2D textureAtlas;\r\nuniform vec2 uvScale: [1.0, 1.0];\r\n\r\n#ifdef VERTEX_COLOR\r\nvarying vec4 v_Color;\r\n#endif\r\nvarying float v_Miter;\r\n\r\nvarying vec2 v_Texcoord;\r\n\r\nvoid main()\r\n{\r\n gl_FragColor = vec4(color, alpha) * texture2D(textureAtlas, v_Texcoord * uvScale);\r\n#ifdef VERTEX_COLOR\r\n gl_FragColor *= v_Color;\r\n#endif\r\n}\r\n\r\n@end";
