export default "/**\r\n * http://en.wikipedia.org/wiki/Lambertian_reflectance\r\n */\r\n\r\n@export ecgl.lambert.vertex\r\n\r\n@import ecgl.common.transformUniforms\r\n\r\n@import ecgl.common.uv.header\r\n\r\n\r\n@import ecgl.common.attributes\r\n\r\n@import ecgl.common.wireframe.vertexHeader\r\n\r\n#ifdef VERTEX_COLOR\r\nattribute vec4 a_Color : COLOR;\r\nvarying vec4 v_Color;\r\n#endif\r\n\r\n\r\n@import ecgl.common.vertexAnimation.header\r\n\r\n\r\nvarying vec3 v_Normal;\r\nvarying vec3 v_WorldPosition;\r\n\r\nvoid main()\r\n{\r\n @import ecgl.common.uv.main\r\n\r\n @import ecgl.common.vertexAnimation.main\r\n\r\n\r\n gl_Position = worldViewProjection * vec4(pos, 1.0);\r\n\r\n v_Normal = normalize((worldInverseTranspose * vec4(norm, 0.0)).xyz);\r\n v_WorldPosition = (world * vec4(pos, 1.0)).xyz;\r\n\r\n#ifdef VERTEX_COLOR\r\n v_Color = a_Color;\r\n#endif\r\n\r\n @import ecgl.common.wireframe.vertexMain\r\n}\r\n\r\n@end\r\n\r\n\r\n@export ecgl.lambert.fragment\r\n\r\n#define LAYER_DIFFUSEMAP_COUNT 0\r\n#define LAYER_EMISSIVEMAP_COUNT 0\r\n\r\n#define NORMAL_UP_AXIS 1\r\n#define NORMAL_FRONT_AXIS 2\r\n\r\n@import ecgl.common.uv.fragmentHeader\r\n\r\nvarying vec3 v_Normal;\r\nvarying vec3 v_WorldPosition;\r\n\r\nuniform sampler2D diffuseMap;\r\nuniform sampler2D detailMap;\r\n\r\n@import ecgl.common.layers.header\r\n\r\nuniform float emissionIntensity: 1.0;\r\n\r\nuniform vec4 color : [1.0, 1.0, 1.0, 1.0];\r\n\r\nuniform mat4 viewInverse : VIEWINVERSE;\r\n\r\n#ifdef ATMOSPHERE_ENABLED\r\nuniform mat4 viewTranspose: VIEWTRANSPOSE;\r\nuniform vec3 glowColor;\r\nuniform float glowPower;\r\n#endif\r\n\r\n#ifdef AMBIENT_LIGHT_COUNT\r\n@import clay.header.ambient_light\r\n#endif\r\n#ifdef AMBIENT_SH_LIGHT_COUNT\r\n@import clay.header.ambient_sh_light\r\n#endif\r\n\r\n#ifdef DIRECTIONAL_LIGHT_COUNT\r\n@import clay.header.directional_light\r\n#endif\r\n\r\n#ifdef VERTEX_COLOR\r\nvarying vec4 v_Color;\r\n#endif\r\n\r\n\r\n@import ecgl.common.ssaoMap.header\r\n\r\n@import ecgl.common.bumpMap.header\r\n\r\n@import clay.util.srgb\r\n\r\n@import ecgl.common.wireframe.fragmentHeader\r\n\r\n@import clay.plugin.compute_shadow_map\r\n\r\nvoid main()\r\n{\r\n#ifdef SRGB_DECODE\r\n gl_FragColor = sRGBToLinear(color);\r\n#else\r\n gl_FragColor = color;\r\n#endif\r\n\r\n#ifdef VERTEX_COLOR\r\n // PENDING\r\n #ifdef SRGB_DECODE\r\n gl_FragColor *= sRGBToLinear(v_Color);\r\n #else\r\n gl_FragColor *= v_Color;\r\n #endif\r\n#endif\r\n\r\n @import ecgl.common.albedo.main\r\n\r\n @import ecgl.common.diffuseLayer.main\r\n\r\n gl_FragColor *= albedoTexel;\r\n\r\n vec3 N = v_Normal;\r\n#ifdef DOUBLE_SIDED\r\n vec3 eyePos = viewInverse[3].xyz;\r\n vec3 V = normalize(eyePos - v_WorldPosition);\r\n\r\n if (dot(N, V) < 0.0) {\r\n N = -N;\r\n }\r\n#endif\r\n\r\n float ambientFactor = 1.0;\r\n\r\n#ifdef BUMPMAP_ENABLED\r\n N = bumpNormal(v_WorldPosition, v_Normal, N);\r\n // PENDING\r\n ambientFactor = dot(v_Normal, N);\r\n#endif\r\n\r\n vec3 N2 = vec3(N.x, N[NORMAL_UP_AXIS], N[NORMAL_FRONT_AXIS]);\r\n\r\n vec3 diffuseColor = vec3(0.0, 0.0, 0.0);\r\n\r\n @import ecgl.common.ssaoMap.main\r\n\r\n#ifdef AMBIENT_LIGHT_COUNT\r\n for(int i = 0; i < AMBIENT_LIGHT_COUNT; i++)\r\n {\r\n // Multiply a dot factor to make sure the bump detail can be seen\r\n // in the dark side\r\n diffuseColor += ambientLightColor[i] * ambientFactor * ao;\r\n }\r\n#endif\r\n#ifdef AMBIENT_SH_LIGHT_COUNT\r\n for(int _idx_ = 0; _idx_ < AMBIENT_SH_LIGHT_COUNT; _idx_++)\r\n {{\r\n diffuseColor += calcAmbientSHLight(_idx_, N2) * ambientSHLightColor[_idx_] * ao;\r\n }}\r\n#endif\r\n#ifdef DIRECTIONAL_LIGHT_COUNT\r\n#if defined(DIRECTIONAL_LIGHT_SHADOWMAP_COUNT)\r\n float shadowContribsDir[DIRECTIONAL_LIGHT_COUNT];\r\n if(shadowEnabled)\r\n {\r\n computeShadowOfDirectionalLights(v_WorldPosition, shadowContribsDir);\r\n }\r\n#endif\r\n for(int i = 0; i < DIRECTIONAL_LIGHT_COUNT; i++)\r\n {\r\n vec3 lightDirection = -directionalLightDirection[i];\r\n vec3 lightColor = directionalLightColor[i];\r\n\r\n float shadowContrib = 1.0;\r\n#if defined(DIRECTIONAL_LIGHT_SHADOWMAP_COUNT)\r\n if (shadowEnabled)\r\n {\r\n shadowContrib = shadowContribsDir[i];\r\n }\r\n#endif\r\n\r\n float ndl = dot(N, normalize(lightDirection)) * shadowContrib;\r\n\r\n diffuseColor += lightColor * clamp(ndl, 0.0, 1.0);\r\n }\r\n#endif\r\n\r\n gl_FragColor.rgb *= diffuseColor;\r\n\r\n#ifdef ATMOSPHERE_ENABLED\r\n float atmoIntensity = pow(1.0 - dot(v_Normal, (viewTranspose * vec4(0.0, 0.0, 1.0, 0.0)).xyz), glowPower);\r\n gl_FragColor.rgb += glowColor * atmoIntensity;\r\n#endif\r\n\r\n @import ecgl.common.emissiveLayer.main\r\n\r\n @import ecgl.common.wireframe.fragmentMain\r\n}\r\n\r\n@end";
