@export ecgl.sm.depth.vertex

uniform mat4 worldViewProjection : WORLDVIEWPROJECTION;

attribute vec3 position : POSITION;

#ifdef VERTEX_ANIMATION
attribute vec3 prevPosition;
uniform float percent : 1.0;
#endif

varying vec4 v_ViewPosition;

void main(){

#ifdef VERTEX_ANIMATION
    vec3 pos = mix(prevPosition, position, percent);
#else
    vec3 pos = position;
#endif

    v_ViewPosition = worldViewProjection * vec4(pos, 1.0);
    gl_Position = v_ViewPosition;

}
@end



@export ecgl.sm.depth.fragment

@import clay.sm.depth.fragment

@end