import SeriesModel from '../../model/Series';
import { SeriesOption, SeriesOnCartesianOptionMixin, SeriesOnPolarOptionMixin, ScaleDataValue, DefaultExtraStateOpts } from '../../util/types';
import GlobalModel from '../../model/Global';
import List from '../../data/List';
export interface BaseBarSeriesOption<StateOption, ExtraStateOption = DefaultExtraStateOpts> extends SeriesOption<StateOption, ExtraStateOption>, SeriesOnCartesianOptionMixin, SeriesOnPolarOptionMixin {
    /**
     * Min height of bar
     */
    barMinHeight?: number;
    /**
     * Min angle of bar. Avaiable on polar coordinate system
     */
    barMinAngle?: number;
    /**
     * Max width of bar. Default to be 1 on cartesian coordinate system. Otherwise it's null
     */
    barMaxWidth?: number;
    barMinWidth?: number;
    /**
     * Bar width. Will be calculated automatically.
     * Can be pixel width or percent string.
     */
    barWidth?: number | string;
    /**
     * Gap between each bar inside category. Default to be 30%. Can be an aboslute pixel value
     */
    barGap?: string | number;
    /**
     * Gap between each category. Default to be 20%. can be an absolute pixel value.
     */
    barCategoryGap?: string | number;
    large?: boolean;
    largeThreshold?: number;
}
declare class BaseBarSeriesModel<Opts extends BaseBarSeriesOption<unknown> = BaseBarSeriesOption<unknown>> extends SeriesModel<Opts> {
    static type: string;
    type: string;
    getInitialData(option: Opts, ecModel: GlobalModel): List;
    getMarkerPosition(value: ScaleDataValue[]): number[];
    static defaultOption: BaseBarSeriesOption<unknown, unknown>;
}
export default BaseBarSeriesModel;
