(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'react', 'underscore', 'react-bootstrap', 'deepmerge'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('react'), require('underscore'), require('react-bootstrap'), require('deepmerge'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.react, global.underscore, global.reactBootstrap, global.deepmerge);
        global.Ardagryd = mod.exports;
    }
})(this, function (exports, _react, _underscore, _reactBootstrap, _deepmerge) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.Grid = undefined;

    var _react2 = _interopRequireDefault(_react);

    var _underscore2 = _interopRequireDefault(_underscore);

    var _deepmerge2 = _interopRequireDefault(_deepmerge);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
        return typeof obj;
    } : function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj;
    };

    var ASCENDING = "asc";
    var DESCENDING = "desc";

    //Workaround. See -> https://phabricator.babeljs.io/T6777
    typeof undefined === 'undefined' ? 'undefined' : _typeof(undefined);

    var Ardagryd = function Ardagryd(props) {
        //Merge custom and default config
        var config = Object.assign({}, defaultConfig, props.config);

        //Get components from config
        var Grid = config.grid;
        var GridHeader = config.header;

        var Toolbar = config.toolbar;
        var GridBody = config.body;
        var ColumnHeader = config.columnHeader;

        //Get custom column-configuration
        var columnConfig = props.columns;

        config.eventHandler = props.dispatch;

        //Columns to show
        var columnKeys = [];
        //extract filters from columnConfig

        var filters = _underscore2.default.chain(columnConfig).pick(function (value, key) {
            if (!_underscore2.default.has(value, "filter") || value.filter == "") {
                return false;
            } else {
                return true;
            }
        }).mapObject(function (value) {
            return value.filter;
        }).value();

        var idColumn = getOrCreateIdColumn(props.objects, columnConfig);

        //Filter objects based on supplied filter strings
        var objects = _underscore2.default.chain(props.objects).filter(function (currentObjectToBeFiltered) {
            var columnNamesWithFilter = _underscore2.default.keys(filters);
            for (var i in columnNamesWithFilter) {

                if (!currentObjectToBeFiltered[columnNamesWithFilter[i]]) {
                    return false;
                } else if (!(JSON.stringify(currentObjectToBeFiltered[columnNamesWithFilter[i]]).toLowerCase().indexOf(filters[columnNamesWithFilter[i]].toLowerCase()) > -1)) {
                    return false;
                }
            }
            return true;
        }).value();

        //Generate array with selected column-names in configured order
        var availableColumnKeys;
        if (props.objects.length > 0) {
            availableColumnKeys = _underscore2.default.union(Object.keys(props.objects[0]), Object.keys(columnConfig));
            columnKeys = _underscore2.default.sortBy(availableColumnKeys.filter(function (currentColumnKey) {
                if (config.showColumnsWithoutConfig) {
                    if (!columnConfig.hasOwnProperty(currentColumnKey)) {
                        return true;
                    } else if (_underscore2.default.has(columnConfig, currentColumnKey) && _underscore2.default.has(columnConfig[currentColumnKey], "show") && !columnConfig[currentColumnKey].show) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    //Show only configured columns
                    if (!columnConfig.hasOwnProperty(currentColumnKey)) {
                        return false;
                    } else if (_underscore2.default.has(columnConfig, currentColumnKey) && _underscore2.default.has(columnConfig[currentColumnKey], "show") && !columnConfig[currentColumnKey].show) {
                        return false;
                    } else {
                        return true;
                    }
                }
            }), function (current) {
                if (columnConfig.hasOwnProperty(current)) {
                    return columnConfig[current].order != null ? columnConfig[current].order : 1000;
                } else {
                    return 1000;
                }
            });
        }
        //Extract sort column from config or define one
        var order = ASCENDING;
        var sortColumn = _underscore2.default.chain(columnConfig).pick(function (value, key) {
            if (_underscore2.default.has(value, "sort") && value.sort) {
                if (value.sort === DESCENDING) {
                    order = DESCENDING;
                }
                return true;
            } else {
                return false;
            }
        }).keys().first().value();
        //If there is no configured sort-column take first configured column

        sortColumn = sortColumn ? sortColumn : availableColumnKeys && availableColumnKeys.length > 0 ? availableColumnKeys[0] : null;

        //Sort
        if (sortColumn) {
            // TODO allow to pass in a custom sort and/or sortValueGetter function
            objects = _underscore2.default.sortBy(objects, function (current) {
                var value = current[sortColumn];
                if (value == null) {
                    return value;
                } else if (typeof value == "number") {
                    return value;
                } else if (typeof value == "string") {
                    return value.toLowerCase();
                } else {
                    return JSON.stringify(value).toLowerCase();
                }
            });
        }

        //reverse order on "descending" sort option
        if (order === DESCENDING) {
            objects.reverse();
        }

        var tools;
        if (config.showToolbar) {
            tools = _react2.default.createElement(Toolbar, { config: config, columnKeys: columnKeys, columns: columnConfig });
        }

        var pagedObjects = void 0;
        var paging = config.paging;
        if (paging) {
            pagedObjects = _underscore2.default.chain(objects).rest(props.skip).first(config.paging).value();
        } else {
            pagedObjects = props.objects;
        }
        var pager = function pager() {
            if (config.paging) {
                return _react2.default.createElement(Pager, { length: objects.length, updatePagination: config.eventHandler, skip: props.skip, paging: config.paging });
            }
        };
        return _react2.default.createElement(
            'div',
            null,
            pager(),
            _react2.default.createElement(
                Grid,
                null,
                _react2.default.createElement(
                    GridHeader,
                    null,
                    _react2.default.createElement(ColumnHeader, { columns: columnConfig, config: config, columnKeys: columnKeys }),
                    tools
                ),
                _react2.default.createElement(GridBody, { idColumn: idColumn, objects: pagedObjects, columns: columnConfig, config: config, columnKeys: columnKeys })
            )
        );
    };

    exports.default = Ardagryd;


    var GridTable = function GridTable(props) {
        return _react2.default.createElement(
            _reactBootstrap.Table,
            { bordered: true, hover: true },
            props.children
        );
    };

    var GridBody = function GridBody(props) {
        var Row = props.config.row;
        var Cell = props.config.cell;
        var CellRenderer = props.config.cellRendererBase;

        var rows = props.objects.map(function (curr) {
            var current = curr;
            var cells = props.columnKeys.map(function (key) {
                return _react2.default.createElement(
                    Cell,
                    { key: key, columnName: key },
                    _react2.default.createElement(CellRenderer, { config: props.config, value: current[key], columns: props.columns, columnName: key, object: current })
                );
            });

            return _react2.default.createElement(
                Row,
                { key: current[props.idColumn], columns: props.columns, config: props.config, object: current },
                cells
            );
        });
        return _react2.default.createElement(
            'tbody',
            null,
            rows,
            props.children
        );
    };

    var GridHeader = function GridHeader(props) {
        return _react2.default.createElement(
            'thead',
            null,
            props.children
        );
    };

    var GridColumnHeader = function GridColumnHeader(props) {
        var GridHeaderCell = props.config.columnHeaderCell;
        var columnConfig = props.columns;
        var headerCells = props.columnKeys.map(function (currentKey, index) {
            var columnLabel = getLabel(currentKey, columnConfig);
            var configForCurrentColumn = columnConfig[currentKey];
            var sortable = configForCurrentColumn && configForCurrentColumn.sortable === false ? false : true;

            return _react2.default.createElement(
                GridHeaderCell,
                { key: currentKey, columnName: currentKey, columnIndex: index, sortable: sortable, sort: configForCurrentColumn && configForCurrentColumn.sort, updateSort: props.config.eventHandler },
                columnLabel
            );
        });

        return _react2.default.createElement(
            'tr',
            null,
            headerCells
        );
    };

    var GridHeaderCell = function (_React$Component) {
        _inherits(GridHeaderCell, _React$Component);

        function GridHeaderCell(props) {
            _classCallCheck(this, GridHeaderCell);

            var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(GridHeaderCell).call(this, props));

            _this.sortChanged = _this.sortChanged.bind(_this);
            return _this;
        }

        _createClass(GridHeaderCell, [{
            key: 'sortChanged',
            value: function sortChanged() {
                var key = this.props.columnName;
                var order = ASCENDING;
                if (this.props.sort && this.props.sort !== DESCENDING) {
                    order = DESCENDING;
                }
                this.props.updateSort({
                    type: "toggle-sort",
                    columnName: key,
                    order: order
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var key = this.props.columnName;
                var sort = this.props.sort;
                var label = this.props.children;
                var sortable = this.props.sortable;
                var iconName = 'sort';
                var active = false;
                if (sort) {
                    iconName = sort === DESCENDING ? 'sort-by-attributes-alt' : 'sort-by-attributes';
                    active = true;
                }
                return _react2.default.createElement(
                    'th',
                    null,
                    _react2.default.createElement(
                        'span',
                        { style: { display: 'flex', alignItems: 'center' } },
                        _react2.default.createElement(
                            'span',
                            { style: { flex: '1' } },
                            label
                        ),
                        sortable && _react2.default.createElement(
                            _reactBootstrap.Button,
                            { active: active, bsSize: 'xsmall', style: { marginLeft: '5px' }, onClick: this.sortChanged },
                            _react2.default.createElement(_reactBootstrap.Glyphicon, { glyph: iconName })
                        )
                    )
                );
            }
        }]);

        return GridHeaderCell;
    }(_react2.default.Component);

    GridHeaderCell.propTypes = {
        columnName: _react2.default.PropTypes.string.isRequired,
        sort: _react2.default.PropTypes.oneOf([true, false, ASCENDING, DESCENDING]),
        updateSort: _react2.default.PropTypes.func.isRequired,
        sortable: _react2.default.PropTypes.bool
    };

    GridHeaderCell.defaultProps = {
        sortable: true
    };

    var GridRow = function GridRow(props) {
        return _react2.default.createElement(
            'tr',
            null,
            props.children
        );
    };

    var GridCell = function GridCell(props) {
        return _react2.default.createElement(
            'td',
            null,
            props.children
        );
    };

    var BaseCellRenderer = function BaseCellRenderer(props) {
        var ObjCellRenderer = props.config.cellRendererObject;
        var ArrCellRenderer = props.config.cellRendererArray;
        var valueType = _typeof(props.value);

        var DisplayValue = props.config.displayValueGetter;
        var columns = props.columns;
        var columnName = props.columnName;
        if (columns[columnName] && columns[columnName].displayValueGetter && typeof columns[columnName].displayValueGetter == "function") {
            DisplayValue = columns[columnName].displayValueGetter;
        }

        // FIXME: columns[columnName].displayValueGetter is not used if value is an array or object
        // TODO: it should be possible to return a string from displayValueGetter
        switch (valueType) {
            case "object":
                if (_underscore2.default.isArray(props.value)) {
                    return _react2.default.createElement(ArrCellRenderer, { columns: columns, columnName: columnName, config: props.config, value: props.value, object: props.object });
                } else {
                    return _react2.default.createElement(ObjCellRenderer, { columns: columns, columnName: columnName, config: props.config, value: props.value, object: props.object });
                }
            default:
                return _react2.default.createElement(DisplayValue, { columns: columns, columnName: columnName, config: props.config, value: props.value, object: props.object });
        }
    };

    var ObjectCellRenderer = function ObjectCellRenderer(props) {
        var Renderer = props.config.cellRendererBase;
        var columns = props.columns;
        var columnName = props.columnName;
        var object = props.object;

        var props = _underscore2.default.map(props.value, function (value, key) {
            return [_react2.default.createElement(
                'dt',
                null,
                key
            ), _react2.default.createElement(
                'dd',
                null,
                _react2.default.createElement(Renderer, { config: props.config, value: value, object: object, columns: columns, columnName: columnName })
            )];
        });
        return _react2.default.createElement(
            'dl',
            null,
            props
        );
    };

    var ArrayCellRenderer = function (_React$Component2) {
        _inherits(ArrayCellRenderer, _React$Component2);

        function ArrayCellRenderer(p) {
            _classCallCheck(this, ArrayCellRenderer);

            return _possibleConstructorReturn(this, Object.getPrototypeOf(ArrayCellRenderer).call(this, p));
        }

        _createClass(ArrayCellRenderer, [{
            key: 'render',
            value: function render() {
                var _this3 = this;

                var Renderer = this.props.config.cellRendererBase;
                var columns = this.props.columns;
                var columnName = this.props.columnName;
                var object = this.props.object;

                var elements = _underscore2.default.map(this.props.value, function (value, i) {
                    return _react2.default.createElement(
                        'li',
                        { key: i },
                        _react2.default.createElement(Renderer, { object: object, config: _this3.props.config, value: value, columns: columns, columnName: columnName })
                    );
                });
                return _react2.default.createElement(
                    'ul',
                    null,
                    elements
                );
            }
        }]);

        return ArrayCellRenderer;
    }(_react2.default.Component);

    var CellEditorText = function CellEditorText(props) {
        return _react2.default.createElement(_reactBootstrap.Input, { type: 'text', value: props.value, onchange: props.changeHandler });
    };

    var ToolbarDefault = function (_React$Component3) {
        _inherits(ToolbarDefault, _React$Component3);

        function ToolbarDefault(props) {
            _classCallCheck(this, ToolbarDefault);

            return _possibleConstructorReturn(this, Object.getPrototypeOf(ToolbarDefault).call(this, props));
        }

        _createClass(ToolbarDefault, [{
            key: 'render',
            value: function render() {
                var _props = this.props;
                var columnKeys = _props.columnKeys;
                var config = _props.config;
                var columns = _props.columns;

                var Filter = config.filter;

                var filters = columnKeys.map(function (currentColumnKey) {
                    var renderFilter = true;
                    if (columns && columns[currentColumnKey] && columns[currentColumnKey].hideTools) {
                        renderFilter = false;
                    }
                    if (renderFilter) {
                        var filter = columns[currentColumnKey] && columns[currentColumnKey].filter ? columns[currentColumnKey].filter : "";
                        return _react2.default.createElement(
                            'th',
                            { key: currentColumnKey },
                            _react2.default.createElement(Filter, { config: config, column: currentColumnKey, query: filter })
                        );
                    } else {
                        return _react2.default.createElement('th', { key: currentColumnKey });
                    }
                });

                return _react2.default.createElement(
                    'tr',
                    null,
                    filters
                );
            }
        }]);

        return ToolbarDefault;
    }(_react2.default.Component);

    var Filter = function (_React$Component4) {
        _inherits(Filter, _React$Component4);

        function Filter(props) {
            _classCallCheck(this, Filter);

            var _this5 = _possibleConstructorReturn(this, Object.getPrototypeOf(Filter).call(this, props));

            _this5.updateFilter = _this5.updateFilter.bind(_this5);
            return _this5;
        }

        _createClass(Filter, [{
            key: 'updateFilter',
            value: function updateFilter(event) {
                this.props.config.eventHandler({
                    type: "filter-change",
                    id: this.props.config.id,
                    column: this.props.column,
                    query: event.target.value
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var throttledUpdate = _underscore2.default.throttle(this.updateFilter, 1000);
                return _react2.default.createElement(_reactBootstrap.FormControl, { id: "filter_for_" + this.props.column, type: 'search', key: this.props.column, value: this.props.query, onChange: throttledUpdate, placeholder: "Filter..." });
            }
        }]);

        return Filter;
    }(_react2.default.Component);

    ;

    var Pager = function (_React$Component5) {
        _inherits(Pager, _React$Component5);

        function Pager(props) {
            _classCallCheck(this, Pager);

            var _this6 = _possibleConstructorReturn(this, Object.getPrototypeOf(Pager).call(this, props));

            _this6.updatePagination = _this6.updatePagination.bind(_this6);
            return _this6;
        }

        _createClass(Pager, [{
            key: 'updatePagination',
            value: function updatePagination(pageNumber) {
                var skipNumber = (pageNumber - 1) * this.props.paging;
                this.props.updatePagination({
                    type: "change-page",
                    skip: skipNumber
                });
            }
        }, {
            key: 'render',
            value: function render() {

                var rest = this.props.length % this.props.paging;
                var numberOfPages = this.props.length / this.props.paging;
                if (rest !== 0) {
                    numberOfPages = Math.floor(numberOfPages + 1);
                }
                var skip = this.props.skip;
                var activePageNumber = this.props.skip / this.props.paging + 1;

                return _react2.default.createElement(_reactBootstrap.Pagination, {
                    items: numberOfPages,
                    activePage: activePageNumber,
                    maxButtons: 7,
                    boundaryLinks: true,
                    onSelect: this.updatePagination,
                    prev: _react2.default.createElement(_reactBootstrap.Glyphicon, { glyph: 'arrow-left' }),
                    next: _react2.default.createElement(_reactBootstrap.Glyphicon, { glyph: 'arrow-right' }) });
            }
        }]);

        return Pager;
    }(_react2.default.Component);

    Pager.propTypes = {
        length: _react2.default.PropTypes.number.isRequired,
        paging: _react2.default.PropTypes.number.isRequired,
        skip: _react2.default.PropTypes.number.isRequired,
        updatePagination: _react2.default.PropTypes.func.isRequired
    };

    var defaultConfig = {
        grid: GridTable,
        body: GridBody,
        row: GridRow,
        cell: GridCell,
        columnHeader: GridColumnHeader,
        header: GridHeader,
        columnHeaderCell: GridHeaderCell,
        cellRendererBase: BaseCellRenderer,
        cellRendererObject: ObjectCellRenderer,
        cellRendererArray: ArrayCellRenderer,
        cellEditorText: CellEditorText,
        filter: Filter,
        toolbar: ToolbarDefault,
        showToolbar: true,
        showColumnsWithoutConfig: true, //show all columns which are not explicitly hidden
        paging: 10,
        displayValueGetter: function displayValueGetter(_ref) {
            var value = _ref.value;
            return _react2.default.createElement(
                'span',
                null,
                value
            );
        }
    };

    Ardagryd.defaultProps = {
        config: {},
        columns: {},
        dispatch: function dispatch() {}
    };

    Ardagryd.propTypes = {
        objects: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.object),
        config: _react2.default.PropTypes.object.isRequired,
        columns: _react2.default.PropTypes.objectOf(_react2.default.PropTypes.shape({
            displayValueGetter: _react2.default.PropTypes.func,
            id: _react2.default.PropTypes.bool,
            label: _react2.default.PropTypes.string,
            order: _react2.default.PropTypes.number,
            hideTools: _react2.default.PropTypes.bool,
            sortable: _react2.default.PropTypes.bool
        })).isRequired,
        dispatch: _react2.default.PropTypes.func.isRequired
    };

    //Find id-column, or enhance objects with ids
    function getOrCreateIdColumn(objects, columns) {
        //check if explicit id-column is set in column-config
        var idColumn;
        _underscore2.default.chain(columns).keys().find(function (key) {
            if (columns[key].id) {
                idColumn = key;
                return true;
            }
        }).value();

        if (idColumn) {
            return idColumn;
        } else if (_underscore2.default.isArray(objects) && objects.length > 0 && _underscore2.default.has(objects[0], "id")) {
            //check if objects have a id-property
            return "id";
        } else {
            var _ret = function () {
                //TODO: use some type of hashing
                //generate id-property
                var index = 0;
                _underscore2.default.map(objects, function (object) {
                    object.id = index++;
                });
                return {
                    v: "id"
                };
            }();

            if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
        }
    }

    function getLabel(columnKey, columnConfig) {
        return columnConfig[columnKey] && columnConfig[columnKey].label ? columnConfig[columnKey].label : columnKey;
    }

    var Grid = exports.Grid = function (_React$Component6) {
        _inherits(Grid, _React$Component6);

        function Grid(props) {
            _classCallCheck(this, Grid);

            var _this7 = _possibleConstructorReturn(this, Object.getPrototypeOf(Grid).call(this, props));

            _this7.state = {
                config: props.config ? props.config : {},
                columns: props.columns ? props.columns : {},
                skip: 0
            };
            _this7.dispatch = _this7.dispatch.bind(_this7);
            return _this7;
        }

        _createClass(Grid, [{
            key: 'componentWillReceiveProps',
            value: function componentWillReceiveProps(nextProps) {
                // TODO: we should not always go back to the first page if props change
                this.setState({
                    config: nextProps.config ? nextProps.config : {},
                    columns: nextProps.columns ? nextProps.columns : {},
                    skip: 0
                });
            }
        }, {
            key: 'dispatch',
            value: function dispatch(action) {

                //State reducer
                switch (action.type) {
                    case "filter-change":
                        var _newColumnConfig = {};
                        var newColumnValues = {};
                        newColumnValues[action.column] = {};
                        newColumnValues[action.column].filter = action.query;
                        _newColumnConfig = (0, _deepmerge2.default)(this.state.columns, newColumnValues);

                        this.setState({ columns: _newColumnConfig });
                        this.setState({ skip: 0 });
                        break;
                    case "change-page":
                        this.setState({ skip: action.skip });
                        break;
                    case "toggle-sort":
                        var _newColumnConfig = _underscore2.default.extend({}, this.state.columns);
                        var sortApplied = false;
                        _underscore2.default.each(_newColumnConfig, function (value, key) {
                            if (key === action.columnName) {
                                value.sort = action.order;
                                sortApplied = true;
                            } else {
                                delete value.sort;
                            }
                        });
                        if (!sortApplied) {
                            _newColumnConfig[action.columnName] = { sort: action.order };
                        }

                        this.setState({ columns: _newColumnConfig, skip: 0 });
                        break;

                }
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement(Ardagryd, { dispatch: this.dispatch, objects: this.props.objects, columns: this.state.columns, config: this.state.config, skip: this.state.skip });
            }
        }]);

        return Grid;
    }(_react2.default.Component);

    Grid.PropTypes = {
        objects: _react2.default.PropTypes.array.isRequired,
        config: _react2.default.PropTypes.object.isRequired,
        columns: _react2.default.PropTypes.object.isRequired
    };

    Grid.defaultProps = {};
});

//# sourceMappingURL=Ardagryd.umd.js.map