(function (global, factory) {
    if (typeof define === "function" && define.amd) {
        define(['exports', 'react', 'react-bootstrap/lib/Input', 'react-bootstrap/lib/Glyphicon', 'react-bootstrap/lib/Button', 'react-bootstrap/lib/FormControl', 'react-bootstrap/lib/Table', 'react-bootstrap/lib/Pagination', 'react-prop-types/lib/elementType', 'deepmerge'], factory);
    } else if (typeof exports !== "undefined") {
        factory(exports, require('react'), require('react-bootstrap/lib/Input'), require('react-bootstrap/lib/Glyphicon'), require('react-bootstrap/lib/Button'), require('react-bootstrap/lib/FormControl'), require('react-bootstrap/lib/Table'), require('react-bootstrap/lib/Pagination'), require('react-prop-types/lib/elementType'), require('deepmerge'));
    } else {
        var mod = {
            exports: {}
        };
        factory(mod.exports, global.react, global.Input, global.Glyphicon, global.Button, global.FormControl, global.Table, global.Pagination, global.elementType, global.deepmerge);
        global.Ardagryd = mod.exports;
    }
})(this, function (exports, _react, _Input, _Glyphicon, _Button, _FormControl, _Table, _Pagination, _elementType, _deepmerge) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.Grid = undefined;

    var _react2 = _interopRequireDefault(_react);

    var _Input2 = _interopRequireDefault(_Input);

    var _Glyphicon2 = _interopRequireDefault(_Glyphicon);

    var _Button2 = _interopRequireDefault(_Button);

    var _FormControl2 = _interopRequireDefault(_FormControl);

    var _Table2 = _interopRequireDefault(_Table);

    var _Pagination2 = _interopRequireDefault(_Pagination);

    var _elementType2 = _interopRequireDefault(_elementType);

    var _deepmerge2 = _interopRequireDefault(_deepmerge);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
        return typeof obj;
    } : function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj;
    };

    var ASCENDING = "asc";
    var DESCENDING = "desc";

    //Workaround. See -> https://phabricator.babeljs.io/T6777
    typeof undefined === 'undefined' ? 'undefined' : _typeof(undefined);

    var Ardagryd = function Ardagryd(props) {
        //Merge custom and default config
        var config = Object.assign({}, defaultConfig, props.config);

        //Get components from config
        var Grid = config.grid;
        var GridHeader = config.header;

        var Toolbar = config.toolbar;
        var GridBody = config.body;
        var ColumnHeader = config.columnHeader;

        //Get custom column-configuration
        var columnConfig = props.columns;

        config.eventHandler = props.dispatch;

        //Columns to show
        var columnKeys = [];
        //extract filters from columnConfig

        var order = ASCENDING;
        var sortColumn;

        var filters = {};
        for (var columnName in columnConfig) {
            var configForColumn = columnConfig[columnName];
            if (configForColumn) {
                var filter = configForColumn.filter;
                if (filter && filter !== "") {
                    filters[columnName] = filter;
                }
                // Extract sort column from config
                // TODO: handle case where multiple columns have a sort property
                if (sortColumn === undefined) {
                    var sort = configForColumn.sort;
                    if (sort !== undefined) {
                        sortColumn = columnName;
                        if (sort === DESCENDING) {
                            order = DESCENDING;
                        }
                    }
                }
            }
        }
        //If there is no configured sort-column take first configured column

        sortColumn = sortColumn ? sortColumn : availableColumnKeys && availableColumnKeys.length > 0 ? availableColumnKeys[0] : null;

        var idColumn = getOrCreateIdColumn(props.objects, columnConfig);

        //Filter objects based on supplied filter strings
        var columnNamesWithFilter = Object.keys(filters);
        var objects = props.objects.filter(function (currentObjectToBeFiltered) {
            for (var i in columnNamesWithFilter) {

                if (!currentObjectToBeFiltered[columnNamesWithFilter[i]]) {
                    return false;
                } else if (!(JSON.stringify(currentObjectToBeFiltered[columnNamesWithFilter[i]]).toLowerCase().indexOf(filters[columnNamesWithFilter[i]].toLowerCase()) > -1)) {
                    return false;
                }
            }
            return true;
        });

        //Generate array with selected column-names in configured order
        var availableColumnKeys = void 0;
        if (props.objects.length > 0) {
            availableColumnKeys = Object.keys(props.objects[0]);
            Object.keys(columnConfig).forEach(function (columnName) {
                if (availableColumnKeys.indexOf(columnName) === -1) {
                    availableColumnKeys.push(columnName);
                }
            });

            columnKeys = availableColumnKeys.filter(function (currentColumnKey) {
                var configForColumn = columnConfig[currentColumnKey];
                if (config.showColumnsWithoutConfig) {
                    return configForColumn === undefined || configForColumn.show !== false;
                } else {
                    //Show only configured columns
                    return configForColumn !== undefined && configForColumn.show !== false;
                }
            }).sort(function (a, b) {
                var configForA = columnConfig[a];
                var configForB = columnConfig[b];
                var valueForA = configForA && configForA.order != null ? configForA.order : 1000;
                var valueForB = configForB && configForB.order != null ? configForB.order : 1000;
                return valueForA - valueForB;
            });
        }

        //Sort
        if (sortColumn) {
            // TODO allow to pass in a custom sort and/or sortValueGetter function

            // temporary array holds objects with position and sort-value
            var mapped = objects.map(function (el, i) {
                var value = el[sortColumn];

                if (typeof value == "string") {
                    value = value.toLowerCase();
                } else {
                    value = JSON.stringify(value).toLowerCase();
                }
                return { index: i, value: value };
            });

            // sorting the mapped array containing the reduced values
            mapped.sort(function (a, b) {
                return +(a.value > b.value) || +(a.value === b.value) - 1;
            });

            // container for the resulting order
            var list = mapped.map(function (el) {
                return objects[el.index];
            });

            objects = list;
        }

        //reverse order on "descending" sort option
        if (order === DESCENDING) {
            objects.reverse();
        }

        var tools;
        if (config.showToolbar) {
            tools = _react2.default.createElement(Toolbar, { config: config, columnKeys: columnKeys, columns: columnConfig, __self: undefined
            });
        }

        var pagedObjects = void 0;
        var paging = config.paging;
        if (paging) {
            pagedObjects = objects.slice(props.skip, props.skip + paging);
        } else {
            pagedObjects = props.objects;
        }
        var pager = function pager() {
            if (config.paging) {
                return _react2.default.createElement(Pager, { length: objects.length, updatePagination: config.eventHandler, skip: props.skip, paging: config.paging, __self: undefined
                });
            }
        };
        return _react2.default.createElement(
            'div',
            {
                __self: undefined
            },
            pager(),
            _react2.default.createElement(
                Grid,
                {
                    __self: undefined
                },
                _react2.default.createElement(
                    GridHeader,
                    {
                        __self: undefined
                    },
                    _react2.default.createElement(ColumnHeader, { columns: columnConfig, config: config, columnKeys: columnKeys, __self: undefined
                    }),
                    tools
                ),
                _react2.default.createElement(GridBody, { idColumn: idColumn, objects: pagedObjects, columns: columnConfig, config: config, columnKeys: columnKeys, __self: undefined
                })
            )
        );
    };

    exports.default = Ardagryd;


    var GridTable = function GridTable(props) {
        return _react2.default.createElement(
            _Table2.default,
            { bordered: true, hover: true, __self: undefined
            },
            props.children
        );
    };

    var GridBody = function GridBody(props) {
        var Row = props.config.row;
        var Cell = props.config.cell;
        var CellRenderer = props.config.cellRendererBase;

        var rows = props.objects.map(function (curr) {
            var current = curr;
            var cells = props.columnKeys.map(function (key) {
                var configForColumn = props.columns[key];
                var displayValueGetter = props.config.displayValueGetter;
                if (configForColumn && configForColumn.displayValueGetter) {
                    displayValueGetter = configForColumn.displayValueGetter;
                }
                var args = { columns: props.columns, columnName: key, config: props.config, value: current[key], object: current };
                var value = void 0;
                if (displayValueGetter.prototype instanceof _react2.default.Component) {
                    value = _react2.default.createElement(displayValueGetter, args);
                } else {
                    value = displayValueGetter(args);
                }
                if (value == null) {
                    return _react2.default.createElement(Cell, { key: key, columnName: key, __self: undefined
                    });
                } else if (typeof value === "string" || typeof value === "number" || typeof value === "boolean" || _react2.default.isValidElement(value)) {
                    return _react2.default.createElement(
                        Cell,
                        { key: key, columnName: key, __self: undefined
                        },
                        value
                    );
                } else {
                    if (configForColumn && configForColumn.cellRenderer) {
                        CellRenderer = configForColumn.cellRenderer;
                    }
                    return _react2.default.createElement(
                        Cell,
                        { key: key, columnName: key, __self: undefined
                        },
                        _react2.default.createElement(CellRenderer, { config: props.config, value: value, columns: props.columns, columnName: key, object: current, __self: undefined
                        })
                    );
                }
            });

            return _react2.default.createElement(
                Row,
                { key: current[props.idColumn], columns: props.columns, config: props.config, object: current, __self: undefined
                },
                cells
            );
        });
        return _react2.default.createElement(
            'tbody',
            {
                __self: undefined
            },
            rows,
            props.children
        );
    };

    var GridHeader = function GridHeader(props) {
        return _react2.default.createElement(
            'thead',
            {
                __self: undefined
            },
            props.children
        );
    };

    var GridColumnHeader = function GridColumnHeader(props) {
        var GridHeaderCell = props.config.columnHeaderCell;
        var columnConfig = props.columns;
        var headerCells = props.columnKeys.map(function (currentKey, index) {
            var columnLabel = getLabel(currentKey, columnConfig);
            var configForCurrentColumn = columnConfig[currentKey];
            var sortable = configForCurrentColumn && configForCurrentColumn.sortable === false ? false : true;

            return _react2.default.createElement(
                GridHeaderCell,
                { key: currentKey, columnName: currentKey, columnIndex: index, sortable: sortable, sort: configForCurrentColumn && configForCurrentColumn.sort, updateSort: props.config.eventHandler, __self: undefined
                },
                columnLabel
            );
        });

        return _react2.default.createElement(
            'tr',
            {
                __self: undefined
            },
            headerCells
        );
    };

    var GridHeaderCell = function (_React$Component) {
        _inherits(GridHeaderCell, _React$Component);

        function GridHeaderCell(props) {
            _classCallCheck(this, GridHeaderCell);

            var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(GridHeaderCell).call(this, props));

            _this.sortChanged = _this.sortChanged.bind(_this);
            return _this;
        }

        _createClass(GridHeaderCell, [{
            key: 'sortChanged',
            value: function sortChanged() {
                var key = this.props.columnName;
                var order = ASCENDING;
                if (this.props.sort && this.props.sort !== DESCENDING) {
                    order = DESCENDING;
                }
                this.props.updateSort({
                    type: "toggle-sort",
                    columnName: key,
                    order: order
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var key = this.props.columnName;
                var sort = this.props.sort;
                var label = this.props.children;
                var sortable = this.props.sortable;
                var iconName = 'sort';
                var active = false;
                if (sort) {
                    iconName = sort === DESCENDING ? 'sort-by-attributes-alt' : 'sort-by-attributes';
                    active = true;
                }
                return _react2.default.createElement(
                    'th',
                    {
                        __self: this
                    },
                    _react2.default.createElement(
                        'span',
                        { style: { display: 'flex', alignItems: 'center' }, __self: this
                        },
                        _react2.default.createElement(
                            'span',
                            { style: { flex: '1' }, __self: this
                            },
                            label
                        ),
                        sortable && _react2.default.createElement(
                            _Button2.default,
                            { active: active, bsSize: 'xsmall', style: { marginLeft: '5px' }, onClick: this.sortChanged, __self: this
                            },
                            _react2.default.createElement(_Glyphicon2.default, { glyph: iconName, __self: this
                            })
                        )
                    )
                );
            }
        }]);

        return GridHeaderCell;
    }(_react2.default.Component);

    GridHeaderCell.propTypes = {
        columnName: _react2.default.PropTypes.string.isRequired,
        sort: _react2.default.PropTypes.oneOf([true, false, ASCENDING, DESCENDING]),
        updateSort: _react2.default.PropTypes.func.isRequired,
        sortable: _react2.default.PropTypes.bool
    };

    GridHeaderCell.defaultProps = {
        sortable: true
    };

    var GridRow = function (_React$Component2) {
        _inherits(GridRow, _React$Component2);

        function GridRow(props) {
            _classCallCheck(this, GridRow);

            return _possibleConstructorReturn(this, Object.getPrototypeOf(GridRow).call(this, props));
        }

        _createClass(GridRow, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(nextProps) {
                return this.props.object !== nextProps.object || this.props.columnConfig !== nextProps.columnConfig || this.props.config.showColumnsWithoutConfig !== nextProps.config.showColumnsWithoutConfig || this.props.config.cell !== nextProps.config.cell || this.props.config.cellRendererBase !== nextProps.config.cellRendererBase || this.props.config.cellRendererObject !== nextProps.config.cellRendererObject || this.props.config.cellRendererArray !== nextProps.config.cellRendererArray || this.props.config.displayValueGetter !== nextProps.config.displayValueGetter;
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement(
                    'tr',
                    {
                        __self: this
                    },
                    this.props.children
                );
            }
        }]);

        return GridRow;
    }(_react2.default.Component);

    var GridCell = function GridCell(props) {
        return _react2.default.createElement(
            'td',
            {
                __self: undefined
            },
            props.children
        );
    };

    var BaseCellRenderer = function BaseCellRenderer(props) {
        var ObjCellRenderer = props.config.cellRendererObject;
        var ArrCellRenderer = props.config.cellRendererArray;
        var valueType = _typeof(props.value);

        var columns = props.columns;
        var columnName = props.columnName;

        switch (valueType) {
            case "object":
                if (Array.isArray(props.value)) {
                    return _react2.default.createElement(ArrCellRenderer, { columns: columns, columnName: columnName, config: props.config, value: props.value, object: props.object, __self: undefined
                    });
                } else {
                    return _react2.default.createElement(ObjCellRenderer, { columns: columns, columnName: columnName, config: props.config, value: props.value, object: props.object, __self: undefined
                    });
                }
            default:
                return _react2.default.createElement(
                    'span',
                    {
                        __self: undefined
                    },
                    props.value
                );
        }
    };

    var ObjectCellRenderer = function ObjectCellRenderer(props) {
        var Renderer = props.config.cellRendererBase;
        var columns = props.columns;
        var columnName = props.columnName;
        var object = props.object;

        var props = Object.keys(props.value).map(function (key) {
            return [_react2.default.createElement(
                'dt',
                {
                    __self: undefined
                },
                key
            ), _react2.default.createElement(
                'dd',
                {
                    __self: undefined
                },
                _react2.default.createElement(Renderer, { config: props.config, value: props.value[key], object: object, columns: columns, columnName: columnName, __self: undefined
                })
            )];
        });
        return _react2.default.createElement(
            'dl',
            {
                __self: undefined
            },
            props
        );
    };

    var ArrayCellRenderer = function (_React$Component3) {
        _inherits(ArrayCellRenderer, _React$Component3);

        function ArrayCellRenderer(p) {
            _classCallCheck(this, ArrayCellRenderer);

            return _possibleConstructorReturn(this, Object.getPrototypeOf(ArrayCellRenderer).call(this, p));
        }

        _createClass(ArrayCellRenderer, [{
            key: 'render',
            value: function render() {
                var _this4 = this;

                var Renderer = this.props.config.cellRendererBase;
                var columns = this.props.columns;
                var columnName = this.props.columnName;
                var object = this.props.object;

                var elements = this.props.value.map(function (value, i) {
                    return _react2.default.createElement(
                        'li',
                        { key: i, __self: _this4
                        },
                        _react2.default.createElement(Renderer, { object: object, config: _this4.props.config, value: value, columns: columns, columnName: columnName, __self: _this4
                        })
                    );
                });
                return _react2.default.createElement(
                    'ul',
                    {
                        __self: this
                    },
                    elements
                );
            }
        }]);

        return ArrayCellRenderer;
    }(_react2.default.Component);

    var ToolbarDefault = function (_React$Component4) {
        _inherits(ToolbarDefault, _React$Component4);

        function ToolbarDefault(props) {
            _classCallCheck(this, ToolbarDefault);

            return _possibleConstructorReturn(this, Object.getPrototypeOf(ToolbarDefault).call(this, props));
        }

        _createClass(ToolbarDefault, [{
            key: 'render',
            value: function render() {
                var _this6 = this;

                var _props = this.props;
                var columnKeys = _props.columnKeys;
                var config = _props.config;
                var columns = _props.columns;

                var Filter = config.filter;

                var filters = columnKeys.map(function (currentColumnKey) {
                    var renderFilter = true;
                    if (columns && columns[currentColumnKey] && columns[currentColumnKey].hideTools) {
                        renderFilter = false;
                    }
                    if (renderFilter) {
                        var filter = columns[currentColumnKey] && columns[currentColumnKey].filter ? columns[currentColumnKey].filter : "";
                        return _react2.default.createElement(
                            'th',
                            { key: currentColumnKey, __self: _this6
                            },
                            _react2.default.createElement(Filter, { config: config, column: currentColumnKey, query: filter, __self: _this6
                            })
                        );
                    } else {
                        return _react2.default.createElement('th', { key: currentColumnKey, __self: _this6
                        });
                    }
                });

                return _react2.default.createElement(
                    'tr',
                    {
                        __self: this
                    },
                    filters
                );
            }
        }]);

        return ToolbarDefault;
    }(_react2.default.Component);

    var Filter = function (_React$Component5) {
        _inherits(Filter, _React$Component5);

        function Filter(props) {
            _classCallCheck(this, Filter);

            var _this7 = _possibleConstructorReturn(this, Object.getPrototypeOf(Filter).call(this, props));

            _this7.state = { filterValue: _this7.props.query };
            _this7.inputChanged = _this7.inputChanged.bind(_this7);
            return _this7;
        }

        _createClass(Filter, [{
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                if (this.timeout) {
                    window.clearTimeout(this.timeout);
                    this.timeout = null;
                }
            }
        }, {
            key: 'inputChanged',
            value: function inputChanged(event) {
                var _this8 = this;

                this.setState({ filterValue: event.target.value });
                if (this.timeout) {
                    window.clearTimeout(this.timeout);
                    this.timeout = null;
                }
                this.timeout = window.setTimeout(function () {
                    _this8.props.config.eventHandler({
                        type: "filter-change",
                        id: _this8.props.config.id,
                        column: _this8.props.column,
                        query: _this8.state.filterValue
                    });
                }, 300);
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement(_FormControl2.default, { id: "filter_for_" + this.props.column, type: 'search', key: this.props.column, value: this.state.filterValue, onChange: this.inputChanged, placeholder: "Filter...", __self: this
                });
            }
        }]);

        return Filter;
    }(_react2.default.Component);

    ;

    var Pager = function (_React$Component6) {
        _inherits(Pager, _React$Component6);

        function Pager(props) {
            _classCallCheck(this, Pager);

            var _this9 = _possibleConstructorReturn(this, Object.getPrototypeOf(Pager).call(this, props));

            _this9.updatePagination = _this9.updatePagination.bind(_this9);
            return _this9;
        }

        _createClass(Pager, [{
            key: 'updatePagination',
            value: function updatePagination(pageNumber) {
                var skipNumber = (pageNumber - 1) * this.props.paging;
                this.props.updatePagination({
                    type: "change-page",
                    skip: skipNumber
                });
            }
        }, {
            key: 'render',
            value: function render() {

                var rest = this.props.length % this.props.paging;
                var numberOfPages = this.props.length / this.props.paging;
                if (rest !== 0) {
                    numberOfPages = Math.floor(numberOfPages + 1);
                }
                var skip = this.props.skip;
                var activePageNumber = this.props.skip / this.props.paging + 1;

                return _react2.default.createElement(_Pagination2.default, {
                    items: numberOfPages,
                    activePage: activePageNumber,
                    maxButtons: 7,
                    boundaryLinks: true,
                    onSelect: this.updatePagination,
                    prev: _react2.default.createElement(_Glyphicon2.default, { glyph: 'arrow-left', __self: this
                    }),
                    next: _react2.default.createElement(_Glyphicon2.default, { glyph: 'arrow-right', __self: this
                    }), __self: this
                });
            }
        }]);

        return Pager;
    }(_react2.default.Component);

    Pager.propTypes = {
        length: _react2.default.PropTypes.number.isRequired,
        paging: _react2.default.PropTypes.number.isRequired,
        skip: _react2.default.PropTypes.number.isRequired,
        updatePagination: _react2.default.PropTypes.func.isRequired
    };

    var defaultConfig = {
        grid: GridTable,
        body: GridBody,
        row: GridRow,
        cell: GridCell,
        columnHeader: GridColumnHeader,
        header: GridHeader,
        columnHeaderCell: GridHeaderCell,
        cellRendererBase: BaseCellRenderer,
        cellRendererObject: ObjectCellRenderer,
        cellRendererArray: ArrayCellRenderer,
        filter: Filter,
        toolbar: ToolbarDefault,
        showToolbar: true,
        showColumnsWithoutConfig: true, //show all columns which are not explicitly hidden
        paging: 10,
        displayValueGetter: function displayValueGetter(_ref) {
            var value = _ref.value;
            return value;
        }
    };

    Ardagryd.defaultProps = {
        config: {},
        columns: {},
        dispatch: function dispatch() {}
    };

    Ardagryd.propTypes = {
        objects: _react2.default.PropTypes.arrayOf(_react2.default.PropTypes.object),
        config: _react2.default.PropTypes.object.isRequired,
        columns: _react2.default.PropTypes.objectOf(_react2.default.PropTypes.shape({
            displayValueGetter: _react2.default.PropTypes.func,
            id: _react2.default.PropTypes.bool,
            label: _react2.default.PropTypes.string,
            order: _react2.default.PropTypes.number,
            hideTools: _react2.default.PropTypes.bool,
            sortable: _react2.default.PropTypes.bool,
            cellRenderer: _elementType2.default,
            filter: _react2.default.PropTypes.string
        })).isRequired,
        dispatch: _react2.default.PropTypes.func.isRequired
    };

    //Find id-column, or enhance objects with ids
    function getOrCreateIdColumn(objects, columns) {
        //check if explicit id-column is set in column-config
        var idColumn = Object.keys(columns).find(function (key) {
            if (columns[key].id) {
                return true;
            }
        });

        if (idColumn) {
            return idColumn;
        } else if (objects.length > 0 && objects[0].id !== undefined) {
            //check if objects have a id-property
            return "id";
        } else {
            var _ret = function () {
                //TODO: use some type of hashing
                //generate id-property
                var index = 0;
                objects.map(function (object) {
                    object.id = index++;
                });
                return {
                    v: "id"
                };
            }();

            if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
        }
    }

    function getLabel(columnKey, columnConfig) {
        return columnConfig[columnKey] && columnConfig[columnKey].label ? columnConfig[columnKey].label : columnKey;
    }

    var Grid = exports.Grid = function (_React$Component7) {
        _inherits(Grid, _React$Component7);

        function Grid(props) {
            _classCallCheck(this, Grid);

            var _this10 = _possibleConstructorReturn(this, Object.getPrototypeOf(Grid).call(this, props));

            _this10.state = {
                config: props.config ? props.config : {},
                columns: props.columns ? props.columns : {},
                skip: 0
            };
            _this10.dispatch = _this10.dispatch.bind(_this10);
            return _this10;
        }

        _createClass(Grid, [{
            key: 'componentWillReceiveProps',
            value: function componentWillReceiveProps(nextProps) {
                this.setState({
                    config: nextProps.config ? nextProps.config : {},
                    columns: nextProps.columns ? nextProps.columns : {}
                });
            }
        }, {
            key: 'dispatch',
            value: function dispatch(action) {
                var _this11 = this;

                //State reducer
                var newColumnConfig;
                var newColumnValues;

                (function () {
                    switch (action.type) {
                        case "filter-change":
                            newColumnConfig = {};
                            newColumnValues = {};

                            newColumnValues[action.column] = {};
                            newColumnValues[action.column].filter = action.query;
                            newColumnConfig = (0, _deepmerge2.default)(_this11.state.columns, newColumnValues);

                            _this11.setState({ columns: newColumnConfig, skip: 0 });
                            break;
                        case "change-page":
                            _this11.setState({ skip: action.skip });
                            break;
                        case "toggle-sort":
                            var newColumnConfig = Object.assign({}, _this11.state.columns);
                            var sortApplied = false;
                            Object.keys(newColumnConfig).forEach(function (key) {
                                var value = newColumnConfig[key];
                                if (key === action.columnName) {
                                    value.sort = action.order;
                                    sortApplied = true;
                                } else {
                                    delete value.sort;
                                }
                            });
                            if (!sortApplied) {
                                newColumnConfig[action.columnName] = { sort: action.order };
                            }

                            _this11.setState({ columns: newColumnConfig, skip: 0 });
                            break;

                    }
                })();
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement(Ardagryd, { dispatch: this.dispatch, objects: this.props.objects, columns: this.state.columns, config: this.state.config, skip: this.state.skip, __self: this
                });
            }
        }]);

        return Grid;
    }(_react2.default.Component);

    Grid.PropTypes = {
        objects: _react2.default.PropTypes.array.isRequired,
        config: _react2.default.PropTypes.object.isRequired,
        columns: _react2.default.PropTypes.object.isRequired
    };

    Grid.defaultProps = {};
});

//# sourceMappingURL=Ardagryd.umd.js.map