(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("react"));
	else if(typeof define === 'function' && define.amd)
		define(["react"], factory);
	else if(typeof exports === 'object')
		exports["Ardagryd"] = factory(require("react"));
	else
		root["Ardagryd"] = factory(root["React"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_2__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.Grid = undefined;

	var _Grid = __webpack_require__(1);

	var _Grid2 = _interopRequireDefault(_Grid);

	var _Ardagryd = __webpack_require__(3);

	var _Ardagryd2 = _interopRequireDefault(_Ardagryd);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	exports.default = _Ardagryd2.default;
	exports.Grid = _Grid2.default;

/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _Ardagryd = __webpack_require__(3);

	var _Ardagryd2 = _interopRequireDefault(_Ardagryd);

	var _utils = __webpack_require__(69);

	var _proptypes = __webpack_require__(25);

	var _constants = __webpack_require__(26);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var Grid = function (_Component) {
	    _inherits(Grid, _Component);

	    function Grid(props) {
	        _classCallCheck(this, Grid);

	        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Grid).call(this, props));

	        _this.state = {
	            config: props.config ? props.config : {},
	            filter: (0, _utils.filterConfigFromProp)(props.filter),
	            sort: props.sort ? (0, _utils.sortConfigFromProp)(props.sort) : undefined,
	            skip: 0
	        };
	        _this.dispatch = _this.dispatch.bind(_this);
	        return _this;
	    }

	    _createClass(Grid, [{
	        key: 'componentWillReceiveProps',
	        value: function componentWillReceiveProps(nextProps) {
	            var newState = {};
	            if (!(JSON.stringify(this.props.sort) === JSON.stringify(nextProps.sort))) {
	                newState.sort = nextProps.sort;
	            }
	            if (!(JSON.stringify(this.props.filter) === JSON.stringify(nextProps.filter))) {
	                newState.filter = nextProps.filter;
	            }
	            var numberOfItems = nextProps.objects.length;
	            if (numberOfItems > 0 && nextProps.config == undefined || nextProps.config.paging !== false) {
	                var paging = nextProps.config !== undefined && nextProps.config.paging || _constants.DEFAULT_ITEMS_PER_PAGE;
	                var rest = numberOfItems % paging;
	                var numberOfPages = numberOfItems / paging;
	                if (rest !== 0) {
	                    numberOfPages = Math.floor(numberOfPages + 1);
	                }
	                var skip = this.state.skip;
	                var activePageNumber = skip / paging + 1;
	                if (activePageNumber > numberOfPages) {
	                    newState.skip = paging * (numberOfPages - 1);
	                }
	            }
	            this.setState(newState);
	        }
	    }, {
	        key: 'dispatch',
	        value: function dispatch(action) {

	            //State reducer
	            switch (action.type) {
	                case 'filter-change':
	                    {
	                        var changed = false;

	                        var newFilters = this.state.filter.map(function (currFilter) {
	                            if (currFilter.columnName === action.column) {
	                                currFilter.expression = action.query;
	                                changed = true;
	                                return currFilter;
	                            } else {
	                                return currFilter;
	                            }
	                        });

	                        if (!changed) {
	                            newFilters.push({ columnName: action.column, expression: action.query });
	                        }

	                        this.setState({ filter: newFilters, skip: 0 });
	                        break;
	                    }
	                case 'change-page':
	                    this.setState({ skip: action.skip });
	                    break;
	                case 'toggle-sort':
	                    this.setState({ sort: { columnName: action.columnName, order: action.order }, skip: 0 });
	                    break;

	            }
	        }
	    }, {
	        key: 'render',
	        value: function render() {
	            return _react2.default.createElement(_Ardagryd2.default, { dispatch: this.dispatch, objects: this.props.objects, columns: this.props.columns, config: this.props.config, filter: this.state.filter, skip: this.state.skip, sort: this.state.sort });
	        }
	    }]);

	    return Grid;
	}(_react.Component);

	exports.default = Grid;


	Grid.propTypes = {
	    objects: _react.PropTypes.array.isRequired,
	    config: _proptypes.globalConfig,
	    columns: _proptypes.columnsConfig,
	    sort: _proptypes.sortConfig,
	    filter: _proptypes.filterConfig
	};

	Grid.defaultProps = {};

/***/ },
/* 2 */
/***/ function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_2__;

/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _GridTable = __webpack_require__(4);

	var _GridTable2 = _interopRequireDefault(_GridTable);

	var _GridBody = __webpack_require__(24);

	var _GridBody2 = _interopRequireDefault(_GridBody);

	var _GridRow = __webpack_require__(29);

	var _GridRow2 = _interopRequireDefault(_GridRow);

	var _GridCell = __webpack_require__(30);

	var _GridCell2 = _interopRequireDefault(_GridCell);

	var _GridColumnHeader = __webpack_require__(31);

	var _GridColumnHeader2 = _interopRequireDefault(_GridColumnHeader);

	var _GridHeader = __webpack_require__(32);

	var _GridHeader2 = _interopRequireDefault(_GridHeader);

	var _GridHeaderCell = __webpack_require__(33);

	var _GridHeaderCell2 = _interopRequireDefault(_GridHeaderCell);

	var _BaseCellRenderer = __webpack_require__(57);

	var _BaseCellRenderer2 = _interopRequireDefault(_BaseCellRenderer);

	var _ObjectCellRenderer = __webpack_require__(58);

	var _ObjectCellRenderer2 = _interopRequireDefault(_ObjectCellRenderer);

	var _ArrayCellRenderer = __webpack_require__(59);

	var _ArrayCellRenderer2 = _interopRequireDefault(_ArrayCellRenderer);

	var _Filter = __webpack_require__(60);

	var _Filter2 = _interopRequireDefault(_Filter);

	var _ToolbarDefault = __webpack_require__(64);

	var _ToolbarDefault2 = _interopRequireDefault(_ToolbarDefault);

	var _Pager = __webpack_require__(65);

	var _Pager2 = _interopRequireDefault(_Pager);

	var _constants = __webpack_require__(26);

	var _utils = __webpack_require__(69);

	var _proptypes = __webpack_require__(25);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var filterObjects = function filterObjects(objects, filterConfig, columnConfig, defaultFilterFunction) {
	    //Filter objects based on supplied filter strings
	    var filters = {};
	    var columnNamesWithFilter = filterConfig.map(function (filterObject) {
	        filters[filterObject.columnName] = filterObject.expression;
	        return filterObject.columnName;
	    });

	    return objects.filter(function (currentObjectToBeFiltered) {
	        for (var i in columnNamesWithFilter) {
	            var currentColumn = columnNamesWithFilter[i];
	            var filterFunction = void 0;
	            if (columnConfig !== undefined && columnConfig[currentColumn] !== undefined && columnConfig[currentColumn].filterFunction !== undefined) {
	                filterFunction = columnConfig[currentColumn].filterFunction;
	            } else {
	                filterFunction = defaultFilterFunction;
	            }
	            if (!filterFunction({
	                value: currentObjectToBeFiltered[currentColumn],
	                expression: filters[currentColumn]
	            })) {
	                return false;
	            }
	        }
	        return true;
	    });
	};

	var sortObjects = function sortObjects(objects, sort, columnConfig, defaultSortValueGetter) {
	    var columnName = sort.columnName;
	    var order = sort.order;

	    var sortValueGetter = void 0;
	    if (columnConfig !== undefined && columnConfig[columnName] !== undefined && columnConfig[columnName].sortValueGetter !== undefined) {
	        sortValueGetter = columnConfig[columnName].sortValueGetter;
	    } else {
	        sortValueGetter = defaultSortValueGetter;
	    }

	    // temporary array holds objects with position and sort-value
	    var mapped = objects.map(function (el, i) {
	        var value = sortValueGetter({ value: el[columnName], object: el });
	        return { index: i, value: value };
	    });

	    //reverse order on "descending" sort option
	    var multplier = order === _constants.DESCENDING ? -1 : 1;

	    // sorting the mapped array containing the reduced values
	    mapped.sort(function (a, b) {
	        if (a.value == null) {
	            return multplier * -1;
	        }
	        if (b.value == null) {
	            return multplier * 1;
	        }
	        return multplier * (+(a.value > b.value) || +(a.value === b.value) - 1);
	    });

	    // container for the resulting order
	    return mapped.map(function (el) {
	        return objects[el.index];
	    });
	};

	var extractColumnKeys = function extractColumnKeys(objects, columnConfig, showColumnsWithoutConfig) {
	    //Generate array with selected column-names in configured order
	    if (objects.length > 0) {
	        var _ret = function () {
	            var availableColumnKeys = Object.keys(columnConfig).filter(function (columnName) {
	                return columnConfig[columnName].show !== false;
	            });
	            if (showColumnsWithoutConfig) {
	                Object.keys(objects[0]).forEach(function (columnName) {
	                    if ((columnConfig[columnName] === undefined || columnConfig[columnName].show !== false) && availableColumnKeys.indexOf(columnName) === -1) {
	                        availableColumnKeys.push(columnName);
	                    }
	                });
	            }
	            return {
	                v: availableColumnKeys.sort(function (a, b) {
	                    var configForA = columnConfig[a];
	                    var configForB = columnConfig[b];
	                    var valueForA = configForA && configForA.order != null ? configForA.order : 1000;
	                    var valueForB = configForB && configForB.order != null ? configForB.order : 1000;
	                    return valueForA - valueForB;
	                })
	            };
	        }();

	        if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
	    } else {
	        return [];
	    }
	};

	//Find id-column, or enhance objects with ids
	var getOrCreateIdColumn = function getOrCreateIdColumn(objects, columns) {
	    //check if explicit id-column is set in column-config
	    var idColumn = Object.keys(columns).find(function (key) {
	        if (columns[key].id) {
	            return true;
	        }
	    });

	    if (idColumn) {
	        return idColumn;
	    } else if (objects.length > 0 && objects[0].id !== undefined) {
	        //check if objects have a id-property
	        return 'id';
	    } else {
	        var _ret2 = function () {
	            //TODO: use some type of hashing
	            //generate id-property
	            var index = 0;
	            objects.map(function (object) {
	                object.id = index++;
	            });
	            return {
	                v: 'id'
	            };
	        }();

	        if ((typeof _ret2 === 'undefined' ? 'undefined' : _typeof(_ret2)) === "object") return _ret2.v;
	    }
	};

	var Ardagryd = function Ardagryd(props) {
	    //Merge custom and default config
	    var config = Object.assign({}, defaultConfig, props.config);

	    //Get components from config
	    var Grid = config.grid;
	    var GridHeader = config.header;

	    var Toolbar = config.toolbar;
	    var GridBody = config.body;
	    var ColumnHeader = config.columnHeader;

	    //Get custom column-configuration
	    var columnConfig = props.columns;

	    config.eventHandler = props.dispatch;

	    var idColumn = getOrCreateIdColumn(props.objects, columnConfig);

	    //filter function
	    var filterFunction = config.filterFunction;
	    var filterConfig = (0, _utils.filterConfigFromProp)(props.filter);

	    var objects = filterObjects(props.objects, filterConfig, columnConfig, filterFunction);

	    //Columns to show
	    var columnKeys = extractColumnKeys(props.objects, columnConfig, config.showColumnsWithoutConfig);

	    //Sort

	    //default order

	    var sort = (0, _utils.sortConfigFromProp)(props.sort);

	    //check for sort configuration

	    if (sort) {
	        objects = sortObjects(objects, sort, columnConfig, config.sortValueGetter);
	    }

	    var pagedObjects = void 0;
	    var paging = config.paging;
	    var usePaging = paging !== undefined && paging !== false && objects.length > paging;
	    if (usePaging) {
	        if (paging < 1) {
	            throw new Error('Invalid value for config.paging: ' + paging);
	        }
	        pagedObjects = objects.slice(props.skip, props.skip + paging);
	    } else {
	        pagedObjects = objects;
	    }

	    return _react2.default.createElement(
	        'div',
	        null,
	        usePaging && _react2.default.createElement(_Pager2.default, { length: objects.length, updatePagination: config.eventHandler, skip: props.skip, paging: paging }),
	        _react2.default.createElement(
	            Grid,
	            null,
	            _react2.default.createElement(
	                GridHeader,
	                null,
	                _react2.default.createElement(ColumnHeader, { columns: columnConfig, config: config, columnKeys: columnKeys, sort: sort }),
	                config.showToolbar && _react2.default.createElement(Toolbar, { config: config, columnKeys: columnKeys, columns: columnConfig, filter: filterConfig })
	            ),
	            _react2.default.createElement(GridBody, { idColumn: idColumn, objects: pagedObjects, columns: columnConfig, config: config, columnKeys: columnKeys })
	        )
	    );
	};

	var defaultConfig = {
	    grid: _GridTable2.default,
	    body: _GridBody2.default,
	    row: _GridRow2.default,
	    cell: _GridCell2.default,
	    columnHeader: _GridColumnHeader2.default,
	    header: _GridHeader2.default,
	    columnHeaderCell: _GridHeaderCell2.default,
	    cellRendererBase: _BaseCellRenderer2.default,
	    cellRendererObject: _ObjectCellRenderer2.default,
	    cellRendererArray: _ArrayCellRenderer2.default,
	    filter: _Filter2.default,
	    toolbar: _ToolbarDefault2.default,
	    showToolbar: true,
	    showColumnsWithoutConfig: true, //show all columns which are not explicitly hidden
	    paging: _constants.DEFAULT_ITEMS_PER_PAGE,
	    displayValueGetter: function displayValueGetter(_ref) {
	        var value = _ref.value;
	        return value;
	    },
	    sortValueGetter: function sortValueGetter(_ref2) {
	        var value = _ref2.value;
	        return value ? typeof value === 'number' ? value : typeof value === 'string' ? value.toLowerCase() : JSON.stringify(value).toLowerCase() : value;
	    },
	    filterFunction: function filterFunction(_ref3) {
	        var value = _ref3.value;
	        var expression = _ref3.expression;

	        if (!(typeof expression === 'string') || expression === '' || expression === undefined || expression === null) {
	            return true;
	        }
	        if (value === undefined || value === null) {
	            return false;
	        }
	        if (typeof value === 'string' && value.toLowerCase().indexOf(expression.toLowerCase()) === -1) {
	            return false;
	        } else if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object' || typeof value === 'number') {
	            return JSON.stringify(value).toLowerCase().indexOf(expression.toLowerCase()) !== -1;
	        } else return true;
	    }
	};

	Ardagryd.defaultProps = {
	    config: {},
	    columns: {},
	    dispatch: function dispatch() {}
	};

	Ardagryd.propTypes = {
	    objects: _react.PropTypes.arrayOf(_react.PropTypes.object),
	    config: _proptypes.globalConfig,
	    columns: _proptypes.columnsConfig,
	    dispatch: _react.PropTypes.func.isRequired,
	    sort: _proptypes.sortConfig,
	    filter: _proptypes.filterConfig,
	    skip: _react.PropTypes.number
	};

	exports.default = Ardagryd;

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _Table = __webpack_require__(5);

	var _Table2 = _interopRequireDefault(_Table);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var GridTable = function GridTable(props) {
	    return _react2.default.createElement(
	        _Table2.default,
	        { bordered: true, hover: true },
	        props.children
	    );
	};

	GridTable.propTypes = {
	    children: _react.PropTypes.node
	};

	exports.default = GridTable;

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends = __webpack_require__(6)['default'];

	var _interopRequireDefault = __webpack_require__(22)['default'];

	exports.__esModule = true;

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _classnames = __webpack_require__(23);

	var _classnames2 = _interopRequireDefault(_classnames);

	var Table = _react2['default'].createClass({
	  displayName: 'Table',

	  propTypes: {
	    striped: _react2['default'].PropTypes.bool,
	    bordered: _react2['default'].PropTypes.bool,
	    condensed: _react2['default'].PropTypes.bool,
	    hover: _react2['default'].PropTypes.bool,
	    responsive: _react2['default'].PropTypes.bool
	  },

	  getDefaultProps: function getDefaultProps() {
	    return {
	      bordered: false,
	      condensed: false,
	      hover: false,
	      responsive: false,
	      striped: false
	    };
	  },

	  render: function render() {
	    var classes = {
	      'table': true,
	      'table-striped': this.props.striped,
	      'table-bordered': this.props.bordered,
	      'table-condensed': this.props.condensed,
	      'table-hover': this.props.hover
	    };
	    var table = _react2['default'].createElement(
	      'table',
	      _extends({}, this.props, { className: _classnames2['default'](this.props.className, classes) }),
	      this.props.children
	    );

	    return this.props.responsive ? _react2['default'].createElement(
	      'div',
	      { className: 'table-responsive' },
	      table
	    ) : table;
	  }
	});

	exports['default'] = Table;
	module.exports = exports['default'];

/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var _Object$assign = __webpack_require__(7)["default"];

	exports["default"] = _Object$assign || function (target) {
	  for (var i = 1; i < arguments.length; i++) {
	    var source = arguments[i];

	    for (var key in source) {
	      if (Object.prototype.hasOwnProperty.call(source, key)) {
	        target[key] = source[key];
	      }
	    }
	  }

	  return target;
	};

	exports.__esModule = true;

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = { "default": __webpack_require__(8), __esModule: true };

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(9);
	module.exports = __webpack_require__(12).Object.assign;

/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	// 19.1.3.1 Object.assign(target, source)
	var $export = __webpack_require__(10);

	$export($export.S + $export.F, 'Object', {assign: __webpack_require__(15)});

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	var global    = __webpack_require__(11)
	  , core      = __webpack_require__(12)
	  , ctx       = __webpack_require__(13)
	  , PROTOTYPE = 'prototype';

	var $export = function(type, name, source){
	  var IS_FORCED = type & $export.F
	    , IS_GLOBAL = type & $export.G
	    , IS_STATIC = type & $export.S
	    , IS_PROTO  = type & $export.P
	    , IS_BIND   = type & $export.B
	    , IS_WRAP   = type & $export.W
	    , exports   = IS_GLOBAL ? core : core[name] || (core[name] = {})
	    , target    = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE]
	    , key, own, out;
	  if(IS_GLOBAL)source = name;
	  for(key in source){
	    // contains in native
	    own = !IS_FORCED && target && key in target;
	    if(own && key in exports)continue;
	    // export native or passed
	    out = own ? target[key] : source[key];
	    // prevent global pollution for namespaces
	    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
	    // bind timers to global for call from export context
	    : IS_BIND && own ? ctx(out, global)
	    // wrap global constructors for prevent change them in library
	    : IS_WRAP && target[key] == out ? (function(C){
	      var F = function(param){
	        return this instanceof C ? new C(param) : C(param);
	      };
	      F[PROTOTYPE] = C[PROTOTYPE];
	      return F;
	    // make static versions for prototype methods
	    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
	    if(IS_PROTO)(exports[PROTOTYPE] || (exports[PROTOTYPE] = {}))[key] = out;
	  }
	};
	// type bitmap
	$export.F = 1;  // forced
	$export.G = 2;  // global
	$export.S = 4;  // static
	$export.P = 8;  // proto
	$export.B = 16; // bind
	$export.W = 32; // wrap
	module.exports = $export;

/***/ },
/* 11 */
/***/ function(module, exports) {

	// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
	var global = module.exports = typeof window != 'undefined' && window.Math == Math
	  ? window : typeof self != 'undefined' && self.Math == Math ? self : Function('return this')();
	if(typeof __g == 'number')__g = global; // eslint-disable-line no-undef

/***/ },
/* 12 */
/***/ function(module, exports) {

	var core = module.exports = {version: '1.2.6'};
	if(typeof __e == 'number')__e = core; // eslint-disable-line no-undef

/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	// optional / simple context binding
	var aFunction = __webpack_require__(14);
	module.exports = function(fn, that, length){
	  aFunction(fn);
	  if(that === undefined)return fn;
	  switch(length){
	    case 1: return function(a){
	      return fn.call(that, a);
	    };
	    case 2: return function(a, b){
	      return fn.call(that, a, b);
	    };
	    case 3: return function(a, b, c){
	      return fn.call(that, a, b, c);
	    };
	  }
	  return function(/* ...args */){
	    return fn.apply(that, arguments);
	  };
	};

/***/ },
/* 14 */
/***/ function(module, exports) {

	module.exports = function(it){
	  if(typeof it != 'function')throw TypeError(it + ' is not a function!');
	  return it;
	};

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	// 19.1.2.1 Object.assign(target, source, ...)
	var $        = __webpack_require__(16)
	  , toObject = __webpack_require__(17)
	  , IObject  = __webpack_require__(19);

	// should work with symbols and should have deterministic property order (V8 bug)
	module.exports = __webpack_require__(21)(function(){
	  var a = Object.assign
	    , A = {}
	    , B = {}
	    , S = Symbol()
	    , K = 'abcdefghijklmnopqrst';
	  A[S] = 7;
	  K.split('').forEach(function(k){ B[k] = k; });
	  return a({}, A)[S] != 7 || Object.keys(a({}, B)).join('') != K;
	}) ? function assign(target, source){ // eslint-disable-line no-unused-vars
	  var T     = toObject(target)
	    , $$    = arguments
	    , $$len = $$.length
	    , index = 1
	    , getKeys    = $.getKeys
	    , getSymbols = $.getSymbols
	    , isEnum     = $.isEnum;
	  while($$len > index){
	    var S      = IObject($$[index++])
	      , keys   = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S)
	      , length = keys.length
	      , j      = 0
	      , key;
	    while(length > j)if(isEnum.call(S, key = keys[j++]))T[key] = S[key];
	  }
	  return T;
	} : Object.assign;

/***/ },
/* 16 */
/***/ function(module, exports) {

	var $Object = Object;
	module.exports = {
	  create:     $Object.create,
	  getProto:   $Object.getPrototypeOf,
	  isEnum:     {}.propertyIsEnumerable,
	  getDesc:    $Object.getOwnPropertyDescriptor,
	  setDesc:    $Object.defineProperty,
	  setDescs:   $Object.defineProperties,
	  getKeys:    $Object.keys,
	  getNames:   $Object.getOwnPropertyNames,
	  getSymbols: $Object.getOwnPropertySymbols,
	  each:       [].forEach
	};

/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	// 7.1.13 ToObject(argument)
	var defined = __webpack_require__(18);
	module.exports = function(it){
	  return Object(defined(it));
	};

/***/ },
/* 18 */
/***/ function(module, exports) {

	// 7.2.1 RequireObjectCoercible(argument)
	module.exports = function(it){
	  if(it == undefined)throw TypeError("Can't call method on  " + it);
	  return it;
	};

/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	// fallback for non-array-like ES3 and non-enumerable old V8 strings
	var cof = __webpack_require__(20);
	module.exports = Object('z').propertyIsEnumerable(0) ? Object : function(it){
	  return cof(it) == 'String' ? it.split('') : Object(it);
	};

/***/ },
/* 20 */
/***/ function(module, exports) {

	var toString = {}.toString;

	module.exports = function(it){
	  return toString.call(it).slice(8, -1);
	};

/***/ },
/* 21 */
/***/ function(module, exports) {

	module.exports = function(exec){
	  try {
	    return !!exec();
	  } catch(e){
	    return true;
	  }
	};

/***/ },
/* 22 */
/***/ function(module, exports) {

	"use strict";

	exports["default"] = function (obj) {
	  return obj && obj.__esModule ? obj : {
	    "default": obj
	  };
	};

	exports.__esModule = true;

/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	  Copyright (c) 2016 Jed Watson.
	  Licensed under the MIT License (MIT), see
	  http://jedwatson.github.io/classnames
	*/
	/* global define */

	(function () {
		'use strict';

		var hasOwn = {}.hasOwnProperty;

		function classNames () {
			var classes = [];

			for (var i = 0; i < arguments.length; i++) {
				var arg = arguments[i];
				if (!arg) continue;

				var argType = typeof arg;

				if (argType === 'string' || argType === 'number') {
					classes.push(arg);
				} else if (Array.isArray(arg)) {
					classes.push(classNames.apply(null, arg));
				} else if (argType === 'object') {
					for (var key in arg) {
						if (hasOwn.call(arg, key) && arg[key]) {
							classes.push(key);
						}
					}
				}
			}

			return classes.join(' ');
		}

		if (typeof module !== 'undefined' && module.exports) {
			module.exports = classNames;
		} else if (true) {
			// register as 'classnames', consistent with npm package name
			!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {
				return classNames;
			}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
		} else {
			window.classNames = classNames;
		}
	}());


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _proptypes = __webpack_require__(25);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var GridBody = function GridBody(props) {
	    var Row = props.config.row;
	    var Cell = props.config.cell;
	    var CellRendererBase = props.config.cellRendererBase;

	    var rows = props.objects.map(function (current) {
	        var cells = props.columnKeys.map(function (key) {
	            var configForColumn = props.columns[key];
	            var displayValueGetter = props.config.displayValueGetter;
	            if (configForColumn && configForColumn.displayValueGetter) {
	                displayValueGetter = configForColumn.displayValueGetter;
	            }
	            var args = { columns: props.columns, columnName: key, config: props.config, value: current[key], object: current };
	            var value = void 0;
	            if (displayValueGetter.prototype instanceof _react.Component) {
	                value = _react2.default.createElement(displayValueGetter, args);
	            } else {
	                value = displayValueGetter(args);
	            }
	            var CellRenderer = CellRendererBase;
	            if (configForColumn && configForColumn.cellRenderer) {
	                CellRenderer = configForColumn.cellRenderer;
	            } else {
	                if (value == null) {
	                    return _react2.default.createElement(Cell, { key: key, columnName: key });
	                } else if (typeof value === 'string' || typeof value === 'number' || typeof value === 'boolean' || _react2.default.isValidElement(value)) {
	                    return _react2.default.createElement(
	                        Cell,
	                        { key: key, columnName: key },
	                        value
	                    );
	                }
	            }

	            return _react2.default.createElement(
	                Cell,
	                { key: key, columnName: key },
	                _react2.default.createElement(CellRenderer, { config: props.config, value: value, columns: props.columns, columnName: key, object: current })
	            );
	        });

	        return _react2.default.createElement(
	            Row,
	            { key: current[props.idColumn], columns: props.columns, config: props.config, object: current },
	            cells
	        );
	    });
	    return _react2.default.createElement(
	        'tbody',
	        null,
	        rows,
	        props.children
	    );
	};

	GridBody.propTypes = {
	    config: _proptypes.globalConfig,
	    objects: _react.PropTypes.arrayOf(_react.PropTypes.object),
	    columnKeys: _react.PropTypes.arrayOf(_react.PropTypes.string).isRequired,
	    columns: _proptypes.columnsConfig,
	    children: _react.PropTypes.any,
	    idColumn: _react.PropTypes.string.isRequired
	};

	exports.default = GridBody;

/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.filterConfig = exports.filterConfigSingle = exports.sortConfig = exports.sortConfigSingle = exports.columnsConfig = exports.globalConfig = undefined;

	var _react = __webpack_require__(2);

	var _constants = __webpack_require__(26);

	var _elementType = __webpack_require__(27);

	var _elementType2 = _interopRequireDefault(_elementType);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var filterConfigSingle = _react.PropTypes.shape({
	    columnName: _react.PropTypes.string.isRequired,
	    expression: _react.PropTypes.string.isRequired
	});

	var sortConfigSingle = _react.PropTypes.shape({
	    columnName: _react.PropTypes.string.isRequired,
	    order: _react.PropTypes.oneOf([_constants.ASCENDING, _constants.DESCENDING])
	});

	var sortConfig = _react.PropTypes.oneOfType([_react.PropTypes.string, sortConfigSingle, _react.PropTypes.arrayOf(sortConfigSingle)]);

	var filterConfig = _react.PropTypes.oneOfType([filterConfigSingle, _react.PropTypes.arrayOf(filterConfigSingle)]);

	var columnsConfig = _react.PropTypes.objectOf(_react.PropTypes.shape({
	    displayValueGetter: _react.PropTypes.func,
	    id: _react.PropTypes.bool,
	    label: _react.PropTypes.string,
	    order: _react.PropTypes.number,
	    hideTools: _react.PropTypes.bool,
	    sortable: _react.PropTypes.bool,
	    cellRenderer: _elementType2.default,
	    sortValueGetter: _react.PropTypes.func,
	    filterFunction: _react.PropTypes.func,
	    filter: function filter(props, propName, componentName, location, propFullName) {
	        if (props[propName]) {
	            return new Error('Invalid prop `' + propFullName + '` supplied to' + ' `' + componentName + '`. Please use the `filter` prop on the root component.');
	        }
	    },
	    sort: function sort(props, propName, componentName, location, propFullName) {
	        if (props[propName]) {
	            return new Error('Invalid prop `' + propFullName + '` supplied to' + ' `' + componentName + '`. Please use the `sort` prop on the root component.');
	        }
	    }
	}));

	var globalConfig = _react.PropTypes.shape({
	    grid: _react.PropTypes.func,
	    body: _react.PropTypes.func,
	    row: _react.PropTypes.func,
	    cell: _react.PropTypes.func,
	    columnHeader: _react.PropTypes.func,
	    header: _react.PropTypes.func,
	    columnHeaderCell: _react.PropTypes.func,
	    cellRendererBase: _react.PropTypes.func,
	    cellRendererObject: _react.PropTypes.func,
	    cellRendererArray: _react.PropTypes.func,
	    filter: _react.PropTypes.func,
	    toolbar: _react.PropTypes.func,
	    showToolbar: _react.PropTypes.bool,
	    showColumnsWithoutConfig: _react.PropTypes.bool,
	    paging: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.oneOf([false])]),
	    displayValueGetter: _react.PropTypes.func,
	    sortValueGetter: _react.PropTypes.func,
	    filterFunction: _react.PropTypes.func
	});

	exports.globalConfig = globalConfig;
	exports.columnsConfig = columnsConfig;
	exports.sortConfigSingle = sortConfigSingle;
	exports.sortConfig = sortConfig;
	exports.filterConfigSingle = filterConfigSingle;
	exports.filterConfig = filterConfig;

/***/ },
/* 26 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	var ASCENDING = exports.ASCENDING = 'asc';
	var DESCENDING = exports.DESCENDING = 'desc';

	var DEFAULT_ITEMS_PER_PAGE = exports.DEFAULT_ITEMS_PER_PAGE = 10;

/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	exports.__esModule = true;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _common = __webpack_require__(28);

	/**
	 * Checks whether a prop provides a type of element.
	 *
	 * The type of element can be provided in two forms:
	 * - tag name (string)
	 * - a return value of React.createClass(...)
	 *
	 * @param props
	 * @param propName
	 * @param componentName
	 * @returns {Error|undefined}
	 */

	function validate(props, propName, componentName) {
	  var errBeginning = _common.errMsg(props, propName, componentName, '. Expected an Element `type`');

	  if (typeof props[propName] !== 'function') {
	    if (_react2['default'].isValidElement(props[propName])) {
	      return new Error(errBeginning + ', not an actual Element');
	    }

	    if (typeof props[propName] !== 'string') {
	      return new Error(errBeginning + ' such as a tag name or return value of React.createClass(...)');
	    }
	  }
	}

	exports['default'] = _common.createChainableTypeChecker(validate);
	module.exports = exports['default'];

/***/ },
/* 28 */
/***/ function(module, exports) {

	'use strict';

	exports.__esModule = true;
	exports.errMsg = errMsg;
	exports.createChainableTypeChecker = createChainableTypeChecker;

	function errMsg(props, propName, componentName, msgContinuation) {
	  return 'Invalid prop \'' + propName + '\' of value \'' + props[propName] + '\'' + (' supplied to \'' + componentName + '\'' + msgContinuation);
	}

	/**
	 * Create chain-able isRequired validator
	 *
	 * Largely copied directly from:
	 *  https://github.com/facebook/react/blob/0.11-stable/src/core/ReactPropTypes.js#L94
	 */

	function createChainableTypeChecker(validate) {
	  function checkType(isRequired, props, propName, componentName) {
	    componentName = componentName || '<<anonymous>>';
	    if (props[propName] == null) {
	      if (isRequired) {
	        return new Error('Required prop \'' + propName + '\' was not specified in \'' + componentName + '\'.');
	      }
	    } else {
	      return validate(props, propName, componentName);
	    }
	  }

	  var chainedCheckType = checkType.bind(null, false);
	  chainedCheckType.isRequired = checkType.bind(null, true);

	  return chainedCheckType;
	}

/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _proptypes = __webpack_require__(25);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var GridRow = function (_Component) {
	    _inherits(GridRow, _Component);

	    function GridRow(props) {
	        _classCallCheck(this, GridRow);

	        return _possibleConstructorReturn(this, Object.getPrototypeOf(GridRow).call(this, props));
	    }

	    _createClass(GridRow, [{
	        key: 'shouldComponentUpdate',
	        value: function shouldComponentUpdate(nextProps) {
	            return this.props.object !== nextProps.object || this.props.columns !== nextProps.columns || this.props.config.showColumnsWithoutConfig !== nextProps.config.showColumnsWithoutConfig || this.props.config.cell !== nextProps.config.cell || this.props.config.cellRendererBase !== nextProps.config.cellRendererBase || this.props.config.cellRendererObject !== nextProps.config.cellRendererObject || this.props.config.cellRendererArray !== nextProps.config.cellRendererArray || this.props.config.displayValueGetter !== nextProps.config.displayValueGetter;
	        }
	    }, {
	        key: 'render',
	        value: function render() {
	            return _react2.default.createElement(
	                'tr',
	                null,
	                this.props.children
	            );
	        }
	    }]);

	    return GridRow;
	}(_react.Component);

	GridRow.propTypes = {
	    object: _react.PropTypes.object.isRequired,
	    config: _proptypes.globalConfig,
	    columns: _proptypes.columnsConfig,
	    children: _react.PropTypes.node
	};

	exports.default = GridRow;

/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var GridCell = function GridCell(props) {
	    return _react2.default.createElement(
	        'td',
	        null,
	        props.children
	    );
	};

	GridCell.propTypes = {
	    children: _react.PropTypes.node
	};

	exports.default = GridCell;

/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _proptypes = __webpack_require__(25);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var getLabel = function getLabel(columnKey, columnConfig) {
	    return columnConfig[columnKey] && columnConfig[columnKey].label ? columnConfig[columnKey].label : columnKey;
	};

	var GridColumnHeader = function GridColumnHeader(props) {
	    var GridHeaderCell = props.config.columnHeaderCell;
	    var columnConfig = props.columns;
	    var headerCells = props.columnKeys.map(function (currentKey, index) {
	        var columnLabel = getLabel(currentKey, columnConfig);
	        var configForCurrentColumn = columnConfig[currentKey];
	        var sortable = configForCurrentColumn && configForCurrentColumn.sortable === false ? false : true;
	        var sort = false;
	        if (props.sort && props.sort.columnName === currentKey) {
	            sort = props.sort.order;
	        }
	        return _react2.default.createElement(
	            GridHeaderCell,
	            { key: currentKey, columnName: currentKey, columnIndex: index, sortable: sortable, sort: sort, updateSort: props.config.eventHandler },
	            columnLabel
	        );
	    });

	    return _react2.default.createElement(
	        'tr',
	        null,
	        headerCells
	    );
	};

	GridColumnHeader.propTypes = {
	    config: _proptypes.globalConfig,
	    columns: _proptypes.columnsConfig,
	    columnKeys: _react.PropTypes.arrayOf(_react.PropTypes.string).isRequired,
	    sort: _proptypes.sortConfigSingle
	};

	exports.default = GridColumnHeader;

/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var GridHeader = function GridHeader(props) {
	    return _react2.default.createElement(
	        'thead',
	        null,
	        props.children
	    );
	};

	GridHeader.propTypes = {
	    children: _react.PropTypes.node
	};

	exports.default = GridHeader;

/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _constants = __webpack_require__(26);

	var _Button = __webpack_require__(34);

	var _Button2 = _interopRequireDefault(_Button);

	var _Glyphicon = __webpack_require__(54);

	var _Glyphicon2 = _interopRequireDefault(_Glyphicon);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var GridHeaderCell = function (_Component) {
	    _inherits(GridHeaderCell, _Component);

	    function GridHeaderCell(props) {
	        _classCallCheck(this, GridHeaderCell);

	        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(GridHeaderCell).call(this, props));

	        _this.sortChanged = _this.sortChanged.bind(_this);
	        return _this;
	    }

	    _createClass(GridHeaderCell, [{
	        key: 'sortChanged',
	        value: function sortChanged() {
	            var key = this.props.columnName;
	            var order = _constants.ASCENDING;
	            if (this.props.sort && this.props.sort !== _constants.DESCENDING) {
	                order = _constants.DESCENDING;
	            }
	            this.props.updateSort({
	                type: 'toggle-sort',
	                columnName: key,
	                order: order
	            });
	        }
	    }, {
	        key: 'render',
	        value: function render() {
	            var sort = this.props.sort;
	            var label = this.props.children;
	            var sortable = this.props.sortable;
	            var iconName = 'sort';
	            var active = false;
	            if (sort) {
	                iconName = sort === _constants.DESCENDING ? 'sort-by-attributes-alt' : 'sort-by-attributes';
	                active = true;
	            }
	            return _react2.default.createElement(
	                'th',
	                null,
	                _react2.default.createElement(
	                    'span',
	                    { style: { display: 'flex', alignItems: 'center' } },
	                    _react2.default.createElement(
	                        'span',
	                        { style: { flex: '1' } },
	                        label
	                    ),
	                    sortable && _react2.default.createElement(
	                        _Button2.default,
	                        { active: active, bsSize: 'xsmall', style: { marginLeft: '5px' }, onClick: this.sortChanged },
	                        _react2.default.createElement(_Glyphicon2.default, { glyph: iconName })
	                    )
	                )
	            );
	        }
	    }]);

	    return GridHeaderCell;
	}(_react.Component);

	GridHeaderCell.propTypes = {
	    columnName: _react.PropTypes.string.isRequired,
	    sort: _react.PropTypes.oneOf([true, false, _constants.ASCENDING, _constants.DESCENDING]),
	    updateSort: _react.PropTypes.func.isRequired,
	    sortable: _react.PropTypes.bool,
	    children: _react.PropTypes.node
	};

	GridHeaderCell.defaultProps = {
	    sortable: true
	};

	exports.default = GridHeaderCell;

/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _inherits = __webpack_require__(35)['default'];

	var _classCallCheck = __webpack_require__(44)['default'];

	var _extends = __webpack_require__(6)['default'];

	var _interopRequireDefault = __webpack_require__(22)['default'];

	exports.__esModule = true;

	var _classnames = __webpack_require__(23);

	var _classnames2 = _interopRequireDefault(_classnames);

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _reactPropTypesLibElementType = __webpack_require__(27);

	var _reactPropTypesLibElementType2 = _interopRequireDefault(_reactPropTypesLibElementType);

	var _styleMaps = __webpack_require__(45);

	var _utilsBootstrapUtils = __webpack_require__(50);

	var _SafeAnchor = __webpack_require__(52);

	var _SafeAnchor2 = _interopRequireDefault(_SafeAnchor);

	var ButtonStyles = _styleMaps.State.values().concat(_styleMaps.DEFAULT, _styleMaps.PRIMARY, _styleMaps.LINK);

	var types = ['button', 'reset', 'submit'];

	var Button = (function (_React$Component) {
	  _inherits(Button, _React$Component);

	  function Button(props, context) {
	    _classCallCheck(this, Button);

	    _React$Component.call(this, props, context);
	  }

	  Button.prototype.render = function render() {
	    var _extends2;

	    var classes = this.props.navDropdown ? {} : _utilsBootstrapUtils.getClassSet(this.props);
	    var renderFuncName = undefined;

	    var blockClass = _utilsBootstrapUtils.prefix(this.props, 'block');

	    classes = _extends((_extends2 = {
	      active: this.props.active
	    }, _extends2[blockClass] = this.props.block, _extends2), classes);

	    if (this.props.navItem) {
	      return this.renderNavItem(classes);
	    }

	    renderFuncName = this.props.href || this.props.target || this.props.navDropdown ? 'renderAnchor' : 'renderButton';

	    return this[renderFuncName](classes);
	  };

	  Button.prototype.renderAnchor = function renderAnchor(classes) {
	    var _props = this.props;
	    var disabled = _props.disabled;
	    var href = _props.href;

	    classes.disabled = disabled;

	    return _react2['default'].createElement(
	      _SafeAnchor2['default'],
	      _extends({}, this.props, {
	        href: href || '#',
	        className: _classnames2['default'](this.props.className, classes)
	      }),
	      this.props.children
	    );
	  };

	  Button.prototype.renderButton = function renderButton(classes) {
	    var Component = this.props.componentClass || 'button';

	    return _react2['default'].createElement(
	      Component,
	      _extends({}, this.props, {
	        type: this.props.type || 'button',
	        className: _classnames2['default'](this.props.className, classes) }),
	      this.props.children
	    );
	  };

	  Button.prototype.renderNavItem = function renderNavItem(classes) {
	    var liClasses = {
	      active: this.props.active
	    };

	    return _react2['default'].createElement(
	      'li',
	      { className: _classnames2['default'](liClasses) },
	      this.renderAnchor(classes)
	    );
	  };

	  return Button;
	})(_react2['default'].Component);

	Button.propTypes = {
	  active: _react2['default'].PropTypes.bool,
	  disabled: _react2['default'].PropTypes.bool,
	  block: _react2['default'].PropTypes.bool,
	  navItem: _react2['default'].PropTypes.bool,
	  navDropdown: _react2['default'].PropTypes.bool,
	  onClick: _react2['default'].PropTypes.func,
	  /**
	   * You can use a custom element for this component
	   */
	  componentClass: _reactPropTypesLibElementType2['default'],
	  href: _react2['default'].PropTypes.string,
	  target: _react2['default'].PropTypes.string,
	  /**
	   * Defines HTML button type Attribute
	   * @type {("button"|"reset"|"submit")}
	   * @defaultValue 'button'
	   */
	  type: _react2['default'].PropTypes.oneOf(types)
	};

	Button.defaultProps = {
	  active: false,
	  block: false,
	  disabled: false,
	  navItem: false,
	  navDropdown: false
	};

	Button.types = types;

	exports['default'] = _utilsBootstrapUtils.bsStyles(ButtonStyles, _styleMaps.DEFAULT, _utilsBootstrapUtils.bsSizes([_styleMaps.Sizes.LARGE, _styleMaps.Sizes.SMALL, _styleMaps.Sizes.XSMALL], _utilsBootstrapUtils.bsClass('btn', Button)));
	module.exports = exports['default'];

/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var _Object$create = __webpack_require__(36)["default"];

	var _Object$setPrototypeOf = __webpack_require__(38)["default"];

	exports["default"] = function (subClass, superClass) {
	  if (typeof superClass !== "function" && superClass !== null) {
	    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
	  }

	  subClass.prototype = _Object$create(superClass && superClass.prototype, {
	    constructor: {
	      value: subClass,
	      enumerable: false,
	      writable: true,
	      configurable: true
	    }
	  });
	  if (superClass) _Object$setPrototypeOf ? _Object$setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	};

	exports.__esModule = true;

/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = { "default": __webpack_require__(37), __esModule: true };

/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	var $ = __webpack_require__(16);
	module.exports = function create(P, D){
	  return $.create(P, D);
	};

/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = { "default": __webpack_require__(39), __esModule: true };

/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(40);
	module.exports = __webpack_require__(12).Object.setPrototypeOf;

/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	// 19.1.3.19 Object.setPrototypeOf(O, proto)
	var $export = __webpack_require__(10);
	$export($export.S, 'Object', {setPrototypeOf: __webpack_require__(41).set});

/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	// Works with __proto__ only. Old v8 can't work with null proto objects.
	/* eslint-disable no-proto */
	var getDesc  = __webpack_require__(16).getDesc
	  , isObject = __webpack_require__(42)
	  , anObject = __webpack_require__(43);
	var check = function(O, proto){
	  anObject(O);
	  if(!isObject(proto) && proto !== null)throw TypeError(proto + ": can't set as prototype!");
	};
	module.exports = {
	  set: Object.setPrototypeOf || ('__proto__' in {} ? // eslint-disable-line
	    function(test, buggy, set){
	      try {
	        set = __webpack_require__(13)(Function.call, getDesc(Object.prototype, '__proto__').set, 2);
	        set(test, []);
	        buggy = !(test instanceof Array);
	      } catch(e){ buggy = true; }
	      return function setPrototypeOf(O, proto){
	        check(O, proto);
	        if(buggy)O.__proto__ = proto;
	        else set(O, proto);
	        return O;
	      };
	    }({}, false) : undefined),
	  check: check
	};

/***/ },
/* 42 */
/***/ function(module, exports) {

	module.exports = function(it){
	  return typeof it === 'object' ? it !== null : typeof it === 'function';
	};

/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	var isObject = __webpack_require__(42);
	module.exports = function(it){
	  if(!isObject(it))throw TypeError(it + ' is not an object!');
	  return it;
	};

/***/ },
/* 44 */
/***/ function(module, exports) {

	"use strict";

	exports["default"] = function (instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	};

	exports.__esModule = true;

/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _Object$assign = __webpack_require__(7)['default'];

	var _Object$create = __webpack_require__(36)['default'];

	var _Object$keys = __webpack_require__(46)['default'];

	exports.__esModule = true;

	var constant = function constant(obj) {
	  return _Object$assign(_Object$create({
	    values: function values() {
	      var _this = this;

	      return _Object$keys(this).map(function (k) {
	        return _this[k];
	      });
	    }
	  }), obj);
	};

	var styleMaps = {

	  SIZES: {
	    'large': 'lg',
	    'medium': 'md',
	    'small': 'sm',
	    'xsmall': 'xs',
	    'lg': 'lg',
	    'md': 'md',
	    'sm': 'sm',
	    'xs': 'xs'
	  },
	  GRID_COLUMNS: 12
	};

	var Sizes = constant({
	  LARGE: 'large',
	  MEDIUM: 'medium',
	  SMALL: 'small',
	  XSMALL: 'xsmall'
	});

	exports.Sizes = Sizes;
	var State = constant({
	  SUCCESS: 'success',
	  WARNING: 'warning',
	  DANGER: 'danger',
	  INFO: 'info'
	});

	exports.State = State;
	var DEFAULT = 'default';
	exports.DEFAULT = DEFAULT;
	var PRIMARY = 'primary';
	exports.PRIMARY = PRIMARY;
	var LINK = 'link';
	exports.LINK = LINK;
	var INVERSE = 'inverse';

	exports.INVERSE = INVERSE;
	exports['default'] = styleMaps;

/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = { "default": __webpack_require__(47), __esModule: true };

/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(48);
	module.exports = __webpack_require__(12).Object.keys;

/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	// 19.1.2.14 Object.keys(O)
	var toObject = __webpack_require__(17);

	__webpack_require__(49)('keys', function($keys){
	  return function keys(it){
	    return $keys(toObject(it));
	  };
	});

/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	// most Object methods by ES6 should accept primitives
	var $export = __webpack_require__(10)
	  , core    = __webpack_require__(12)
	  , fails   = __webpack_require__(21);
	module.exports = function(KEY, exec){
	  var fn  = (core.Object || {})[KEY] || Object[KEY]
	    , exp = {};
	  exp[KEY] = exec(fn);
	  $export($export.S + $export.F * fails(function(){ fn(1); }), 'Object', exp);
	};

/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends = __webpack_require__(6)['default'];

	var _interopRequireDefault = __webpack_require__(22)['default'];

	exports.__esModule = true;
	exports.prefix = prefix;
	exports.getClassSet = getClassSet;
	exports.addStyle = addStyle;

	var _react = __webpack_require__(2);

	var _styleMaps = __webpack_require__(45);

	var _styleMaps2 = _interopRequireDefault(_styleMaps);

	var _invariant = __webpack_require__(51);

	var _invariant2 = _interopRequireDefault(_invariant);

	function curry(fn) {
	  return function () {
	    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
	      args[_key] = arguments[_key];
	    }

	    var last = args[args.length - 1];
	    if (typeof last === 'function') {
	      return fn.apply(undefined, args);
	    }
	    return function (Component) {
	      return fn.apply(undefined, args.concat([Component]));
	    };
	  };
	}

	function prefix(props, variant) {
	  if (props === undefined) props = {};

	  !(props.bsClass || '').trim() ?  true ? _invariant2['default'](false, 'A `bsClass` prop is required for this component') : _invariant2['default'](false) : undefined;
	  return props.bsClass + (variant ? '-' + variant : '');
	}

	var bsClass = curry(function (defaultClass, Component) {
	  var propTypes = Component.propTypes || (Component.propTypes = {});
	  var defaultProps = Component.defaultProps || (Component.defaultProps = {});

	  propTypes.bsClass = _react.PropTypes.string;
	  defaultProps.bsClass = defaultClass;

	  return Component;
	});

	exports.bsClass = bsClass;
	var bsStyles = curry(function (styles, defaultStyle, Component) {
	  if (typeof defaultStyle !== 'string') {
	    Component = defaultStyle;
	    defaultStyle = undefined;
	  }

	  var existing = Component.STYLES || [];
	  var propTypes = Component.propTypes || {};

	  styles.forEach(function (style) {
	    if (existing.indexOf(style) === -1) {
	      existing.push(style);
	    }
	  });

	  var propType = _react.PropTypes.oneOf(existing);

	  // expose the values on the propType function for documentation
	  Component.STYLES = propType._values = existing;

	  Component.propTypes = _extends({}, propTypes, {
	    bsStyle: propType
	  });

	  if (defaultStyle !== undefined) {
	    var defaultProps = Component.defaultProps || (Component.defaultProps = {});
	    defaultProps.bsStyle = defaultStyle;
	  }

	  return Component;
	});

	exports.bsStyles = bsStyles;
	var bsSizes = curry(function (sizes, defaultSize, Component) {
	  if (typeof defaultSize !== 'string') {
	    Component = defaultSize;
	    defaultSize = undefined;
	  }

	  var existing = Component.SIZES || [];
	  var propTypes = Component.propTypes || {};

	  sizes.forEach(function (size) {
	    if (existing.indexOf(size) === -1) {
	      existing.push(size);
	    }
	  });

	  var values = [];
	  existing.forEach(function (size) {
	    var mappedSize = _styleMaps2['default'].SIZES[size];
	    if (mappedSize && mappedSize !== size) {
	      values.push(mappedSize);
	    }

	    values.push(size);
	  });

	  var propType = _react.PropTypes.oneOf(values);
	  propType._values = values;

	  // expose the values on the propType function for documentation
	  Component.SIZES = existing;

	  Component.propTypes = _extends({}, propTypes, {
	    bsSize: propType
	  });

	  if (defaultSize !== undefined) {
	    if (!Component.defaultProps) {
	      Component.defaultProps = {};
	    }
	    Component.defaultProps.bsSize = defaultSize;
	  }

	  return Component;
	});

	exports.bsSizes = bsSizes;

	function getClassSet(props) {
	  var _classes;

	  var classes = (_classes = {}, _classes[prefix(props)] = true, _classes);

	  if (props.bsSize) {
	    var bsSize = _styleMaps2['default'].SIZES[props.bsSize] || bsSize;
	    classes[prefix(props, bsSize)] = true;
	  }

	  if (props.bsStyle) {
	    classes[prefix(props, props.bsStyle)] = true;
	  }

	  return classes;
	}

	/**
	 * Add a style variant to a Component. Mutates the propTypes of the component
	 * in order to validate the new variant.
	 */

	function addStyle(Component) {
	  for (var _len2 = arguments.length, styleVariant = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
	    styleVariant[_key2 - 1] = arguments[_key2];
	  }

	  bsStyles(styleVariant, Component);
	}

	var _curry = curry;
	exports._curry = _curry;

/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copyright 2013-2015, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 */

	'use strict';

	/**
	 * Use invariant() to assert state which your program assumes to be true.
	 *
	 * Provide sprintf-style format (only %s is supported) and arguments
	 * to provide information about what broke and what you were
	 * expecting.
	 *
	 * The invariant message will be stripped in production, but the invariant
	 * will remain to ensure logic does not differ in production.
	 */

	var invariant = function(condition, format, a, b, c, d, e, f) {
	  if (true) {
	    if (format === undefined) {
	      throw new Error('invariant requires an error message argument');
	    }
	  }

	  if (!condition) {
	    var error;
	    if (format === undefined) {
	      error = new Error(
	        'Minified exception occurred; use the non-minified dev environment ' +
	        'for the full error message and additional helpful warnings.'
	      );
	    } else {
	      var args = [a, b, c, d, e, f];
	      var argIndex = 0;
	      error = new Error(
	        format.replace(/%s/g, function() { return args[argIndex++]; })
	      );
	      error.name = 'Invariant Violation';
	    }

	    error.framesToPop = 1; // we don't care about invariant's own frame
	    throw error;
	  }
	};

	module.exports = invariant;


/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _inherits = __webpack_require__(35)['default'];

	var _classCallCheck = __webpack_require__(44)['default'];

	var _extends = __webpack_require__(6)['default'];

	var _objectWithoutProperties = __webpack_require__(53)['default'];

	var _interopRequireDefault = __webpack_require__(22)['default'];

	exports.__esModule = true;

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _reactPropTypesLibElementType = __webpack_require__(27);

	var _reactPropTypesLibElementType2 = _interopRequireDefault(_reactPropTypesLibElementType);

	function isTrivialHref(href) {
	  return !href || href.trim() === '#';
	}

	/**
	 * There are situations due to browser quirks or bootstrap css where
	 * an anchor tag is needed, when semantically a button tag is the
	 * better choice. SafeAnchor ensures that when an anchor is used like a
	 * button its accessible. It also emulates input `disabled` behavior for
	 * links, which is usually desirable for Buttons, NavItems, MenuItems, etc.
	 */

	var SafeAnchor = (function (_React$Component) {
	  _inherits(SafeAnchor, _React$Component);

	  function SafeAnchor(props) {
	    _classCallCheck(this, SafeAnchor);

	    _React$Component.call(this, props);
	    this.handleClick = this.handleClick.bind(this);
	  }

	  SafeAnchor.prototype.render = function render() {
	    var _props = this.props;
	    var href = _props.href;
	    var role = _props.role;
	    var tabIndex = _props.tabIndex;
	    var disabled = _props.disabled;
	    var style = _props.style;

	    var props = _objectWithoutProperties(_props, ['href', 'role', 'tabIndex', 'disabled', 'style']);

	    var Component = this.props.componentClass || 'a';

	    if (isTrivialHref(href)) {
	      role = role || 'button';
	      // we want to make sure there is a href attribute on the node
	      // otherwise, the cursor incorrectly styled (except with role='button')
	      href = href || '';
	    }

	    if (disabled) {
	      tabIndex = -1;
	      style = _extends({ pointerEvents: 'none' }, style);
	    }

	    return _react2['default'].createElement(Component, _extends({}, props, {
	      role: role,
	      href: href,
	      style: style,
	      tabIndex: tabIndex,
	      onClick: this.handleClick
	    }));
	  };

	  SafeAnchor.prototype.handleClick = function handleClick(event) {
	    var _props2 = this.props;
	    var disabled = _props2.disabled;
	    var href = _props2.href;
	    var onClick = _props2.onClick;

	    if (disabled || isTrivialHref(href)) {
	      event.preventDefault();
	    }

	    if (disabled) {
	      event.stopPropagation();
	      return;
	    }

	    if (onClick) {
	      onClick(event);
	    }
	  };

	  return SafeAnchor;
	})(_react2['default'].Component);

	exports['default'] = SafeAnchor;

	SafeAnchor.propTypes = {
	  href: _react2['default'].PropTypes.string,
	  onClick: _react2['default'].PropTypes.func,
	  disabled: _react2['default'].PropTypes.bool,
	  role: _react2['default'].PropTypes.string,
	  tabIndex: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.number, _react2['default'].PropTypes.string]),
	  /**
	   * this is sort of silly but needed for Button
	   */
	  componentClass: _reactPropTypesLibElementType2['default']
	};
	module.exports = exports['default'];

/***/ },
/* 53 */
/***/ function(module, exports) {

	"use strict";

	exports["default"] = function (obj, keys) {
	  var target = {};

	  for (var i in obj) {
	    if (keys.indexOf(i) >= 0) continue;
	    if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
	    target[i] = obj[i];
	  }

	  return target;
	};

	exports.__esModule = true;

/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends = __webpack_require__(6)['default'];

	var _interopRequireDefault = __webpack_require__(22)['default'];

	exports.__esModule = true;

	var _classnames = __webpack_require__(23);

	var _classnames2 = _interopRequireDefault(_classnames);

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _reactPropTypesLibDeprecated = __webpack_require__(55);

	var _reactPropTypesLibDeprecated2 = _interopRequireDefault(_reactPropTypesLibDeprecated);

	var Glyphicon = _react2['default'].createClass({
	  displayName: 'Glyphicon',

	  propTypes: {
	    /**
	     * bootstrap className
	     * @private
	     */
	    bsClass: _react2['default'].PropTypes.string,
	    /**
	     * An icon name. See e.g. http://getbootstrap.com/components/#glyphicons
	     */
	    glyph: _react2['default'].PropTypes.string.isRequired,
	    /**
	     * Adds 'form-control-feedback' class
	     * @private
	     */
	    formControlFeedback: _reactPropTypesLibDeprecated2['default'](_react2['default'].PropTypes.bool, 'Use `<FormControl.Feedback>`.')
	  },

	  getDefaultProps: function getDefaultProps() {
	    return {
	      bsClass: 'glyphicon'
	    };
	  },

	  render: function render() {
	    var _classNames;

	    var className = _classnames2['default'](this.props.className, (_classNames = {}, _classNames[this.props.bsClass] = true, _classNames['glyphicon-' + this.props.glyph] = true, _classNames['form-control-feedback'] = this.props.formControlFeedback, _classNames));

	    return _react2['default'].createElement(
	      'span',
	      _extends({}, this.props, { className: className }),
	      this.props.children
	    );
	  }
	});

	exports['default'] = Glyphicon;
	module.exports = exports['default'];

/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	exports.__esModule = true;
	exports['default'] = deprecated;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

	var _warning = __webpack_require__(56);

	var _warning2 = _interopRequireDefault(_warning);

	var warned = {};

	function deprecated(propType, explanation) {
	  return function validate(props, propName, componentName) {
	    if (props[propName] != null) {
	      var message = '"' + propName + '" property of "' + componentName + '" has been deprecated.\n' + explanation;
	      if (!warned[message]) {
	        _warning2['default'](false, message);
	        warned[message] = true;
	      }
	    }

	    return propType(props, propName, componentName);
	  };
	}

	function _resetWarned() {
	  warned = {};
	}

	deprecated._resetWarned = _resetWarned;
	module.exports = exports['default'];

/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * Copyright 2014-2015, Facebook, Inc.
	 * All rights reserved.
	 *
	 * This source code is licensed under the BSD-style license found in the
	 * LICENSE file in the root directory of this source tree. An additional grant
	 * of patent rights can be found in the PATENTS file in the same directory.
	 */

	'use strict';

	/**
	 * Similar to invariant but only logs a warning if the condition is not met.
	 * This can be used to log issues in development environments in critical
	 * paths. Removing the logging code for production environments will keep the
	 * same logic and follow the same code paths.
	 */

	var warning = function() {};

	if (true) {
	  warning = function(condition, format, args) {
	    var len = arguments.length;
	    args = new Array(len > 2 ? len - 2 : 0);
	    for (var key = 2; key < len; key++) {
	      args[key - 2] = arguments[key];
	    }
	    if (format === undefined) {
	      throw new Error(
	        '`warning(condition, format, ...args)` requires a warning ' +
	        'message argument'
	      );
	    }

	    if (format.length < 10 || (/^[s\W]*$/).test(format)) {
	      throw new Error(
	        'The warning format should be able to uniquely identify this ' +
	        'warning. Please, use a more descriptive format than: ' + format
	      );
	    }

	    if (!condition) {
	      var argIndex = 0;
	      var message = 'Warning: ' +
	        format.replace(/%s/g, function() {
	          return args[argIndex++];
	        });
	      if (typeof console !== 'undefined') {
	        console.error(message);
	      }
	      try {
	        // This error was thrown as a convenience so that you can use this stack
	        // to find the callsite that caused this warning to fire.
	        throw new Error(message);
	      } catch(x) {}
	    }
	  };
	}

	module.exports = warning;


/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _proptypes = __webpack_require__(25);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var BaseCellRenderer = function BaseCellRenderer(props) {
	    var ObjCellRenderer = props.config.cellRendererObject;
	    var ArrCellRenderer = props.config.cellRendererArray;
	    var valueType = _typeof(props.value);

	    var columns = props.columns;
	    var columnName = props.columnName;

	    switch (valueType) {
	        case 'object':
	            if (Array.isArray(props.value)) {
	                return _react2.default.createElement(ArrCellRenderer, { columns: columns, columnName: columnName, config: props.config, value: props.value, object: props.object });
	            } else {
	                return _react2.default.createElement(ObjCellRenderer, { columns: columns, columnName: columnName, config: props.config, value: props.value, object: props.object });
	            }
	        default:
	            return _react2.default.createElement(
	                'span',
	                null,
	                props.value
	            );
	    }
	};

	BaseCellRenderer.propTypes = {
	    config: _proptypes.globalConfig,
	    columns: _proptypes.columnsConfig,
	    value: _react.PropTypes.any.isRequired,
	    columnName: _react.PropTypes.string.isRequired,
	    object: _react.PropTypes.object.isRequired
	};

	exports.default = BaseCellRenderer;

/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _proptypes = __webpack_require__(25);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var ObjectCellRenderer = function ObjectCellRenderer(props) {
	    var Renderer = props.config.cellRendererBase;
	    var columns = props.columns;
	    var columnName = props.columnName;
	    var object = props.object;

	    var items = Object.keys(props.value).map(function (key) {
	        return [_react2.default.createElement(
	            'dt',
	            null,
	            key
	        ), _react2.default.createElement(
	            'dd',
	            null,
	            _react2.default.createElement(Renderer, { config: props.config, value: props.value[key], object: object, columns: columns, columnName: columnName })
	        )];
	    });
	    return _react2.default.createElement(
	        'dl',
	        null,
	        items
	    );
	};

	ObjectCellRenderer.propTypes = {
	    config: _proptypes.globalConfig,
	    columns: _proptypes.columnsConfig,
	    columnName: _react.PropTypes.string.isRequired,
	    object: _react.PropTypes.object.isRequired,
	    value: _react.PropTypes.object.isRequired

	};

	exports.default = ObjectCellRenderer;

/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _proptypes = __webpack_require__(25);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var ArrayCellRenderer = function (_Component) {
	    _inherits(ArrayCellRenderer, _Component);

	    function ArrayCellRenderer(p) {
	        _classCallCheck(this, ArrayCellRenderer);

	        return _possibleConstructorReturn(this, Object.getPrototypeOf(ArrayCellRenderer).call(this, p));
	    }

	    _createClass(ArrayCellRenderer, [{
	        key: 'render',
	        value: function render() {
	            var _this2 = this;

	            var Renderer = this.props.config.cellRendererBase;
	            var columns = this.props.columns;
	            var columnName = this.props.columnName;
	            var object = this.props.object;

	            var elements = this.props.value.map(function (value, i) {
	                return _react2.default.createElement(
	                    'li',
	                    { key: i },
	                    _react2.default.createElement(Renderer, { object: object, config: _this2.props.config, value: value, columns: columns, columnName: columnName })
	                );
	            });
	            return _react2.default.createElement(
	                'ul',
	                null,
	                elements
	            );
	        }
	    }]);

	    return ArrayCellRenderer;
	}(_react.Component);

	ArrayCellRenderer.propTypes = {
	    config: _proptypes.globalConfig,
	    columns: _proptypes.columnsConfig,
	    columnName: _react.PropTypes.string.isRequired,
	    object: _react.PropTypes.object.isRequired,
	    value: _react.PropTypes.array.isRequired
	};

	exports.default = ArrayCellRenderer;

/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _FormControl = __webpack_require__(61);

	var _FormControl2 = _interopRequireDefault(_FormControl);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var Filter = function (_Component) {
	    _inherits(Filter, _Component);

	    function Filter(props) {
	        _classCallCheck(this, Filter);

	        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Filter).call(this, props));

	        _this.state = { filterValue: _this.props.query };
	        _this.inputChanged = _this.inputChanged.bind(_this);
	        return _this;
	    }

	    _createClass(Filter, [{
	        key: 'componentWillUnmount',
	        value: function componentWillUnmount() {
	            if (this.timeout) {
	                window.clearTimeout(this.timeout);
	                this.timeout = null;
	            }
	        }
	    }, {
	        key: 'inputChanged',
	        value: function inputChanged(event) {
	            var _this2 = this;

	            this.setState({ filterValue: event.target.value });
	            if (this.timeout) {
	                window.clearTimeout(this.timeout);
	                this.timeout = null;
	            }
	            this.timeout = window.setTimeout(function () {
	                _this2.props.config.eventHandler({
	                    type: 'filter-change',
	                    id: _this2.props.config.id,
	                    column: _this2.props.column,
	                    query: _this2.state.filterValue
	                });
	            }, 300);
	        }
	    }, {
	        key: 'render',
	        value: function render() {
	            return _react2.default.createElement(_FormControl2.default, { id: 'filter_for_' + this.props.column, type: 'search', key: this.props.column, value: this.state.filterValue, onChange: this.inputChanged, placeholder: "Filter..." });
	        }
	    }]);

	    return Filter;
	}(_react.Component);

	Filter.propTypes = {
	    query: _react.PropTypes.string,
	    config: _react.PropTypes.object,
	    column: _react.PropTypes.string.isRequired
	};

	exports.default = Filter;

/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _inherits = __webpack_require__(35)['default'];

	var _classCallCheck = __webpack_require__(44)['default'];

	var _objectWithoutProperties = __webpack_require__(53)['default'];

	var _extends = __webpack_require__(6)['default'];

	var _interopRequireDefault = __webpack_require__(22)['default'];

	exports.__esModule = true;

	var _classnames = __webpack_require__(23);

	var _classnames2 = _interopRequireDefault(_classnames);

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _reactPropTypesLibElementType = __webpack_require__(27);

	var _reactPropTypesLibElementType2 = _interopRequireDefault(_reactPropTypesLibElementType);

	var _warning = __webpack_require__(56);

	var _warning2 = _interopRequireDefault(_warning);

	var _utilsBootstrapUtils = __webpack_require__(50);

	var _FormControlFeedback = __webpack_require__(62);

	var _FormControlFeedback2 = _interopRequireDefault(_FormControlFeedback);

	var _FormControlStatic = __webpack_require__(63);

	var _FormControlStatic2 = _interopRequireDefault(_FormControlStatic);

	var propTypes = {
	  componentClass: _reactPropTypesLibElementType2['default'],
	  /**
	   * Only relevant if `componentClass` is `'input'`.
	   */
	  type: _react2['default'].PropTypes.string,
	  /**
	   * Uses `controlId` from `<FormGroup>` if not explicitly specified.
	   */
	  id: _react2['default'].PropTypes.string
	};

	var defaultProps = {
	  componentClass: 'input'
	};

	var contextTypes = {
	  $bs_formGroup: _react2['default'].PropTypes.object
	};

	var FormControl = (function (_React$Component) {
	  _inherits(FormControl, _React$Component);

	  function FormControl() {
	    _classCallCheck(this, FormControl);

	    _React$Component.apply(this, arguments);
	  }

	  FormControl.prototype.render = function render() {
	    var formGroup = this.context.$bs_formGroup;
	    var controlId = formGroup && formGroup.controlId;

	    var _props = this.props;
	    var Component = _props.componentClass;
	    var type = _props.type;
	    var _props$id = _props.id;
	    var id = _props$id === undefined ? controlId : _props$id;
	    var className = _props.className;

	    var props = _objectWithoutProperties(_props, ['componentClass', 'type', 'id', 'className']);

	     true ? _warning2['default'](controlId == null || id === controlId, '`controlId` is ignored on `<FormControl>` when `id` is specified.') : undefined;

	    delete props.bsClass;

	    // input[type="file"] should not have .form-control.
	    var classes = undefined;
	    if (type !== 'file') {
	      classes = _utilsBootstrapUtils.getClassSet(this.props);
	    }

	    return _react2['default'].createElement(Component, _extends({}, props, {
	      type: type,
	      id: id,
	      className: _classnames2['default'](className, classes)
	    }));
	  };

	  return FormControl;
	})(_react2['default'].Component);

	FormControl.propTypes = propTypes;
	FormControl.defaultProps = defaultProps;
	FormControl.contextTypes = contextTypes;

	FormControl.Feedback = _FormControlFeedback2['default'];
	FormControl.Static = _FormControlStatic2['default'];

	exports['default'] = _utilsBootstrapUtils.bsClass('form-control', FormControl);
	module.exports = exports['default'];

/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _inherits = __webpack_require__(35)['default'];

	var _classCallCheck = __webpack_require__(44)['default'];

	var _extends = __webpack_require__(6)['default'];

	var _objectWithoutProperties = __webpack_require__(53)['default'];

	var _interopRequireDefault = __webpack_require__(22)['default'];

	exports.__esModule = true;

	var _classnames = __webpack_require__(23);

	var _classnames2 = _interopRequireDefault(_classnames);

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _utilsBootstrapUtils = __webpack_require__(50);

	var _Glyphicon = __webpack_require__(54);

	var _Glyphicon2 = _interopRequireDefault(_Glyphicon);

	var defaultProps = {
	  bsRole: 'feedback'
	};

	var contextTypes = {
	  $bs_formGroup: _react2['default'].PropTypes.object
	};

	var FormControlFeedback = (function (_React$Component) {
	  _inherits(FormControlFeedback, _React$Component);

	  function FormControlFeedback() {
	    _classCallCheck(this, FormControlFeedback);

	    _React$Component.apply(this, arguments);
	  }

	  FormControlFeedback.prototype.getGlyph = function getGlyph(validationState) {
	    switch (validationState) {
	      case 'success':
	        return 'ok';
	      case 'warning':
	        return 'warning-sign';
	      case 'error':
	        return 'remove';
	      default:
	        return null;
	    }
	  };

	  FormControlFeedback.prototype.renderDefaultFeedback = function renderDefaultFeedback(formGroup, className, classes, props) {
	    var glyph = this.getGlyph(formGroup && formGroup.validationState);
	    if (!glyph) {
	      return null;
	    }

	    return _react2['default'].createElement(_Glyphicon2['default'], _extends({}, props, {
	      glyph: glyph,
	      className: _classnames2['default'](className, classes)
	    }));
	  };

	  FormControlFeedback.prototype.render = function render() {
	    var _props = this.props;
	    var className = _props.className;
	    var children = _props.children;

	    var props = _objectWithoutProperties(_props, ['className', 'children']);

	    delete props.bsClass;

	    var classes = _utilsBootstrapUtils.getClassSet(this.props);

	    if (!children) {
	      return this.renderDefaultFeedback(this.context.$bs_formGroup, className, classes, props);
	    }

	    var child = _react2['default'].Children.only(children);
	    return _react2['default'].cloneElement(child, _extends({}, props, {
	      className: _classnames2['default'](child.props.className, className, classes)
	    }));
	  };

	  return FormControlFeedback;
	})(_react2['default'].Component);

	FormControlFeedback.defaultProps = defaultProps;
	FormControlFeedback.contextTypes = contextTypes;

	exports['default'] = _utilsBootstrapUtils.bsClass('form-control-feedback', FormControlFeedback);
	module.exports = exports['default'];

/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _inherits = __webpack_require__(35)['default'];

	var _classCallCheck = __webpack_require__(44)['default'];

	var _objectWithoutProperties = __webpack_require__(53)['default'];

	var _extends = __webpack_require__(6)['default'];

	var _interopRequireDefault = __webpack_require__(22)['default'];

	exports.__esModule = true;

	var _classnames = __webpack_require__(23);

	var _classnames2 = _interopRequireDefault(_classnames);

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _reactPropTypesLibElementType = __webpack_require__(27);

	var _reactPropTypesLibElementType2 = _interopRequireDefault(_reactPropTypesLibElementType);

	var _utilsBootstrapUtils = __webpack_require__(50);

	var propTypes = {
	  componentClass: _reactPropTypesLibElementType2['default']
	};

	var defaultProps = {
	  componentClass: 'p'
	};

	var FormControlStatic = (function (_React$Component) {
	  _inherits(FormControlStatic, _React$Component);

	  function FormControlStatic() {
	    _classCallCheck(this, FormControlStatic);

	    _React$Component.apply(this, arguments);
	  }

	  FormControlStatic.prototype.render = function render() {
	    var _props = this.props;
	    var Component = _props.componentClass;
	    var className = _props.className;

	    var props = _objectWithoutProperties(_props, ['componentClass', 'className']);

	    delete props.bsClass;

	    var classes = _utilsBootstrapUtils.getClassSet(this.props);

	    return _react2['default'].createElement(Component, _extends({}, props, { className: _classnames2['default'](className, classes) }));
	  };

	  return FormControlStatic;
	})(_react2['default'].Component);

	FormControlStatic.propTypes = propTypes;
	FormControlStatic.defaultProps = defaultProps;

	exports['default'] = _utilsBootstrapUtils.bsClass('form-control-static', FormControlStatic);
	module.exports = exports['default'];

/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _proptypes = __webpack_require__(25);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var ToolbarDefault = function (_Component) {
	    _inherits(ToolbarDefault, _Component);

	    function ToolbarDefault(props) {
	        _classCallCheck(this, ToolbarDefault);

	        return _possibleConstructorReturn(this, Object.getPrototypeOf(ToolbarDefault).call(this, props));
	    }

	    _createClass(ToolbarDefault, [{
	        key: 'render',
	        value: function render() {
	            var _props = this.props;
	            var columnKeys = _props.columnKeys;
	            var config = _props.config;
	            var columns = _props.columns;
	            var filter = _props.filter;

	            var Filter = config.filter;

	            var filters = columnKeys.map(function (currentColumnKey) {
	                var renderFilter = true;
	                if (columns && columns[currentColumnKey] && columns[currentColumnKey].hideTools) {
	                    renderFilter = false;
	                }
	                if (renderFilter) {
	                    var filterObject = filter.filter(function (obj) {
	                        return obj.columnName === currentColumnKey;
	                    })[0];
	                    var query = filterObject ? filterObject.expression : '';
	                    return _react2.default.createElement(
	                        'th',
	                        { key: currentColumnKey },
	                        _react2.default.createElement(Filter, { config: config, column: currentColumnKey, query: query })
	                    );
	                } else {
	                    return _react2.default.createElement('th', { key: currentColumnKey });
	                }
	            });

	            return _react2.default.createElement(
	                'tr',
	                null,
	                filters
	            );
	        }
	    }]);

	    return ToolbarDefault;
	}(_react.Component);

	ToolbarDefault.propTypes = {
	    config: _proptypes.globalConfig,
	    columnKeys: _react.PropTypes.arrayOf(_react.PropTypes.string).isRequired,
	    columns: _proptypes.columnsConfig,
	    filter: _react.PropTypes.arrayOf(_proptypes.filterConfigSingle).isRequired

	};

	exports.default = ToolbarDefault;

/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _Pagination = __webpack_require__(66);

	var _Pagination2 = _interopRequireDefault(_Pagination);

	var _Glyphicon = __webpack_require__(54);

	var _Glyphicon2 = _interopRequireDefault(_Glyphicon);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

	function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

	var Pager = function (_Component) {
	    _inherits(Pager, _Component);

	    function Pager(props) {
	        _classCallCheck(this, Pager);

	        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(Pager).call(this, props));

	        _this.updatePagination = _this.updatePagination.bind(_this);
	        return _this;
	    }

	    _createClass(Pager, [{
	        key: 'updatePagination',
	        value: function updatePagination(pageNumber) {
	            var skipNumber = (pageNumber - 1) * this.props.paging;
	            this.props.updatePagination({
	                type: 'change-page',
	                skip: skipNumber
	            });
	        }
	    }, {
	        key: 'render',
	        value: function render() {

	            var rest = this.props.length % this.props.paging;
	            var numberOfPages = this.props.length / this.props.paging;
	            if (rest !== 0) {
	                numberOfPages = Math.floor(numberOfPages + 1);
	            }
	            var skip = this.props.skip;
	            var activePageNumber = skip / this.props.paging + 1;

	            return _react2.default.createElement(_Pagination2.default, {
	                items: numberOfPages,
	                activePage: activePageNumber,
	                maxButtons: 7,
	                boundaryLinks: true,
	                onSelect: this.updatePagination,
	                prev: _react2.default.createElement(_Glyphicon2.default, { glyph: 'arrow-left' }),
	                next: _react2.default.createElement(_Glyphicon2.default, { glyph: 'arrow-right' }),
	                style: { marginTop: 0 } });
	        }
	    }]);

	    return Pager;
	}(_react.Component);

	Pager.propTypes = {
	    length: _react.PropTypes.number.isRequired,
	    paging: _react.PropTypes.number.isRequired,
	    skip: _react.PropTypes.number.isRequired,
	    updatePagination: _react.PropTypes.func.isRequired
	};

	exports.default = Pager;

/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends = __webpack_require__(6)['default'];

	var _interopRequireDefault = __webpack_require__(22)['default'];

	exports.__esModule = true;

	var _classnames = __webpack_require__(23);

	var _classnames2 = _interopRequireDefault(_classnames);

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _reactPropTypesLibElementType = __webpack_require__(27);

	var _reactPropTypesLibElementType2 = _interopRequireDefault(_reactPropTypesLibElementType);

	var _utilsBootstrapUtils = __webpack_require__(50);

	var _PaginationButton = __webpack_require__(67);

	var _PaginationButton2 = _interopRequireDefault(_PaginationButton);

	var _SafeAnchor = __webpack_require__(52);

	var _SafeAnchor2 = _interopRequireDefault(_SafeAnchor);

	var Pagination = _react2['default'].createClass({
	  displayName: 'Pagination',

	  propTypes: {
	    activePage: _react2['default'].PropTypes.number,
	    items: _react2['default'].PropTypes.number,
	    maxButtons: _react2['default'].PropTypes.number,
	    /**
	     * When `true`, will display the first and the last button page
	     */
	    boundaryLinks: _react2['default'].PropTypes.bool,
	    /**
	     * When `true`, will display the default node value ('&hellip;').
	     * Otherwise, will display provided node (when specified).
	     */
	    ellipsis: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.bool, _react2['default'].PropTypes.node]),
	    /**
	     * When `true`, will display the default node value ('&laquo;').
	     * Otherwise, will display provided node (when specified).
	     */
	    first: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.bool, _react2['default'].PropTypes.node]),
	    /**
	     * When `true`, will display the default node value ('&raquo;').
	     * Otherwise, will display provided node (when specified).
	     */
	    last: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.bool, _react2['default'].PropTypes.node]),
	    /**
	     * When `true`, will display the default node value ('&lsaquo;').
	     * Otherwise, will display provided node (when specified).
	     */
	    prev: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.bool, _react2['default'].PropTypes.node]),
	    /**
	     * When `true`, will display the default node value ('&rsaquo;').
	     * Otherwise, will display provided node (when specified).
	     */
	    next: _react2['default'].PropTypes.oneOfType([_react2['default'].PropTypes.bool, _react2['default'].PropTypes.node]),
	    onSelect: _react2['default'].PropTypes.func,
	    /**
	     * You can use a custom element for the buttons
	     */
	    buttonComponentClass: _reactPropTypesLibElementType2['default']
	  },

	  getDefaultProps: function getDefaultProps() {
	    return {
	      activePage: 1,
	      items: 1,
	      maxButtons: 0,
	      first: false,
	      last: false,
	      prev: false,
	      next: false,
	      ellipsis: true,
	      boundaryLinks: false,
	      buttonComponentClass: _SafeAnchor2['default'],
	      bsClass: 'pagination'
	    };
	  },

	  renderPageButtons: function renderPageButtons() {
	    var pageButtons = [];
	    var startPage = undefined,
	        endPage = undefined,
	        hasHiddenPagesAfter = undefined;
	    var _props = this.props;
	    var maxButtons = _props.maxButtons;
	    var activePage = _props.activePage;
	    var items = _props.items;
	    var onSelect = _props.onSelect;
	    var ellipsis = _props.ellipsis;
	    var buttonComponentClass = _props.buttonComponentClass;
	    var boundaryLinks = _props.boundaryLinks;

	    if (maxButtons) {
	      var hiddenPagesBefore = activePage - parseInt(maxButtons / 2, 10);
	      startPage = hiddenPagesBefore > 1 ? hiddenPagesBefore : 1;
	      hasHiddenPagesAfter = startPage + maxButtons <= items;

	      if (!hasHiddenPagesAfter) {
	        endPage = items;
	        startPage = items - maxButtons + 1;
	        if (startPage < 1) {
	          startPage = 1;
	        }
	      } else {
	        endPage = startPage + maxButtons - 1;
	      }
	    } else {
	      startPage = 1;
	      endPage = items;
	    }

	    for (var pagenumber = startPage; pagenumber <= endPage; pagenumber++) {
	      pageButtons.push(_react2['default'].createElement(
	        _PaginationButton2['default'],
	        {
	          key: pagenumber,
	          eventKey: pagenumber,
	          active: pagenumber === activePage,
	          onSelect: onSelect,
	          buttonComponentClass: buttonComponentClass
	        },
	        pagenumber
	      ));
	    }

	    if (boundaryLinks && ellipsis && startPage !== 1) {
	      pageButtons.unshift(_react2['default'].createElement(
	        _PaginationButton2['default'],
	        {
	          key: 'ellipsisFirst',
	          disabled: true,
	          buttonComponentClass: buttonComponentClass
	        },
	        _react2['default'].createElement(
	          'span',
	          { 'aria-label': 'More' },
	          this.props.ellipsis === true ? '…' : this.props.ellipsis
	        )
	      ));

	      pageButtons.unshift(_react2['default'].createElement(
	        _PaginationButton2['default'],
	        {
	          key: 1,
	          eventKey: 1,
	          active: false,
	          onSelect: onSelect,
	          buttonComponentClass: buttonComponentClass
	        },
	        '1'
	      ));
	    }

	    if (maxButtons && hasHiddenPagesAfter && ellipsis) {
	      pageButtons.push(_react2['default'].createElement(
	        _PaginationButton2['default'],
	        {
	          key: 'ellipsis',
	          disabled: true,
	          buttonComponentClass: buttonComponentClass
	        },
	        _react2['default'].createElement(
	          'span',
	          { 'aria-label': 'More' },
	          this.props.ellipsis === true ? '…' : this.props.ellipsis
	        )
	      ));

	      if (boundaryLinks && endPage !== items) {
	        pageButtons.push(_react2['default'].createElement(
	          _PaginationButton2['default'],
	          {
	            key: items,
	            eventKey: items,
	            active: false,
	            onSelect: onSelect,
	            buttonComponentClass: buttonComponentClass
	          },
	          items
	        ));
	      }
	    }

	    return pageButtons;
	  },

	  renderPrev: function renderPrev() {
	    if (!this.props.prev) {
	      return null;
	    }

	    return _react2['default'].createElement(
	      _PaginationButton2['default'],
	      {
	        key: 'prev',
	        eventKey: this.props.activePage - 1,
	        disabled: this.props.activePage === 1,
	        onSelect: this.props.onSelect,
	        buttonComponentClass: this.props.buttonComponentClass
	      },
	      _react2['default'].createElement(
	        'span',
	        { 'aria-label': 'Previous' },
	        this.props.prev === true ? '‹' : this.props.prev
	      )
	    );
	  },

	  renderNext: function renderNext() {
	    if (!this.props.next) {
	      return null;
	    }

	    return _react2['default'].createElement(
	      _PaginationButton2['default'],
	      {
	        key: 'next',
	        eventKey: this.props.activePage + 1,
	        disabled: this.props.activePage >= this.props.items,
	        onSelect: this.props.onSelect,
	        buttonComponentClass: this.props.buttonComponentClass
	      },
	      _react2['default'].createElement(
	        'span',
	        { 'aria-label': 'Next' },
	        this.props.next === true ? '›' : this.props.next
	      )
	    );
	  },

	  renderFirst: function renderFirst() {
	    if (!this.props.first) {
	      return null;
	    }

	    return _react2['default'].createElement(
	      _PaginationButton2['default'],
	      {
	        key: 'first',
	        eventKey: 1,
	        disabled: this.props.activePage === 1,
	        onSelect: this.props.onSelect,
	        buttonComponentClass: this.props.buttonComponentClass
	      },
	      _react2['default'].createElement(
	        'span',
	        { 'aria-label': 'First' },
	        this.props.first === true ? '«' : this.props.first
	      )
	    );
	  },

	  renderLast: function renderLast() {
	    if (!this.props.last) {
	      return null;
	    }

	    return _react2['default'].createElement(
	      _PaginationButton2['default'],
	      {
	        key: 'last',
	        eventKey: this.props.items,
	        disabled: this.props.activePage >= this.props.items,
	        onSelect: this.props.onSelect,
	        buttonComponentClass: this.props.buttonComponentClass
	      },
	      _react2['default'].createElement(
	        'span',
	        { 'aria-label': 'Last' },
	        this.props.last === true ? '»' : this.props.last
	      )
	    );
	  },

	  render: function render() {
	    return _react2['default'].createElement(
	      'ul',
	      _extends({}, this.props, {
	        className: _classnames2['default'](this.props.className, _utilsBootstrapUtils.getClassSet(this.props))
	      }),
	      this.renderFirst(),
	      this.renderPrev(),
	      this.renderPageButtons(),
	      this.renderNext(),
	      this.renderLast()
	    );
	  }
	});

	exports['default'] = _utilsBootstrapUtils.bsClass('pagination', Pagination);
	module.exports = exports['default'];

/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _objectWithoutProperties = __webpack_require__(53)['default'];

	var _extends = __webpack_require__(6)['default'];

	var _interopRequireDefault = __webpack_require__(22)['default'];

	exports.__esModule = true;

	var _classnames = __webpack_require__(23);

	var _classnames2 = _interopRequireDefault(_classnames);

	var _react = __webpack_require__(2);

	var _react2 = _interopRequireDefault(_react);

	var _reactPropTypesLibElementType = __webpack_require__(27);

	var _reactPropTypesLibElementType2 = _interopRequireDefault(_reactPropTypesLibElementType);

	var _utilsCreateChainedFunction = __webpack_require__(68);

	var _utilsCreateChainedFunction2 = _interopRequireDefault(_utilsCreateChainedFunction);

	var PaginationButton = _react2['default'].createClass({
	  displayName: 'PaginationButton',

	  propTypes: {
	    className: _react2['default'].PropTypes.string,
	    eventKey: _react2['default'].PropTypes.any,
	    onSelect: _react2['default'].PropTypes.func,
	    disabled: _react2['default'].PropTypes.bool,
	    active: _react2['default'].PropTypes.bool,
	    onClick: _react2['default'].PropTypes.func,
	    /**
	     * You can use a custom element for this component
	     */
	    buttonComponentClass: _reactPropTypesLibElementType2['default']
	  },

	  getDefaultProps: function getDefaultProps() {
	    return {
	      active: false,
	      disabled: false
	    };
	  },

	  handleClick: function handleClick(event) {
	    if (this.props.disabled) {
	      return;
	    }

	    if (this.props.onSelect) {
	      this.props.onSelect(this.props.eventKey, event);
	    }
	  },

	  render: function render() {
	    var _props = this.props;
	    var active = _props.active;
	    var disabled = _props.disabled;
	    var onClick = _props.onClick;
	    var ButtonComponentClass = _props.buttonComponentClass;
	    var className = _props.className;
	    var style = _props.style;

	    var props = _objectWithoutProperties(_props, ['active', 'disabled', 'onClick', 'buttonComponentClass', 'className', 'style']);

	    delete props.onSelect;

	    return _react2['default'].createElement(
	      'li',
	      {
	        className: _classnames2['default'](className, { active: active, disabled: disabled }),
	        style: style
	      },
	      _react2['default'].createElement(ButtonComponentClass, _extends({}, props, {
	        disabled: disabled,
	        onClick: _utilsCreateChainedFunction2['default'](onClick, this.handleClick)
	      }))
	    );
	  }
	});

	exports['default'] = PaginationButton;
	module.exports = exports['default'];

/***/ },
/* 68 */
/***/ function(module, exports) {

	/**
	 * Safe chained function
	 *
	 * Will only create a new function if needed,
	 * otherwise will pass back existing functions or null.
	 *
	 * @param {function} functions to chain
	 * @returns {function|null}
	 */
	'use strict';

	exports.__esModule = true;
	function createChainedFunction() {
	  for (var _len = arguments.length, funcs = Array(_len), _key = 0; _key < _len; _key++) {
	    funcs[_key] = arguments[_key];
	  }

	  return funcs.filter(function (f) {
	    return f != null;
	  }).reduce(function (acc, f) {
	    if (typeof f !== 'function') {
	      throw new Error('Invalid Argument Type, must only provide functions, undefined, or null.');
	    }

	    if (acc === null) {
	      return f;
	    }

	    return function chainedFunction() {
	      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
	        args[_key2] = arguments[_key2];
	      }

	      acc.apply(this, args);
	      f.apply(this, args);
	    };
	  }, null);
	}

	exports['default'] = createChainedFunction;
	module.exports = exports['default'];

/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});
	exports.sortConfigFromProp = exports.filterConfigFromProp = undefined;

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

	var _constants = __webpack_require__(26);

	var filterConfigFromProp = function filterConfigFromProp(filterProp) {

	    var filter = [];
	    if (filterProp && !Array.isArray(filterProp)) {
	        filter.push(filterProp);
	    } else if (Array.isArray(filterProp)) {
	        return filterProp;
	    }
	    return filter;
	};

	var sortConfigFromProp = function sortConfigFromProp(sortProp) {
	    var sortColumn = void 0;
	    var order = _constants.ASCENDING;
	    if (sortProp === undefined) {
	        return undefined;
	    }

	    switch (typeof sortProp === 'undefined' ? 'undefined' : _typeof(sortProp)) {
	        case 'string':
	            sortColumn = sortProp;
	            break;
	        case 'object':
	            {
	                var sortConfigObject = void 0;
	                if (Array.isArray(sortProp) && sortProp.length > 0) {
	                    sortConfigObject = sortProp[0];
	                } else {
	                    sortConfigObject = sortProp;
	                }
	                sortColumn = sortConfigObject.columnName;
	                if (sortConfigObject.order && (sortConfigObject.order === _constants.ASCENDING || sortConfigObject.order === _constants.DESCENDING)) {
	                    order = sortConfigObject.order;
	                }
	                break;
	            }
	        default:
	    }
	    return {
	        columnName: sortColumn,
	        order: order
	    };
	};

	exports.filterConfigFromProp = filterConfigFromProp;
	exports.sortConfigFromProp = sortConfigFromProp;

/***/ }
/******/ ])
});
;