(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react'), require('prop-types')) :
	typeof define === 'function' && define.amd ? define(['exports', 'react', 'prop-types'], factory) :
	(factory((global.Ardagryd = global.Ardagryd || {}),global.React,global.PropTypes));
}(this, (function (exports,React,PropTypes) { 'use strict';

var React__default = 'default' in React ? React['default'] : React;
PropTypes = 'default' in PropTypes ? PropTypes['default'] : PropTypes;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};











var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

var createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  };
}();







var _extends = Object.assign || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};



var inherits = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
};









var objectWithoutProperties = function (obj, keys) {
  var target = {};

  for (var i in obj) {
    if (keys.indexOf(i) >= 0) continue;
    if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
    target[i] = obj[i];
  }

  return target;
};

var possibleConstructorReturn = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && (typeof call === "object" || typeof call === "function") ? call : self;
};



















var toConsumableArray = function (arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  } else {
    return Array.from(arr);
  }
};

var DefaultCell = function DefaultCell(props) {
    var tdProps = Object.assign({}, props);
    delete tdProps.columnName;
    delete tdProps.object;
    delete tdProps.content;
    delete tdProps.value;
    return React__default.createElement('td', tdProps);
};

var ConfigCollector = function ConfigCollector(ComponentToWrap) {
    var wrapper = function (_React$Component) {
        inherits(wrapper, _React$Component);

        function wrapper(props) {
            classCallCheck(this, wrapper);

            var _this = possibleConstructorReturn(this, (wrapper.__proto__ || Object.getPrototypeOf(wrapper)).call(this, props));

            _this.state = {
                config: [],
                defaultCellContent: function defaultCellContent(_ref) {
                    var value = _ref.value;
                    return value;
                },
                cell: DefaultCell,
                row: function row(_ref2) {
                    var children = _ref2.children;
                    return React__default.createElement(
                        'tr',
                        null,
                        children
                    );
                },
                main: function main(_ref3) {
                    var children = _ref3.children;
                    return React__default.createElement(
                        'table',
                        null,
                        children
                    );
                },
                header: function header(_ref4) {
                    var children = _ref4.children;
                    return React__default.createElement(
                        'thead',
                        null,
                        children
                    );
                },
                noDataMessage: 'There is no data to display'
            };
            _this.updateColumnConfig = _this.updateColumnConfig.bind(_this);
            _this.registerRow = _this.registerRow.bind(_this);
            _this.registerMain = _this.registerMain.bind(_this);
            _this.registerHeader = _this.registerHeader.bind(_this);
            _this.updateCell = _this.updateCell.bind(_this);
            return _this;
        }

        createClass(wrapper, [{
            key: 'registerMain',
            value: function registerMain(main) {
                this.setState({ main: main });
            }
        }, {
            key: 'registerHeader',
            value: function registerHeader(header) {
                this.setState({ header: header });
            }
        }, {
            key: 'updateCell',
            value: function updateCell(_ref5) {
                var component = _ref5.component,
                    content = _ref5.content;

                var newState = {};
                if (component !== undefined) {
                    newState.cell = component;
                }
                if (content !== undefined) {
                    newState.defaultCellContent = content;
                }
                this.setState(newState);
            }
        }, {
            key: 'getChildContext',
            value: function getChildContext() {
                return {
                    updateColumnConfig: this.updateColumnConfig,
                    registerRow: this.registerRow,
                    row: this.state.row,
                    registerMain: this.registerMain,
                    registerHeader: this.registerHeader,
                    updateCell: this.updateCell,
                    cell: this.state.cell,
                    defaultCellContent: this.state.defaultCellContent,
                    noDataMessage: this.state.noDataMessage
                };
            }
        }, {
            key: 'updateColumnConfig',
            value: function updateColumnConfig(columnName, newConfig) {

                this.setState(function (prevState) {
                    var prevConfig = prevState.config;
                    var remove = newConfig === undefined;

                    if (remove) {
                        return { config: prevConfig.filter(function (item) {
                                return item.name !== columnName;
                            }) };
                    }

                    var name = newConfig.name;

                    var oldConfigForColumn = void 0;
                    var newColumnConfig = prevConfig.filter(function (item) {
                        if (item.name == name) {
                            oldConfigForColumn = item;
                            return false;
                        }
                        return true;
                    });
                    newColumnConfig.push(Object.assign({}, oldConfigForColumn, newConfig));
                    return { config: newColumnConfig };
                });
            }
        }, {
            key: 'registerRow',
            value: function registerRow(newRow) {
                this.setState({ row: newRow });
            }
        }, {
            key: 'render',
            value: function render() {
                var props = this.props;
                return React__default.createElement(ComponentToWrap, _extends({}, props, {
                    main: this.state.main,
                    header: this.state.header,
                    columnConfigs: this.state.config }));
            }
        }]);
        return wrapper;
    }(React__default.Component);

    wrapper.childContextTypes = {
        updateColumnConfig: PropTypes.func,
        registerRow: PropTypes.func,
        row: PropTypes.oneOfType([PropTypes.func, PropTypes.node]),
        registerMain: PropTypes.func,
        registerHeader: PropTypes.func,
        updateCell: PropTypes.func,
        cell: PropTypes.oneOfType([PropTypes.func, PropTypes.node]),
        defaultCellContent: PropTypes.oneOfType([PropTypes.func, PropTypes.node]),
        noDataMessage: PropTypes.node
    };

    wrapper.displayName = 'ConfigCollector(' + (ComponentToWrap.displayName || ComponentToWrap.name || 'Component') + ')';

    {
        wrapper.propTypes = {
            children: PropTypes.node
        };
    }

    return wrapper;
};

var DefaultPager = function (_Component) {
    inherits(DefaultPager, _Component);

    function DefaultPager(props) {
        classCallCheck(this, DefaultPager);

        var _this = possibleConstructorReturn(this, (DefaultPager.__proto__ || Object.getPrototypeOf(DefaultPager)).call(this, props));

        _this.changePage = _this.changePage.bind(_this);
        _this.changePageSize = _this.changePageSize.bind(_this);
        return _this;
    }

    createClass(DefaultPager, [{
        key: 'changePage',
        value: function changePage(e) {
            this.props.onChangePage(parseInt(e.target.value, 10));
        }
    }, {
        key: 'changePageSize',
        value: function changePageSize(e) {
            this.props.onChangePageSize(parseInt(e.target.value, 10));
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                page = _props.page,
                pageSize = _props.pageSize,
                numberOfPages = _props.numberOfPages;

            return React__default.createElement(
                'div',
                null,
                'Page: ',
                React__default.createElement('input', { type: 'number', value: page, min: '1', max: numberOfPages, onChange: this.changePage }),
                'Page size: ',
                React__default.createElement('input', { type: 'number', value: pageSize, min: '5', onChange: this.changePageSize })
            );
        }
    }]);
    return DefaultPager;
}(React.Component);

{
    DefaultPager.propTypes = {
        onChangePage: PropTypes.func.isRequired,
        onChangePageSize: PropTypes.func.isRequired,
        page: PropTypes.number.isRequired,
        pageSize: PropTypes.number.isRequired,
        numberOfPages: PropTypes.number.isRequired
    };
}

var Pager = function (_React$Component) {
    inherits(Pager, _React$Component);

    function Pager(props) {
        classCallCheck(this, Pager);
        return possibleConstructorReturn(this, (Pager.__proto__ || Object.getPrototypeOf(Pager)).call(this, props));
    }

    createClass(Pager, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this.context.registerPager();
        }
    }, {
        key: 'render',
        value: function render() {
            var PagerComponent = this.props.component;
            var _context = this.context,
                onChangePage = _context.onChangePage,
                page = _context.page,
                onChangePageSize = _context.onChangePageSize,
                pageSize = _context.pageSize,
                numberOfPages = _context.numberOfPages;

            return React__default.createElement(PagerComponent, { page: page,
                pageSize: pageSize,
                numberOfPages: numberOfPages,
                onChangePage: onChangePage,
                onChangePageSize: onChangePageSize });
        }
    }]);
    return Pager;
}(React__default.Component);

Pager.contextTypes = {
    onChangePage: PropTypes.func.isRequired,
    onChangePageSize: PropTypes.func.isRequired,
    page: PropTypes.number.isRequired,
    pageSize: PropTypes.number.isRequired,
    numberOfPages: PropTypes.number.isRequired,
    registerPager: PropTypes.func.isRequired
};

Pager.defaultProps = {
    component: DefaultPager
};

{
    Pager.propTypes = {
        component: PropTypes.func.isRequired
    };
}

var ASCENDING = 'asc';
var DESCENDING = 'desc';

var sortConfigFromProp = function sortConfigFromProp(sortProp) {
    var sortColumn = void 0;
    var order = ASCENDING;
    if (sortProp === undefined) {
        return undefined;
    }

    switch (typeof sortProp === 'undefined' ? 'undefined' : _typeof(sortProp)) {
        case 'string':
            sortColumn = sortProp;
            break;
        case 'object':
            {
                var sortConfigObject = void 0;
                if (Array.isArray(sortProp) && sortProp.length > 0) {
                    sortConfigObject = sortProp[0];
                } else {
                    sortConfigObject = sortProp;
                }
                sortColumn = sortConfigObject.columnName;
                if (sortConfigObject.order && (sortConfigObject.order === ASCENDING || sortConfigObject.order === DESCENDING)) {
                    order = sortConfigObject.order;
                }
                break;
            }
        default:
    }
    return {
        columnName: sortColumn,
        order: order
    };
};

var activeColumnKeys = function activeColumnKeys(columnConfigs) {
    return columnConfigs.filter(function (config) {
        return !config.hide === true;
    }).map(function (config) {
        return config.name;
    });
};

var SortButton = function SortButton(props) {
    var onClick = props.onClick,
        sort = props.sort;

    var content = sort === ASCENDING ? '↓' : sort === DESCENDING ? '↑' : '⇅';
    return React__default.createElement(
        'button',
        { onClick: onClick },
        content
    );
};

{
    SortButton.propTypes = {
        onClick: PropTypes.func.isRequired,
        sort: PropTypes.oneOf([ASCENDING, DESCENDING])
    };
}

var DefaultHeaderCell = function (_Component) {
    inherits(DefaultHeaderCell, _Component);

    function DefaultHeaderCell(props) {
        classCallCheck(this, DefaultHeaderCell);

        var _this = possibleConstructorReturn(this, (DefaultHeaderCell.__proto__ || Object.getPrototypeOf(DefaultHeaderCell)).call(this, props));

        _this.buttonClicked = _this.buttonClicked.bind(_this);
        return _this;
    }

    createClass(DefaultHeaderCell, [{
        key: 'buttonClicked',
        value: function buttonClicked() {
            var _props = this.props,
                columnName = _props.columnName,
                updateSort = _props.updateSort,
                sort = _props.sort;

            var newSort = sort === ASCENDING ? DESCENDING : ASCENDING;
            updateSort(columnName, newSort);
        }
    }, {
        key: 'render',
        value: function render() {
            var _props2 = this.props,
                label = _props2.label,
                sortable = _props2.sortable,
                sort = _props2.sort;

            return React__default.createElement(
                'th',
                null,
                label,
                sortable && React__default.createElement(SortButton, { onClick: this.buttonClicked, sort: sort })
            );
        }
    }]);
    return DefaultHeaderCell;
}(React.Component);

{
    DefaultHeaderCell.propTypes = {
        columnName: PropTypes.string.isRequired,
        columnIndex: PropTypes.number.isRequired,
        sort: PropTypes.oneOf([ASCENDING, DESCENDING]),
        updateSort: PropTypes.func.isRequired,
        sortable: PropTypes.bool,
        label: PropTypes.string
    };
}

var DefaultHeaderRowComponent = function DefaultHeaderRowComponent(_ref) {
    var children = _ref.children,
        restProps = objectWithoutProperties(_ref, ['children']);
    return React__default.createElement(
        'tr',
        restProps,
        children
    );
};

{
    DefaultHeaderRowComponent.propTypes = {
        children: PropTypes.node
    };
}

var HeaderRow = function (_React$Component) {
    inherits(HeaderRow, _React$Component);

    function HeaderRow(props) {
        classCallCheck(this, HeaderRow);

        var _this = possibleConstructorReturn(this, (HeaderRow.__proto__ || Object.getPrototypeOf(HeaderRow)).call(this, props));

        _this.state = { HeaderCell: DefaultHeaderCell };
        _this.updateGlobalHeaderCell = _this.updateGlobalHeaderCell.bind(_this);
        return _this;
    }

    createClass(HeaderRow, [{
        key: 'updateGlobalHeaderCell',
        value: function updateGlobalHeaderCell(_ref2) {
            var NewHeaderComponent = _ref2.component;

            this.setState({ HeaderCell: NewHeaderComponent });
        }
    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextContext) {
            return this.context !== nextContext;
        }
    }, {
        key: 'getChildContext',
        value: function getChildContext() {
            return { updateCell: this.updateGlobalHeaderCell };
        }
    }, {
        key: 'render',
        value: function render() {
            var _this2 = this;

            var _props = this.props,
                component = _props.component,
                children = _props.children,
                rest = objectWithoutProperties(_props, ['component', 'children']);
            var _context = this.context,
                columnConfigs = _context.columnConfigs,
                updateSort = _context.updateSort,
                sort = _context.sort;

            var childrenAsArray = React__default.Children.toArray(children);
            var activeColumnKeys$$1 = activeColumnKeys(columnConfigs);
            var HeaderRowComponent = component ? component : DefaultHeaderRowComponent;
            var headerCells = activeColumnKeys$$1.map(function (columnKey, columnIndex) {
                var currentConfig = columnConfigs.find(function (c) {
                    return c.name === columnKey;
                });
                var HeaderComponent = currentConfig && currentConfig.headerComponent ? currentConfig.headerComponent : _this2.state.HeaderCell;
                var sortForColumn = sort && sort.columnName === columnKey ? sort.order : undefined;
                var labelForColumn = currentConfig && currentConfig.label !== undefined ? currentConfig.label : columnKey.charAt(0).toUpperCase() + columnKey.slice(1);
                return React__default.createElement(HeaderComponent, { key: columnKey,
                    columnName: columnKey,
                    columnIndex: columnIndex,
                    columnConfig: currentConfig,
                    sortable: currentConfig.sortable,
                    sort: sortForColumn,
                    updateSort: updateSort,
                    label: labelForColumn });
            });
            return React__default.createElement(
                HeaderRowComponent,
                rest,
                [].concat(toConsumableArray(childrenAsArray), [headerCells])
            );
        }
    }]);
    return HeaderRow;
}(React__default.Component);

HeaderRow.contextTypes = {
    columnConfigs: PropTypes.array.isRequired,
    updateSort: PropTypes.func.isRequired,
    sort: PropTypes.shape({
        columnName: PropTypes.string.isRequired,
        order: PropTypes.oneOf([ASCENDING, DESCENDING]).isRequired
    })
};

{
    HeaderRow.propTypes = {
        component: PropTypes.func,
        children: PropTypes.node
    };
}

HeaderRow.childContextTypes = {
    updateCell: PropTypes.func
};

var DefaultFilterRowComponent = function DefaultFilterRowComponent(_ref) {
    var children = _ref.children;
    return React__default.createElement(
        'tr',
        null,
        children
    );
};
var DefaultFilterCellComponent = function DefaultFilterCellComponent(_ref2) {
    var children = _ref2.children;
    return React__default.createElement(
        'th',
        null,
        children
    );
};

{
    DefaultFilterRowComponent.propTypes = {
        children: PropTypes.node
    };
}

{
    DefaultFilterCellComponent.propTypes = {
        children: PropTypes.node
    };
}

var FilterRow = function (_React$Component) {
    inherits(FilterRow, _React$Component);

    function FilterRow(props) {
        classCallCheck(this, FilterRow);

        var _this = possibleConstructorReturn(this, (FilterRow.__proto__ || Object.getPrototypeOf(FilterRow)).call(this, props));

        _this.state = { FilterCell: DefaultFilterCellComponent };
        _this.updateGlobalFilterCell = _this.updateGlobalFilterCell.bind(_this);
        return _this;
    }

    createClass(FilterRow, [{
        key: 'updateGlobalFilterCell',
        value: function updateGlobalFilterCell(_ref3) {
            var NewFilterCell = _ref3.component;

            this.setState({ FilterCell: NewFilterCell });
        }
    }, {
        key: 'getChildContext',
        value: function getChildContext() {
            return { updateCell: this.updateGlobalFilterCell };
        }
    }, {
        key: 'render',
        value: function render() {
            var _props = this.props,
                component = _props.component,
                children = _props.children;
            var _context = this.context,
                columnConfigs = _context.columnConfigs,
                filter = _context.filter,
                _updateFilter = _context.updateFilter,
                filterComponents = _context.filterComponents,
                defaultFilterComponent = _context.defaultFilterComponent;
            var FilterCell = this.state.FilterCell;

            var childrenAsArray = React__default.Children.toArray(children);
            var activeColumnKeys$$1 = activeColumnKeys(columnConfigs);
            var FilterRowComponent = component ? component : DefaultFilterRowComponent;
            var activeFilters = activeColumnKeys$$1.filter(function (columnKey) {
                return !columnConfigs.find(function (c) {
                    return c.name === columnKey;
                }).hideTools;
            });
            var filterCells = activeColumnKeys$$1.map(function (columnKey) {
                if (activeFilters.indexOf(columnKey) !== -1) {
                    var FilterComponent = filterComponents[columnKey] || defaultFilterComponent;
                    var currentFilter = filter.find(function (currentFilter) {
                        return currentFilter.columnName === columnKey;
                    });
                    var query = currentFilter && currentFilter.expression ? currentFilter.expression : '';

                    return React__default.createElement(
                        FilterCell,
                        { key: columnKey },
                        React__default.createElement(FilterComponent, { updateFilter: function updateFilter(newExpression) {
                                _updateFilter({ columnName: columnKey, expression: newExpression });
                            }, column: columnKey, query: query })
                    );
                } else {
                    return React__default.createElement('th', { key: columnKey });
                }
            });
            return React__default.createElement(
                FilterRowComponent,
                null,
                [].concat(toConsumableArray(childrenAsArray), toConsumableArray(filterCells))
            );
        }
    }]);
    return FilterRow;
}(React__default.Component);

FilterRow.contextTypes = {
    columnConfigs: PropTypes.array,
    filter: PropTypes.array,
    updateFilter: PropTypes.func.isRequired,
    filterComponents: PropTypes.objectOf(PropTypes.func).isRequired,
    defaultFilterComponent: PropTypes.func.isRequired
};

FilterRow.childContextTypes = {
    updateCell: PropTypes.func
};

{
    FilterRow.propTypes = {
        component: PropTypes.func,
        children: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.node), PropTypes.node])
    };
}

var filterConfigSingle = PropTypes.shape({
    columnName: PropTypes.string.isRequired,
    expression: PropTypes.string.isRequired
});

var sortConfigSingle = PropTypes.shape({
    columnName: PropTypes.string.isRequired,
    order: PropTypes.oneOf([ASCENDING, DESCENDING])
});

var sortConfig = PropTypes.oneOfType([PropTypes.string, sortConfigSingle, PropTypes.arrayOf(sortConfigSingle)]);

var filterConfig = PropTypes.oneOfType([filterConfigSingle, PropTypes.arrayOf(filterConfigSingle)]);

var columnsConfig = PropTypes.objectOf(PropTypes.shape({
    id: PropTypes.bool,
    label: PropTypes.string,
    order: PropTypes.number,
    hideTools: PropTypes.bool,
    sortable: PropTypes.bool,
    sortValueGetter: PropTypes.func,
    filterFunction: PropTypes.func,
    filter: function filter(props, propName, componentName, location, propFullName) {
        if (props[propName]) {
            return new Error('Invalid prop `' + propFullName + '` supplied to' + ' `' + componentName + '`. Please use the `filter` prop on the root component.');
        }
    },
    sort: function sort(props, propName, componentName, location, propFullName) {
        if (props[propName]) {
            return new Error('Invalid prop `' + propFullName + '` supplied to' + ' `' + componentName + '`. Please use the `sort` prop on the root component.');
        }
    }
}));

var ObjectCellRenderer = function ObjectCellRenderer(props) {

    var columnName = props.columnName;
    var object = props.object;

    var items = Object.keys(props.value).map(function (key) {
        return [React__default.createElement(
            'dt',
            { key: 'dt' },
            key
        ), React__default.createElement(
            'dd',
            { key: 'dd' },
            React__default.createElement(BaseCellRenderer, { value: props.value[key], object: object, columnName: columnName })
        )];
    });
    return React__default.createElement(
        'dl',
        null,
        items
    );
};

{
    ObjectCellRenderer.propTypes = {
        columns: columnsConfig,
        columnName: PropTypes.string.isRequired,
        object: PropTypes.object.isRequired,
        value: PropTypes.object.isRequired
    };
}

var ArrayCellRenderer = function (_Component) {
    inherits(ArrayCellRenderer, _Component);

    function ArrayCellRenderer(p) {
        classCallCheck(this, ArrayCellRenderer);
        return possibleConstructorReturn(this, (ArrayCellRenderer.__proto__ || Object.getPrototypeOf(ArrayCellRenderer)).call(this, p));
    }

    createClass(ArrayCellRenderer, [{
        key: 'render',
        value: function render() {
            var columns = this.props.columns;
            var columnName = this.props.columnName;
            var object = this.props.object;

            var elements = this.props.value.map(function (value, i) {
                return React__default.createElement(
                    'li',
                    { key: i },
                    React__default.createElement(BaseCellRenderer, { object: object, value: value, columns: columns, columnName: columnName })
                );
            });
            return React__default.createElement(
                'ul',
                null,
                elements
            );
        }
    }]);
    return ArrayCellRenderer;
}(React.Component);

{
    ArrayCellRenderer.propTypes = {
        columns: columnsConfig,
        columnName: PropTypes.string.isRequired,
        object: PropTypes.object.isRequired,
        value: PropTypes.array.isRequired
    };
}

var BaseCellRenderer = function BaseCellRenderer(props) {
    var value = props.value;

    if (value === null) {
        return value;
    }

    var valueType = typeof value === 'undefined' ? 'undefined' : _typeof(value);

    var columnName = props.columnName;

    switch (valueType) {
        case 'object':
            if (Array.isArray(value)) {
                return React__default.createElement(ArrayCellRenderer, { columnName: columnName, value: value, object: props.object });
            } else {
                return React__default.createElement(ObjectCellRenderer, { columnName: columnName, value: value, object: props.object });
            }
        default:
            return React__default.createElement(
                'span',
                null,
                value != null ? value.toString() : value
            );
    }
};

{
    BaseCellRenderer.propTypes = {
        columns: columnsConfig,
        value: PropTypes.any,
        columnName: PropTypes.string.isRequired,
        object: PropTypes.object.isRequired
    };
}

var CellView = function CellView(props) {
    var Component$$1 = props.component,
        rest = objectWithoutProperties(props, ['component']);
    var content = rest.content;


    var contentToRender = void 0;

    var type = typeof content === 'undefined' ? 'undefined' : _typeof(content);
    if (type === 'function') {
        if (content.prototype instanceof React__default.Component) {
            contentToRender = React__default.createElement(content, props);
        } else {
            contentToRender = content(props);
        }
    } else {
        contentToRender = content;
    }

    if (contentToRender !== undefined && !React__default.isValidElement(contentToRender)) {
        switch (typeof contentToRender === 'undefined' ? 'undefined' : _typeof(contentToRender)) {
            case 'string':
                break;
            case 'number':
            case 'boolean':
                contentToRender = contentToRender.toString();
                break;
            default:
                {
                    contentToRender = React__default.createElement(BaseCellRenderer, _extends({}, props, { value: contentToRender, content: content }));
                }
        }
    }
    return React__default.createElement(
        Component$$1,
        rest,
        contentToRender
    );
};

{
    CellView.propTypes = {
        content: PropTypes.oneOfType([PropTypes.node, PropTypes.func]).isRequired,
        component: PropTypes.func.isRequired,
        children: function children(props, propName) {
            if (props[propName] !== undefined) {
                return new Error('GridCell does not allow children, please use the `content` prop instead.');
            }
        }
    };
}

var RowView = function (_Component) {
    inherits(RowView, _Component);

    function RowView(props) {
        classCallCheck(this, RowView);
        return possibleConstructorReturn(this, (RowView.__proto__ || Object.getPrototypeOf(RowView)).call(this, props));
    }

    createClass(RowView, [{
        key: 'render',
        value: function render() {
            var _props = this.props,
                object = _props.object,
                columnConfigs = _props.columnConfigs,
                objects = _props.objects,
                rowIndex = _props.rowIndex,
                _context = this.context,
                defaultCellContent = _context.defaultCellContent,
                Component$$1 = _context.row,
                cell = _context.cell;

            return React__default.createElement(
                Component$$1,
                { object: object, columnConfigs: columnConfigs, rowIndex: rowIndex, objects: objects },
                columnConfigs.map(function (columnConfig) {
                    var CellComponent = columnConfig.component ? columnConfig.component : cell;
                    var content = columnConfig.content ? columnConfig.content : defaultCellContent;
                    if (columnConfig.hide) {
                        return;
                    }
                    return React__default.createElement(CellView, { key: columnConfig.name,
                        value: object[columnConfig.name],
                        columnName: columnConfig.name,
                        object: object,
                        component: CellComponent,
                        content: content
                    });
                })
            );
        }
    }]);
    return RowView;
}(React.Component);

RowView.contextTypes = {
    cell: PropTypes.oneOfType([PropTypes.func, PropTypes.node]).isRequired,
    defaultCellContent: PropTypes.oneOfType([PropTypes.func, PropTypes.node]).isRequired,
    row: PropTypes.oneOfType([PropTypes.func, PropTypes.node]).isRequired
};

{
    RowView.propTypes = {
        object: PropTypes.object.isRequired,
        columnConfigs: PropTypes.array.isRequired,
        objects: PropTypes.array.isRequired,
        rowIndex: PropTypes.number.isRequired
    };
}

var Body = function (_React$Component) {
    inherits(Body, _React$Component);

    function Body(props) {
        classCallCheck(this, Body);
        return possibleConstructorReturn(this, (Body.__proto__ || Object.getPrototypeOf(Body)).call(this, props));
    }

    createClass(Body, [{
        key: 'render',
        value: function render() {
            var children = this.props.children;
            var _context = this.context,
                columnConfigs = _context.columnConfigs,
                objects = _context.objects,
                Row = _context.row,
                Cell = _context.cell,
                noDataMessage = _context.noDataMessage;


            var idColumnConfig = columnConfigs ? columnConfigs.find(function (c) {
                return c.id;
            }) : null;
            var content = void 0;
            if (objects.length == 0) {
                var numberOfConfiguredColumns = columnConfigs.length;
                content = React__default.createElement(
                    Row,
                    null,
                    React__default.createElement(
                        Cell,
                        { colSpan: numberOfConfiguredColumns },
                        noDataMessage
                    )
                );
            } else {
                content = objects.map(function (currentObject, index) {
                    return React__default.createElement(RowView, { key: idColumnConfig ? currentObject[idColumnConfig.name] : index,
                        object: currentObject,
                        objects: objects,
                        rowIndex: index,
                        columnConfigs: columnConfigs });
                });
            }
            return React__default.createElement(
                'tbody',
                null,
                children,
                content
            );
        }
    }]);
    return Body;
}(React__default.Component);

Body.contextTypes = {
    objects: PropTypes.array,
    columnConfigs: PropTypes.array.isRequired,
    row: PropTypes.func.isRequired,
    cell: PropTypes.func.isRequired,
    noDataMessage: PropTypes.node
};

Body.propTypes = {
    children: PropTypes.node
};

var borderStyle = '1px solid grey';
var defaultPadding = '15px';

var DefaultGridTemplate = function DefaultGridTemplate() {
  return React__default.createElement(
    'div',
    { className: 'react-grid' },
    React__default.createElement(Pager, null),
    React__default.createElement(
      'style',
      { type: 'text/css' },
      '\n          .react-grid > div {\n            padding-bottom: 5px;\n          }\n          .react-grid > div > input {\n            height: 1.3em;\n            margin-right: 10px;\n          }\n          .react-grid table {\n            font-family: sans-serif;\n            border-collapse: collapse;\n          }\n          .react-grid > table > thead > tr > th {\n            border-bottom: ' + borderStyle + ';\n            padding: ' + defaultPadding + ';\n            background-color: lightgray;\n            line-height: 1.5em;\n          }\n          .react-grid > table > thead > tr:nth-child(1) > th > button {\n            float: right;\n            border: ' + borderStyle + ';\n            height: 2em;\n            width: 2em;\n            \n          }\n          .react-grid > table > thead > tr:nth-child(2) > th > input {\n            width: 100%;\n          }\n          .react-grid > table > tbody > tr > td {\n            border-bottom: ' + borderStyle + ';\n            padding: ' + defaultPadding + ';\n            text-align: left;\n          }\n          .react-grid > table > tbody > tr > td dt {\n            font-weight: bold;\n          }\n        '
    ),
    React__default.createElement(
      'table',
      null,
      React__default.createElement(
        'thead',
        null,
        React__default.createElement(HeaderRow, null),
        React__default.createElement(FilterRow, null)
      ),
      React__default.createElement(Body, null)
    )
  );
};

var TextFilter = function (_Component) {
    inherits(TextFilter, _Component);

    function TextFilter(props) {
        classCallCheck(this, TextFilter);

        var _this = possibleConstructorReturn(this, (TextFilter.__proto__ || Object.getPrototypeOf(TextFilter)).call(this, props));

        _this.state = { filterValue: _this.props.query };
        _this.inputChanged = _this.inputChanged.bind(_this);
        return _this;
    }

    createClass(TextFilter, [{
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            if (this.timeout) {
                window.clearTimeout(this.timeout);
                this.timeout = null;
            }
        }
    }, {
        key: 'inputChanged',
        value: function inputChanged(event) {
            var _this2 = this;

            this.setState({ filterValue: event.target.value });
            if (this.timeout) {
                window.clearTimeout(this.timeout);
                this.timeout = null;
            }
            this.timeout = window.setTimeout(function () {
                _this2.props.updateFilter(_this2.state.filterValue);
            }, 300);
        }
    }, {
        key: 'render',
        value: function render() {
            return React__default.createElement('input', { id: 'filter_for_' + this.props.column, type: 'search', key: this.props.column, value: this.state.filterValue, onChange: this.inputChanged, placeholder: 'Filter...' });
        }
    }]);
    return TextFilter;
}(React.Component);

{
    TextFilter.propTypes = {
        query: PropTypes.string,
        config: PropTypes.object,
        column: PropTypes.string.isRequired,
        updateFilter: PropTypes.func
    };
}

var defaultFilterFunction = function defaultFilterFunction(_ref) {
    var displayValue = _ref.displayValue,
        expression = _ref.expression;

    if (!(typeof expression === 'string') || expression === '' || expression === undefined || expression === null) {
        return true;
    }
    if (displayValue === undefined || displayValue === null) {
        return false;
    }
    var valueType = typeof displayValue === 'undefined' ? 'undefined' : _typeof(displayValue);
    if (valueType === 'string' && displayValue.toLowerCase().indexOf(expression.toLowerCase()) === -1) {
        return false;
    } else if (['number', 'boolean', 'object'].indexOf(valueType) !== -1) {
        return JSON.stringify(displayValue).toLowerCase().indexOf(expression.toLowerCase()) !== -1;
    } else return true;
};

var withFilterHandler = function withFilterHandler(ComponentToWrap) {
    var FilterHandler = function (_React$Component) {
        inherits(FilterHandler, _React$Component);

        function FilterHandler(props) {
            classCallCheck(this, FilterHandler);

            var _this = possibleConstructorReturn(this, (FilterHandler.__proto__ || Object.getPrototypeOf(FilterHandler)).call(this, props));

            _this.updateFilter = _this.updateFilter.bind(_this);
            _this.filterObjects = _this.filterObjects.bind(_this);
            _this.normalizeFilterConfig = _this.normalizeFilterConfig.bind(_this);
            _this.updateFilterConfig = _this.updateFilterConfig.bind(_this);
            _this.state = {
                filter: _this.normalizeFilterConfig(props.defaultFilter),
                filterComponents: {},
                filterFunctions: {},
                defaultFilterFunction: defaultFilterFunction,
                defaultFilterComponent: TextFilter
            };
            return _this;
        }

        createClass(FilterHandler, [{
            key: 'normalizeFilterConfig',
            value: function normalizeFilterConfig(filterConfig$$1) {
                if ((typeof filterConfig$$1 === 'undefined' ? 'undefined' : _typeof(filterConfig$$1)) === 'object') {
                    if (Array.isArray(filterConfig$$1)) {
                        return filterConfig$$1;
                    } else {
                        return [filterConfig$$1];
                    }
                }
                return [];
            }
        }, {
            key: 'getChildContext',
            value: function getChildContext() {
                return {
                    updateFilterConfig: this.updateFilterConfig,
                    filterComponents: this.state.filterComponents,
                    defaultFilterComponent: this.state.defaultFilterComponent,
                    updateFilter: this.updateFilter,
                    filter: this.state.filter
                };
            }
        }, {
            key: 'componentWillReceiveProps',
            value: function componentWillReceiveProps(nextProps) {

                var newState = {};
                if (!(JSON.stringify(this.props.defaultFilter) === JSON.stringify(nextProps.defaultFilter))) {
                    newState.filter = this.normalizeFilterConfig(nextProps.defaultFilter);
                    this.setState(newState);
                }
            }
        }, {
            key: 'updateFilter',
            value: function updateFilter(newFilter) {
                this.setState(function (prevState) {
                    var index = prevState.filter.findIndex(function (filterObject) {
                        return filterObject.columnName === newFilter.columnName;
                    });
                    var filterCopy = void 0;
                    if (index !== -1) {
                        filterCopy = prevState.filter.slice();
                        filterCopy[index] = Object.assign({}, prevState[index], newFilter);
                    } else {
                        filterCopy = prevState.filter ? prevState.filter : [];
                        filterCopy.push(newFilter);
                    }
                    return { filter: filterCopy };
                });
            }
        }, {
            key: 'updateFilterConfig',
            value: function updateFilterConfig(filterFunction, filterComponent, columnName) {
                if (columnName !== undefined) {
                    var newState = {};
                    if (filterFunction !== undefined) {
                        newState.filterFunctions = Object.assign({}, this.state.filterFunctions);
                        newState.filterFunctions[columnName] = filterFunction;
                    }
                    if (filterComponent !== undefined) {
                        newState.filterComponents = Object.assign({}, this.state.filterComponents);
                        newState.filterComponents[columnName] = filterComponent;
                    }
                    this.setState(newState);
                } else {
                    var _newState = {};
                    if (filterFunction !== undefined) {
                        _newState.defaultFilterFunction = filterFunction;
                    }
                    if (filterComponent !== undefined) {
                        _newState.defaultFilterComponent = filterComponent;
                    }
                    this.setState(_newState);
                }
            }
        }, {
            key: 'filterObjects',
            value: function filterObjects(objects, filterConfig$$1, columns, defaultFilterFunction, globalCellConfig) {
                var filterFunctions = this.state.filterFunctions;
                //Filter objects based on supplied filter strings

                var filters = {};
                var columnNamesWithFilter = filterConfig$$1.map(function (filterObject) {
                    filters[filterObject.columnName] = filterObject.expression;
                    return filterObject.columnName;
                });
                return objects.filter(function (currentObjectToBeFiltered) {
                    var _loop = function _loop(i) {
                        var currentColumn = columnNamesWithFilter[i];

                        //Objects shall be filtered by the visible value by default.
                        //Therefore get the correct content for every column.
                        var value = currentObjectToBeFiltered[currentColumn];
                        var columnConfig = columns.find(function (c) {
                            return c.name === currentColumn;
                        });
                        var content = void 0;
                        var displayValue = value;
                        if (columnConfig !== undefined && columnConfig.content !== undefined) {
                            content = columnConfig.content;
                        } else if (globalCellConfig !== undefined && globalCellConfig.content !== undefined) {
                            content = globalCellConfig.content;
                        }
                        if (content !== undefined) {
                            if (typeof content === 'function') {
                                displayValue = content({ value: currentObjectToBeFiltered[currentColumn], object: currentObjectToBeFiltered });
                            } else {
                                displayValue = content;
                            }
                        }

                        var filterFunction = filterFunctions[currentColumn] || defaultFilterFunction;
                        if (!filterFunction({
                            object: currentObjectToBeFiltered,
                            value: currentObjectToBeFiltered[currentColumn],
                            expression: filters[currentColumn],
                            displayValue: displayValue
                        })) {
                            return {
                                v: false
                            };
                        }
                    };

                    for (var i in columnNamesWithFilter) {
                        var _ret = _loop(i);

                        if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
                    }
                    return true;
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var props = this.props;
                var objects = this.filterObjects(props.objects, this.state.filter, props.columnConfigs, defaultFilterFunction);
                return React__default.createElement(ComponentToWrap, _extends({}, props, { filter: this.state.filter, objects: objects }));
            }
        }]);
        return FilterHandler;
    }(React__default.Component);
    FilterHandler.childContextTypes = {
        updateFilter: PropTypes.func,
        updateFilterConfig: PropTypes.func,
        filter: PropTypes.array,
        filterComponents: PropTypes.objectOf(PropTypes.func),
        defaultFilterComponent: PropTypes.func
    };

    {
        FilterHandler.propTypes = {
            defaultFilter: filterConfig
        };
    }

    FilterHandler.displayName = 'FilterCollector(' + (ComponentToWrap.displayName || ComponentToWrap.name || 'Component') + ')';

    return FilterHandler;
};

var withPagingHandler = function withPagingHandler(ComponentToWrap) {
    var PagingHandler = function (_React$Component) {
        inherits(PagingHandler, _React$Component);

        function PagingHandler(props) {
            classCallCheck(this, PagingHandler);

            var _this = possibleConstructorReturn(this, (PagingHandler.__proto__ || Object.getPrototypeOf(PagingHandler)).call(this, props));

            var pageSize = props.pageSize,
                defaultPageSize = props.defaultPageSize,
                page = props.page,
                defaultPage = props.defaultPage;

            if (defaultPageSize < 1) {
                throw new Error('Invalid value for "defaultPageSize": ' + defaultPageSize);
            }
            _this.state = {
                currentPage: page || defaultPage || 1,
                pageSize: pageSize || defaultPageSize || 10
            };
            _this.setPage = _this.setPage.bind(_this);
            _this.setPageSize = _this.setPageSize.bind(_this);
            _this.registerPager = _this.registerPager.bind(_this);
            return _this;
        }

        createClass(PagingHandler, [{
            key: 'componentWillReceiveProps',
            value: function componentWillReceiveProps(_ref) {
                var objects = _ref.objects;

                var numberOfObjects = objects.length;
                var currentPage = this.state.currentPage;

                if (numberOfObjects < this.props.objects.length) {
                    var newMaxPage = Math.ceil(numberOfObjects / this.state.pageSize);
                    if (currentPage > newMaxPage) {
                        newMaxPage > 0 ? this.setPage(newMaxPage) : this.setPage(1);
                    }
                }
            }
        }, {
            key: 'getChildContext',
            value: function getChildContext() {
                var numberOfPages = Math.ceil(this.props.objects.length / this.state.pageSize);
                return {
                    page: this.state.currentPage,
                    onChangePage: this.setPage,
                    pageSize: this.state.pageSize,
                    onChangePageSize: this.setPageSize,
                    numberOfPages: numberOfPages > 0 ? numberOfPages : 1,
                    registerPager: this.registerPager
                };
            }
        }, {
            key: 'setPage',
            value: function setPage(newPage) {
                var _props = this.props,
                    page = _props.page,
                    onChangePage = _props.onChangePage;

                var hasOnChangePage = onChangePage !== undefined;
                if (page === undefined || hasOnChangePage) {
                    this.setState({ currentPage: newPage }, function () {
                        hasOnChangePage && onChangePage(newPage);
                    });
                }
            }
        }, {
            key: 'setPageSize',
            value: function setPageSize(newPageSize) {
                if (newPageSize < 1) {
                    throw new Error('Invalid value for pageSize: ' + newPageSize);
                }
                var _props2 = this.props,
                    pageSize = _props2.pageSize,
                    onChangePageSize = _props2.onChangePageSize;

                var hasOnChangePageSize = onChangePageSize !== undefined;
                if (pageSize === undefined || hasOnChangePageSize) {
                    this.setState({ pageSize: newPageSize }, function () {
                        hasOnChangePageSize && onChangePageSize(newPageSize);
                    });
                }
            }
        }, {
            key: 'registerPager',
            value: function registerPager() {
                this.setState({ pagingEnabled: true });
            }
        }, {
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.setState({ configurationFinished: true });
            }
        }, {
            key: 'render',
            value: function render() {
                var props = this.props;
                var objects = props.objects;
                var _state = this.state,
                    pageSize = _state.pageSize,
                    currentPage = _state.currentPage,
                    pagingEnabled = _state.pagingEnabled,
                    configurationFinished = _state.configurationFinished;


                var pagedObjects = !configurationFinished || pagingEnabled ? objects.slice((currentPage - 1) * pageSize, currentPage * pageSize) : objects;

                return React__default.createElement(ComponentToWrap, _extends({}, props, { objects: pagedObjects }));
            }
        }]);
        return PagingHandler;
    }(React__default.Component);
    PagingHandler.childContextTypes = {
        page: PropTypes.number,
        onChangePage: PropTypes.func,
        pageSize: PropTypes.number,
        onChangePageSize: PropTypes.func,
        numberOfPages: PropTypes.number,
        registerPager: PropTypes.func
    };
    PagingHandler.displayName = 'PagingHandler(' + (ComponentToWrap.displayName || ComponentToWrap.name || 'Component') + ')';

    {
        PagingHandler.propTypes = {
            objects: PropTypes.array.isRequired,
            defaultPage: PropTypes.number,
            page: function page(props, propName, componentName) {
                if (!props[propName]) {
                    return null;
                }
                if (!props.onChangePage) {
                    return new Error('You provided a `page` prop without an `onChangePage` handler. This will disable paging. If you want to set the default initial page, use the `defaultPage` prop.');
                }

                for (var _len = arguments.length, rest = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
                    rest[_key - 3] = arguments[_key];
                }

                return PropTypes.number.apply(PropTypes, [props, propName, componentName].concat(rest));
            },
            onChangePage: PropTypes.func,
            pageSize: function pageSize(props, propName, componentName) {
                if (!props[propName]) {
                    return null;
                }
                if (!props.onChangePageSize) {
                    return new Error('You provided a `pageSize` prop without an `onChangePageSize` handler. This will make the page size constant. If you want to set the default page size, use the `defaultPageSize` prop.');
                }

                for (var _len2 = arguments.length, rest = Array(_len2 > 3 ? _len2 - 3 : 0), _key2 = 3; _key2 < _len2; _key2++) {
                    rest[_key2 - 3] = arguments[_key2];
                }

                return PropTypes.number.apply(PropTypes, [props, propName, componentName].concat(rest));
            },
            onChangePageSize: PropTypes.func,
            defaultPageSize: PropTypes.number
        };
    }

    return PagingHandler;
};

var withSortHandler = function withSortHandler(ComponentToWrap) {
    var SortHandler = function (_React$Component) {
        inherits(SortHandler, _React$Component);

        function SortHandler(props) {
            classCallCheck(this, SortHandler);

            var _this = possibleConstructorReturn(this, (SortHandler.__proto__ || Object.getPrototypeOf(SortHandler)).call(this, props));

            var sort = void 0;
            if (props.sort !== undefined) {
                sort = sortConfigFromProp(props.sort);
            } else {
                sort = sortConfigFromProp(props.defaultSort);
            }
            _this.state = {
                sort: sort
            };
            _this.updateSort = _this.updateSort.bind(_this);
            return _this;
        }

        createClass(SortHandler, [{
            key: 'getChildContext',
            value: function getChildContext() {
                return {
                    updateSort: this.updateSort,
                    sort: this.state.sort
                };
            }
        }, {
            key: 'componentWillReceiveProps',
            value: function componentWillReceiveProps(nextProps) {
                var newSort = sortConfigFromProp(nextProps.defaultSort);
                var newState = {};
                if (!(JSON.stringify(this.props.defaultSort) === JSON.stringify(newSort))) {
                    newState.sort = newSort;
                }
                this.setState(newState);
            }
        }, {
            key: 'updateSort',
            value: function updateSort(column, order) {
                var _props = this.props,
                    onChangeSort = _props.onChangeSort,
                    sort = _props.sort;

                var hasOnChangeSort = onChangeSort !== undefined;
                if (sort === undefined || hasOnChangeSort) {
                    this.setState({ sort: { columnName: column, order: order } }, function () {
                        hasOnChangeSort && onChangeSort({ columnName: column, order: order });
                    });
                }
            }
        }, {
            key: 'sortObjects',
            value: function sortObjects() {
                var sort = this.state.sort;
                var _props2 = this.props,
                    objects = _props2.objects,
                    columnConfigs = _props2.columnConfigs,
                    defaultSortValueGetter = _props2.sortValueGetter;

                if (sort === undefined) {
                    return objects;
                }
                var columnName = sort.columnName,
                    order = sort.order;

                var columnConfig = columnConfigs.find(function (c) {
                    return c.name === columnName;
                });
                var sortValueGetter = void 0;
                if (columnConfig !== undefined && columnConfig.sortValueGetter !== undefined) {
                    sortValueGetter = columnConfig.sortValueGetter;
                } else {
                    sortValueGetter = defaultSortValueGetter;
                }

                // temporary array holds objects with position and sort-value
                var mapped = objects.map(function (el, i) {
                    var value = sortValueGetter({ value: el[columnName], object: el });
                    return { index: i, value: value };
                });

                //reverse order on "descending" sort option
                var multplier = order === DESCENDING ? -1 : 1;

                // sorting the mapped array containing the reduced values
                mapped.sort(function (a, b) {
                    if (a.value == null) {
                        return multplier * -1;
                    }
                    if (b.value == null) {
                        return multplier * 1;
                    }
                    return multplier * (+(a.value > b.value) || +(a.value === b.value) - 1);
                });

                // container for the resulting order
                return mapped.map(function (el) {
                    return objects[el.index];
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var props = this.props;
                var objects = this.sortObjects();

                return React__default.createElement(ComponentToWrap, _extends({}, props, { objects: objects }));
            }
        }]);
        return SortHandler;
    }(React__default.Component);
    SortHandler.childContextTypes = {
        sort: PropTypes.object,
        updateSort: PropTypes.func
    };
    SortHandler.displayName = 'SortHandler(' + (ComponentToWrap.displayName || ComponentToWrap.name || 'Component') + ')';

    {
        SortHandler.propTypes = {
            objects: PropTypes.array.isRequired,
            defaultSort: PropTypes.oneOfType([PropTypes.string, sortConfigSingle]),
            sort: function sort(props, propName, componentName) {
                if (!props[propName]) {
                    return null;
                }
                if (!props.onChangeSort) {
                    return new Error('You provided a `sort` prop without an `onChangeSort` handler. This will lead to constant sorting. If you want to set the default sorting, use the `defaultSort` prop.');
                }

                for (var _len = arguments.length, rest = Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
                    rest[_key - 3] = arguments[_key];
                }

                return PropTypes.oneOfType([PropTypes.string, sortConfigSingle]).apply(undefined, [props, propName, componentName].concat(rest));
            },
            onChangeSort: PropTypes.func,
            columnConfigs: PropTypes.arrayOf(PropTypes.shape({
                sortValueGetter: PropTypes.func
            })).isRequired,
            sortValueGetter: PropTypes.func.isRequired
        };
    }

    SortHandler.defaultProps = {
        sortValueGetter: function sortValueGetter(_ref) {
            var value = _ref.value;

            if (value) {
                var valueType = typeof value === 'undefined' ? 'undefined' : _typeof(value);
                switch (valueType) {
                    case 'number':
                    case 'boolean':
                        return value;
                    case 'string':
                        return value.toLowerCase();
                    default:
                        return JSON.stringify(value).toLowerCase();
                }
            }
            return value;
        }
    };

    return SortHandler;
};

var withDefaultColumnsHandler = function withDefaultColumnsHandler(ComponentToWrap) {
    var DefaultColumnsHandler = function (_React$Component) {
        inherits(DefaultColumnsHandler, _React$Component);

        function DefaultColumnsHandler() {
            classCallCheck(this, DefaultColumnsHandler);
            return possibleConstructorReturn(this, (DefaultColumnsHandler.__proto__ || Object.getPrototypeOf(DefaultColumnsHandler)).apply(this, arguments));
        }

        createClass(DefaultColumnsHandler, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    columnConfigs = _props.columnConfigs,
                    objects = _props.objects,
                    hideColumnsWithoutConfig = _props.hideColumnsWithoutConfig,
                    rest = objectWithoutProperties(_props, ['columnConfigs', 'objects', 'hideColumnsWithoutConfig']);

                var columns = columnConfigs;
                if (objects && objects.length && !hideColumnsWithoutConfig) {
                    var configuredColumnNames = columnConfigs.map(function (item) {
                        return item.name;
                    });
                    var unconfiguredColunms = Object.keys(objects[0]).filter(function (name) {
                        return configuredColumnNames.indexOf(name) === -1;
                    }).map(function (name) {
                        return { name: name, sortable: true };
                    });
                    if (unconfiguredColunms.length !== 0) {
                        columns = columns.concat(unconfiguredColunms);
                    }
                }

                return React__default.createElement(ComponentToWrap, _extends({}, rest, { columnConfigs: columns, objects: objects }));
            }
        }]);
        return DefaultColumnsHandler;
    }(React__default.Component);

    {
        DefaultColumnsHandler.propTypes = {
            columnConfigs: PropTypes.array.isRequired,
            objects: PropTypes.array.isRequired,
            hideColumnsWithoutConfig: PropTypes.bool
        };
    }

    return DefaultColumnsHandler;
};

var ConfigurationBridge = function (_React$Component) {
    inherits(ConfigurationBridge, _React$Component);

    function ConfigurationBridge(props) {
        classCallCheck(this, ConfigurationBridge);
        return possibleConstructorReturn(this, (ConfigurationBridge.__proto__ || Object.getPrototypeOf(ConfigurationBridge)).call(this, props));
    }

    createClass(ConfigurationBridge, [{
        key: 'getChildContext',
        value: function getChildContext() {
            var _props = this.props,
                objects = _props.objects,
                columnConfigs = _props.columnConfigs;

            return {
                objects: objects, columnConfigs: columnConfigs
            };
        }
    }, {
        key: 'render',
        value: function render() {
            return React__default.Children.only(this.props.children);
        }
    }]);
    return ConfigurationBridge;
}(React__default.Component);

ConfigurationBridge.childContextTypes = {
    objects: PropTypes.array,
    columnConfigs: PropTypes.array.isRequired
};

{
    ConfigurationBridge.propTypes = {
        objects: PropTypes.array.isRequired,
        columnConfigs: PropTypes.array.isRequired,
        children: PropTypes.node
    };
}

var withConfigurationBridge = function withConfigurationBridge(WrappedComponent) {
    var wrapper = function wrapper(props) {
        var objects = props.objects,
            columnConfigs = props.columnConfigs;

        return React__default.createElement(
            ConfigurationBridge,
            { objects: objects, columnConfigs: columnConfigs },
            React__default.createElement(WrappedComponent, props)
        );
    };

    wrapper.displayName = 'withConfigurationBridge(' + (WrappedComponent.displayName || WrappedComponent.name || 'Component') + ')';
    {
        wrapper.propTypes = {
            objects: PropTypes.array.isRequired,
            columnConfigs: PropTypes.array.isRequired
        };
    }
    return wrapper;
};

//this is needed to actually render the grid config components (children) which inject the (e.g. column)
// configuration into the grid
var withGridTemplate = function withGridTemplate(GridTemplate) {
    var wrapper = function wrapper(props) {
        var children = props.children,
            columnConfigs = props.columnConfigs,
            rest = objectWithoutProperties(props, ['children', 'columnConfigs']);

        var hasColumns = columnConfigs.filter(function (item) {
            return !item.hide;
        }).length !== 0;
        var hasObjects = props.objects.length !== 0;
        var render = hasColumns || hasObjects;

        return React__default.createElement(
            'div',
            null,
            render && React__default.createElement(GridTemplate, _extends({}, rest, { columnConfigs: true })),
            children
        );
    };
    wrapper.displayName = 'withGridTemplate(' + (GridTemplate.displayName || GridTemplate.name || 'Component') + ')';

    {
        wrapper.propTypes = {
            children: PropTypes.node,
            columnConfigs: PropTypes.array.isRequired,
            objects: PropTypes.array.isRequired
        };
    }
    return wrapper;
};

//Integrate new context providers or prop proxies at this point.
//
//This can also be used as an example for advanced users on
//how to integrate new functionality
var buildGridWithTemplate = function buildGridWithTemplate(Template) {
    return ConfigCollector(withDefaultColumnsHandler(withFilterHandler(withSortHandler(withPagingHandler(withConfigurationBridge(withGridTemplate(Template)))))));
};

//legacy default export, we should add another file which exports several default templates as examples
buildGridWithTemplate(DefaultGridTemplate);

var Row = function (_React$Component) {
    inherits(Row, _React$Component);

    function Row(props) {
        classCallCheck(this, Row);
        return possibleConstructorReturn(this, (Row.__proto__ || Object.getPrototypeOf(Row)).call(this, props));
    }

    createClass(Row, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            this.context.registerRow(this.props.component);
        }
    }, {
        key: 'render',
        value: function render() {
            return React__default.createElement(
                'noscript',
                null,
                this.props.children
            );
        }
    }]);
    return Row;
}(React__default.Component);

Row.contextTypes = {
    registerRow: PropTypes.func
};

{
    Row.propTypes = {
        component: PropTypes.func.isRequired,
        children: PropTypes.node
    };
}

var isSameComponent = function isSameComponent(oldComponent, newComponent) {
    if (oldComponent === newComponent) {
        return true;
    }
    if (typeof oldComponent === 'function' && typeof newComponent === 'function') {
        if (oldComponent.hasOwnProperty('prototype') && newComponent.hasOwnProperty('prototype')) {
            return oldComponent.toString() === newComponent.toString();
        }
    }
    return false;
};

var Cell = function (_Component) {
    inherits(Cell, _Component);

    function Cell(props) {
        classCallCheck(this, Cell);

        var _this = possibleConstructorReturn(this, (Cell.__proto__ || Object.getPrototypeOf(Cell)).call(this, props));

        _this.update = _this.update.bind(_this);
        return _this;
    }

    createClass(Cell, [{
        key: 'update',
        value: function update() {
            var _props = this.props,
                component = _props.component,
                content = _props.content;
            var updateCell = this.context.updateCell;


            updateCell({ component: component, content: content });
        }
    }, {
        key: 'componentWillMount',
        value: function componentWillMount() {
            this.update();
        }
    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps) {
            return nextProps.content !== this.props.content || !isSameComponent(nextProps.component, this.props.component);
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate() {
            this.update();
        }
    }, {
        key: 'render',
        value: function render() {
            return null;
        }
    }]);
    return Cell;
}(React.Component);

Cell.contextTypes = {
    updateCell: PropTypes.func.isRequired
};

{
    Cell.propTypes = {
        content: PropTypes.oneOfType([PropTypes.func, PropTypes.node]),
        component: PropTypes.oneOfType([PropTypes.func, PropTypes.node]),
        children: function children(props, propName) {
            if (props[propName] !== undefined) {
                return new Error('GridCell does not allow children, please use the `content` prop instead.');
            }
        }
    };
}

var Column = function (_Component) {
    inherits(Column, _Component);

    function Column(props) {
        classCallCheck(this, Column);

        var _this = possibleConstructorReturn(this, (Column.__proto__ || Object.getPrototypeOf(Column)).call(this, props));

        _this.updateColumnConfig = _this.updateColumnConfig.bind(_this);
        _this.updateCell = _this.updateCell.bind(_this);
        _this.updateFilterConfig = _this.updateFilterConfig.bind(_this);
        return _this;
    }

    createClass(Column, [{
        key: 'updateCell',
        value: function updateCell(_ref) {
            var component = _ref.component,
                content = _ref.content;
            var name = this.props.name;
            var updateColumnConfig = this.context.updateColumnConfig;

            updateColumnConfig(name, { name: name, component: component, content: content });
        }
    }, {
        key: 'updateFilterConfig',
        value: function updateFilterConfig(filterFunction, filterComponent) {
            var name = this.props.name;
            var updateFilterConfig = this.context.updateFilterConfig;

            updateFilterConfig(filterFunction, filterComponent, name);
        }
    }, {
        key: 'getChildContext',
        value: function getChildContext() {
            return {
                columnName: this.props.name,
                updateCell: this.updateCell,
                updateFilterConfig: this.updateFilterConfig
            };
        }
    }, {
        key: 'updateColumnConfig',
        value: function updateColumnConfig(props) {
            var updateColumnConfig = this.context.updateColumnConfig;

            updateColumnConfig(props.name, props);
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.updateColumnConfig(this.props);
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            var updateColumnConfig = this.context.updateColumnConfig;

            updateColumnConfig(this.props.name, undefined);
        }
    }, {
        key: 'shouldComponentUpdate',
        value: function shouldComponentUpdate(nextProps) {
            return nextProps.sortable !== this.props.sortable || nextProps.hide !== this.props.hide || nextProps.label !== this.props.label || nextProps.name !== this.props.name;
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate(prevProps) {
            this.context.updateColumnConfig(prevProps.name, this.props);
        }
    }, {
        key: 'render',
        value: function render() {
            var children = this.props.children;

            return React__default.createElement(
                'noscript',
                null,
                children
            );
        }
    }]);
    return Column;
}(React.Component);

Column.defaultProps = {
    sortable: true
};

Column.childContextTypes = {
    updateCell: PropTypes.func,
    columnName: PropTypes.string,
    updateFilterConfig: PropTypes.func
};

Column.contextTypes = {
    updateColumnConfig: PropTypes.func.isRequired,
    updateFilterConfig: PropTypes.func.isRequired
};

{
    Column.propTypes = {
        hide: PropTypes.bool,
        name: PropTypes.string.isRequired,
        sortable: PropTypes.bool,
        label: PropTypes.node,
        children: PropTypes.node
    };
}

var Filter = function (_Component) {
    inherits(Filter, _Component);

    function Filter(props) {
        classCallCheck(this, Filter);
        return possibleConstructorReturn(this, (Filter.__proto__ || Object.getPrototypeOf(Filter)).call(this, props));
    }

    createClass(Filter, [{
        key: 'componentWillMount',
        value: function componentWillMount() {
            var _props = this.props,
                match = _props.match,
                component = _props.component;
            var updateFilterConfig = this.context.updateFilterConfig;

            updateFilterConfig(match, component);
        }
    }, {
        key: 'render',
        value: function render() {
            return null;
        }
    }]);
    return Filter;
}(React.Component);

Filter.contextTypes = {
    updateFilterConfig: PropTypes.func.isRequired
};

{
    Filter.propTypes = {
        match: PropTypes.func,
        component: PropTypes.func
    };
}

var DefaultGrid = buildGridWithTemplate(DefaultGridTemplate);

exports.ConfigCollector = ConfigCollector;
exports.buildGridWithTemplate = buildGridWithTemplate;
exports.DefaultGrid = DefaultGrid;
exports.Body = Body;
exports.Row = Row;
exports.Cell = Cell;
exports.HeaderRow = HeaderRow;
exports.FilterRow = FilterRow;
exports.Filter = Filter;
exports.Column = Column;
exports.Pager = Pager;
exports.ASCENDING = ASCENDING;
exports.DESCENDING = DESCENDING;
exports.DefaultHeaderCell = DefaultHeaderCell;

Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=Ardagryd.js.map
