// Generated by CoffeeScript 1.8.0
(function() {
  var ArgumentParser, Rule, Rules, W, argparser, argv, check, editorconfig, exitCode, filePath, fix, fs, infer, packageInfo, path, promise, promises, requireTree, results, ruleName, subparsers, _, _fn, _i, _j, _len, _len1, _ref, _ref1;

  path = require('path');

  packageInfo = require(path.join(__dirname, '../package.json'));

  ArgumentParser = require('argparse').ArgumentParser;

  argparser = new ArgumentParser({
    version: packageInfo.version,
    addHelp: true,
    description: packageInfo.description
  });

  subparsers = argparser.addSubparsers({
    title: 'action',
    dest: 'action'
  });

  infer = subparsers.addParser('infer', {
    help: 'Infer .editorconfig settings from one or more files',
    addHelp: true
  });

  infer.addArgument(['files'], {
    type: 'string',
    metavar: 'FILE',
    nargs: '+',
    help: 'The file(s) to use'
  });

  check = subparsers.addParser('check', {
    help: 'Validate that file(s) adhere to .editorconfig settings, returning an error code if they don\'t',
    addHelp: true
  });

  check.addArgument(['files'], {
    type: 'string',
    metavar: 'FILE',
    nargs: '+',
    help: 'The file(s) to use'
  });

  fix = subparsers.addParser('fix', {
    help: 'Fix formatting errors that disobey .editorconfig settings',
    addHelp: true
  });

  fix.addArgument(['files'], {
    type: 'string',
    metavar: 'FILE',
    nargs: '+',
    help: 'The file(s) to use'
  });

  argv = argparser.parseArgs();

  editorconfig = require('editorconfig');

  fs = require('graceful-fs');

  path = require('path');

  W = require('when');

  _ = require('lodash');

  requireTree = require('require-tree');

  Rules = requireTree('./rules');

  exitCode = 0;

  if (argv.action === 'check') {
    promises = [];
    Object.keys(Rules).forEach(function(ruleName) {
      var Rule;
      Rule = Rules[ruleName];
      return argv.files.forEach(function(filePath) {
        var property;
        if (fs.lstatSync(filePath).isDirectory()) {
          return;
        }
        property = void 0;
        return promises.push((new Rule(filePath)).then(function(returnedProperty) {
          property = returnedProperty;
          return property.check();
        }).then(function(res) {
          return {
            res: res,
            file: filePath,
            rule: property.propertyName
          };
        })["catch"](function(err) {
          return {
            file: filePath,
            rule: property.propertyName,
            error: err
          };
        }));
      });
    });
    W.all(promises).done(function(res) {
      var file, files, match, matches, text, verbose, _i, _j, _len, _len1;
      files = _.uniq(_.pluck(res, 'file'));
      for (_i = 0, _len = files.length; _i < _len; _i++) {
        file = files[_i];
        matches = _.where(res, {
          file: file
        });
        verbose = true;
        if (verbose || _.compact(_.pluck(matches, 'error')).length > 0) {
          for (_j = 0, _len1 = matches.length; _j < _len1; _j++) {
            match = matches[_j];
            if (match.error != null) {
              exitCode = 1;
              text = "" + file + " failed " + match.rule;
              if (match.error.lineNumber != null) {
                text += " on line " + match.error.lineNumber;
              }
              if (match.error.message != null) {
                text += ": " + match.error.message;
              }
              console.log(text);
            } else if (verbose) {
              if (match.res === null) {
                console.log("" + file + " ignored " + match.rule + " (no setting defined)");
              } else {

              }
            }
          }
        }
      }
      return process.exit(exitCode);
    });
  } else if (argv.action === 'fix') {
    results = [];
    promise = W.resolve();
    _ref = Object.keys(Rules);
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      ruleName = _ref[_i];
      Rule = Rules[ruleName];
      _ref1 = argv.files;
      _fn = function(Rule, filePath) {
        var property;
        property = void 0;
        return promise = promise.then(function() {
          return new Rule(filePath);
        }).then(function(returnedProperty) {
          property = returnedProperty;
          return property.fix();
        }).then(function(res) {
          return results.push({
            res: res,
            file: filePath,
            rule: property.propertyName
          });
        })["catch"](function(err) {
          return results.push({
            file: filePath,
            rule: property.propertyName,
            error: err
          });
        });
      };
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        filePath = _ref1[_j];
        if (fs.lstatSync(filePath).isDirectory()) {
          continue;
        }
        _fn(Rule, filePath);
      }
    }
    promise.done(function() {
      var result, verbose, _k, _len2, _results;
      verbose = true;
      _results = [];
      for (_k = 0, _len2 = results.length; _k < _len2; _k++) {
        result = results[_k];
        if (result.error != null) {
          _results.push(console.log("" + result.file + " " + result.error.message));
        } else if (verbose) {
          _results.push(console.log("" + result.file + " fixed"));
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    });
  } else if (argv.action === 'infer') {
    promises = [];
    Object.keys(Rules).forEach(function(ruleName) {
      Rule = Rules[ruleName];
      return argv.files.forEach(function(filePath) {
        var property;
        if (fs.lstatSync(filePath).isDirectory()) {
          return;
        }
        property = void 0;
        return promises.push((new Rule(filePath)).then(function(returnedProperty) {
          property = returnedProperty;
          return property.infer();
        }).then(function(res) {
          return {
            res: String(res),
            file: filePath,
            rule: property.propertyName
          };
        })["catch"](function(err) {
          return {
            file: filePath,
            rule: property.propertyName,
            error: err
          };
        }));
      });
    });
    W.all(promises).done(function(res) {
      var distributionOfValues, files, group, groups, property, rule, ruleGroup, rules, selector, sortedValues, value, _k, _l, _len2, _len3, _ref2, _ref3, _results;
      rules = {};
      groups = _.groupBy(res, 'rule');
      for (property in groups) {
        group = groups[property];
        distributionOfValues = _.pairs(_.countBy(_.pluck(group, 'res'), function(x) {
          return x;
        }));
        sortedValues = _.sortBy(distributionOfValues, function(x) {
          return -x[1];
        });
        if (rules['[*]'] == null) {
          rules['[*]'] = [];
        }
        rules['[*]'].push([property, sortedValues[0][0]]);
        _ref2 = sortedValues.slice(1);
        for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
          value = _ref2[_k];
          if ((_ref3 = value[0]) === 'null' || _ref3 === 'undefined') {
            continue;
          }
          files = _.pluck(_.where(group, {
            res: value[0]
          }), 'file');
          selector = "[{" + (files.join(',')) + "}]";
          if (rules[selector] == null) {
            rules[selector] = [];
          }
          rules[selector].push([property, value[0]]);
        }
      }
      _results = [];
      for (selector in rules) {
        ruleGroup = rules[selector];
        console.log(selector);
        for (_l = 0, _len3 = ruleGroup.length; _l < _len3; _l++) {
          rule = ruleGroup[_l];
          if (rule[0] === 'indent_char') {
            if (rule[1] === '\t') {
              console.log('indent_style: tab');
            } else {
              console.log('indent_style = space');
              console.log("indent_size = " + rule[1].length);
            }
          } else {
            console.log("" + rule[0] + " = " + rule[1]);
          }
        }
        _results.push(console.log(''));
      }
      return _results;
    });
  }

}).call(this);
