// Generated by CoffeeScript 1.8.0
(function() {
  var EditorConfigError, LineRule, Rule, W,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  W = require('when');

  Rule = require('./rule');

  EditorConfigError = require('./editorconfigerror');

  LineRule = (function(_super) {
    __extends(LineRule, _super);

    function LineRule() {
      this.inferLine = __bind(this.inferLine, this);
      this.checkLine = __bind(this.checkLine, this);
      this.fixLine = __bind(this.fixLine, this);
      this.infer = __bind(this.infer, this);
      this.check = __bind(this.check, this);
      this.fix = __bind(this.fix, this);
      this.fileAsLines = __bind(this.fileAsLines, this);
      return LineRule.__super__.constructor.apply(this, arguments);
    }


    /**
     * Get the contents of the file as an array of lines.
     * @return {Promise} A promise for the lines as an array of strings.
     */

    LineRule.prototype.fileAsLines = function() {
      return this.file.read({
        encoding: 'utf8'
      }).then(function(data) {
        var i, joinedLines, lines;
        lines = data.split(/(\r\n|\n|\r)/);
        i = 0;
        joinedLines = [];
        while (i < lines.length) {
          joinedLines.push(lines[i] + (lines[i + 1] || ''));
          i += 2;
        }
        if (joinedLines.slice(-1)[0] === '') {
          joinedLines = joinedLines.slice(0, -1);
        }
        return joinedLines;
      });
    };

    LineRule.prototype.fix = function() {
      return LineRule.__super__.fix.call(this).then(this.fileAsLines).then((function(_this) {
        return function(lines) {
          var line, newLines, _i, _len;
          newLines = [];
          for (_i = 0, _len = lines.length; _i < _len; _i++) {
            line = lines[_i];
            newLines.push(_this.fixLine(line));
          }
          return _this.file.write(newLines.join(''));
        };
      })(this));
    };

    LineRule.prototype.check = function() {
      if (this.setting == null) {
        return W.resolve(null);
      } else {
        return this.fileAsLines().then((function(_this) {
          return function(lines) {
            var line, lineNum, _i, _len, _results;
            _results = [];
            for (lineNum = _i = 0, _len = lines.length; _i < _len; lineNum = ++_i) {
              line = lines[lineNum];
              _results.push(_this.checkLine(line, lineNum));
            }
            return _results;
          };
        })(this));
      }
    };

    LineRule.prototype.infer = function() {
      return this.fileAsLines().then((function(_this) {
        return function(lines) {
          var line, lineSetting, lineSettings, _i, _len;
          lineSettings = [];
          for (_i = 0, _len = lines.length; _i < _len; _i++) {
            line = lines[_i];
            lineSetting = _this.inferLine(line);
            if ((lineSetting != null) && __indexOf.call(lineSettings, lineSetting) < 0) {
              lineSettings.push(lineSetting);
            }
          }
          if (lineSettings.length === 1) {
            return lineSettings[0];
          } else {
            throw new Error("multiple setting values found: " + (lineSettings.join(', ')));
          }
        };
      })(this));
    };


    /**
     * @param {String} line
     * @return {String} The fixed line.
     */

    LineRule.prototype.fixLine = function(line) {
      throw new Error("Unable to fix " + this.propertyName);
    };


    /**
     * Check if the line is valid according to the rule. By default it just uses
       `inferLine` to check aginst the setting for the rule. Throw an exception if
       it isn't valid
     * @param {String} line
     * @param {Integer} lineNum
     */

    LineRule.prototype.checkLine = function(line, lineNum) {
      var detectedSetting;
      detectedSetting = this.inferLine(line);
      if ((detectedSetting != null) && detectedSetting !== this.setting) {
        throw new EditorConfigError("found setting '" + detectedSetting + "', should be '" + this.setting + "'", this.file.path, lineNum);
      }
    };


    /**
     * @param {String} line
     * @return {String|Integer|Boolean} Setting value for the line.
     */

    LineRule.prototype.inferLine = function(line) {
      throw new Error("Cannot infer " + this.propertyName);
    };

    return LineRule;

  })(Rule);

  module.exports = LineRule;

}).call(this);
