// Generated by CoffeeScript 1.8.0
(function() {
  var EditorConfigError, File, Rule, W, editorconfig, path,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  path = require('path');

  File = require('fobject');

  W = require('when');

  EditorConfigError = require('./editorconfigerror');

  editorconfig = require('./editorconfig');

  Rule = (function() {

    /**
     * The "official" name of the rule, according to the editorconfig spec.
     * @type {String}
     */
    Rule.prototype.propertyName = '';


    /**
     * The setting of the rule for the file being tested.
     * @type {String|Integer|Boolean}
     */

    Rule.prototype.setting = void 0;


    /**
     * The file being tested.
     * @type {File}
     */

    Rule.prototype.file = void 0;


    /**
     * Setup the Rule for a given filename so the other methods can be used.
     * @param {String} filename
     */

    function Rule(filename) {
      this.check = __bind(this.check, this);
      this.fix = __bind(this.fix, this);
      return editorconfig(filename).then((function(_this) {
        return function(editorconfig) {
          _this.editorconfig = editorconfig;
          _this.setting = _this.editorconfig[_this.propertyName];
          _this.file = new File(filename);
          return _this;
        };
      })(this));
    }


    /**
     * Fix the file so it matches the given editorconfig setting
     * @return {Promise}
     */

    Rule.prototype.fix = function() {
      if (this.setting == null) {
        return W.reject(new EditorConfigError("cannot fix " + this.propertyName + " (no setting defined)"));
      } else {
        return W();
      }
    };


    /**
     * Ensure that the file obeys the editorconfig setting. Throw an error if it
       doesn't.
     * @return {Promise}
     */

    Rule.prototype.check = function() {
      if (this.setting == null) {
        return W.resolve(null);
      } else {
        return this.infer().then((function(_this) {
          return function(detectedSetting) {
            if ((detectedSetting != null) && detectedSetting !== _this.setting) {
              throw new EditorConfigError("found setting '" + detectedSetting + "', should be '" + _this.setting + "'", _this.file.path);
            }
          };
        })(this));
      }
    };


    /**
     * Determine the value of the setting based on the contents of the file.
     * @return {Promise} A promise for the value of the setting.
     */

    Rule.prototype.infer = function() {};

    return Rule;

  })();

  module.exports = Rule;

}).call(this);
