// Generated by CoffeeScript 1.8.0
(function() {
  var EndOfLine, LineRule,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  LineRule = require('../line-rule');

  EndOfLine = (function(_super) {
    __extends(EndOfLine, _super);

    function EndOfLine() {
      this.inferLine = __bind(this.inferLine, this);
      this.fixLine = __bind(this.fixLine, this);
      return EndOfLine.__super__.constructor.apply(this, arguments);
    }

    EndOfLine.prototype.propertyName = 'end_of_line';

    EndOfLine.prototype._eolRegex = /(?:\r\n|\n|\r)$/;

    EndOfLine.prototype.fixLine = function(line) {
      return line.replace(this._eolRegex, (function(_this) {
        return function(match) {
          switch (_this.setting) {
            case 'crlf':
              return '\r\n';
            case 'cr':
              return '\r';
            case 'lf':
              return '\n';
            default:
              throw new Error("unsupported value for end_of_line: " + _this.setting);
          }
        };
      })(this));
    };


    /**
     * Infer the line ending, returning `undefined` if there is no line ending
     * @param {String} line
     */

    EndOfLine.prototype.inferLine = function(line) {
      var _ref;
      switch ((_ref = line.match(this._eolRegex)) != null ? _ref[0] : void 0) {
        case '\r\n':
          return 'crlf';
        case '\n':
          return 'lf';
        case '\r':
          return 'cr';
      }
    };

    return EndOfLine;

  })(LineRule);

  module.exports = EndOfLine;

}).call(this);
