// Generated by CoffeeScript 1.8.0
(function() {
  var EditorConfigError, IndentChar, LineRule, Rule, detectIndent,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  LineRule = require('../line-rule');

  Rule = require('../rule');

  detectIndent = require('detect-indent');

  EditorConfigError = require('../editorconfigerror');

  IndentChar = (function(_super) {
    __extends(IndentChar, _super);

    function IndentChar() {
      this.infer = __bind(this.infer, this);
      this.fixLine = __bind(this.fixLine, this);
      this.fix = __bind(this.fix, this);
      return IndentChar.__super__.constructor.apply(this, arguments);
    }


    /**
     * This actually isn't an official property. It's a combination of the
       `indent_style` and `indent_size` properties that's used internally to do
       them both at once.
     */

    IndentChar.prototype.propertyName = 'indent_char';

    IndentChar.prototype.fix = function() {
      return this.infer().then((function(_this) {
        return function(_detectedSetting) {
          _this._detectedSetting = _detectedSetting;
          if (_this._detectedSetting == null) {
            throw new Error('couldn\'t detect indentation');
          }
          if (_this.setting === _this._detectedSetting) {
            return;
          }
          _this._indentRegex = new RegExp("^(?:" + _this._detectedSetting + ")*");
          return IndentChar.__super__.fix.call(_this);
        };
      })(this));
    };

    IndentChar.prototype.fixLine = function(line) {
      var match, totalIndents;
      match = line.match(this._indentRegex)[0];
      totalIndents = match.length / this._detectedSetting.length;
      return Array(totalIndents + 1).join(this.setting) + line.slice(match.length);
    };

    IndentChar.prototype.check = Rule.prototype.check;

    IndentChar.prototype.infer = function() {
      return this.file.read({
        encoding: 'utf8'
      }).then(detectIndent);
    };

    return IndentChar;

  })(LineRule);

  module.exports = IndentChar;

}).call(this);
