// Generated by CoffeeScript 1.8.0
(function() {
  var LineRule, TrimTrailingWhitespace,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  LineRule = require('../line-rule');

  TrimTrailingWhitespace = (function(_super) {
    __extends(TrimTrailingWhitespace, _super);

    function TrimTrailingWhitespace() {
      this.inferLine = __bind(this.inferLine, this);
      this.infer = __bind(this.infer, this);
      this.fixLine = __bind(this.fixLine, this);
      return TrimTrailingWhitespace.__super__.constructor.apply(this, arguments);
    }

    TrimTrailingWhitespace.prototype.propertyName = 'trim_trailing_whitespace';


    /**
     * The first group is any trailing whitespace, and the 2nd group is the line
       ending (which might not be there if `insert_final_newline` is false).
     * @type {Regex}
     */

    TrimTrailingWhitespace.prototype._trailingWhitespace = /[^\S\r\n]+(\r\n|\n|\r|)$/;

    TrimTrailingWhitespace.prototype.fixLine = function(line) {
      var match;
      if (this.setting) {
        match = line.match(this._trailingWhitespace);
        if (match != null) {
          return line.slice(0, -match[0].length) + match[1];
        }
      }
      return line;
    };

    TrimTrailingWhitespace.prototype.infer = function() {
      return this.fileAsLines().then((function(_this) {
        return function(lines) {
          var line, _i, _len;
          for (_i = 0, _len = lines.length; _i < _len; _i++) {
            line = lines[_i];
            if (!_this.inferLine(line)) {
              return false;
            }
          }
          return true;
        };
      })(this));
    };

    TrimTrailingWhitespace.prototype.inferLine = function(line) {
      return !this._trailingWhitespace.test(line);
    };

    return TrimTrailingWhitespace;

  })(LineRule);

  module.exports = TrimTrailingWhitespace;

}).call(this);
