var Utils;(function(Utils){var Async=function(){function Async(){}Async.waitFor=function(test,successCallback,failureCallback,interval,maxTries,numTries){if(!interval)interval=200;if(!maxTries)maxTries=100;if(!numTries)numTries=0;numTries+=1;if(numTries>maxTries){if(failureCallback)failureCallback()}else if(test()){successCallback()}else{setTimeout(function(){Async.waitFor(test,successCallback,failureCallback,interval,maxTries,numTries)},interval)}};return Async}();Utils.Async=Async;var Bools=function(){function Bools(){}Bools.getBool=function(val,defaultVal){if(val===null||typeof val==="undefined"){return defaultVal}return val};return Bools}();Utils.Bools=Bools;var Clipboard=function(){function Clipboard(){}Clipboard.supportsCopy=function(){return document.queryCommandSupported&&document.queryCommandSupported("copy")};Clipboard.copy=function(text){text=Clipboard.convertBrToNewLine(text);var textArea=document.createElement("textarea");textArea.value=text;Clipboard.hideButKeepEnabled(textArea);document.body.appendChild(textArea);textArea.focus();textArea.select();document.execCommand("copy");document.body.removeChild(textArea)};Clipboard.hideButKeepEnabled=function(textArea){textArea.style.position="fixed";textArea.style.top="0";textArea.style.left="0";textArea.style.width="2em";textArea.style.height="2em";textArea.style.padding="0";textArea.style.border="none";textArea.style.outline="none";textArea.style.boxShadow="none";textArea.style.background="transparent"};Clipboard.convertBrToNewLine=function(text){var brRegex=/<br\s*[\/]?>/gi;text=text.replace(brRegex,"\n");return text};return Clipboard}();Utils.Clipboard=Clipboard;var Colors=function(){function Colors(){}Colors.float32ColorToARGB=function(float32Color){var a=(float32Color&4278190080)>>>24;var r=(float32Color&16711680)>>>16;var g=(float32Color&65280)>>>8;var b=float32Color&255;var result=[a,r,g,b];return result};Colors._componentToHex=function(c){var hex=c.toString(16);return hex.length==1?"0"+hex:hex};Colors.rgbToHexString=function(rgb){Colors.coalesce(rgb);return"#"+Colors._componentToHex(rgb[0])+Colors._componentToHex(rgb[1])+Colors._componentToHex(rgb[2])};Colors.argbToHexString=function(argb){return"#"+Colors._componentToHex(argb[0])+Colors._componentToHex(argb[1])+Colors._componentToHex(argb[2])+Colors._componentToHex(argb[3])};Colors.coalesce=function(arr){for(var i=1;i<arr.length;i++){if(typeof arr[i]==="undefined")arr[i]=arr[i-1]}};return Colors}();Utils.Colors=Colors;var Dates=function(){function Dates(){}Dates.getTimeStamp=function(){return(new Date).getTime()};return Dates}();Utils.Dates=Dates;var Device=function(){function Device(){}Device.getPixelRatio=function(ctx){var dpr=window.devicePixelRatio||1;var bsr=ctx.webkitBackingStorePixelRatio||ctx.mozBackingStorePixelRatio||ctx.msBackingStorePixelRatio||ctx.oBackingStorePixelRatio||ctx.backingStorePixelRatio||1;return dpr/bsr};Device.isTouch=function(){return!!("ontouchstart"in window)||window.navigator.msMaxTouchPoints>0};return Device}();Utils.Device=Device;var Documents=function(){function Documents(){}Documents.isInIFrame=function(){try{return window.self!==window.top}catch(e){return true}};Documents.supportsFullscreen=function(){var doc=document.documentElement;var support=doc.requestFullscreen||doc.mozRequestFullScreen||doc.webkitRequestFullScreen||doc.msRequestFullscreen;return support!==undefined};Documents.isHidden=function(){var prop=Documents.getHiddenProp();if(!prop)return false;return true};Documents.getHiddenProp=function(){var prefixes=["webkit","moz","ms","o"];if("hidden"in document)return"hidden";for(var i=0;i<prefixes.length;i++){if(prefixes[i]+"Hidden"in document){return prefixes[i]+"Hidden"}}return null};return Documents}();Utils.Documents=Documents;var Events=function(){function Events(){}Events.debounce=function(fn,debounceDuration){debounceDuration=debounceDuration||100;return function(){if(!fn.debouncing){var args=Array.prototype.slice.apply(arguments);fn.lastReturnVal=fn.apply(window,args);fn.debouncing=true}clearTimeout(fn.debounceTimeout);fn.debounceTimeout=setTimeout(function(){fn.debouncing=false},debounceDuration);return fn.lastReturnVal}};return Events}();Utils.Events=Events;var Files=function(){function Files(){}Files.simplifyMimeType=function(mime){switch(mime){case"text/plain":return"txt";case"image/jpeg":return"jpg";case"application/msword":return"doc";case"application/vnd.openxmlformats-officedocument.wordprocessingml.document":return"docx";default:var parts=mime.split("/");return parts[parts.length-1]}};return Files}();Utils.Files=Files;var Keyboard=function(){function Keyboard(){}Keyboard.getCharCode=function(e){var charCode=typeof e.which=="number"?e.which:e.keyCode;return charCode};return Keyboard}();Utils.Keyboard=Keyboard;var Maths=function(){function Maths(){}Maths.normalise=function(num,min,max){return(num-min)/(max-min)};Maths.median=function(values){values.sort(function(a,b){return a-b});var half=Math.floor(values.length/2);if(values.length%2){return values[half]}else{return(values[half-1]+values[half])/2}};Maths.clamp=function(value,min,max){return Math.min(Math.max(value,min),max)};return Maths}();Utils.Maths=Maths;var Size=function(){function Size(width,height){this.width=width;this.height=height}return Size}();Utils.Size=Size;var Dimensions=function(){function Dimensions(){}Dimensions.fitRect=function(width1,height1,width2,height2){var ratio1=height1/width1;var ratio2=height2/width2;var width=0;var height=0;var scale;if(ratio1<ratio2){scale=width2/width1;width=width1*scale;height=height1*scale}else{scale=height2/height1;width=width1*scale;height=height1*scale}return new Size(Math.floor(width),Math.floor(height))};Dimensions.hitRect=function(x,y,w,h,mx,my){if(mx>x&&mx<x+w&&my>y&&my<y+h){return true}return false};return Dimensions}();Utils.Dimensions=Dimensions;var Numbers=function(){function Numbers(){}Numbers.numericalInput=function(event){if(event.keyCode==46||event.keyCode==8||event.keyCode==9||event.keyCode==27||event.keyCode==65&&event.ctrlKey===true||event.keyCode>=35&&event.keyCode<=39){return true}else{if(event.shiftKey||(event.keyCode<48||event.keyCode>57)&&(event.keyCode<96||event.keyCode>105)){event.preventDefault();return false}return true}};return Numbers}();Utils.Numbers=Numbers;var Objects=function(){function Objects(){}Objects.toPlainObject=function(value){value=Object(value);var result={};for(var key in value){result[key]=value[key]}return result};return Objects}();Utils.Objects=Objects;var Storage=function(){function Storage(){}Storage.clear=function(storageType){if(storageType===void 0){storageType=StorageType.memory}switch(storageType.value){case StorageType.memory.value:this._memoryStorage={};break;case StorageType.session.value:sessionStorage.clear();break;case StorageType.local.value:localStorage.clear();break}};Storage.clearExpired=function(storageType){if(storageType===void 0){storageType=StorageType.memory}var items=this.getItems(storageType);for(var i=0;i<items.length;i++){var item=items[i];if(this._isExpired(item)){this.remove(item.key)}}};Storage.get=function(key,storageType){if(storageType===void 0){storageType=StorageType.memory}var data=null;switch(storageType.value){case StorageType.memory.value:data=this._memoryStorage[key];break;case StorageType.session.value:data=sessionStorage.getItem(key);break;case StorageType.local.value:data=localStorage.getItem(key);break}if(!data)return null;var item=null;try{item=JSON.parse(data)}catch(error){return null}if(!item)return null;if(this._isExpired(item))return null;item.key=key;return item};Storage._isExpired=function(item){if((new Date).getTime()<item.expiresAt){return false}return true};Storage.getItems=function(storageType){if(storageType===void 0){storageType=StorageType.memory}var items=[];switch(storageType.value){case StorageType.memory.value:var keys=Object.keys(this._memoryStorage);for(var i=0;i<keys.length;i++){var item=this.get(keys[i],StorageType.memory);if(item){items.push(item)}}break;case StorageType.session.value:for(var i=0;i<sessionStorage.length;i++){var key=sessionStorage.key(i);if(key){var item=this.get(key,StorageType.session);if(item){items.push(item)}}}break;case StorageType.local.value:for(var i=0;i<localStorage.length;i++){var key=localStorage.key(i);if(key){var item=this.get(key,StorageType.local);if(item){items.push(item)}}}break}return items};Storage.remove=function(key,storageType){if(storageType===void 0){storageType=StorageType.memory}switch(storageType.value){case StorageType.memory.value:delete this._memoryStorage[key];break;case StorageType.session.value:sessionStorage.removeItem(key);break;case StorageType.local.value:localStorage.removeItem(key);break}};Storage.set=function(key,value,expirationSecs,storageType){if(storageType===void 0){storageType=StorageType.memory}var expirationMS=expirationSecs*1e3;var record=new StorageItem;record.value=value;record.expiresAt=(new Date).getTime()+expirationMS;switch(storageType.value){case StorageType.memory.value:this._memoryStorage[key]=JSON.stringify(record);break;case StorageType.session.value:sessionStorage.setItem(key,JSON.stringify(record));break;case StorageType.local.value:localStorage.setItem(key,JSON.stringify(record));break}return record};Storage._memoryStorage={};return Storage}();Utils.Storage=Storage;var StorageItem=function(){function StorageItem(){}return StorageItem}();Utils.StorageItem=StorageItem;var StorageType=function(){function StorageType(value){this.value=value}StorageType.prototype.toString=function(){return this.value};StorageType.memory=new StorageType("memory");StorageType.session=new StorageType("session");StorageType.local=new StorageType("local");return StorageType}();Utils.StorageType=StorageType;var Strings=function(){function Strings(){}Strings.ellipsis=function(text,chars){if(text.length<=chars)return text;var trimmedText=text.substr(0,chars);var lastSpaceIndex=trimmedText.lastIndexOf(" ");if(lastSpaceIndex!=-1){trimmedText=trimmedText.substr(0,Math.min(trimmedText.length,lastSpaceIndex))}return trimmedText+"&hellip;"};Strings.htmlDecode=function(encoded){var div=document.createElement("div");div.innerHTML=encoded;return div.firstChild.nodeValue};Strings.format=function(str){var values=[];for(var _i=1;_i<arguments.length;_i++){values[_i-1]=arguments[_i]}for(var i=0;i<values.length;i++){var reg=new RegExp("\\{"+i+"\\}","gm");str=str.replace(reg,values[i])}return str};Strings.isAlphanumeric=function(str){return/^[a-zA-Z0-9]*$/.test(str)};Strings.toCssClass=function(str){return str.replace(/[^a-z0-9]/g,function(s){var c=s.charCodeAt(0);if(c==32)return"-";if(c>=65&&c<=90)return"_"+s.toLowerCase();return"__"+("000"+c.toString(16)).slice(-4)})};Strings.toFileName=function(str){return str.replace(/[^a-z0-9]/gi,"_").toLowerCase()};Strings.utf8_to_b64=function(str){return window.btoa(unescape(encodeURIComponent(str)))};return Strings}();Utils.Strings=Strings;var Urls=function(){function Urls(){}Urls.getHashParameter=function(key,doc){if(!doc)doc=window.document;if(doc&&doc.location){return this.getHashParameterFromString(key,doc.location.hash)}return null};Urls.getHashParameterFromString=function(key,url){var regex=new RegExp("#.*[?&]"+key+"=([^&]+)(&|$)");var match=regex.exec(url);return match?decodeURIComponent(match[1].replace(/\+/g," ")):null};Urls.setHashParameter=function(key,value,doc){if(!doc)doc=window.document;if(doc&&doc.location){var kvp=this.updateURIKeyValuePair(doc.location.hash.replace("#?",""),key,value);var newHash="#?"+kvp;var url=doc.URL;var index=url.indexOf("#");if(index!=-1){url=url.substr(0,url.indexOf("#"))}doc.location.replace(url+newHash)}};Urls.getQuerystringParameter=function(key,w){if(!w)w=window;return this.getQuerystringParameterFromString(key,w.location.search)};Urls.getQuerystringParameterFromString=function(key,querystring){key=key.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");var regex=new RegExp("[\\?&]"+key+"=([^&#]*)");var match=regex.exec(querystring);return match?decodeURIComponent(match[1].replace(/\+/g," ")):null};Urls.setQuerystringParameter=function(key,value,doc){if(!doc)doc=window.document;if(doc&&doc.location){var kvp=this.updateURIKeyValuePair(doc.location.hash.replace("#?",""),key,value);window.location.search=kvp}};Urls.updateURIKeyValuePair=function(uriSegment,key,value){key=encodeURIComponent(key);value=encodeURIComponent(value);var kvp=uriSegment.split("&");if(kvp[0]=="")kvp.shift();var i=kvp.length;var x;while(i--){x=kvp[i].split("=");if(x[0]==key){x[1]=value;kvp[i]=x.join("=");break}}if(i<0){kvp[kvp.length]=[key,value].join("=")}return kvp.join("&")};Urls.getUrlParts=function(url){var a=document.createElement("a");a.href=url;return a};Urls.convertToRelativeUrl=function(url){var parts=this.getUrlParts(url);var relUri=parts.pathname+parts.searchWithin;if(!relUri.startsWith("/")){relUri="/"+relUri}return relUri};return Urls}();Utils.Urls=Urls})(Utils||(Utils={}));window.Utils=Utils;
