import ComponentEvent from "./ComponentEvent";
export declare type AnyFunction = (...args: any[]) => any;
export declare type NoArguments = undefined | null | void | never;
export declare type EventMap = Record<string, any>;
export declare type EventKey<T> = string & keyof T;
export declare type EventHash<T extends EventMap, THIS> = Partial<{
    [K in EventKey<T>]: EventCallback<T, K, THIS>;
}>;
export declare type EventCallback<T extends EventMap, K extends EventKey<T>, THIS> = T[K] extends NoArguments ? () => any : T[K] extends AnyFunction ? T[K] : T[K] extends ComponentEvent<infer PROPS> ? (event: ComponentEvent<PROPS, K, THIS>) => any : (event: T[K]) => any;
export declare type EventTriggerParams<T, K extends EventKey<T>> = T[K] extends NoArguments ? void[] : T[K] extends AnyFunction ? Parameters<T[K]> : [T[K]];
export interface ComponentEventConstructor {
    new <PROPS extends Record<string, any>, TYPE extends string = string, THIS = any>(eventType: TYPE, props: PROPS): DefaultProps<TYPE, THIS> & PROPS;
    new <TYPE extends string = string, THIS = any>(eventType: TYPE): DefaultProps<TYPE, THIS>;
}
export interface DefaultProps<TYPE extends string, THIS> {
    eventType: TYPE;
    currentTarget: THIS;
    stop(): void;
    isCanceled(): boolean;
}
