import _mergeJSXProps from "@vue/babel-helper-vue-jsx-merge-props";
import menuMixin from "../../../mixin/menu";
import { appGetters, asideGetters, asideMutations } from "../../../store";
import Logo from '../../../component/Logo';
import NavMenu from '../../../component/NavMenu';
import Hamburger from '../../../component/Hamburger';
import LoadingSpinner from '../../../component/LoadingSpinner';
import { getRouterActiveMenu, isRedirectRouter } from "../../../config/logic";
export default {
  name: "DefaultSidebar",
  mixins: [menuMixin],

  data() {
    return {
      mouseOutside: true,
      openedMenuNum: 0
    };
  },

  computed: {
    sidebarMenus() {
      const menus = appGetters.menus;
      let finalData;
      if (appGetters.isMobile) finalData = menus;else {
        switch (appGetters.navMode) {
          case 'aside':
            finalData = menus;
            break;

          case 'mix':
            const root = menus.find(i => i.fullPath === appGetters.activeRootMenu);
            finalData = root ? root.children || [] : [];
            break;

          default:
            finalData = [];
        }
      }
      const f = asideGetters.postMenus;
      return f ? f(this.copyMenus(finalData)) : finalData;
    },

    renderInDrawer() {
      return appGetters.isMobile || asideGetters.autoHide;
    },

    drawerClass() {
      const behindHeader = !appGetters.isMobile && appGetters.struct === 'top-bottom';
      return `sidebar-drawer${behindHeader ? ' behind-header' : ''}`;
    },

    show() {
      if (asideGetters.show) return true;
      if (appGetters.isMobile) return false;
      if (!asideGetters.autoHide) return false;
      if (!this.mouseOutside) return true;
      return this.collapse && this.openedMenuNum > 0;
    },

    collapse() {
      return asideGetters.collapse && !appGetters.isMobile;
    },

    showLogo() {
      return appGetters.showLogo && (appGetters.isMobile || appGetters.struct === 'left-right');
    },

    sidebarClass() {
      return {
        'sidebar': true,
        'collapse': this.collapse
      };
    },

    sidebarEvent() {
      return !appGetters.isMobile && asideGetters.autoHide ? {
        mouseleave: this.onMouseLeave,
        mouseenter: this.onMouseEnter
      } : undefined;
    }

  },
  watch: {
    $route: {
      immediate: true,

      handler(to) {
        if (isRedirectRouter(to)) return;
        this.activeMenu = getRouterActiveMenu(this.$route);
        const elMenu = this.$_getElMenuInstance();
        if (!elMenu) return;
        this.resetActiveMenu();
        const item = elMenu.items[this.activeMenu];
        if (!item) return;
        this.onSelect(item.index, item.indexPath, item, false);
        this.$nextTick(this.moveToActiveMenuVertically);
      }

    }
  },
  methods: {
    copyMenus(menus) {
      return menus.map(menu => {
        const result = { ...menu
        };

        if (result.children) {
          result.children = this.copyMenus(result.children);
        }

        return result;
      });
    },

    onSelect(index, indexPath, item, jump = true) {
      if (!asideGetters.collapse && asideGetters.uniqueOpen) {
        const elMenu = this.$_getElMenuInstance();
        elMenu.openedMenus = indexPath.slice(0, -1);
      }

      jump && this.actionOnSelectMenu(index);

      if (this.renderInDrawer && this.show) {
        asideMutations.close();
        this.mouseOutside = true;
      }
    },

    moveToActiveMenuVertically() {
      const elMenu = this.$_getElMenuInstance();
      if (!elMenu) return;
      const cur = elMenu.activeIndex;
      if (!cur) return;
      const curInstance = elMenu.items[cur];
      if (!curInstance) return;
      let el = curInstance.$el;

      if (elMenu.collapse) {
        let rootParent = curInstance;

        while (rootParent.$parent.$options.componentName !== 'ElMenu') {
          rootParent = rootParent.$parent;
        }

        el = rootParent.$el;
      }

      window.setTimeout(() => el.scrollIntoView({
        behavior: 'smooth',
        block: 'nearest'
      }), 300);
    },

    onMouseMove(e) {
      if (e.clientX <= 1) this.mouseOutside = false;
    },

    onMouseLeave() {
      this.mouseOutside = true;
    },

    onMouseEnter() {
      this.mouseOutside = false;
    },

    watchOpenedMenus() {
      if (this.watchOpenedMenusCallback) {
        this.watchOpenedMenusCallback();
        this.watchOpenedMenusCallback = null;
      }

      const elMenu = this.$_getElMenuInstance();
      if (!elMenu) return;
      this.watchOpenedMenusCallback = elMenu.$watch('openedMenus', v => {
        this.openedMenuNum = v.length;
      });
    },

    onDrawerOpened() {
      this.$nextTick(this.moveToActiveMenuVertically);
    },

    renderHeader(h) {
      const defaultContent = this.showLogo && h(Logo, {
        "attrs": {
          "show-title": !this.collapse
        }
      });
      const {
        headerSlot
      } = asideGetters;
      return headerSlot ? headerSlot(h, defaultContent) : defaultContent;
    },

    renderFooter(h) {
      const defaultContent = asideGetters.showHamburger && !this.renderInDrawer && h(Hamburger);
      const {
        footerSlot
      } = asideGetters;
      let children;

      if (footerSlot) {
        let renderResult = footerSlot(h, defaultContent);

        if (Array.isArray(renderResult)) {
          renderResult = renderResult.filter(Boolean);

          if (renderResult.length > 0) {
            children = renderResult;
          }
        } else children = renderResult;
      } else children = defaultContent;

      return children && h("div", {
        "class": "sidebar-footer"
      }, [children]);
    }

  },

  created() {
    this.$watch('sidebarMenus', this.setDefaultActiveMenu, {
      immediate: true
    });
    this.$watch(() => {
      if (appGetters.isMobile) return false;
      if (!asideGetters.autoHide) return false;
      if (this.show) return false;
      return this.mouseOutside;
    }, v => {
      window.removeEventListener('mousemove', this.onMouseMove);
      v && window.addEventListener('mousemove', this.onMouseMove);
    }, {
      immediate: true
    });
    this.$watch(() => appGetters.isMobile, v => (v || asideGetters.autoHide) && asideMutations.close());
  },

  beforeDestroy() {
    window.removeEventListener('mousemove', this.onMouseMove);
  },

  render(h) {
    if (this.sidebarMenus.length === 0 && !asideGetters.alwaysRender) {
      return;
    }

    const sidebar = h("div", _mergeJSXProps([{}, {
      class: this.sidebarClass,
      on: this.sidebarEvent
    }]), [this.renderHeader(h), appGetters.loadingMenu ? h("div", {
      "style": "position: relative;flex: 1"
    }, [h(LoadingSpinner)]) : h(NavMenu, {
      "ref": "nav-menu",
      "attrs": {
        "menus": this.sidebarMenus,
        "collapse": this.collapse,
        "default-active": this.defaultActive,
        "default-openeds": asideGetters.defaultOpeneds,
        "theme": asideGetters.theme,
        "unique-opened": asideGetters.uniqueOpen,
        "show-parent-on-collapse": asideGetters.showParentOnCollapse,
        "inline-indent": asideGetters.inlineIndent,
        "switch-transition-name": asideGetters.switchTransitionName,
        "menu-icon-slot": asideGetters.menuIconSlot,
        "menu-content-slot": asideGetters.menuContentSlot
      },
      "on": { ...{
          select: this.onSelect,
          'hook:mounted': this.watchOpenedMenus
        }
      }
    }), this.renderFooter(h)]);
    if (!this.renderInDrawer) return sidebar;
    return h("el-drawer", {
      "attrs": {
        "visible": this.show,
        "with-header": false,
        "custom-class": this.drawerClass,
        "modal": appGetters.isMobile,
        "direction": "ltr",
        "size": "auto"
      },
      "on": {
        "close": asideMutations.close,
        "opened": this.onDrawerOpened
      }
    }, [sidebar]);
  }

};