/**
 * 右键菜单，用于页签栏，右键点击页签时弹出
 */

var __render__ = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('ul',{directives:[{name:"show",rawName:"v-show",value:(_vm.value),expression:"value"}],staticClass:"context-menu",style:(_vm.style)},_vm._l((_vm.menuItems),function(i){return _c('li',{key:i.content,staticClass:"context-menu-item",on:{"click":i.click}},[_vm._v("\n        "+_vm._s(i.content)+"\n    ")])}),0)}
var __staticRenderFns__ = []

const __component__ = {
    name: "ContextMenu",

    props: {
        value: Boolean,
        items: Array,
        left: Number,
        top: Number
    },

    data() {
        return {
            realLeft: '0px',
            realTop: '0px'
        }
    },

    computed: {
        style() {
            return {left: this.realLeft, top: this.realTop}
        },

        menuItems() {
            return this.items.filter(Boolean)
        }
    },

    watch: {
        value(v) {
            document.body[v ? 'addEventListener' : 'removeEventListener']('click', this.close)
            v && this.$nextTick(this.autoAdapt)
        },
        left(v) {
            v && this.autoAdaptLeft(v)
        },
        top(v) {
            v && this.autoAdaptTop(v)
        }
    },

    methods: {
        close() {
            this.$emit('input', false)
        },
        autoAdapt() {
            this.autoAdaptTop(this.top)
            this.autoAdaptLeft(this.left)
        },
        autoAdaptTop(v) {
            if (!this.value) return

            const elOffsetHeight = this.$el.offsetHeight

            if (elOffsetHeight > document.body.clientHeight - v && v > elOffsetHeight) {
                this.realTop = v - elOffsetHeight + 'px'
            }
            else this.realTop = v + 'px'
        },
        autoAdaptLeft(v) {
            if (!this.value) return

            const elOffsetWidth = this.$el.offsetWidth

            if (elOffsetWidth > document.body.clientWidth - v) {
                this.realLeft = v - elOffsetWidth + 'px'
            }
            else this.realLeft = v + 'px'
        }
    }
}

__component__.render = __render__
__component__._compiled = true

export default __component__