import { Const } from '../../config';
import Aside from '../Aside';
import Header from '../Header';
import TagsView from '../TagsView';
import Page from '../Page';
import { appGetters, appMutations, asideMutations, headerMutations, tagsViewGetters, tagsViewMutations, pageMutations } from "../../store";
import { isMobile } from "../../helper";
import { debounce } from "../../util";
export default {
  name: 'ElAdminLayout',
  computed: {
    isLeftRight() {
      return appGetters.struct === 'left-right';
    },

    renderAside() {
      return appGetters.isMobile || ['aside', 'mix'].includes(appGetters.navMode);
    }

  },
  methods: {
    mutateStoreSlot() {
      const cache = this.$_cachedScopedSlots;
      const curr = this.$scopedSlots;
      Object.keys(cache).forEach(k => {
        if (!curr[k]) {
          const f = this.getMutationBySlot(k);
          f(undefined);
        }
      });
      Object.keys(curr).forEach(k => {
        if (!cache[k]) {
          const f = this.getMutationBySlot(k);
          f((h, props) => curr[k](props));
        }
      });
      this.$_cachedScopedSlots = curr;
    },

    getMutations(prefix) {
      switch (prefix) {
        case 'app':
          return appMutations;

        case 'aside':
          return asideMutations;

        case 'header':
          return headerMutations;

        case 'tagsView':
          return tagsViewMutations;

        case 'page':
          return pageMutations;
      }
    },

    getMutationBySlot(slot) {
      const cache = this.$_slotMutationsMap;
      if (cache[slot]) return cache[slot];

      if (slot === 'logo') {
        cache[slot] = appMutations.logoSlot;
        return cache[slot];
      }

      const arr = slot.split('-');
      const mutations = this.getMutations(arr[0]);

      if (arr.length === 1) {
        cache[slot] = mutations.defaultSlot;
      } else {
        let method = arr[1];

        for (let i = 2, len = arr.length; i < len; i++) {
          method += arr[i][0].toUpperCase() + [...arr[i].slice(1)].join('');
        }

        cache[slot] = mutations[method += 'Slot'];
      }

      return cache[slot];
    }

  },

  beforeCreate() {
    this.$_cachedScopedSlots = Object.create(null);
    this.$_slotMutationsMap = Object.create(null);
  },

  mounted() {
    this.$_resize = debounce(() => {
      !document.hidden && appMutations.isMobile(isMobile());
    });
    window.addEventListener('resize', this.$_resize);
  },

  beforeDestroy() {
    if (this.$_resize) {
      window.removeEventListener('resize', this.$_resize);
      delete this.$_resize;
    }

    delete this.$_cachedScopedSlots;
    delete this.$_slotMutationsMap;
  },

  render() {
    const h = arguments[0];
    Const.enableLayoutSlot && this.mutateStoreSlot();
    return h("div", {
      "class": {
        'el-admin-layout': true,
        'has-header': true,
        'has-tags-view': tagsViewGetters.enabled,
        'left-right': this.isLeftRight
      }
    }, [h(Header, {
      "ref": "header"
    }), tagsViewGetters.enabled && h(TagsView, {
      "ref": "tags-view"
    }), this.renderAside && h(Aside, {
      "ref": "aside"
    }), h(Page, {
      "ref": "page"
    })]);
  }

};