import {pageGetters, pageMutations, tagsViewGetters} from "../../store"
import {getRouterKey} from "../../config/logic"
import {isEmpty} from "../../util"

var __render__ = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{directives:[{name:"show",rawName:"v-show",value:(_vm.showIframe),expression:"showIframe"}],staticClass:"page-iframe"},_vm._l((_vm.iframeList),function(src){return _c('iframe',{directives:[{name:"show",rawName:"v-show",value:(src === _vm.currentIframe),expression:"src === currentIframe"}],key:src,attrs:{"id":src,"src":src,"frameborder":"0","height":"100%","width":"100%"}})}),0)}
var __staticRenderFns__ = []

const __component__ = {
    name: "PageIframe",

    computed: {
        showIframe() {
            return pageGetters.showIframe
        },
        iframeList() {
            return pageGetters.iframeList
        },
        currentIframe() {
            return pageGetters.currentIframe
        }
    },

    watch: {
        $route: {
            handler(to, from) {
                this.iframeCtrl(to, from)
            },
            immediate: true
        }
    },

    methods: {
        //路由跳转时控制iframe的显隐
        iframeCtrl(to, from) {
            //从iframe页面离开时，判断是否需要删除iframe
            if (from && from.meta.iframe) {
                const key = getRouterKey(from)
                const del = isEmpty(key) || !tagsViewGetters.cachedViews.includes(key)

                pageMutations.closeIframe(from.meta.iframe, del)
            }

            //跳转至iframe页面时，打开iframe
            if (to.meta.iframe) {
                pageMutations.openIframe(to.meta.iframe)
            }
        }
    }
}

__component__.render = __render__
__component__._compiled = true

export default __component__