import MenuMixin from './mixin';
import { Submenu } from 'element-ui';
export default {
  name: Submenu.name,
  componentName: Submenu.componentName,
  mixins: [MenuMixin, ...Submenu.mixins.slice(1)],
  props: { ...Submenu.props,
    popperAppendToBody: {
      type: Boolean,
      default: true
    }
  },
  data: Submenu.data,
  computed: {
    appendToBody: Submenu.computed.appendToBody,
    menuTransitionName: Submenu.computed.menuTransitionName,
    opened: Submenu.computed.opened,
    active: Submenu.computed.active,
    mode: Submenu.computed.mode,
    isMenuPopup: Submenu.computed.isMenuPopup,
    isFirstLevel: Submenu.computed.isFirstLevel,

    className() {
      return {
        'el-submenu': true,
        'is-active': this.active,
        'is-opened': this.opened,
        'is-disabled': this.disabled
      };
    },

    submenuArrowClass() {
      const icon = this.rootMenu.mode === 'horizontal' && this.isFirstLevel || this.rootMenu.mode === 'vertical' && !this.rootMenu.collapse ? 'el-icon-arrow-down' : 'el-icon-arrow-right';
      return 'el-submenu__icon-arrow ' + icon;
    },

    popupMenuClass() {
      return `el-menu el-menu--popup el-menu--popup-${this.currentPlacement}`;
    }

  },
  watch: Submenu.watch,
  methods: Submenu.methods,
  created: Submenu.created,
  mounted: Submenu.mounted,
  beforeDestroy: Submenu.beforeDestroy,

  render() {
    const h = arguments[0];
    return h("li", {
      "class": this.className,
      "on": {
        "mouseenter": this.handleMouseenter,
        "mouseleave": () => this.handleMouseleave(false),
        "focus": this.handleMouseenter
      }
    }, [h("div", {
      "ref": "submenu-title",
      "class": "el-submenu__title",
      "style": this.paddingStyle,
      "on": {
        "click": this.handleClick
      }
    }, [this.$slots.title, h("i", {
      "class": this.submenuArrowClass
    })]), this.isMenuPopup ? h("transition", {
      "attrs": {
        "name": this.menuTransitionName
      }
    }, [h("div", {
      "ref": "menu",
      "directives": [{
        name: "show",
        value: this.opened
      }],
      "class": [`el-menu--${this.mode}`, this.popperClass],
      "on": {
        "mouseenter": e => this.handleMouseenter(e, 100),
        "mouseleave": () => this.handleMouseleave(true),
        "focus": e => this.handleMouseenter(e, 100)
      }
    }, [h("ul", {
      "class": this.popupMenuClass
    }, [this.$slots.default])])]) : h("el-collapse-transition", [h("ul", {
      "directives": [{
        name: "show",
        value: this.opened
      }],
      "class": "el-menu el-menu--inline"
    }, [this.$slots.default])])]);
  }

};