/**
 * @param h {CreateElement}
 * @param key {string}
 * @param active {boolean}
 * @param on {?Object<string, function>}
 * @param title {string}
 * @param close {?function}
 * @return {VNode}
 */
export default function (h, {key, active, on, title, close}) {
    const className = `tags-view-item${active ? ' active' : ''}`

    return (
        <div key={key} class={className} {...{on}}>
            <div class="tags-view-item__title">{title}</div>
            {close && (
                <div class="tags-view-item__close" on-click={close}>
                    <i class="el-icon-close"/>
                </div>
            )}
            <div class="tags-view-item__divider"/>
        </div>
    )
}
