import { appGetters, asideGetters, asideMutations } from '../../store';
export default {
  name: 'Hamburger',

  render() {
    const h = arguments[0];
    const collapsed = appGetters.isMobile ? asideGetters.show : !asideGetters.collapse;
    const className = `hamburger${collapsed ? ' collapsed' : ''}`;
    return h("div", {
      "class": className,
      "attrs": {
        "title": `${collapsed ? '折叠' : '展开'}侧边栏`
      },
      "on": {
        "click": asideMutations.switch
      }
    }, [h("i", {
      "class": "el-icon-s-unfold"
    })]);
  }

};