import { appGetters, headerGetters } from '../../store';
import Logo from '../../component/Logo';
import Hamburger from '../../component/Hamburger';
import HorizontalResizableMenu from '../../component/HorizontalResizableMenu';
import { refreshPage } from '../../helper';
import { isEmpty } from '../../util';
export default {
  name: 'Header',
  computed: {
    defaultLogo() {
      const h = this.$createElement;
      const renderLogo = !appGetters.isMobile && appGetters.showLogo && (appGetters.navMode === 'head' || appGetters.struct === 'top-bottom');
      return renderLogo && h(Logo, {
        "attrs": {
          "show-title": true
        }
      });
    },

    defaultHamburger() {
      const h = this.$createElement;
      return appGetters.isMobile && h(Hamburger, {
        "class": "header-item header-icon"
      });
    },

    defaultHeadMenu() {
      const h = this.$createElement;
      const renderHeadMenu = !appGetters.isMobile && ['head', 'mix'].includes(appGetters.navMode);
      return renderHeadMenu && h(HorizontalResizableMenu, {
        "ref": "head-menu"
      });
    },

    defaultRefreshBtn() {
      const h = this.$createElement;
      return h("div", {
        "attrs": {
          "title": "刷新"
        },
        "class": "header-item",
        "on": {
          "click": () => refreshPage(this.$router)
        }
      }, [h("i", {
        "class": "el-icon-refresh-right header-icon"
      })]);
    },

    defaultUserDropdown() {
      const h = this.$createElement;
      const {
        dropdownItemsSlot
      } = headerGetters;
      const {
        username
      } = headerGetters;
      return h("el-dropdown", {
        "class": "header-item"
      }, [h("div", {
        "class": "user-dropdown-reference"
      }, [h("el-avatar", {
        "attrs": {
          "size": 30,
          "src": headerGetters.avatar,
          "icon": "el-icon-user-solid"
        }
      }), !isEmpty(username) && h("span", {
        "class": "username hide-on-mobile"
      }, [username])]), h("el-dropdown-menu", {
        "slot": "dropdown",
        "class": `header-dropdown ${headerGetters.theme}`,
        "attrs": {
          "visible-arrow": false
        }
      }, [dropdownItemsSlot ? dropdownItemsSlot(this.$createElement) : headerGetters.dropdownItems.map(item => h("el-dropdown-item", {
        "attrs": {
          "icon": item.icon
        },
        "nativeOn": { ...{
            click: item.handler
          }
        }
      }, [item.content]))])]);
    }

  },
  methods: {
    renderLeftContent(h) {
      const defaultContent = [this.defaultLogo, this.defaultHamburger];
      const {
        leftSlot
      } = headerGetters;
      return leftSlot ? leftSlot(h, defaultContent) : defaultContent;
    },

    renderCenterContent(h) {
      const defaultContent = [this.defaultHeadMenu];
      const {
        centerSlot
      } = headerGetters;
      return centerSlot ? centerSlot(h, defaultContent) : defaultContent;
    },

    renderRightContent(h) {
      const defaultContent = [this.defaultRefreshBtn, this.defaultUserDropdown];
      const {
        rightSlot
      } = headerGetters;
      return rightSlot ? rightSlot(h, defaultContent) : defaultContent;
    }

  },

  render(h) {
    return h("header", {
      "class": `header ${headerGetters.theme}`
    }, [h("div", {
      "class": "header-left"
    }, [this.renderLeftContent(h)]), h("div", {
      "class": "header-center"
    }, [this.renderCenterContent(h)]), h("div", {
      "class": "header-right"
    }, [this.renderRightContent(h)])]);
  }

};