import { appGetters, asideGetters } from '../../store';
import DefaultSidebar from './DefaultSidebar';
export default {
  name: 'Aside',
  computed: {
    style() {
      return appGetters.isMobile ? 'z-index: auto !important' : undefined;
    }

  },

  render(h) {
    const {
      defaultSlot
    } = asideGetters;
    return h("aside", {
      "class": `aside ${asideGetters.theme}`,
      "style": this.style
    }, [defaultSlot ? defaultSlot(h) : h(DefaultSidebar, {
      "ref": "default-sidebar"
    })]);
  }

};