/**
 * 面包屑，用于页面（Page）的页头
 */

import { getMenuByFullPath } from '../../store'
import { getRouterKey, getRouterTitle, isRedirectRouter } from '../../config/logic'

const __component__ = {
  name: 'Breadcrumb',

  data() {
    return {
      items: []
    }
  },

  computed: {
    lastItem() {
      return this.items.length <= 1
        ? undefined
        : this.items[this.items.length - 1]
    }
  },

  watch: {
    $route: {
      handler(to) {
        const result = this.generateBreadcrumb(to)
        if (Array.isArray(result) && result.length !== 0) {
          this.items = result
        }
      },
      immediate: true
    }
  },

  methods: {
    onClick(fullPath) {
      let menu = getMenuByFullPath(fullPath)
      if (!menu) return

      // 找到其叶子菜单
      while (menu.children && menu.children.length >= 1) {
        menu = menu.children[0]
      }

      const { route } = this.$router.resolve(menu.fullPath)

      // 不刷新
      if (getRouterKey(route) !== getRouterKey(this.$route)) {
        this.$router.push(route)
      }
    },

    generateBreadcrumb(route) {
      const { path, fullPath, meta: { activeMenu } } = route

      // 刷新时返回undefined
      if (isRedirectRouter(route)) return

      // 使用route.path而非fullPath进行匹配
      const menuFullPath = activeMenu || path
      const menu = getMenuByFullPath(menuFullPath)

      // 没有匹配的菜单
      if (!menu) return []

      // 将菜单的所有父级放入数组
      const items = [menu]
      let parent = menu.parent
      while (parent) {
        items.unshift(parent)
        parent = parent.parent
      }

      // 使用了activeMenu的还需要拼接上自己的标题
      if (activeMenu) {
        items.push({
          fullPath,
          meta: { title: getRouterTitle(route) }
        })
      }

      return items
    }
  }
}
var __render__ = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"breadcrumb"},[_c('transition-group',{attrs:{"name":"breadcrumb"}},[_vm._l((_vm.items),function(ref,index){
var fullPath = ref.fullPath;
var title = ref.meta.title;
return (index !== _vm.items.length - 1)?_c('div',{key:fullPath,staticClass:"breadcrumb-item"},[_c('span',{staticClass:"breadcrumb-inner is-link",on:{"click":function () { return _vm.onClick(fullPath); }}},[_vm._v("\n        "+_vm._s(title)+"\n      ")]),_vm._v(" "),_c('span',{staticClass:"breadcrumb-separator"},[_vm._v("/")])]):_vm._e()}),_vm._v(" "),(_vm.lastItem)?_c('div',{key:_vm.lastItem.fullPath,staticClass:"breadcrumb-item"},[_c('span',{staticClass:"breadcrumb-inner"},[_vm._v(_vm._s(_vm.lastItem.meta.title))])]):_vm._e()],2)],1)}
var __staticRenderFns__ = []
__component__.render = __render__
__component__.staticRenderFns = __staticRenderFns__
__component__._compiled = true
export default __component__