/**
 * 水平滚动区域，能够通过鼠标滚轮来进行水平滚动，用于页签栏
 * 借鉴[vue-element-admin](https://github.com/PanJiaChen/vue-element-admin)
 */

const __component__ = {
  name: 'HorizontalScroller',

  props: {
    // 元素之间的距离（px）
    between: { type: Number, default: 4 }
  },

  methods: {
    /**
     * @param e {WheelEvent}
     */
    handleScroll(e) {
      const eventDelta = e.deltaY
      const { scrollLeft, scrollWidth, clientWidth } = this.$el

      /**
       * ①滚轮向上滚动并且是最左边
       * ②滚轮向下滚动并且是最右边
       */
      if (eventDelta < 0 && scrollLeft === 0
        || eventDelta > 0 && scrollWidth <= scrollLeft + clientWidth) {
        return
      }

      this.$el.scrollLeft += eventDelta
    },

    /**
     * 将指定元素以及其相邻元素移动至视窗内，外部调用
     * @param target {Element}
     */
    moveToTarget(target) {
      const nodes = Array.from(this.$el.children)
      const { offsetWidth: containerWidth, scrollWidth, scrollLeft } = this.$el

      if (containerWidth >= scrollWidth) return

      let first = null
      let last = null

      // find first el and last el
      if (nodes.length > 0) {
        first = nodes[0]
        last = nodes[nodes.length - 1]
      }

      if (first === target) {
        return this.scrollLeft(0)
      }
      if (last === target) {
        return this.scrollLeft(scrollWidth - containerWidth)
      }

      // find prev and next
      const currentIndex = nodes.findIndex(item => item === target)
      const prev = nodes[currentIndex - 1]
      const next = nodes[currentIndex + 1]

      // the el's offsetLeft after of next
      const afterNextOffsetLeft = next.offsetLeft + next.offsetWidth + this.between

      // the el's offsetLeft before of prev
      const beforePrevOffsetLeft = prev.offsetLeft - this.between

      if (afterNextOffsetLeft > scrollLeft + containerWidth) {
        this.scrollLeft(afterNextOffsetLeft - containerWidth)
      }
      else if (beforePrevOffsetLeft < scrollLeft) {
        this.scrollLeft(beforePrevOffsetLeft)
      }
    },

    scrollLeft(val) {
      this.$el.scrollTo({ left: val, behavior: 'smooth' })
    }
  }
}
var __render__ = function () {var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"horizontal-scroller",on:{"wheel":_vm.handleScroll}},[_vm._t("default")],2)}
var __staticRenderFns__ = []
__component__.render = __render__
__component__.staticRenderFns = __staticRenderFns__
__component__._compiled = true
export default __component__