/*!
 * el-select-tree v1.1.3
 * (c) 2019-2021 yujinpan
 * Released under the MIT License.
 */

import 'core-js/modules/es6.number.constructor';
import Vue from 'vue';
import Emitter from 'element-ui/lib/mixins/emitter';
import { addResizeListener, removeResizeListener } from 'element-ui/lib/utils/resize-event';
import styleInject from 'style-inject/dist/style-inject.es.js';
import __vue_normalize__ from 'vue-runtime-helpers/dist/normalize-component.js';

var script = {
  name: 'ElSelectTree',
  mixins: [Emitter],
  model: {
    prop: 'value',
    event: 'change'
  },
  props: {
    data: {
      type: Array,
      default: function _default() {
        return [];
      }
    },
    props: {
      type: Object,
      default: function _default() {
        return {
          value: 'value',
          label: 'label',
          children: 'children',
          disabled: 'disabled',
          isLeaf: 'isLeaf'
        };
      }
    },
    checkStrictly: Boolean,
    nodeKey: String,
    defaultExpandAll: Boolean,
    lazy: Boolean,
    load: Function,
    iconClass: String,
    indent: Number,
    accordion: Boolean,
    filterNodeMethod: Function,
    autoExpandParent: {
      type: Boolean,
      default: true
    },
    renderContent: Function,
    renderAfterExpand: Boolean,
    clearable: Boolean,
    placeholder: {
      type: String,
      default: '请选择'
    },
    placement: {
      type: String,
      default: 'bottom-start'
    },
    size: {
      type: String,
      default: Vue.prototype.$ELEMENT ? Vue.prototype.$ELEMENT.size : ''
    },
    disabled: Boolean,
    multiple: Boolean,
    value: {
      type: [Number, String, Array],
      default: ''
    },
    popoverWidth: Number
  },
  computed: {
    propsValue: function propsValue() {
      return this.nodeKey || this.props.value || 'value';
    },
    propsLabel: function propsLabel() {
      return this.props.label || 'label';
    },
    propsIsLeaf: function propsIsLeaf() {
      return this.props.isLeaf || 'isLeaf';
    },
    defaultExpandedKeys: function defaultExpandedKeys() {
      return Array.isArray(this.value) ? this.value : this.value || this.value === 0 ? [this.value] : [];
    }
  },
  data: function data() {
    return {
      visible: false,
      selectedLabel: '',
      minWidth: 0
    };
  },
  methods: {
    valueChange: function valueChange(value, node) {
      this.$emit('change', value, node);
    },
    clear: function clear() {
      var _this = this;

      this.visible = false;

      if (this.multiple) {
        this.valueChange([]);
        this.$nextTick(function () {
          _this.$refs.elTree.setCheckedKeys([]);
        });
      } else {
        this.valueChange('');
      }

      this.$emit('clear');
    },
    handleScroll: function handleScroll() {
      this.$refs.scrollbar && this.$refs.scrollbar.handleScroll();
    },
    nodeClick: function nodeClick(data, node, component) {
      var children = data[this.props.children];
      var value = data[this.propsValue];

      if ((children && children.length || this.lazy && !data[this.propsIsLeaf]) && !this.checkStrictly) {
        component.handleExpandIconClick();
      } else if (!this.multiple && !data.disabled) {
        if (value !== this.value) {
          this.valueChange(value, data);
          this.selectedLabel = data[this.propsLabel];
        }

        this.visible = false;
      }
    },
    checkChange: function checkChange() {
      var elTree = this.$refs.elTree;
      var leafOnly = !this.checkStrictly;
      var keys = elTree.getCheckedKeys(leafOnly);
      var nodes = elTree.getCheckedNodes(leafOnly);
      this.valueChange(keys, nodes);
      this.setMultipleSelectedLabel();
    },
    setSelected: function setSelected() {
      var _this2 = this;

      this.$nextTick(function () {
        var elTree = _this2.$refs.elTree;

        if (_this2.multiple) {
          elTree.setCheckedKeys(_this2.value);

          _this2.setMultipleSelectedLabel();
        } else {
          var selectedNode = elTree.getNode(_this2.value);
          _this2.selectedLabel = selectedNode ? selectedNode.data[_this2.propsLabel] : '';
        }
      });
    },
    setMultipleSelectedLabel: function setMultipleSelectedLabel() {
      var _this3 = this;

      var elTree = this.$refs.elTree;
      var selectedNodes = elTree.getCheckedNodes(!this.checkStrictly);
      this.selectedLabel = selectedNodes.map(function (item) {
        return item[_this3.propsLabel];
      }).join(',');
    },
    treeItemClass: function treeItemClass(data) {
      return {
        'is-selected': this.multiple ? false : data[this.propsValue] === this.value,
        'is-disabled': data.disabled
      };
    },
    handleResize: function handleResize() {
      this.minWidth = this.$el.clientWidth - 2;
    }
  },
  watch: {
    value: function value() {
      this.setSelected();
      this.dispatch('ElFormItem', 'el.form.change');
    },
    data: function data() {
      this.setSelected();
    }
  },
  created: function created() {
    if (this.multiple && !Array.isArray(this.value)) {
      throw new Error('[el-select-tree] props `value` must be Array if use multiple!');
    }
  },
  mounted: function mounted() {
    this.setSelected();
    addResizeListener(this.$el, this.handleResize);
  },
  beforeDestroy: function beforeDestroy() {
    if (this.$el && this.handleResize) {
      removeResizeListener(this.$el, this.handleResize);
    }
  }
};

var css_248z = ".el-select-tree{display:inline-block}.el-select-tree .el-input__icon{cursor:pointer;-webkit-transition:-webkit-transform .3s;transition:-webkit-transform .3s;transition:transform .3s;transition:transform .3s,-webkit-transform .3s}.el-select-tree .el-input__icon-close{display:none}.el-select-tree .el-input__inner{cursor:pointer;padding-right:30px}.el-select-tree .el-input:hover:not(.is-disabled) .el-input__inner{border-color:#c0c4cc}.el-select-tree .el-input:hover:not(.is-disabled).is-selected.is-clearable .el-input__icon-close{display:inline-block}.el-select-tree .el-input:hover:not(.is-disabled).is-selected.is-clearable .el-input__icon-arrow-down{display:none}.el-select-tree .el-input.is-active .el-input__icon-arrow-down{-webkit-transform:rotate(-180deg);-ms-transform:rotate(-180deg);transform:rotate(-180deg)}.el-select-tree .el-input.is-active .el-input__inner{border-color:#409eff}.el-select-tree__popover{padding:0!important;border:1px solid #e4e7ed!important;border-radius:4px!important}.el-select-tree__popover .popper__arrow{left:35px!important}.el-select-tree__popover .el-tree-node__expand-icon.is-leaf{cursor:pointer}.el-select-tree__list{overflow-y:auto}.el-select-tree__list::-webkit-scrollbar-track-piece{background:#d3dce6}.el-select-tree__list::-webkit-scrollbar{width:4px}.el-select-tree__list::-webkit-scrollbar-thumb{background:#99a9bf}.el-select-tree__item{position:relative;white-space:nowrap;padding-right:20px}.el-select-tree__item.is-selected{color:#409eff;font-weight:bolder}.el-select-tree__item.is-disabled{color:#bbb;cursor:not-allowed}";
styleInject(css_248z);

/* script */
var __vue_script__ = script;
/* template */

var __vue_render__ = function __vue_render__() {
  var _vm = this;

  var _h = _vm.$createElement;

  var _c = _vm._self._c || _h;

  return _c('div', {
    staticClass: "el-select-tree"
  }, [_c('el-popover', {
    ref: "elPopover",
    attrs: {
      "transition": "el-zoom-in-top",
      "popper-class": "el-select-tree__popover",
      "trigger": "click",
      "disabled": _vm.disabled,
      "placement": _vm.placement,
      "width": _vm.popoverWidth
    },
    on: {
      "after-enter": function afterEnter($event) {
        return _vm.handleScroll();
      }
    },
    model: {
      value: _vm.visible,
      callback: function callback($$v) {
        _vm.visible = $$v;
      },
      expression: "visible"
    }
  }, [_c('el-scrollbar', {
    ref: "scrollbar",
    attrs: {
      "wrap-class": "el-select-dropdown__wrap",
      "view-class": "el-select-dropdown__list"
    }
  }, [_c('el-tree', {
    ref: "elTree",
    staticClass: "el-select-tree__list",
    style: {
      'min-width': _vm.minWidth + 'px'
    },
    attrs: {
      "default-expanded-keys": _vm.defaultExpandedKeys,
      "show-checkbox": _vm.multiple,
      "expand-on-click-node": _vm.multiple,
      "data": _vm.data,
      "props": _vm.props,
      "node-key": _vm.propsValue,
      "default-expand-all": _vm.defaultExpandAll,
      "check-strictly": _vm.checkStrictly,
      "lazy": _vm.lazy,
      "load": _vm.load,
      "icon-class": _vm.iconClass,
      "indent": _vm.indent,
      "accordion": _vm.accordion,
      "filter-node-method": _vm.filterNodeMethod,
      "auto-expand-parent": _vm.autoExpandParent,
      "render-content": _vm.renderContent,
      "render-after-expand": _vm.renderAfterExpand
    },
    on: {
      "node-click": _vm.nodeClick,
      "check-change": _vm.checkChange
    },
    nativeOn: {
      "transitionend": function transitionend($event) {
        return _vm.$refs.elPopover.updatePopper();
      }
    },
    scopedSlots: _vm._u([{
      key: "default",
      fn: function fn(ref) {
        var data = ref.data;
        return _c('div', {
          staticClass: "el-select-tree__item",
          class: _vm.treeItemClass(data)
        }, [_vm._v("\n          " + _vm._s(data[_vm.propsLabel]) + "\n        ")]);
      }
    }])
  })], 1), _c('el-input', {
    ref: "reference",
    class: {
      'is-active': _vm.visible,
      'is-selected': _vm.selectedLabel,
      'is-clearable': _vm.clearable
    },
    attrs: {
      "slot": "reference",
      "readonly": "",
      "validate-event": false,
      "size": _vm.size,
      "disabled": _vm.disabled,
      "placeholder": _vm.placeholder
    },
    slot: "reference",
    model: {
      value: _vm.selectedLabel,
      callback: function callback($$v) {
        _vm.selectedLabel = $$v;
      },
      expression: "selectedLabel"
    }
  }, [_vm.clearable ? _c('i', {
    staticClass: "el-input__icon el-input__icon-close el-icon-circle-close",
    attrs: {
      "slot": "suffix"
    },
    on: {
      "click": function click($event) {
        $event.stopPropagation();
        return _vm.clear();
      }
    },
    slot: "suffix"
  }) : _vm._e(), _c('i', {
    staticClass: "el-input__icon el-input__icon-arrow-down el-icon-arrow-down",
    attrs: {
      "slot": "suffix"
    },
    slot: "suffix"
  })])], 1)], 1);
};

var __vue_staticRenderFns__ = [];
/* style */

var __vue_inject_styles__ = undefined;
/* scoped */

var __vue_scope_id__ = undefined;
/* module identifier */

var __vue_module_identifier__ = undefined;
/* functional template */

var __vue_is_functional_template__ = false;
/* style inject */

/* style inject SSR */

/* style inject shadow dom */

var __vue_component__ =
/*#__PURE__*/
__vue_normalize__({
  render: __vue_render__,
  staticRenderFns: __vue_staticRenderFns__
}, __vue_inject_styles__, __vue_script__, __vue_scope_id__, __vue_is_functional_template__, __vue_module_identifier__, false, undefined, undefined, undefined);

__vue_component__.install = function (Vue) {
  Vue.component('ElSelectTree', __vue_component__);
};

export default __vue_component__;
