/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiAccordion } from './accordion';

try {
  EuiAccordion.__docgenInfo = {
    description: '',
    displayName: 'EuiAccordion',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      buttonClassName: {
        defaultValue: null,
        description: 'Class that will apply to the trigger for the accordion.',
        name: 'buttonClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      buttonContentClassName: {
        defaultValue: null,
        description: 'Class that will apply to the trigger content for the accordion.',
        name: 'buttonContentClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      buttonContent: {
        defaultValue: null,
        description: 'The content of the clickable trigger',
        name: 'buttonContent',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      extraAction: {
        defaultValue: null,
        description: 'Will appear right aligned against the button. Useful for separate actions like deletions.',
        name: 'extraAction',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      initialIsOpen: {
        defaultValue: null,
        description: 'The accordion will start in the open state.',
        name: 'initialIsOpen',
        parent: undefined,
        required: true,
        type: {
          name: 'boolean'
        }
      },
      onToggle: {
        defaultValue: null,
        description: 'Optional callback method called on open and close with a single `isOpen` parameter',
        name: 'onToggle',
        parent: undefined,
        required: false,
        type: {
          name: '(isOpen: boolean) => void'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: 'The padding around the exposed accordion content.',
        name: 'paddingSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "none" | "xs" | "l" | "xl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }]
        }
      },
      arrowDisplay: {
        defaultValue: null,
        description: 'Placement of the arrow indicator, or \'none\' to hide it.\nPlacing on the `right` doesn\'t work with `extraAction` and so it will be ignored',
        name: 'arrowDisplay',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"left" | "right" | "none"',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"none"'
          }]
        }
      },
      forceState: {
        defaultValue: null,
        description: 'Control the opening of accordion via prop',
        name: 'forceState',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"closed" | "open"',
          value: [{
            value: '"closed"'
          }, {
            value: '"open"'
          }]
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Change `extraAction` and children into a loading spinner',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoadingMessage: {
        defaultValue: null,
        description: 'Choose whether the loading message replaces the content. Customize the message by passing a node',
        name: 'isLoadingMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}