function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { forwardRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keysOf } from '../../common';
var gutterSizeToClassNameMap = {
  none: null,
  xs: 'euiBadgeGroup--gutterExtraSmall',
  s: 'euiBadgeGroup--gutterSmall'
};
export var GUTTER_SIZES = keysOf(gutterSizeToClassNameMap);
export var EuiBadgeGroup = forwardRef(function (_ref, ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'xs' : _ref$gutterSize,
      rest = _objectWithoutProperties(_ref, ["children", "className", "gutterSize"]);

  var classes = classNames('euiBadgeGroup', gutterSizeToClassNameMap[gutterSize], className);
  return React.createElement("div", _extends({
    className: classes,
    ref: ref
  }, rest), React.Children.map(children, function (child) {
    return React.createElement("span", {
      className: "euiBadgeGroup__item"
    }, child);
  }));
});
EuiBadgeGroup.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
     * Space between badges
     */
  gutterSize: PropTypes.oneOf(["none", "xs", "s"]),

  /**
     * Should be a list of EuiBadge's but can also be any other element
     * Will apply an extra class to add spacing
     */
  children: PropTypes.node
};
EuiBadgeGroup.displayName = 'EuiBadgeGroup';

try {
  EuiBadgeGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiBadgeGroup',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'Should be a list of EuiBadge\'s but can also be any other element\nWill apply an extra class to add spacing',
        name: 'children',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'DOMAttributes'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      gutterSize: {
        defaultValue: null,
        description: 'Space between badges',
        name: 'gutterSize',
        parent: {
          fileName: 'eui/src/components/badge/badge_group/badge_group.tsx',
          name: 'EuiBadgeGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "none" | "xs"',
          value: [{
            value: '"s"'
          }, {
            value: '"none"'
          }, {
            value: '"xs"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}