/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiBadge } from './badge';
export { EuiBetaBadge } from './beta_badge';
export { EuiNotificationBadge } from './notification_badge';
export { EuiBadgeGroup } from './badge_group';

try {
  EuiBadge.__docgenInfo = {
    description: '',
    displayName: 'EuiBadge',
    methods: [],
    props: {
      iconType: {
        defaultValue: null,
        description: 'Accepts any string from our icon library',
        name: 'iconType',
        parent: undefined,
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSide: {
        defaultValue: null,
        description: 'The side of the badge the icon should sit',
        name: 'iconSide',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      color: {
        defaultValue: null,
        description: 'Accepts either our palette colors (primary, secondary ..etc) or a hex value `#FFFFFF`, `#000`.',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: 'Will override any color passed through the `color` prop.',
        name: 'isDisabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      closeButtonProps: {
        defaultValue: null,
        description: 'Props passed to the close button.',
        name: 'closeButtonProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<EuiIconProps>'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      iconOnClick: {
        defaultValue: null,
        description: 'Will apply an onclick to icon within the badge',
        name: 'iconOnClick',
        parent: {
          fileName: 'eui/src/components/badge/badge.tsx',
          name: 'WithIconOnClick'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      },
      iconOnClickAriaLabel: {
        defaultValue: null,
        description: 'Aria label applied to the iconOnClick button',
        name: 'iconOnClickAriaLabel',
        parent: {
          fileName: 'eui/src/components/badge/badge.tsx',
          name: 'WithIconOnClick'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: 'Will apply an onclick to the badge itself',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      onClickAriaLabel: {
        defaultValue: null,
        description: 'Aria label applied to the onClick button',
        name: 'onClickAriaLabel',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiBetaBadge.__docgenInfo = {
    description: '',
    displayName: 'EuiBetaBadge',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      iconType: {
        defaultValue: null,
        description: 'Supply an icon type if the badge should just be an icon',
        name: 'iconType',
        parent: undefined,
        required: false,
        type: {
          name: 'IconType'
        }
      },
      label: {
        defaultValue: null,
        description: 'One word label like "Beta" or "Lab"\nOne word label like "Beta" or "Lab"',
        name: 'label',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      tooltipContent: {
        defaultValue: null,
        description: 'Content for the tooltip',
        name: 'tooltipContent',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      tooltipPosition: {
        defaultValue: null,
        description: 'Custom position of the tooltip',
        name: 'tooltipPosition',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      title: {
        defaultValue: null,
        description: 'Optional title will be supplied as tooltip title or title attribute\notherwise the label will be used',
        name: 'title',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiNotificationBadge.__docgenInfo = {
    description: '',
    displayName: 'EuiNotificationBadge',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      size: {
        defaultValue: null,
        description: '',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/badge/notification_badge/badge_notification.tsx',
          name: 'EuiNotificationBadgeProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }]
        }
      },
      color: {
        defaultValue: null,
        description: '',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/badge/notification_badge/badge_notification.tsx',
          name: 'EuiNotificationBadgeProps'
        },
        required: false,
        type: {
          name: 'string | number'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiBadgeGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiBadgeGroup',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'Should be a list of EuiBadge\'s but can also be any other element\nWill apply an extra class to add spacing',
        name: 'children',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'DOMAttributes'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      gutterSize: {
        defaultValue: null,
        description: 'Space between badges',
        name: 'gutterSize',
        parent: {
          fileName: 'eui/src/components/badge/badge_group/badge_group.tsx',
          name: 'EuiBadgeGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "none" | "xs"',
          value: [{
            value: '"s"'
          }, {
            value: '"none"'
          }, {
            value: '"xs"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}