/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiBasicTable } from './basic_table';
export { EuiInMemoryTable } from './in_memory_table';
export {} from './table_types';

try {
  EuiBasicTable.__docgenInfo = {
    description: '',
    displayName: 'EuiBasicTable',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      itemId: {
        defaultValue: null,
        description: '',
        name: 'itemId',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'ItemId<T>'
        }
      },
      itemIdToExpandedRowMap: {
        defaultValue: null,
        description: '',
        name: 'itemIdToExpandedRowMap',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'ItemIdToExpandedRowMap'
        }
      },
      items: {
        defaultValue: null,
        description: '',
        name: 'items',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: true,
        type: {
          name: 'T[]'
        }
      },
      cellProps: {
        defaultValue: null,
        description: '',
        name: 'cellProps',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'object | CellPropsCallback<T>'
        }
      },
      columns: {
        defaultValue: null,
        description: '',
        name: 'columns',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: true,
        type: {
          name: 'EuiBasicTableColumn<T>[]'
        }
      },
      error: {
        defaultValue: null,
        description: '',
        name: 'error',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      tableCaption: {
        defaultValue: null,
        description: '',
        name: 'tableCaption',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rowHeader: {
        defaultValue: null,
        description: '',
        name: 'rowHeader',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      hasActions: {
        defaultValue: null,
        description: '',
        name: 'hasActions',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isExpandable: {
        defaultValue: null,
        description: '',
        name: 'isExpandable',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSelectable: {
        defaultValue: null,
        description: '',
        name: 'isSelectable',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      loading: {
        defaultValue: null,
        description: '',
        name: 'loading',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      noItemsMessage: {
        defaultValue: null,
        description: '',
        name: 'noItemsMessage',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: '((criteria: Criteria<T>) => void) | ((criteria: CriteriaWithPagination<T>) => void)'
        }
      },
      pagination: {
        defaultValue: null,
        description: '',
        name: 'pagination',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'Pagination'
        }
      },
      rowProps: {
        defaultValue: null,
        description: '',
        name: 'rowProps',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'object | RowPropsCallback<T>'
        }
      },
      selection: {
        defaultValue: null,
        description: '',
        name: 'selection',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'EuiTableSelectionType<T>'
        }
      },
      sorting: {
        defaultValue: null,
        description: '',
        name: 'sorting',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'EuiTableSortingType<T>'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/table/table.tsx',
          name: 'EuiTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      responsive: {
        defaultValue: null,
        description: '',
        name: 'responsive',
        parent: {
          fileName: 'eui/src/components/table/table.tsx',
          name: 'EuiTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      tableLayout: {
        defaultValue: null,
        description: 'Sets the table-layout CSS property',
        name: 'tableLayout',
        parent: {
          fileName: 'eui/src/components/table/table.tsx',
          name: 'EuiTableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"fixed" | "auto"',
          value: [{
            value: '"fixed"'
          }, {
            value: '"auto"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiInMemoryTable.__docgenInfo = {
    description: '',
    displayName: 'EuiInMemoryTable',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: '((criteria: Criteria<T>) => void) | ((criteria: CriteriaWithPagination<T>) => void)'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/table/table.tsx',
          name: 'EuiTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      responsive: {
        defaultValue: null,
        description: '',
        name: 'responsive',
        parent: {
          fileName: 'eui/src/components/table/table.tsx',
          name: 'EuiTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      tableLayout: {
        defaultValue: null,
        description: 'Sets the table-layout CSS property',
        name: 'tableLayout',
        parent: {
          fileName: 'eui/src/components/table/table.tsx',
          name: 'EuiTableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"fixed" | "auto"',
          value: [{
            value: '"fixed"'
          }, {
            value: '"auto"'
          }]
        }
      },
      itemId: {
        defaultValue: null,
        description: '',
        name: 'itemId',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'ItemId<T>'
        }
      },
      itemIdToExpandedRowMap: {
        defaultValue: null,
        description: '',
        name: 'itemIdToExpandedRowMap',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'ItemIdToExpandedRowMap'
        }
      },
      items: {
        defaultValue: null,
        description: '',
        name: 'items',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: true,
        type: {
          name: 'T[]'
        }
      },
      cellProps: {
        defaultValue: null,
        description: '',
        name: 'cellProps',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'object | CellPropsCallback<T>'
        }
      },
      columns: {
        defaultValue: null,
        description: '',
        name: 'columns',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: true,
        type: {
          name: 'EuiBasicTableColumn<T>[]'
        }
      },
      error: {
        defaultValue: null,
        description: '',
        name: 'error',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      tableCaption: {
        defaultValue: null,
        description: '',
        name: 'tableCaption',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rowHeader: {
        defaultValue: null,
        description: '',
        name: 'rowHeader',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      hasActions: {
        defaultValue: null,
        description: '',
        name: 'hasActions',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isExpandable: {
        defaultValue: null,
        description: '',
        name: 'isExpandable',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSelectable: {
        defaultValue: null,
        description: '',
        name: 'isSelectable',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      loading: {
        defaultValue: null,
        description: '',
        name: 'loading',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      rowProps: {
        defaultValue: null,
        description: '',
        name: 'rowProps',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'object | RowPropsCallback<T>'
        }
      },
      selection: {
        defaultValue: null,
        description: '',
        name: 'selection',
        parent: {
          fileName: 'eui/src/components/basic_table/basic_table.tsx',
          name: 'BasicTableProps'
        },
        required: false,
        type: {
          name: 'EuiTableSelectionType<T>'
        }
      },
      message: {
        defaultValue: null,
        description: '',
        name: 'message',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      search: {
        defaultValue: null,
        description: '',
        name: 'search',
        parent: undefined,
        required: false,
        type: {
          name: 'Search'
        }
      },
      pagination: {
        defaultValue: null,
        description: '',
        name: 'pagination',
        parent: undefined,
        required: false,
        type: {
          name: 'Pagination'
        }
      },
      sorting: {
        defaultValue: null,
        description: '',
        name: 'sorting',
        parent: undefined,
        required: false,
        type: {
          name: 'Sorting'
        }
      },
      allowNeutralSort: {
        defaultValue: null,
        description: 'Set `allowNeutralSort` to false to force column sorting. Defaults to true.',
        name: 'allowNeutralSort',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onTableChange: {
        defaultValue: null,
        description: '',
        name: 'onTableChange',
        parent: undefined,
        required: false,
        type: {
          name: '((nextValues: Criteria<T>) => void) | ((nextValues: CriteriaWithPagination<T>) => void)'
        }
      },
      executeQueryOptions: {
        defaultValue: null,
        description: '',
        name: 'executeQueryOptions',
        parent: undefined,
        required: false,
        type: {
          name: '{ defaultFields?: string[]; isClauseMatcher?: (...args: any) => boolean; explain?: boolean; }'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}