/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiButtonToggle } from './button_toggle';

try {
  EuiButtonToggle.__docgenInfo = {
    description: '',
    displayName: 'EuiButtonToggle',
    methods: [],
    props: {
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      isEmpty: {
        defaultValue: null,
        description: 'Simulates a `EuiButtonEmpty`',
        name: 'isEmpty',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isIconOnly: {
        defaultValue: null,
        description: 'Hides the label from the button content and only displays the icon',
        name: 'isIconOnly',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSelected: {
        defaultValue: null,
        description: 'Initial state of the toggle',
        name: 'isSelected',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      label: {
        defaultValue: null,
        description: 'Button label, which is also passed to `EuiToggle` as the input\'s label',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      toggleClassName: {
        defaultValue: null,
        description: 'Classnames to add to `EuiToggle` instead of the `EuiButton`',
        name: 'toggleClassName',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: 'Is the button a single action or part of a group (multi)?\nUsed primarily for `EuiButtonGroup`',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"single" | "multi"',
          value: [{
            value: '"single"'
          }, {
            value: '"multi"'
          }]
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/button/button_toggle/button_toggle.tsx',
          name: 'EuiButtonToggleProps'
        },
        required: false,
        type: {
          name: '(((event: ChangeEvent<HTMLInputElement>) => void) & ((event: FormEvent<HTMLButtonElement>) => void)) | (((event: ChangeEvent<HTMLInputElement>) => void) & ((event: FormEvent<...>) => void))'
        }
      },
      fill: {
        defaultValue: null,
        description: 'Make button a solid color for prominence',
        name: 'fill',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      color: {
        defaultValue: null,
        description: 'Any of our named colors. `text` color is set for deprecation',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonColor',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: 'Use size `s` in confined spaces',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '`disabled` is also allowed',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: 'Extends the button to 100% width',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Force disables the button and changes the icon to a loading spinner',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      contentProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the button\'s content',
        name: 'contentProps',
        parent: {
          fileName: 'eui/src/components/button/button.tsx',
          name: 'EuiButtonProps'
        },
        required: false,
        type: {
          name: 'EuiButtonContentType'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSide: {
        defaultValue: null,
        description: '',
        name: 'iconSide',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      textProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the content\'s text/children only (not icon)',
        name: 'textProps',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement> & CommonProps'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void)'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}