/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiCheckableCard } from './checkable_card';

try {
  EuiCheckableCard.__docgenInfo = {
    description: '',
    displayName: 'EuiCheckableCard',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: true,
        type: {
          name: '(event: ChangeEvent<HTMLInputElement>) => void'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      checked: {
        defaultValue: null,
        description: '',
        name: 'checked',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      checkableType: {
        defaultValue: null,
        description: 'Whether the control is a radio button or checkbox',
        name: 'checkableType',
        parent: {
          fileName: 'eui/src/components/card/checkable_card/checkable_card.tsx',
          name: 'EuiCheckableCardAsCheckboxProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"radio" | "checkbox"',
          value: [{
            value: '"radio"'
          }, {
            value: '"checkbox"'
          }]
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/card/checkable_card/checkable_card.tsx',
          name: 'EuiCheckableCardBaseProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/card/checkable_card/checkable_card.tsx',
          name: 'EuiCheckableCardBaseProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}