/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiCard } from './card';
export { EuiCheckableCard } from './checkable_card';

try {
  EuiCard.__docgenInfo = {
    description: '',
    displayName: 'EuiCard',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      title: {
        defaultValue: null,
        description: 'Card\'s are required to have at least a title and description',
        name: 'title',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      titleElement: {
        defaultValue: null,
        description: 'Determines the title\'s heading element',
        name: 'titleElement',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"h2" | "h3" | "h4" | "h5" | "h6" | "span"',
          value: [{
            value: '"h2"'
          }, {
            value: '"h3"'
          }, {
            value: '"h4"'
          }, {
            value: '"h5"'
          }, {
            value: '"h6"'
          }, {
            value: '"span"'
          }]
        }
      },
      titleSize: {
        defaultValue: null,
        description: 'Determines the title\'s size, matching that of EuiTitle.\nThough, card titles can\'t be too large or small relative to the description text.',
        name: 'titleSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "xs"',
          value: [{
            value: '"s"'
          }, {
            value: '"xs"'
          }]
        }
      },
      description: {
        defaultValue: null,
        description: 'Card\'s are required to have at least a title and description',
        name: 'description',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      icon: {
        defaultValue: null,
        description: 'Accepts an `<EuiIcon>` node or `null`',
        name: 'icon',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactElement<EuiIconProps, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)>'
        }
      },
      image: {
        defaultValue: null,
        description: 'Accepts a url in string form or ReactElement for a custom image component',
        name: 'image',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      children: {
        defaultValue: null,
        description: 'Content to be rendered between the description and the footer',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      footer: {
        defaultValue: null,
        description: 'Accepts any combination of elements',
        name: 'footer',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onClick: {
        defaultValue: null,
        description: 'Use only if you want to forego a button in the footer and make the whole card clickable',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: 'any'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      textAlign: {
        defaultValue: null,
        description: 'Changes alignment of the title and description',
        name: 'textAlign',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'CardAlignment',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"center"'
          }]
        }
      },
      layout: {
        defaultValue: null,
        description: 'Change to "horizontal" if you need the icon to be left of the content',
        name: 'layout',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"horizontal" | "vertical"',
          value: [{
            value: '"horizontal"'
          }, {
            value: '"vertical"'
          }]
        }
      },
      betaBadgeLabel: {
        defaultValue: null,
        description: 'Add a badge to the card to label it as "Beta" or other non-GA state',
        name: 'betaBadgeLabel',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      betaBadgeTooltipContent: {
        defaultValue: null,
        description: 'Add a description to the beta badge (will appear in a tooltip)',
        name: 'betaBadgeTooltipContent',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      betaBadgeTitle: {
        defaultValue: null,
        description: 'Optional title will be supplied as tooltip title or title attribute otherwise the label will be used',
        name: 'betaBadgeTitle',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      selectable: {
        defaultValue: null,
        description: 'Adds a button to the bottom of the card to allow for in-place selection',
        name: 'selectable',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiCardSelectProps'
        }
      },
      display: {
        defaultValue: null,
        description: 'Visual display of the card. Display as \'panel\' or \'plain\'.\nSelectable cards will always display as \'panel\'.',
        name: 'display',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'CardDisplay',
          value: [{
            value: '"panel"'
          }, {
            value: '"plain"'
          }]
        }
      },
      paddingSize: {
        defaultValue: null,
        description: 'Padding applied around the content of the card',
        name: 'paddingSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiCheckableCard.__docgenInfo = {
    description: '',
    displayName: 'EuiCheckableCard',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: true,
        type: {
          name: '(event: ChangeEvent<HTMLInputElement>) => void'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      checked: {
        defaultValue: null,
        description: '',
        name: 'checked',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      checkableType: {
        defaultValue: null,
        description: 'Whether the control is a radio button or checkbox',
        name: 'checkableType',
        parent: {
          fileName: 'eui/src/components/card/checkable_card/checkable_card.tsx',
          name: 'EuiCheckableCardAsCheckboxProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"radio" | "checkbox"',
          value: [{
            value: '"radio"'
          }, {
            value: '"checkbox"'
          }]
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/card/checkable_card/checkable_card.tsx',
          name: 'EuiCheckableCardBaseProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/card/checkable_card/checkable_card.tsx',
          name: 'EuiCheckableCardBaseProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}