/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiCode } from './code';
export { EuiCodeBlock } from './code_block';
export { EuiCodeBlockImpl } from './_code_block';

try {
  EuiCode.__docgenInfo = {
    description: '',
    displayName: 'EuiCode',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      inline: {
        defaultValue: null,
        description: '',
        name: 'inline',
        parent: {
          fileName: 'eui/src/components/code/code.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'true'
        }
      },
      language: {
        defaultValue: null,
        description: 'Sets the syntax highlighting for a specific language\n@see http://highlightjs.readthedocs.io/en/latest/css-classes-reference.html#language-names-and-aliases\nfor options',
        name: 'language',
        parent: {
          fileName: 'eui/src/components/code/code.tsx',
          name: 'EuiCodeSharedProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      transparentBackground: {
        defaultValue: null,
        description: '',
        name: 'transparentBackground',
        parent: {
          fileName: 'eui/src/components/code/code.tsx',
          name: 'EuiCodeSharedProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiCodeBlock.__docgenInfo = {
    description: '',
    displayName: 'EuiCodeBlock',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      inline: {
        defaultValue: null,
        description: '',
        name: 'inline',
        parent: {
          fileName: 'eui/src/components/code/code_block.tsx',
          name: 'OwnProps'
        },
        required: false,
        type: {
          name: 'false'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: '',
        name: 'paddingSize',
        parent: {
          fileName: 'eui/src/components/code/code_block.tsx',
          name: 'OwnProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      fontSize: {
        defaultValue: null,
        description: '',
        name: 'fontSize',
        parent: {
          fileName: 'eui/src/components/code/code_block.tsx',
          name: 'OwnProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }]
        }
      },
      overflowHeight: {
        defaultValue: null,
        description: '',
        name: 'overflowHeight',
        parent: {
          fileName: 'eui/src/components/code/code_block.tsx',
          name: 'OwnProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      isCopyable: {
        defaultValue: null,
        description: '',
        name: 'isCopyable',
        parent: {
          fileName: 'eui/src/components/code/code_block.tsx',
          name: 'OwnProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      language: {
        defaultValue: null,
        description: 'Sets the syntax highlighting for a specific language\n@see http://highlightjs.readthedocs.io/en/latest/css-classes-reference.html#language-names-and-aliases\nfor options',
        name: 'language',
        parent: {
          fileName: 'eui/src/components/code/code.tsx',
          name: 'EuiCodeSharedProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      transparentBackground: {
        defaultValue: null,
        description: '',
        name: 'transparentBackground',
        parent: {
          fileName: 'eui/src/components/code/code.tsx',
          name: 'EuiCodeSharedProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiCodeBlockImpl.__docgenInfo = {
    description: 'This is the base component extended by EuiCode and EuiCodeBlock.\nThese components share the same propTypes definition with EuiCodeBlockImpl.',
    displayName: 'EuiCodeBlockImpl',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/code/_code_block.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      fontSize: {
        defaultValue: null,
        description: '',
        name: 'fontSize',
        parent: {
          fileName: 'eui/src/components/code/_code_block.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }]
        }
      },
      inline: {
        defaultValue: null,
        description: 'Displays the passed code in an inline format. Also removes any margins set.',
        name: 'inline',
        parent: {
          fileName: 'eui/src/components/code/_code_block.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isCopyable: {
        defaultValue: null,
        description: 'Displays an icon button to copy the code snippet to the clipboard.',
        name: 'isCopyable',
        parent: {
          fileName: 'eui/src/components/code/_code_block.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      language: {
        defaultValue: null,
        description: 'Sets the syntax highlighting for a specific language',
        name: 'language',
        parent: {
          fileName: 'eui/src/components/code/_code_block.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      overflowHeight: {
        defaultValue: null,
        description: '',
        name: 'overflowHeight',
        parent: {
          fileName: 'eui/src/components/code/_code_block.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: '',
        name: 'paddingSize',
        parent: {
          fileName: 'eui/src/components/code/_code_block.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      transparentBackground: {
        defaultValue: null,
        description: '',
        name: 'transparentBackground',
        parent: {
          fileName: 'eui/src/components/code/_code_block.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      whiteSpace: {
        defaultValue: null,
        description: 'Specify how `white-space` inside the element is handled.\n`pre` respects line breaks/white space but doesn\'t force them to wrap the line\n`pre-wrap` respects line breaks/white space but does force them to wrap the line when necessary.',
        name: 'whiteSpace',
        parent: {
          fileName: 'eui/src/components/code/_code_block.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"pre" | "pre-wrap"',
          value: [{
            value: '"pre"'
          }, {
            value: '"pre-wrap"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}