/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiCodeEditor } from './code_editor';

try {
  EuiCodeEditor.__docgenInfo = {
    description: '',
    displayName: 'EuiCodeEditor',
    methods: [],
    props: {
      width: {
        defaultValue: null,
        description: '',
        name: 'width',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      height: {
        defaultValue: null,
        description: '',
        name: 'height',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onBlur: {
        defaultValue: null,
        description: '',
        name: 'onBlur',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: false,
        type: {
          name: '(event: any, editor?: AceEditorClass) => void'
        }
      },
      onFocus: {
        defaultValue: null,
        description: '',
        name: 'onFocus',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: false,
        type: {
          name: '(event: any, editor?: AceEditorClass) => void'
        }
      },
      isReadOnly: {
        defaultValue: null,
        description: '',
        name: 'isReadOnly',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      setOptions: {
        defaultValue: null,
        description: '',
        name: 'setOptions',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: true,
        type: {
          name: 'IAceOptions'
        }
      },
      cursorStart: {
        defaultValue: null,
        description: '',
        name: 'cursorStart',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      theme: {
        defaultValue: null,
        description: 'Select the `brace` theme\nThe matching theme file must also be imported from `brace` (e.g., `import \'brace/theme/github\';`)',
        name: 'theme',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      mode: {
        defaultValue: null,
        description: 'Use string for a built-in mode or object for a custom mode',
        name: 'mode',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: false,
        type: {
          name: 'string | object'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/code_editor/code_editor.tsx',
          name: 'EuiCodeEditorProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/react-ace/lib/ace.d.ts',
          name: 'IAceEditorProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}