function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useState, cloneElement } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { throttle } from '../color_picker/utils';
import { EuiWindowEvent, keys, htmlIdGenerator } from '../../services';
import { EuiFocusTrap } from '../focus_trap';
import { EuiOverlayMask } from '../overlay_mask';
import { EuiButtonEmpty } from '../button';
import { EuiI18n } from '../i18n';
import { EuiScreenReaderOnly } from '../accessibility';
export var EuiCollapsibleNav = function EuiCollapsibleNav(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$isDocked = _ref.isDocked,
      isDocked = _ref$isDocked === void 0 ? false : _ref$isDocked,
      _ref$isOpen = _ref.isOpen,
      isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
      button = _ref.button,
      _ref$showButtonIfDock = _ref.showButtonIfDocked,
      showButtonIfDocked = _ref$showButtonIfDock === void 0 ? false : _ref$showButtonIfDock,
      _ref$dockedBreakpoint = _ref.dockedBreakpoint,
      dockedBreakpoint = _ref$dockedBreakpoint === void 0 ? 992 : _ref$dockedBreakpoint,
      _ref$showCloseButton = _ref.showCloseButton,
      showCloseButton = _ref$showCloseButton === void 0 ? true : _ref$showCloseButton,
      closeButtonProps = _ref.closeButtonProps,
      onClose = _ref.onClose,
      id = _ref.id,
      maskProps = _ref.maskProps,
      rest = _objectWithoutProperties(_ref, ["children", "className", "isDocked", "isOpen", "button", "showButtonIfDocked", "dockedBreakpoint", "showCloseButton", "closeButtonProps", "onClose", "id", "maskProps"]);

  var _useState = useState(id || htmlIdGenerator()('euiCollapsibleNav')),
      _useState2 = _slicedToArray(_useState, 1),
      flyoutID = _useState2[0];

  var _useState3 = useState(window.innerWidth >= dockedBreakpoint),
      _useState4 = _slicedToArray(_useState3, 2),
      windowIsLargeEnoughToDock = _useState4[0],
      setWindowIsLargeEnoughToDock = _useState4[1];

  var navIsDocked = isDocked && windowIsLargeEnoughToDock;
  var functionToCallOnWindowResize = throttle(function () {
    if (window.innerWidth < dockedBreakpoint) {
      setWindowIsLargeEnoughToDock(false);
    } else {
      setWindowIsLargeEnoughToDock(true);
    } // reacts every 50ms to resize changes and always gets the final update

  }, 50); // Watch for docked status and appropriately add/remove body classes and resize handlers

  useEffect(function () {
    window.addEventListener('resize', functionToCallOnWindowResize);

    if (navIsDocked) {
      document.body.classList.add('euiBody--collapsibleNavIsDocked');
    } else if (isOpen) {
      document.body.classList.add('euiBody--collapsibleNavIsOpen');
    }

    return function () {
      document.body.classList.remove('euiBody--collapsibleNavIsDocked');
      document.body.classList.remove('euiBody--collapsibleNavIsOpen');
      window.removeEventListener('resize', functionToCallOnWindowResize);
    };
  }, [navIsDocked, functionToCallOnWindowResize, isOpen]);

  var onKeyDown = function onKeyDown(event) {
    if (event.key === keys.ESCAPE) {
      event.preventDefault();
      collapse();
    }
  };

  var collapse = function collapse() {
    // Skip collapsing if it is docked
    if (navIsDocked) {
      return;
    } else {
      onClose && onClose();
    }
  };

  var classes = classNames('euiCollapsibleNav', {
    'euiCollapsibleNav--isDocked': navIsDocked
  }, className);
  var optionalOverlay;

  if (!navIsDocked) {
    optionalOverlay = React.createElement(EuiOverlayMask, _extends({
      onClick: collapse,
      headerZindexLocation: "below"
    }, maskProps));
  } // Show a trigger button if one was passed but
  // not if navIsDocked and showButtonIfDocked is false


  var trigger = navIsDocked && !showButtonIfDocked ? undefined : button && cloneElement(button, {
    'aria-controls': flyoutID,
    'aria-expanded': isOpen,
    'aria-pressed': isOpen,
    className: classNames(button.props.className, 'euiCollapsibleNav__toggle')
  });
  var closeButton = showCloseButton && React.createElement(EuiScreenReaderOnly, {
    showOnFocus: true
  }, React.createElement(EuiButtonEmpty, _extends({
    onClick: collapse,
    size: "xs",
    textProps: {
      className: 'euiCollapsibleNav__closeButtonText'
    },
    iconType: "cross"
  }, closeButtonProps, {
    className: classNames('euiCollapsibleNav__closeButton', closeButtonProps && closeButtonProps.className)
  }), React.createElement(EuiI18n, {
    token: "euiCollapsibleNav.closeButtonLabel",
    default: "close"
  })));
  var flyout = React.createElement(React.Fragment, null, React.createElement(EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), optionalOverlay, React.createElement(EuiFocusTrap, {
    disabled: navIsDocked,
    clickOutsideDisables: true
  }, React.createElement("nav", _extends({
    id: flyoutID,
    className: classes
  }, rest), children, closeButton)));
  return React.createElement(React.Fragment, null, trigger, (isOpen || navIsDocked) && flyout);
};
EuiCollapsibleNav.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
       * ReactNode to render as this component's content
       */
  children: PropTypes.node,

  /**
       * Keeps navigation flyout visible and push `<body>` content via padding
       */
  isDocked: PropTypes.bool,

  /**
       * Pixel value for customizing the minimum window width for enabling docking
       */
  dockedBreakpoint: PropTypes.number,

  /**
       * Shows the navigation flyout
       */
  isOpen: PropTypes.bool,

  /**
       * Button for controlling visible state of the nav
       */
  button: PropTypes.element,

  /**
       * Keeps the display of toggle button when in docked state
       */
  showButtonIfDocked: PropTypes.bool,

  /**
       * Keeps the display of floating close button.
       * If `false`, you must then keep the `button` displayed at all breakpoints.
       */
  showCloseButton: PropTypes.bool,

  /**
       * Extend the props of the close button, an EuiButtonEmpty
       */
  closeButtonProps: PropTypes.shape({
    href: PropTypes.string,
    onClick: PropTypes.func,

    /**
       * Any of our named colors
       */

    /**
       * Any of our named colors
       */
    color: PropTypes.oneOf(["primary", "danger", "disabled", "text", "ghost"]),
    size: PropTypes.oneOf(["xs", "s", "l"]),

    /**
       * Ensure the text of the button sits flush to the left or right side of its container
       */

    /**
       * Ensure the text of the button sits flush to the left or right side of its container
       */
    flush: PropTypes.oneOf(["left", "right"]),

    /**
       * `disabled` is also allowed
       */

    /**
       * `disabled` is also allowed
       */
    isDisabled: PropTypes.bool,

    /**
       * Force disables the button and changes the icon to a loading spinner
       */

    /**
       * Force disables the button and changes the icon to a loading spinner
       */
    isLoading: PropTypes.bool,
    target: PropTypes.string,
    rel: PropTypes.string,
    type: PropTypes.oneOf(["button", "submit"]),
    buttonRef: PropTypes.func,

    /**
       * Object of props passed to the <span/> wrapping the button's content
       */
    contentProps: PropTypes.any,
    iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
    iconSide: PropTypes.oneOf(["left", "right"]),

    /**
       * Object of props passed to the <span/> wrapping the content's text/children only (not icon)
       */
    textProps: PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string
    }),
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }),
  onClose: PropTypes.func,

  /**
       * Adjustments to the EuiOverlayMask
       */
  maskProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
       * Function that applies to clicking the mask itself and not the children
       */
    onClick: PropTypes.func,

    /**
       * ReactNode to render as this component's content
       */
    children: PropTypes.node,

    /**
       * Should the mask visually sit above or below the EuiHeader (controlled by z-index)
       */
    headerZindexLocation: PropTypes.oneOf(["above", "below"])
  })
};

try {
  EuiCollapsibleNav.__docgenInfo = {
    description: '',
    displayName: 'EuiCollapsibleNav',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      isDocked: {
        defaultValue: {
          value: 'false'
        },
        description: 'Keeps navigation flyout visible and push `<body>` content via padding',
        name: 'isDocked',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      dockedBreakpoint: {
        defaultValue: {
          value: '992'
        },
        description: 'Pixel value for customizing the minimum window width for enabling docking',
        name: 'dockedBreakpoint',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      isOpen: {
        defaultValue: {
          value: 'false'
        },
        description: 'Shows the navigation flyout',
        name: 'isOpen',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      button: {
        defaultValue: null,
        description: 'Button for controlling visible state of the nav',
        name: 'button',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactElement'
        }
      },
      showButtonIfDocked: {
        defaultValue: {
          value: 'false'
        },
        description: 'Keeps the display of toggle button when in docked state',
        name: 'showButtonIfDocked',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showCloseButton: {
        defaultValue: {
          value: 'true'
        },
        description: 'Keeps the display of floating close button.\nIf `false`, you must then keep the `button` displayed at all breakpoints.',
        name: 'showCloseButton',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      closeButtonProps: {
        defaultValue: null,
        description: 'Extend the props of the close button, an EuiButtonEmpty',
        name: 'closeButtonProps',
        parent: undefined,
        required: false,
        type: {
          name: '(DisambiguateSet<PropsForAnchor<CommonEuiButtonEmptyProps, {}>, PropsForButton<CommonEuiButtonEmptyProps, {}>> & CommonEuiButtonEmptyProps & { ...; } & ButtonHTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & AnchorHTMLAttributes<...>)'
        }
      },
      onClose: {
        defaultValue: null,
        description: '',
        name: 'onClose',
        parent: undefined,
        required: false,
        type: {
          name: '() => void'
        }
      },
      maskProps: {
        defaultValue: null,
        description: 'Adjustments to the EuiOverlayMask',
        name: 'maskProps',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiOverlayMaskProps'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}