function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { htmlIdGenerator } from '../../../services';
import { EuiAccordion } from '../../accordion';
import { EuiIcon } from '../../icon';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiTitle } from '../../title';
var backgroundToClassNameMap = {
  none: '',
  light: 'euiCollapsibleNavGroup--light',
  dark: 'euiCollapsibleNavGroup--dark'
};
export var BACKGROUNDS = Object.keys(backgroundToClassNameMap);
export var EuiCollapsibleNavGroup = function EuiCollapsibleNavGroup(_ref) {
  var className = _ref.className,
      children = _ref.children,
      id = _ref.id,
      title = _ref.title,
      iconType = _ref.iconType,
      _ref$iconSize = _ref.iconSize,
      iconSize = _ref$iconSize === void 0 ? 'l' : _ref$iconSize,
      _ref$background = _ref.background,
      background = _ref$background === void 0 ? 'none' : _ref$background,
      _ref$isCollapsible = _ref.isCollapsible,
      isCollapsible = _ref$isCollapsible === void 0 ? false : _ref$isCollapsible,
      _ref$titleElement = _ref.titleElement,
      titleElement = _ref$titleElement === void 0 ? 'h3' : _ref$titleElement,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'xxs' : _ref$titleSize,
      iconProps = _ref.iconProps,
      rest = _objectWithoutProperties(_ref, ["className", "children", "id", "title", "iconType", "iconSize", "background", "isCollapsible", "titleElement", "titleSize", "iconProps"]);

  var _useState = useState(id || htmlIdGenerator()()),
      _useState2 = _slicedToArray(_useState, 1),
      groupID = _useState2[0];

  var titleID = "".concat(groupID, "__title");
  var classes = classNames('euiCollapsibleNavGroup', backgroundToClassNameMap[background], {
    'euiCollapsibleNavGroup--withHeading': title
  }, className); // Warn if consumer passes an iconType without a title

  if (iconType && !title) {
    console.warn('EuiCollapsibleNavGroup will not render an icon without `title`.');
  }

  var content = React.createElement("div", {
    className: "euiCollapsibleNavGroup__children"
  }, children);
  var headingClasses = 'euiCollapsibleNavGroup__heading';
  var TitleElement = titleElement;
  var titleContent = title ? React.createElement(EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, iconType && React.createElement(EuiFlexItem, {
    grow: false
  }, React.createElement(EuiIcon, _extends({}, iconProps, {
    type: iconType,
    size: iconSize
  }))), React.createElement(EuiFlexItem, null, React.createElement(EuiTitle, {
    size: titleSize
  }, React.createElement(TitleElement, {
    id: titleID,
    className: "euiCollapsibleNavGroup__title"
  }, title)))) : undefined;

  if (isCollapsible && title) {
    return React.createElement(EuiAccordion, _extends({
      id: groupID,
      className: classes,
      buttonClassName: headingClasses,
      buttonContent: titleContent,
      initialIsOpen: true,
      arrowDisplay: "right"
    }, rest), content);
  } else {
    return React.createElement("div", _extends({
      id: groupID,
      className: classes
    }, rest), titleContent && React.createElement("div", {
      className: headingClasses
    }, titleContent), content);
  }
};
EuiCollapsibleNavGroup.propTypes = {
  /**
     * ReactNode to render as this component's content
     */

  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node,

  /**
     * Sits left of the `title` and only when `title` is present
     */
  iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),

  /**
     * Change the size of the icon in the `title`
     */
  iconSize: PropTypes.oneOf(["original", "s", "m", "l", "xl", "xxl"]),

  /**
     * Further extend the props applied to EuiIcon
     */
  iconProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
         * One of EUI's color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.
         * Note that coloring only works if your SVG is removed of fill attributes.
         */
    color: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.oneOf(["default", "primary", "secondary", "success", "accent", "warning", "danger", "text", "subdued", "ghost"]).isRequired]),

    /**
         * Descriptive title for naming the icon based on its use
         */
    title: PropTypes.string,

    /**
         * A unique identifier for the title element
         */
    titleId: PropTypes.string,

    /**
         * Its value should be one or more element IDs
         */
    "aria-labelledby": PropTypes.string,

    /**
         * Callback when the icon has been loaded & rendered
         */
    onIconLoad: PropTypes.func
  }),

  /**
     * Optionally provide an id, otherwise one will be created
     */

  /**
     * Optionally provide an id, otherwise one will be created
     */
  id: PropTypes.string,

  /**
     * Adds a background color to the entire group,
     * applying the correct text color to the `title` only
     */

  /**
     * Adds a background color to the entire group,
     * applying the correct text color to the `title` only
     */
  background: PropTypes.oneOf(["none", "light", "dark"]),

  /**
     * Determines the title's heading element
     */

  /**
     * Determines the title's heading element
     */
  titleElement: PropTypes.oneOf(["h2", "h3", "h4", "h5", "h6", "span"]),

  /**
     * Title sizing equivelant to EuiTitle, but only `s` and smaller
     */

  /**
     * Title sizing equivelant to EuiTitle, but only `s` and smaller
     */
  titleSize: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
       * Class that will apply to the trigger for the accordion.
       */
  buttonClassName: PropTypes.string,

  /**
       * Class that will apply to the trigger content for the accordion.
       */
  buttonContentClassName: PropTypes.string,

  /**
       * The content of the clickable trigger
       */
  buttonContent: PropTypes.node,

  /**
       * Will appear right aligned against the button. Useful for separate actions like deletions.
       */
  extraAction: PropTypes.node,

  /**
       * The accordion will start in the open state.
       */
  initialIsOpen: PropTypes.bool,

  /**
       * Optional callback method called on open and close with a single `isOpen` parameter
       */
  onToggle: PropTypes.func,

  /**
       * The padding around the exposed accordion content.
       */
  paddingSize: PropTypes.oneOf(["none", "xs", "s", "m", "l", "xl"]),

  /**
       * Placement of the arrow indicator, or 'none' to hide it.
       * Placing on the `right` doesn't work with `extraAction` and so it will be ignored
       */
  arrowDisplay: PropTypes.oneOf(["left", "right", "none"]),

  /**
       * Control the opening of accordion via prop
       */
  forceState: PropTypes.oneOf(["closed", "open"]),

  /**
       * Change `extraAction` and children into a loading spinner
       */
  isLoading: PropTypes.bool,

  /**
       * Choose whether the loading message replaces the content. Customize the message by passing a node
       */
  isLoadingMessage: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.node.isRequired]),

  /**
     * If `true`, wraps children in the body of an accordion,
     * requiring the prop `title` to be used as the button.
     * When `false`, simply renders a div without any accordion functionality.
     */

  /**
       * If `true`, wraps children in the body of an accordion,
       * requiring the prop `title` to be used as the button.
       * When `false`, simply renders a div without any accordion functionality.
       */
  isCollapsible: PropTypes.oneOfType([PropTypes.oneOf([true]).isRequired, PropTypes.oneOf([false])]),

  /**
     * The title gets wrapped in the appropriate heading level
     * with the option to add an iconType
     */

  /**
       * The title gets wrapped in the appropriate heading level
       * with the option to add an iconType
       */
  title: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.node])
};

try {
  EuiCollapsibleNavGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiCollapsibleNavGroup',
    methods: [],
    props: {
      isLoading: {
        defaultValue: null,
        description: 'Change `extraAction` and children into a loading spinner',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      buttonClassName: {
        defaultValue: null,
        description: 'Class that will apply to the trigger for the accordion.',
        name: 'buttonClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      buttonContentClassName: {
        defaultValue: null,
        description: 'Class that will apply to the trigger content for the accordion.',
        name: 'buttonContentClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      buttonContent: {
        defaultValue: null,
        description: 'The content of the clickable trigger',
        name: 'buttonContent',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      extraAction: {
        defaultValue: null,
        description: 'Will appear right aligned against the button. Useful for separate actions like deletions.',
        name: 'extraAction',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      initialIsOpen: {
        defaultValue: null,
        description: 'The accordion will start in the open state.',
        name: 'initialIsOpen',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onToggle: {
        defaultValue: null,
        description: 'Optional callback method called on open and close with a single `isOpen` parameter',
        name: 'onToggle',
        parent: undefined,
        required: false,
        type: {
          name: '(isOpen: boolean) => void'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: 'The padding around the exposed accordion content.',
        name: 'paddingSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "none" | "xs" | "l" | "xl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }]
        }
      },
      arrowDisplay: {
        defaultValue: null,
        description: 'Placement of the arrow indicator, or \'none\' to hide it.\nPlacing on the `right` doesn\'t work with `extraAction` and so it will be ignored',
        name: 'arrowDisplay',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"left" | "right" | "none"',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"none"'
          }]
        }
      },
      forceState: {
        defaultValue: null,
        description: 'Control the opening of accordion via prop',
        name: 'forceState',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"closed" | "open"',
          value: [{
            value: '"closed"'
          }, {
            value: '"open"'
          }]
        }
      },
      isLoadingMessage: {
        defaultValue: null,
        description: 'Choose whether the loading message replaces the content. Customize the message by passing a node',
        name: 'isLoadingMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      iconType: {
        defaultValue: null,
        description: 'Sits left of the `title` and only when `title` is present',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSize: {
        defaultValue: {
          value: 'l'
        },
        description: 'Change the size of the icon in the `title`',
        name: 'iconSize',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l" | "xl" | "original" | "xxl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }, {
            value: '"original"'
          }, {
            value: '"xxl"'
          }]
        }
      },
      iconProps: {
        defaultValue: null,
        description: 'Further extend the props applied to EuiIcon',
        name: 'iconProps',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'Pick<EuiIconProps, "string" | "children" | "tabIndex" | "fill" | "color" | "className" | "aria-label" | "data-test-subj" | "href" | "onClick" | "media" | "target" | ... 458 more ... | "onIconLoad">'
        }
      },
      id: {
        defaultValue: null,
        description: 'Optionally provide an id, otherwise one will be created',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      background: {
        defaultValue: {
          value: 'none'
        },
        description: 'Adds a background color to the entire group,\napplying the correct text color to the `title` only',
        name: 'background',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'Background',
          value: [{
            value: '"none"'
          }, {
            value: '"light"'
          }, {
            value: '"dark"'
          }]
        }
      },
      titleElement: {
        defaultValue: {
          value: 'h3'
        },
        description: 'Determines the title\'s heading element',
        name: 'titleElement',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"h2" | "h3" | "h4" | "h5" | "h6" | "span"',
          value: [{
            value: '"h2"'
          }, {
            value: '"h3"'
          }, {
            value: '"h4"'
          }, {
            value: '"h5"'
          }, {
            value: '"h6"'
          }, {
            value: '"span"'
          }]
        }
      },
      titleSize: {
        defaultValue: {
          value: 'xxs'
        },
        description: 'Title sizing equivelant to EuiTitle, but only `s` and smaller',
        name: 'titleSize',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "xs" | "xxxs" | "xxs"',
          value: [{
            value: '"s"'
          }, {
            value: '"xs"'
          }, {
            value: '"xxxs"'
          }, {
            value: '"xxs"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isCollapsible: {
        defaultValue: {
          value: 'false'
        },
        description: 'If `true`, wraps children in the body of an accordion,\nrequiring the prop `title` to be used as the button.\nWhen `false`, simply renders a div without any accordion functionality.\nIf `true`, wraps children in the body of an accordion,\nrequiring the prop `title` to be used as the button.\nWhen `false`, simply renders a div without any accordion functionality.',
        name: 'isCollapsible',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      title: {
        defaultValue: null,
        description: 'The title gets wrapped in the appropriate heading level\nwith the option to add an iconType\nThe title gets wrapped in the appropriate heading level\nwith the option to add an iconType',
        name: 'title',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}