/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiCollapsibleNavGroup } from './collapsible_nav_group';
export { EuiCollapsibleNav } from './collapsible_nav';

try {
  EuiCollapsibleNavGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiCollapsibleNavGroup',
    methods: [],
    props: {
      isLoading: {
        defaultValue: null,
        description: 'Change `extraAction` and children into a loading spinner',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      buttonClassName: {
        defaultValue: null,
        description: 'Class that will apply to the trigger for the accordion.',
        name: 'buttonClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      buttonContentClassName: {
        defaultValue: null,
        description: 'Class that will apply to the trigger content for the accordion.',
        name: 'buttonContentClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      buttonContent: {
        defaultValue: null,
        description: 'The content of the clickable trigger',
        name: 'buttonContent',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      extraAction: {
        defaultValue: null,
        description: 'Will appear right aligned against the button. Useful for separate actions like deletions.',
        name: 'extraAction',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      initialIsOpen: {
        defaultValue: null,
        description: 'The accordion will start in the open state.',
        name: 'initialIsOpen',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onToggle: {
        defaultValue: null,
        description: 'Optional callback method called on open and close with a single `isOpen` parameter',
        name: 'onToggle',
        parent: undefined,
        required: false,
        type: {
          name: '(isOpen: boolean) => void'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: 'The padding around the exposed accordion content.',
        name: 'paddingSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "none" | "xs" | "l" | "xl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }]
        }
      },
      arrowDisplay: {
        defaultValue: null,
        description: 'Placement of the arrow indicator, or \'none\' to hide it.\nPlacing on the `right` doesn\'t work with `extraAction` and so it will be ignored',
        name: 'arrowDisplay',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"left" | "right" | "none"',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"none"'
          }]
        }
      },
      forceState: {
        defaultValue: null,
        description: 'Control the opening of accordion via prop',
        name: 'forceState',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"closed" | "open"',
          value: [{
            value: '"closed"'
          }, {
            value: '"open"'
          }]
        }
      },
      isLoadingMessage: {
        defaultValue: null,
        description: 'Choose whether the loading message replaces the content. Customize the message by passing a node',
        name: 'isLoadingMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      iconType: {
        defaultValue: null,
        description: 'Sits left of the `title` and only when `title` is present',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSize: {
        defaultValue: null,
        description: 'Change the size of the icon in the `title`',
        name: 'iconSize',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l" | "xl" | "original" | "xxl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }, {
            value: '"original"'
          }, {
            value: '"xxl"'
          }]
        }
      },
      iconProps: {
        defaultValue: null,
        description: 'Further extend the props applied to EuiIcon',
        name: 'iconProps',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'Pick<EuiIconProps, "string" | "children" | "tabIndex" | "fill" | "color" | "className" | "aria-label" | "data-test-subj" | "href" | "onClick" | "media" | "target" | ... 458 more ... | "onIconLoad">'
        }
      },
      id: {
        defaultValue: null,
        description: 'Optionally provide an id, otherwise one will be created',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      background: {
        defaultValue: null,
        description: 'Adds a background color to the entire group,\napplying the correct text color to the `title` only',
        name: 'background',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'Background',
          value: [{
            value: '"none"'
          }, {
            value: '"light"'
          }, {
            value: '"dark"'
          }]
        }
      },
      titleElement: {
        defaultValue: null,
        description: 'Determines the title\'s heading element',
        name: 'titleElement',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"h2" | "h3" | "h4" | "h5" | "h6" | "span"',
          value: [{
            value: '"h2"'
          }, {
            value: '"h3"'
          }, {
            value: '"h4"'
          }, {
            value: '"h5"'
          }, {
            value: '"h6"'
          }, {
            value: '"span"'
          }]
        }
      },
      titleSize: {
        defaultValue: null,
        description: 'Title sizing equivelant to EuiTitle, but only `s` and smaller',
        name: 'titleSize',
        parent: {
          fileName: 'eui/src/components/collapsible_nav/collapsible_nav_group/collapsible_nav_group.tsx',
          name: 'EuiCollapsibleNavGroupInterface'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "xs" | "xxxs" | "xxs"',
          value: [{
            value: '"s"'
          }, {
            value: '"xs"'
          }, {
            value: '"xxxs"'
          }, {
            value: '"xxs"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isCollapsible: {
        defaultValue: null,
        description: 'If `true`, wraps children in the body of an accordion,\nrequiring the prop `title` to be used as the button.\nWhen `false`, simply renders a div without any accordion functionality.\nIf `true`, wraps children in the body of an accordion,\nrequiring the prop `title` to be used as the button.\nWhen `false`, simply renders a div without any accordion functionality.',
        name: 'isCollapsible',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      title: {
        defaultValue: null,
        description: 'The title gets wrapped in the appropriate heading level\nwith the option to add an iconType\nThe title gets wrapped in the appropriate heading level\nwith the option to add an iconType',
        name: 'title',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiCollapsibleNav.__docgenInfo = {
    description: '',
    displayName: 'EuiCollapsibleNav',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      isDocked: {
        defaultValue: null,
        description: 'Keeps navigation flyout visible and push `<body>` content via padding',
        name: 'isDocked',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      dockedBreakpoint: {
        defaultValue: null,
        description: 'Pixel value for customizing the minimum window width for enabling docking',
        name: 'dockedBreakpoint',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      isOpen: {
        defaultValue: null,
        description: 'Shows the navigation flyout',
        name: 'isOpen',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      button: {
        defaultValue: null,
        description: 'Button for controlling visible state of the nav',
        name: 'button',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactElement'
        }
      },
      showButtonIfDocked: {
        defaultValue: null,
        description: 'Keeps the display of toggle button when in docked state',
        name: 'showButtonIfDocked',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showCloseButton: {
        defaultValue: null,
        description: 'Keeps the display of floating close button.\nIf `false`, you must then keep the `button` displayed at all breakpoints.',
        name: 'showCloseButton',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      closeButtonProps: {
        defaultValue: null,
        description: 'Extend the props of the close button, an EuiButtonEmpty',
        name: 'closeButtonProps',
        parent: undefined,
        required: false,
        type: {
          name: '(DisambiguateSet<PropsForAnchor<CommonEuiButtonEmptyProps, {}>, PropsForButton<CommonEuiButtonEmptyProps, {}>> & CommonEuiButtonEmptyProps & { ...; } & ButtonHTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & AnchorHTMLAttributes<...>)'
        }
      },
      onClose: {
        defaultValue: null,
        description: '',
        name: 'onClose',
        parent: undefined,
        required: false,
        type: {
          name: '() => void'
        }
      },
      maskProps: {
        defaultValue: null,
        description: 'Adjustments to the EuiOverlayMask',
        name: 'maskProps',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiOverlayMaskProps'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}