/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiComboBox } from './combo_box';
export * from './combo_box_input';
export * from './combo_box_options_list';
export {} from './types';

try {
  EuiComboBox.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBox',
    methods: [],
    props: {
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      async: {
        defaultValue: null,
        description: 'Updates the list of options asynchronously',
        name: 'async',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      compressed: {
        defaultValue: null,
        description: 'When `true` creates a shorter height input',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: 'When `true` expands to the entire width available',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      inputRef: {
        defaultValue: null,
        description: '',
        name: 'inputRef',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLInputElement) => void'
        }
      },
      isClearable: {
        defaultValue: null,
        description: 'Shows a button that quickly clears any input',
        name: 'isClearable',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: 'Disables the input',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Swaps the dropdown options for a loading spinner',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      noSuggestions: {
        defaultValue: null,
        description: 'Doesn\'t show the suggestions list/dropdown',
        name: 'noSuggestions',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onBlur: {
        defaultValue: null,
        description: '',
        name: 'onBlur',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: '(event: FocusEvent<HTMLDivElement>) => void'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'Called every time the query in the combo box is parsed',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: '(options: EuiComboBoxOptionOption<T>[]) => void'
        }
      },
      onFocus: {
        defaultValue: null,
        description: '',
        name: 'onFocus',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: '(event: FocusEvent<HTMLDivElement>) => void'
        }
      },
      onKeyDown: {
        defaultValue: null,
        description: '',
        name: 'onKeyDown',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: '(event: KeyboardEvent<HTMLDivElement>) => void'
        }
      },
      onSearchChange: {
        defaultValue: null,
        description: 'Called every time the text query in the search box is parsed',
        name: 'onSearchChange',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: '(searchValue: string, hasMatchingOptions?: boolean) => void'
        }
      },
      placeholder: {
        defaultValue: null,
        description: 'Sets the placeholder of the input',
        name: 'placeholder',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rowHeight: {
        defaultValue: null,
        description: 'Every option must be the same height and must be explicitly set if using a custom render',
        name: 'rowHeight',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: 'When `true` only allows the user to select a single option. Set to `{ asPlainText: true }` to not render input selection as pills',
        name: 'singleSelection',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: true,
        type: {
          name: 'boolean | EuiComboBoxSingleSelectionShape'
        }
      },
      sortMatchesBy: {
        defaultValue: null,
        description: 'Display matching options by:\n`startsWith`: moves items that start with search value to top of the list;\n`none`: don\'t change the sort order of initial object',
        name: 'sortMatchesBy',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: true,
        type: {
          name: 'enum',
          raw: '"none" | "startsWith"',
          value: [{
            value: '"none"'
          }, {
            value: '"startsWith"'
          }]
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before input. It won\'t show if `singleSelection` is set to `false`.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after input. It won\'t show if `singleSelection` is set to `false`.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      delimiter: {
        defaultValue: null,
        description: 'A special character to use as a value separator. Typically a comma `,`',
        name: 'delimiter',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box.tsx',
          name: '_EuiComboBoxProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      options: {
        defaultValue: null,
        description: '',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>[]'
        }
      },
      customOptionText: {
        defaultValue: null,
        description: 'Creates a custom text option. You can use `{searchValue}` inside your string to better customize your text.\nIt won\'t show if there\'s no onCreateOption.',
        name: 'customOptionText',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      onCreateOption: {
        defaultValue: null,
        description: '',
        name: 'onCreateOption',
        parent: undefined,
        required: false,
        type: {
          name: '(searchValue: string, options: EuiComboBoxOptionOption<T>[]) => boolean | void'
        }
      },
      renderOption: {
        defaultValue: null,
        description: '',
        name: 'renderOption',
        parent: undefined,
        required: false,
        type: {
          name: '(option: EuiComboBoxOptionOption<T>, searchValue: string, OPTION_CONTENT_CLASSNAME: string) => ReactNode'
        }
      },
      selectedOptions: {
        defaultValue: null,
        description: '',
        name: 'selectedOptions',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>[]'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiComboBoxInput.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBoxInput',
    methods: [],
    props: {
      autoSizeInputRef: {
        defaultValue: null,
        description: '',
        name: 'autoSizeInputRef',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '(instance: AutosizeInput & HTMLInputElement) => void'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      focusedOptionId: {
        defaultValue: null,
        description: '',
        name: 'focusedOptionId',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      hasSelectedOptions: {
        defaultValue: null,
        description: '',
        name: 'hasSelectedOptions',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      inputRef: {
        defaultValue: null,
        description: '',
        name: 'inputRef',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLInputElement) => void'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isListOpen: {
        defaultValue: null,
        description: '',
        name: 'isListOpen',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      noIcon: {
        defaultValue: null,
        description: '',
        name: 'noIcon',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      onBlur: {
        defaultValue: null,
        description: '',
        name: 'onBlur',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '(event: FocusEvent<HTMLInputElement>) => void'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '(searchValue: string) => void'
        }
      },
      onClear: {
        defaultValue: null,
        description: '',
        name: 'onClear',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      onCloseListClick: {
        defaultValue: null,
        description: '',
        name: 'onCloseListClick',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: '() => void'
        }
      },
      onFocus: {
        defaultValue: null,
        description: '',
        name: 'onFocus',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: '(event: FocusEvent<HTMLInputElement>) => void'
        }
      },
      onOpenListClick: {
        defaultValue: null,
        description: '',
        name: 'onOpenListClick',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: '() => void'
        }
      },
      onRemoveOption: {
        defaultValue: null,
        description: '',
        name: 'onRemoveOption',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      placeholder: {
        defaultValue: null,
        description: '',
        name: 'placeholder',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rootId: {
        defaultValue: null,
        description: '',
        name: 'rootId',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: '(idSuffix?: string) => string'
        }
      },
      searchValue: {
        defaultValue: null,
        description: '',
        name: 'searchValue',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      selectedOptions: {
        defaultValue: null,
        description: '',
        name: 'selectedOptions',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'EuiComboBoxOptionOption<T>[]'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: '',
        name: 'singleSelection',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'boolean | EuiComboBoxSingleSelectionShape'
        }
      },
      toggleButtonRef: {
        defaultValue: null,
        description: '',
        name: 'toggleButtonRef',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLButtonElement | HTMLSpanElement) => void'
        }
      },
      updatePosition: {
        defaultValue: null,
        description: '',
        name: 'updatePosition',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: true,
        type: {
          name: 'UpdatePositionHandler'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      prepend: {
        defaultValue: null,
        description: '',
        name: 'prepend',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: '',
        name: 'append',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_input.tsx',
          name: 'EuiComboBoxInputProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiComboBoxPill.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBoxPill',
    methods: [],
    props: {
      asPlainText: {
        defaultValue: null,
        description: '',
        name: 'asPlainText',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_pill.tsx',
          name: 'EuiComboBoxPillProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_pill.tsx',
          name: 'EuiComboBoxPillProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      color: {
        defaultValue: null,
        description: '',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_pill.tsx',
          name: 'EuiComboBoxPillProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_pill.tsx',
          name: 'EuiComboBoxPillProps'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      },
      onClickAriaLabel: {
        defaultValue: null,
        description: '',
        name: 'onClickAriaLabel',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_pill.tsx',
          name: 'EuiComboBoxPillProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClose: {
        defaultValue: null,
        description: '',
        name: 'onClose',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_pill.tsx',
          name: 'EuiComboBoxPillProps'
        },
        required: false,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      option: {
        defaultValue: null,
        description: '',
        name: 'option',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_input/combo_box_pill.tsx',
          name: 'EuiComboBoxPillProps'
        },
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiComboBoxOptionsList.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBoxOptionsList',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      hasShadow: {
        defaultValue: null,
        description: 'If active, adds a deeper shadow to the panel',
        name: 'hasShadow',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: 'Padding applied to the panel',
        name: 'paddingSize',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      grow: {
        defaultValue: null,
        description: 'When true the panel will grow to match `EuiFlexItem`',
        name: 'grow',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      panelRef: {
        defaultValue: null,
        description: '',
        name: 'panelRef',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'Ref<HTMLDivElement>'
        }
      },
      betaBadgeLabel: {
        defaultValue: null,
        description: 'Add a badge to the panel to label it as "Beta" or other non-GA state',
        name: 'betaBadgeLabel',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      betaBadgeTooltipContent: {
        defaultValue: null,
        description: 'Add a description to the beta badge (will appear in a tooltip)',
        name: 'betaBadgeTooltipContent',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      betaBadgeTitle: {
        defaultValue: null,
        description: 'Optional title will be supplied as tooltip title or title attribute otherwise the label will be used',
        name: 'betaBadgeTitle',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      activeOptionIndex: {
        defaultValue: null,
        description: '',
        name: 'activeOptionIndex',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      areAllOptionsSelected: {
        defaultValue: null,
        description: '',
        name: 'areAllOptionsSelected',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      customOptionText: {
        defaultValue: null,
        description: 'Creates a custom text option. You can use `{searchValue}` inside your string to better customize your text.\nIt won\'t show if there\'s no onCreateOption.',
        name: 'customOptionText',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      getSelectedOptionForSearchValue: {
        defaultValue: null,
        description: '',
        name: 'getSelectedOptionForSearchValue',
        parent: undefined,
        required: false,
        type: {
          name: '(searchValue: string, selectedOptions: any[]) => EuiComboBoxOptionOption<T>'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      listRef: {
        defaultValue: null,
        description: '',
        name: 'listRef',
        parent: undefined,
        required: true,
        type: {
          name: '(instance: HTMLDivElement) => void'
        }
      },
      matchingOptions: {
        defaultValue: null,
        description: '',
        name: 'matchingOptions',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>[]'
        }
      },
      onCloseList: {
        defaultValue: null,
        description: '',
        name: 'onCloseList',
        parent: undefined,
        required: true,
        type: {
          name: '(event: Event) => void'
        }
      },
      onCreateOption: {
        defaultValue: null,
        description: '',
        name: 'onCreateOption',
        parent: undefined,
        required: false,
        type: {
          name: '(searchValue: string, options: EuiComboBoxOptionOption<T>[]) => boolean | void'
        }
      },
      onOptionClick: {
        defaultValue: null,
        description: '',
        name: 'onOptionClick',
        parent: undefined,
        required: false,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      onOptionEnterKey: {
        defaultValue: null,
        description: '',
        name: 'onOptionEnterKey',
        parent: undefined,
        required: false,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      optionRef: {
        defaultValue: null,
        description: '',
        name: 'optionRef',
        parent: undefined,
        required: true,
        type: {
          name: '(index: number, node: EuiFilterSelectItem) => void'
        }
      },
      options: {
        defaultValue: null,
        description: '',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>[]'
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiComboBoxOptionsListPosition',
          value: [{
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      renderOption: {
        defaultValue: null,
        description: '',
        name: 'renderOption',
        parent: undefined,
        required: false,
        type: {
          name: '(option: EuiComboBoxOptionOption<T>, searchValue: string, OPTION_CONTENT_CLASSNAME: string) => ReactNode'
        }
      },
      rootId: {
        defaultValue: null,
        description: '',
        name: 'rootId',
        parent: undefined,
        required: true,
        type: {
          name: '(idSuffix?: string) => string'
        }
      },
      rowHeight: {
        defaultValue: null,
        description: '',
        name: 'rowHeight',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      scrollToIndex: {
        defaultValue: null,
        description: '',
        name: 'scrollToIndex',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      searchValue: {
        defaultValue: null,
        description: '',
        name: 'searchValue',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      selectedOptions: {
        defaultValue: null,
        description: '',
        name: 'selectedOptions',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>[]'
        }
      },
      updatePosition: {
        defaultValue: null,
        description: '',
        name: 'updatePosition',
        parent: undefined,
        required: true,
        type: {
          name: 'UpdatePositionHandler'
        }
      },
      width: {
        defaultValue: null,
        description: '',
        name: 'width',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: '',
        name: 'singleSelection',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | EuiComboBoxSingleSelectionShape'
        }
      },
      delimiter: {
        defaultValue: null,
        description: '',
        name: 'delimiter',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      zIndex: {
        defaultValue: null,
        description: '',
        name: 'zIndex',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiComboBoxOption.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBoxOption',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isFocused: {
        defaultValue: null,
        description: '',
        name: 'isFocused',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      onEnterKey: {
        defaultValue: null,
        description: '',
        name: 'onEnterKey',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'OptionHandler<T>'
        }
      },
      option: {
        defaultValue: null,
        description: '',
        name: 'option',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: true,
        type: {
          name: 'EuiComboBoxOptionOption<T>'
        }
      },
      optionRef: {
        defaultValue: null,
        description: '',
        name: 'optionRef',
        parent: {
          fileName: 'eui/src/components/combo_box/combo_box_options_list/combo_box_option.tsx',
          name: 'EuiComboBoxOptionProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLButtonElement) => void'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiComboBoxTitle.__docgenInfo = {
    description: '',
    displayName: 'EuiComboBoxTitle',
    methods: [],
    props: {},
    extends: ['DOMAttributes']
  };
} catch (e) {}