/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import { keysOf } from '../common';
import classNames from 'classnames';
var typeToClassNameMap = {
  regular: 'euiCommentEvent--regular',
  update: 'euiCommentEvent--update'
};
export var TYPES = keysOf(typeToClassNameMap);
export var EuiCommentEvent = function EuiCommentEvent(_ref) {
  var children = _ref.children,
      className = _ref.className,
      username = _ref.username,
      timestamp = _ref.timestamp,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'regular' : _ref$type,
      event = _ref.event,
      actions = _ref.actions;
  var classes = classNames('euiCommentEvent', typeToClassNameMap[type], className);
  var isFigure = type === 'regular' || type === 'update' && typeof children !== 'undefined';
  var Element = isFigure ? 'figure' : 'div';
  var HeaderElement = isFigure ? 'figcaption' : 'div';
  return React.createElement(Element, {
    className: classes
  }, React.createElement(HeaderElement, {
    className: "euiCommentEvent__header"
  }, React.createElement("div", {
    className: "euiCommentEvent__headerData"
  }, React.createElement("div", {
    className: "euiCommentEvent__headerUsername"
  }, username), React.createElement("div", {
    className: "euiCommentEvent__headerEvent"
  }, event), timestamp ? React.createElement("div", {
    className: "euiCommentEvent__headerTimestamp"
  }, React.createElement("time", null, timestamp)) : undefined), actions ? React.createElement("div", {
    className: "euiCommentEvent__headerActions"
  }, actions) : undefined), children ? React.createElement("div", {
    className: "euiCommentEvent__body"
  }, children) : undefined);
};
EuiCommentEvent.propTypes = {
  /**
     * Author of the comment. Display a small icon or avatar with it if needed.
     */
  username: PropTypes.node.isRequired,

  /**
     * Time of occurrence of the event. Its format is set on the consumer's side
     */
  timestamp: PropTypes.node,

  /**
     * Describes the event that took place
     */
  event: PropTypes.node,

  /**
     * Custom actions that the user can perform from the comment's header
     */
  actions: PropTypes.node,

  /**
     * Use "update" when the comment is primarily showing info about actions that the user or the system has performed (e.g. "user1 edited a case").
     */
  type: PropTypes.oneOf(["regular", "update"]),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};

try {
  EuiCommentEvent.__docgenInfo = {
    description: '',
    displayName: 'EuiCommentEvent',
    methods: [],
    props: {
      username: {
        defaultValue: null,
        description: 'Author of the comment. Display a small icon or avatar with it if needed.',
        name: 'username',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      timestamp: {
        defaultValue: null,
        description: 'Time of occurrence of the event. Its format is set on the consumer\'s side',
        name: 'timestamp',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      event: {
        defaultValue: null,
        description: 'Describes the event that took place',
        name: 'event',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      actions: {
        defaultValue: null,
        description: 'Custom actions that the user can perform from the comment\'s header',
        name: 'actions',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      type: {
        defaultValue: {
          value: 'regular'
        },
        description: 'Use "update" when the comment is primarily showing info about actions that the user or the system has performed (e.g. "user1 edited a case").',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/comment_list/comment_event.tsx',
          name: 'EuiCommentEventProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"regular" | "update"',
          value: [{
            value: '"regular"'
          }, {
            value: '"update"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}